var Assistant = {};
(function(assist) {

	
	var assistCount = {count:0};
	var isCtrl = false;
	var ctrlTime = 0;
	
	function hitCtrl() {
		var val = ++ctrlTime;
		isCtrl = true;
		
		setTimeout(function() {
			chkCtrl(val);
		}, 1500)
	}
	
	function chkCtrl(val) {
		if (isCtrl && ctrlTime == val) {
			isCtrl = false;
		}
	}
	
	
	assist.NEW = function(elem, fnUpdate) {
		assistCount.count++;
		//Si pas d'élément ou que celui ci pas valid, on va pas plus loin
		elem = $(elem);
		if (elem.size() != 1) {
			return;
		}
		if (elem[0].tagName != "INPUT" && elem[0].tagName != "TEXTAREA" 
			&& (elem[0].tagName == "INPUT" && elem.attr("type") != "text")) {
			return;
		}
		
		//On va maintenant s'assurer qu'il a un positionner
		var posi = $("#"+elem.attr("assistId"));
		//S'il n'y en a pas, on va le flagger et on va le créer
		var flag = false;
		if (posi.size() == 0) {
			var relDiv = $("<div>");
			relDiv.attr("id","assistposi-"+assistCount.count);
			elem.attr("assistId","assistposi-"+assistCount.count);
			elem.before(relDiv);
			flag = true;
		}
		
//		var isCtrl = false;
		$(document).keyup(function (e) { 
			if(e.which == 17) {
				isCtrl=false; 
			}
		}).keydown(function (e) { 
			if(e.which == 17) {
				hitCtrl(); 
			}
			if (e.which == 27) {
				closeAllAssist(e);
			}
		});
		
		var assist = new AssistDynaText(elem.get(0));
		assist.fnUpdate = fnUpdate || function() {};
		assist.ajaxCall = function(value) {
			var newTemplate = { desc: getNewTemplateValue(this.baseElement), special: true };
			var idType = $(this.baseElement).attr("idType");
			var sObj = getAssistText(idType, getWord(this.baseElement));
			var obj = $.parseJSON(sObj);
			
			var list = new Array();
			
			for (var i = 0 ;i  < obj.length; i++) {
				list.push(obj[i]);
			}
			if (newTemplate.desc != null) {
				list.push(newTemplate);
			}
			
			this.search.elems = list;
		}
		
		assist.getSpecialKey = function(elem) {
			var span = $("<span>");
			span.text("Ajouter assistant");
			span.addClass("special-assist");
			return span;
		}
		
		assist.getSpecialDescription = function(elem) {
			var div = $("<div>");
			var pA = $("<div>");
			var pB = $("<div>");
			var pC = $("<div>");
			
			div.append(pA).append(pB).append(pC);
			
			pA.addClass("desc-special-header");
			pB.addClass("desc-special-text");
			pC.addClass("desc-special-footer");
			
			pA.text("Voici le texte qui sera ajout\u00E9 comme assistant:");
			pB.html(elem.desc.replace(/\n/g,"<br/>").replace(/  /g," &nbsp;"));
			pC.text(
				"Le texte d'ajout d'un assistant est le texte s\u00E9lectionn\u00E9.  Si aucun text est "
				+"s\u00E9lectionn\u00E9, c'est le texte complet."
			);
			
			return div;
		}
		assist.getKeyClass = function(elem) {
			if (elem.special) {
				return "flag-0";
			}
			return "flag-"+elem.flag
		}
		assist.getKey = function(elem) {
			if (elem.special) {
				return this.getSpecialKey(elem);
			}
		
			var key = elem.name;
			var div = $("<div>");
			div.text(key);
			return div;
		}
		
		assist.getDescription = function(elem) {
			if (elem.special) {
				return this.getSpecialDescription(elem);
			}
			var desc = elem.text;
			var div = $("<div>");
			var divT = $("<div>");
			var divD = $("<div>");
			divD.html(desc.replace(/\$\{[^\}]*\}/g," ? ").replace(/\r\n/g,"<br/>").replace(/\n/g,"<br/>").replace(/\r/g,"<br/>").replace(/  /g," &nbsp;"));
			divT.text(elem.name);
			divT.css({
				"font-weight": "bolder",
				"font-size": "1.1em",
				"padding": "2px 0px 6px 0px" 
			});
			div.append(divT).append(divD);
			return div;
		}
		
		assist.selection = function(elem) {
			if (elem.special) {
				this.getSpecialSelection(elem);
				return;
			}
			
			var val = this.baseElement.value.substring(0,this.baseElement.selectionStart);
//			val += elem.text;
			val += gabaritGetFinalText(elem.text);
			val += this.baseElement.value.substring(this.baseElement.selectionEnd);
			this.baseElement.selectionStart = val.length;
			this.baseElement.selectionEnd = val.length;
			$(this.baseElement).val(val);
			assistantSelectedCount(elem.id);
			this.fnUpdate();
		}
		
		assist.getSpecialSelection = function(elem) {
			popupAddWindow(elem.desc,$(this.baseElement).attr("idType"));
		}
		
		if (flag) {
			assist.calculatePosition = function(){
				var baseConfig = {
					font: $(this.baseElement).css("font-family"),
					fontSize: $(this.baseElement).css("font-size"),
					fontWeight: $(this.baseElement).css("font-weigth"),
					width: $(this.baseElement).width(),
					height: $(this.baseElement).height(),
					charSize: getNavSizeFrom(this.baseElement),
					position: Math.max(this.baseElement.selectionStart, this.baseElement.selectionEnd),
					lineHeight: parseInt($(this.baseElement).css("line-height")),
					scrollTop: $(this.baseElement).scrollTop()
				};
				
				if (typeof(baseConfig.lineHeight) == 'undefined' || isNaN(baseConfig.lineHeight) || baseConfig.lineHeight == "normal") {
					baseConfig.lineHeight = baseConfig.charSize.h;
				}
				
				baseConfig.nbChar = Math.floor(baseConfig.width/baseConfig.charSize.l);
				var reg = new RegExp(".*\\w*");
				
				var info = { line: 0, pos: 0, txt: $(this.baseElement).val()}
				
				var lines = info.txt.split("\n");
				
				var lines2 = new Array();
				var reg1 = /^[^ ]* ?/;
				var reg2 = /^ */;
				for (var i = 0; i < lines.length; i++) {
					var line = lines[i];
					var li = "";
					
					if (line.length == 0 || line == "\n") {
						lines2.push(line);
					}
					
					while(line.length > 0) {
						var word = reg1.exec(line);
						if (word != null) {
							word = word[0]
							line = line.substring(word.length);
							if (word.length > baseConfig.nbChar) {
								if (li.length > 0) {
									lines2.push(li);
								}
								lines2.push(word.substring(0,baseConfig.nbChar));
								li = word.substring(baseConfig.nbChar);
							} else if (li.length + word.length > baseConfig.nbChar){
								if (li.length > 0) {
									lines2.push(li);
								}
								li = word;
							} else {
								li += word;
							}
						}
						var space = reg2.exec(line);
						if (space != null) {
							space = space[0];
							line = line.substring(space.length);
							if (li.length + space.length > baseConfig.nbChar) {
								if (li.length > 0) {
									lines2.push(li+space.substring(0, baseConfig.nbChar-li.length));
								}
								li = space.substring(baseConfig.nbChar-li.length);
							} else {
								li += space;
							}
						}
					}
					if (li.length > 0 ) {
						lines2.push(li);
					}
					
				}
				
				var pos = baseConfig.position;
				var count = 0;
				var lastLine = null;
				while (pos > 0) {
					lastLine = lines.length > count?lines2[count]:lastLine;
					pos  -= Math.max(1,lines.length > count?lines2[count].length:0);
					if (lines.length > count) {count++};
				}
				if (pos == 0 && (lastLine == null || (lastLine != "\n" && lastLine != ""))) {
					count++;
				}
				
				info.line = count;

				var posX = 2+baseConfig.lineHeight*Math.max(1,info.line)-baseConfig.scrollTop;
				baseConfig.info = info;

				return posX;
			};
		}
	};
	
	function popupAddWindow(desc, idType) {
		
		var mainTable = $("<table>");

		for (var j = 0; j < 3; j++) {
			var tr = $("<tr>");
			for (var i = 0; i < 3; i++) {
				var td = $("<td>");
				td.addClass("col-"+(i+1));
				tr.append(td);
			}
			tr.addClass("row-"+(j+1));
			mainTable.append(tr);
		}
		
		mainTable.addClass("popup-table");
		
		var popupDiv = $("<div>");
		var hDiv = $("<div>");
		var cDiv = $("<div>");
		var tDiv = $("<div>");
		var input = $("<input>");
		var buOkiDiv = $("<div>");
		var buCancelDiv = $("<div>");
		var cBuDiv = $("<div>");
		var errDiv = $("<div>");
		
		input.attr("type", "text");
		input.addClass("popup-input");
		
		popupDiv.addClass("popup-div");
		hDiv.addClass("header");
		cDiv.addClass("content");
		tDiv.addClass("text");
		buOkiDiv.addClass("popup-bu").addClass("popup-bu-oki");
		buCancelDiv.addClass("popup-bu").addClass("popup-bu-can");
		cBuDiv.addClass("clear");
		errDiv.addClass("error");
		input.addClass("input").addClass("starter");
		
		hDiv.text("Ajouter un assistant");
		cDiv.text("Vous devez donner un nom pour identifier ce nouvel assistant ayant le contenu suivant:");
		tDiv.text(desc);
		buOkiDiv.text("Sauvegarder");
		buCancelDiv.text("Annuler");
		var startName = "Nom de l'assistant";
		input.val(startName);
		
		popupDiv.append(hDiv)
			.append(cDiv)
			.append(tDiv)
			.append(input)
			.append(errDiv)
			.append(buOkiDiv)
			.append(buCancelDiv)
			.append(cBuDiv);
			
		buCancelDiv.click(function() {
			mainTable.remove();
		});
		
		buOkiDiv.click(function() {
			var val = input.val();
			if (val.length && (val.length == 0 || val == startName)) {
				
				var p = $("<div>");
				var childs = errDiv.children();
				p.hide();
				p.text("Vous devez entrer un nom pour votre assistant!");
				if (childs.size() > 0 ) {
					childs.slideUp(200, function() {
						childs.remove();
						errDiv.append(p);
						p.slideDown();
					});
				} else {
					errDiv.append(p);
					p.slideDown();
				}
			} else {
				createNewAssistant(idType,desc, val);
				mainTable.remove();
			}
		});
		
		input.keydown(function() {
			if (input.val() == startName) {
				input.val("");
				input.removeClass("starter");
			}
		});
		
		mainTable.find(".row-2 .col-2").append(popupDiv);
		$(document.body).append(mainTable);
		input.focus();
	}
	
	function getNewTemplateValue(input) {
		var val = input.value;
		var pos = {
			start: input.selectionStart,
			end: input.selectionEnd
		}
		if (pos.start != pos.end) {
			return val.substring(pos.start, pos.end);
		} else if (val.length > 0){
			return val;
		} else {
			return null;
		}
	}
	
	function getWord(input) {
		var val = input.value;
		var pos = {
			start: input.selectionStart,
			end: input.selectionEnd,
			sens: input.selectionDirection
		}
		if (pos.start != pos.end) {
			return val.substring(pos.start, pos.end);
		} else {
			var str = "";
			var patt = /\W/;
			for (var i = pos.start-1; i >= 0; i--) {
				var c = val.substring(i, i+1);
				if ( patt.test(c) && "-àäâéèêëìïîòôöÿûüçÀÂÄÉÈÊËÌÎÏÒÔÖÛÜÇ".indexOf(c) == -1) {
					break;
				} else {
					str = c + str;
				}
			}
			if (str.length > 0) {
				input.selectionStart = input.selectionEnd - str.length;
				return str;
			}
		}
		
		return null;
	}
	
/*	function createNewAssistant(desc, val) {
//				console.log("CREATE: "+val+" - "+desc);
	}
	function getAssistText() {
		var str = "[{\"id\":390,\"name\":\"Principale Principale Principale Principale Principale Principale \",\"text\":\"Principale\",\"type\":2,\"flag\":1,\"user\":{\"id\":4,\"idUser\":37,\"application\":\"ofys\",\"idClient\":3},\"isHtml\":false,\"isClientPrivate\":true,\"type2\":\"ADDRESS_NOTE\"},"+
				"{\"id\":3,\"name\":\"Travail\",\"text\":\"Travail\",\"type\":2,\"flag\":1,\"user\":{\"id\":4,\"idUser\":37,\"application\":\"ofys\",\"idClient\":3},\"isHtml\":false,\"isClientPrivate\":true,\"type2\":\"ADDRESS_NOTE\"},"+
				"{\"id\":4,\"name\":\"Travail1\",\"text\":\"Travail1\",\"type\":2,\"flag\":1,\"user\":{\"id\":4,\"idUser\":37,\"application\":\"ofys\",\"idClient\":3},\"isHtml\":false,\"isClientPrivate\":true,\"type2\":\"ADDRESS_NOTE\"},"+
				"{\"id\":5,\"name\":\"Travail2\",\"text\":\"Travail2\",\"type\":2,\"flag\":2,\"user\":{\"id\":4,\"idUser\":37,\"application\":\"ofys\",\"idClient\":3},\"isHtml\":false,\"isClientPrivate\":true,\"type2\":\"ADDRESS_NOTE\"},"+
				"{\"id\":6,\"name\":\"Travail3\",\"text\":\"Travail3\",\"type\":2,\"flag\":2,\"user\":{\"id\":4,\"idUser\":37,\"application\":\"ofys\",\"idClient\":3},\"isHtml\":false,\"isClientPrivate\":true,\"type2\":\"ADDRESS_NOTE\"},"+
				"{\"id\":7,\"name\":\"Travail4\",\"text\":\"Travail4\",\"type\":2,\"flag\":3,\"user\":{\"id\":4,\"idUser\":37,\"application\":\"ofys\",\"idClient\":3},\"isHtml\":false,\"isClientPrivate\":true,\"type2\":\"ADDRESS_NOTE\"},"+
				"{\"id\":8,\"name\":\"Travail5\",\"text\":\"Travail5\",\"type\":2,\"flag\":3,\"user\":{\"id\":4,\"idUser\":37,\"application\":\"ofys\",\"idClient\":3},\"isHtml\":false,\"isClientPrivate\":true,\"type2\":\"ADDRESS_NOTE\"},"+
				"{\"id\":9,\"name\":\"Travail6\",\"text\":\"Travail6\",\"type\":2,\"flag\":4,\"user\":{\"id\":4,\"idUser\":37,\"application\":\"ofys\",\"idClient\":3},\"isHtml\":false,\"isClientPrivate\":true,\"type2\":\"ADDRESS_NOTE\"},"+
				"{\"id\":10,\"name\":\"Travail7\",\"text\":\"Travail7\",\"type\":2,\"flag\":4,\"user\":{\"id\":4,\"idUser\":37,\"application\":\"ofys\",\"idClient\":3},\"isHtml\":false,\"isClientPrivate\":true,\"type2\":\"ADDRESS_NOTE\"},"+
				"{\"id\":11,\"name\":\"Travail8\",\"text\":\"Travail8\",\"type\":2,\"flag\":4,\"user\":{\"id\":4,\"idUser\":37,\"application\":\"ofys\",\"idClient\":3},\"isHtml\":false,\"isClientPrivate\":true,\"type2\":\"ADDRESS_NOTE\"}"+
				"]";
//				console.log(str);
		return str;
	}
	*/		
		
		
		
		
		






/****************************
 *	BASE ASSISTANT BUILDER	*
 ****************************/

var listAssist = new Array();

var currentAssist = null;


function AssistDynaText(linkedElement) {
	this.baseElement = linkedElement;
	this.assistElement = null
	this.search = null;
	this.assistCss = {
		listWidth: 250,
		descWidth: 400,
		borderColor: "rgb(201,156,71)",
		//backgroundColor: "rgb(245,228,154)",
		backgroundColor: "rgb(242,232,187)",
		helpText: "'ESC' pour fermer, \u2191 et \u2193 pour d\u00E9placer, 'ENTRER' pour s\u00E9lectionner.",
		maxHeigth: 250
	};
	this.isOver = false;
	this.isOpen = false;
	/*
		Must be defined on the fly :
		var elem : element that we want the description
		return : $ element that can be append to an other element
	*/
	this.getText = function(elem){};
	this.getKey = function(elem){};
	this.getKeyClass = function(elem){ return null;};
	this.getDescription = function(elem){};
	this.selection = function(elem){};
	this.calculatePosition = function(){ return null; };
	
	/*
		Must be synchronus call
	*/
	this.ajaxCall = function(value){};
	
	this.open = function() {
		if (this.assistElement == null) return;
		this.isOpen = true;
		if (this.buildInner()) {
			this.assistElement.children(".assist-main-div").fadeIn(300);
		}
		var pos = this.calculatePosition();
		if (pos != null) {
			this.assistElement.children(".assist-main-div").css("top",pos+"px");
		}
		var vertical = {
			wh : $(window).height(),
			ws : $(window).scrollTop(),
			ah : this.assistElement.children(".assist-main-div").height(),
			as : this.assistElement.children(".assist-main-div").offset().top
		};
		var scrollTo = Math.max(0,vertical.as + vertical.ah - vertical.wh);
		if (scrollTo > vertical.ws) {
//			$(window).scrollTop(scrollTo);
		}
		var ul = this.assistElement.children(".assist-main-div").children(".assist-list-div").children(".assist-list-ul");
/*		if (ul.height() > this.assistCss.maxHeigth) {
			ul.css("overflow","scroll");
			ul.css("height",this.assistCss.maxHeigth+"px");
		} else {
			ul.css("overflow","");
			ul.css("height","");
		}*/
	};
	

	
	this.close = function(dontReset) {
		//Make reset as default
		var reset = !(dontReset || false);
		if (this.assistElement == null) return;
		this.assistElement.children(".assist-main-div").fadeOut(100);
		if (reset) {
			this.resetSearch();
		}
		this.isOpen = false;
	};
	
	this.buildBase = function() {
		//Check if usable
		var e = $(this.baseElement);
		if (e.size() != 1
			|| typeof e.attr("assistId") === 'undefined' || e.attr("assistId").length < 1
		) {
			return;
		}
		e.css("font-family","Courier New");
		e.css("font-size","14pt");
		this.assistElement = $("#"+e.attr("assistId"));
		
		if (this.assistElement.size() != 1) {
			this.assistElement = null;
			return;
		}
		
		//On va construire les prémisse asteur
		var assistMainDiv = $("<div></div>");
		var helpDiv = $("<div></div>");
		var assistListDiv = $("<div></div>");
		var assistListUL = $("<ul></ul>");
		var assistDescDiv = $("<div></div>");
//		var clearDiv = $("<div></div>");
		
		//On va rendre l'assistElement comme positionneur
		this.assistElement.children().remove();
		this.assistElement.css("position","relative");
		this.assistElement.css("top","0px");
		this.assistElement.css("left","0px");
		
		//On va ajuster les div
		helpDiv.addClass("assist-help-div");
		helpDiv.css("width",(this.assistCss.listWidth+this.assistCss.descWidth+4)+"px");
		helpDiv.css("border-color",this.assistCss.borderColor);
		helpDiv.css("background-color",this.assistCss.backgroundColor);
		helpDiv.text(this.assistCss.helpText);
		
		assistMainDiv.addClass("assist-main-div");
		assistMainDiv.css("width",(this.assistCss.listWidth+this.assistCss.descWidth+8)+"px");

		assistListDiv.addClass("assist-list-div");
		assistListDiv.css("width",this.assistCss.listWidth+"px");
		assistListDiv.css("border-color",this.assistCss.borderColor);
		assistListDiv.css("background-color",this.assistCss.backgroundColor);

		assistDescDiv.addClass("assist-desc-div");
		assistDescDiv.css("width",this.assistCss.descWidth+"px");
		assistDescDiv.css("border-color",this.assistCss.borderColor);
		assistDescDiv.css("background-color",this.assistCss.backgroundColor);
		
		assistListUL.addClass("assist-list-ul");

		//Bind event
		var that = this;
		$(this.baseElement).keydown(function(e) {
			if (that.isOpen) {
				if (	e.which == 40 
					||	e.which == 39 
					||	e.which == 38 
					||	e.which == 37 
					||	e.which == 13
					||	e.which == 13
				){
					e.preventDefault();
				}
			}
			if (isCtrl) {
				if (e.which == 32) {
					e.preventDefault();
				}
			}
		});
		$(document).keypress(function(e) {
			if (that.isOpen) {
				if (	e.which == 40 
					||	e.which == 39 
					||	e.which == 38 
					||	e.which == 37 
					||	e.which == 27
				){
					e.preventDefault();
				}
			}
			if (isCtrl) {
				if (e.which == 32) {
					e.preventDefault();
				}
			}
		});
		$(this.baseElement).keyup(function(e) {
			if (e.which == 32 && isCtrl && !that.isOpen) {
				e.preventDefault();
				e.stopPropagation();
				closeAllAssist();
				that.open();
			} else if (e.which == 40 && that.isOpen) {
				e.preventDefault();
				e.stopPropagation();
				that.selectNext();
			} else if (e.which == 38 && that.isOpen) {
				e.preventDefault();
				e.stopPropagation();
				that.selectPrev();
			} else if (e.which == 13 && that.isOpen) {
				e.preventDefault();
				e.stopPropagation();
				that.select();
			} else if (e.which == 27 && that.isOpen) {
				alert("CLOSE ESC");
				e.preventDefault();
				e.stopPropagation();
				closeAllAssist();
			} else if ( typeof that.baseElement.value !== 'undefined' && that.baseElement.value.length >= 3 && !that.isOpen && !isHelperKey(e.which)) {
/*				if (that.search.originalText == null) {
					closeAllAssist();
				}
				console.log("OPEN B");
				that.open();*/
			} else if ( typeof that.baseElement.value !== 'undefined' && that.baseElement.value.length >= 3 && that.isOpen && !isHelperKey(e.which)) {
				e.preventDefault();
				e.stopPropagation();
	//			that.buildInner();
			} else if ( typeof that.baseElement.value !== 'undefined' && that.baseElement.value.length < 3 && that.isOpen) {
				e.preventDefault();
				e.stopPropagation();
				that.open();
			}
			
		});
		$(this.baseElement).blur(function() {
			if (!that.isOver) {
				that.close();
			}
		});
		
		$(this.assistElement).mouseover(function() {
			that.isOver = true;
		}).mouseout(function() {
			that.isOver = false;
		});
		
		//finir d'initaliser
		this.resetSearch();
		
		//On va les assembler
		assistListDiv.append(assistListUL);
		assistMainDiv.append(helpDiv).append(assistListDiv).append(assistDescDiv);
		this.assistElement.append(assistMainDiv);
		
		//S'enregistrer
		listAssist.push(this);
		
	};
	
	this.buildInner = function() {
		//On va aller chercher la valeur a rechercher
		var val = this.baseElement.value;
		//On va aller voir si on doit faire un ajaxCall
		//console.log(this.search.originalText+"/"+val.indexOf(this.search.originalText)
//		console.log("val="+val+", orig="+this.search.originalText);
		if (this.search.originalText == null) {//  && val.length >= 3) {
			this.resetSearch();
			this.search.originalText = val;
			this.ajaxCall(val);
		} else if (this.search.originalText != null && this.search.originalText != val) {// && val.length >= 3) {
			this.resetSearch();
			this.search.originalText = val;
			this.ajaxCall(val);
		} else {
/*			this.close();
			return false;*/
		}
		
		if (this.search.elems == null || this.search.elems.length < 1) {
			this.close();
			return false;
		}
		
		//Gonna creates elements : first : remove all old
		var ul = this.assistElement.children(".assist-main-div").children(".assist-list-div").children(".assist-list-ul");
		ul.children().remove();
		var count = 0;
		
		//NORMAL LIST
		for (var i = 0; i < this.search.elems.length; i++) {
			var key = this.getKey(this.search.elems[i]);
			//On construit!
			var li = $("<li></li>");
			if (typeof key == "string") {
				li.text(key);
			} else {
				li.append(key);
			}
			li.attr("ref",i);
			li.addClass("assist-item-"+i);
			li.addClass("assist-item");
			var c = this.getKeyClass(this.search.elems[i]);
			if (c != null) {
				li.addClass(c);
			}
			//bind event
			var that = this;
			li.mouseover(function() {
				var ind = $(this).attr("ref");
				if (typeof ind != 'undefined' && ind != null) {
					that.assistElement.find(".item-selected").removeClass("item-selected");
					that.selectThisOne(ind);
				}
			});
			li.click(function() {
				that.select();
			});
				
			ul.append(li);
			count++;
		}
		
		if (count == 0) {
			this.close(true);
			return false;
		} else if (ul.height() > this.assistCss.maxHeigth-2) {
			ul.css("overflow-y","scroll");
			ul.css("height",(this.assistCss.maxHeigth-2)+"px");
		} else {
			ul.css("overflow-y","");
			ul.css("height","");
		} 
	
		this.selectNext();
		return true;
	}
	
	this.select = function(arg) {
		var i = this.assistElement.find(".item-selected").attr("ref");
		var elem = null;
		if (typeof i != 'undefined' && i != null) {
			var e = this.search.elems[i];
			if (typeof e != 'undefined' && e != null) {
				elem = e;
			}
		}
		
		this.close();
		if (elem != null) {
			this.selection(elem, arg);
		}
	}
	
	this.selectThisOne = function(index) {
		var s = this.assistElement.find(".assist-item-"+index);
		s.addClass("item-selected");
		var e = this.search.elems[index];
		var desc = null;
		if (typeof e != 'undefined' && e != null) {
			desc = this.getDescription(e);
		}
		this.assistElement.find(".assist-desc-div").css("height","");
		this.assistElement.find(".assist-desc-div").css("overflow-y","inherit");
		this.assistElement.find(".assist-desc-div").children().remove();
		if (typeof desc != 'undefined' && desc != null) {
			this.assistElement.find(".assist-desc-div").append(desc).show();
			if (this.assistElement.find(".assist-desc-div").height() > this.assistCss.maxHeigth) {
				this.assistElement.find(".assist-desc-div").css("overflow-y","scroll");
			}
			this.assistElement.find(".assist-desc-div").css("height", this.assistCss.maxHeigth+"px");
		} else {
			this.assistElement.find(".assist-desc-div").text("").hide();
		}
		
		//Watch for autoscroll
		var ul = s.parent();
		console.log("position: "+(s.offset().top - ul.offset().top)+ ":" +(s.offset().top - ul.offset().top + s.height())+ " / " + ul.height() + " / " + ul.scrollTop());
		if (
			ul.css("overflow-y") == "scroll" && 
			(s.offset().top - ul.offset().top + s.height() ) > (ul.height())
		) {
			console.log("  scroll: "+( (s.offset().top - ul.offset().top + s.height() ) -  ul.height() ) );
			ul.scrollTop( (s.offset().top - ul.offset().top + s.height() + ul.scrollTop()) -  ul.height() );
		} else if (
			ul.css("overflow-y") == "scroll" && 
			(s.offset().top - ul.offset().top ) < 0
		){
			console.log("  scroll up:"+( ul.scrollTop() + (s.offset().top - ul.offset().top ) )+" / "+(s.offset().top - ul.offset().top ));
			ul.scrollTop( ul.scrollTop() + (s.offset().top - ul.offset().top ) );
		}
		
	};
	
	this.selectNext = function() {
		var s = this.assistElement.find(".item-selected").removeClass("item-selected");
		var i = 0;
		if (s.size() > 0) {
			var next = s.next("li");
			if (next.size() > 0) {
				var index = next.attr("ref");
				if (typeof index != 'undefined' && index != null) {
					i = index;
				}
			} else {
				var index = this.assistElement.find(".assist-item").first().attr("ref");
				if (typeof index != 'undefined' && index != null) {
					i = index;
				}
			}
		} else {
			var index = this.assistElement.find(".assist-item").first().attr("ref");
			if (typeof index != 'undefined' && index != null) {
				i = index;
			}
		}

		this.selectThisOne(i);
	};
	this.selectPrev = function() {
		var s = this.assistElement.find(".item-selected").removeClass("item-selected");
		var i = 0;
		if (s.size() > 0) {
			var prev = s.prev("li");
			if (prev.size() > 0) {
				var index = prev.attr("ref");
				if (typeof index != 'undefined' && index != null) {
					i = index;
				}
			} else {
				var index = this.assistElement.find(".assist-item").last().attr("ref");
				if (typeof index != 'undefined' && index != null) {
					i = index;
				}
			}
		}

		this.selectThisOne(i);
	};
	
	this.resetSearch = function() {
		this.search = {originalText: null, elems: new Array()};
	}
	
	this.buildBase();
	
}

function closeAllAssist(e) {
	var oneOpen = false;
	for(var i = 0; i < listAssist.length; i++) {
		oneOpen = oneOpen || listAssist[i].isOpen;
		listAssist[i].close();
	}
	
	if (typeof(e) != 'undefined' && e != null && oneOpen) {
		e.preventDefault();
		e.stopPropagation();
	}
}


function isHelperKey(value) {
	if
		(value == 17
		|| value == 27
		|| value == 16
		|| value == 20
		|| value == 18
		|| value == 9
		|| value == 144
		|| value == 45
		|| value == 145
		|| value == 44
		|| value == 46
		|| value == 35
		|| value == 36
		|| value == 33
		|| value == 34
		|| (value >= 112 && value <= 123)) {
		return true;
	}
	return false;
}

function getJavaAssist(val) {
	return [
		{key:val+"a"+Math.floor((Math.random()*10)+1), desc: "a-desc"},
		{key:val+"b"+Math.floor((Math.random()*10)+1), desc: "b-desc"},
		{key:val+"c"+Math.floor((Math.random()*10)+1), desc: "c-desc"},
		{key:val+"aa"+Math.floor((Math.random()*10)+1), desc: "aa-desc"},
		{key:val+"bb"+Math.floor((Math.random()*10)+1), desc: "bb-desc"},
		{key:val+"cc"+Math.floor((Math.random()*10)+1), desc: "cc-desc"}
	];
}

/********************
 *	NAVIGATOR INFO	*
 ********************/

 function getNavSizeFrom(txt) {
	txt = $(txt);
	var fontSize = txt.css("font-size");
	var reg = {
		number: /[0-9\.]*/,
		type: /pt|px/
	};
	
	var size = parseInt(reg.number.exec(fontSize));
	var type = reg.type.exec(fontSize);
	var list = getNavigatorSize();
	
	for ( var i = 0; i < list.px.length; i++) {
		if (type == "pt" && list.pt[i].s == size) {
			return list.pt[i];
		} else if (type == "px" && list.px[i].s == size) {
			return list.px[i];
		} else if (type != "pt" && type != "px") {
			break;
		}
	}
	
	return null;
}


function splitText() {
	var reg = /.{0,15}\w/;

	var txt = "Je suis un\n trou duc en la matière.";
	return reg.exec(txt);
}

function getNavigatorSize() {
	var jsType = '', browserType = '', browserVersion = '', osName = '';
	var ua = navigator.userAgent.toLowerCase();
	var check = function(r) {
		return r.test(ua);
	};
	var isOpera = check(/opera/);
	var isChrome = check(/chrome/);
	var isWebKit = check(/webkit/);
	var isSafari = !isChrome && check(/safari/);
	var isIE = !isOpera && check(/msie/);
	var isIE7 = isIE && check(/msie 7/);
	var isIE8 = isIE && check(/msie 8/);
	var isIE9 = isIE && check(/msie 9/);
	var isIE10 = isIE && check(/msie 10/);
	var isIE11 = isIE && check(/msie 11/);
	var isGecko = !isWebKit && check(/gecko/);
	var isWindows = check(/windows|win32/);
	var isMac = check(/macintosh|mac os x/);

	if(isIE){
		if( isIE7 ) {
			return { 
				px: [
					{ s: 4, l: 2.45, h: 3},
					{ s: 5, l: 3.25, h: 4.5},
					{ s: 6, l: 4.1, h: 6.5},
					{ s: 7, l: 4.95, h: 6.5},
					{ s: 8, l: 4.95, h: 9.5},
					{ s: 9, l: 5.75, h: 9.5},
					{ s: 10, l: 6.6, h: 11.5},
					{ s: 11, l: 7.45, h: 13},
					{ s: 12, l: 7.45, h: 14},
					{ s: 13, l: 8.3, h: 14},
					{ s: 14, l: 9.1, h: 14.5},
					{ s: 15, l: 9.1, h: 16.5},
					{ s: 16, l: 9.95, h: 17},
					{ s: 17, l: 10.8, h: 18},
					{ s: 18, l: 11.6, h: 19},
					{ s: 19, l: 11.6, h: 19.5},
					{ s: 20, l: 12.45, h: 20.5},
					{ s: 21, l: 13.3, h: 24},
					{ s: 22, l: 14.1, h: 24},
					{ s: 23, l: 14.1, h: 24.5},
					{ s: 24, l: 14.95, h: 25.5},
					{ s: 25, l: 14.95, h: 16.5},
					{ s: 26, l: 16.65, h: 27},
					{ s: 27, l: 16.65, h: 29.5},
					{ s: 28, l: 17.45, h: 29.5},
					{ s: 29, l: 17.45, h: 30.5},
				],
				pt: [
					{ s: 4, l: 4.1, h: 5.5},
					{ s: 5, l: 4.1, h: 6.5},
					{ s: 6, l: 4.95, h: 9.5},
					{ s: 7, l: 6.6, h: 11.5},
					{ s: 8, l: 6.6, h: 12},
					{ s: 9, l: 7.45, h: 14},
					{ s: 10, l: 8.3, h: 14},
					{ s: 11, l: 9.1, h: 16.5},
					{ s: 12, l: 9.95, h: 17},
					{ s: 13, l: 10.8, h: 18},
					{ s: 14, l: 11.6, h: 19.5},
					{ s: 15, l: 12.45, h: 20.5},
					{ s: 16, l: 13.3, h: 24},
					{ s: 17, l: 14.1, h: 24.5},
					{ s: 18, l: 14.95, h: 25.5},
					{ s: 19, l: 15.8, h: 27},
					{ s: 20, l: 16.65, h: 27},
					{ s: 21, l: 17.45, h: 29.5},
					{ s: 22, l: 18.3, h: 32},
					{ s: 23, l: 19.15, h: 32},
					{ s: 24, l: 19.95, h: 33},
					{ s: 25, l: 19.95, h: 34.5},
					{ s: 26, l: 21.65, h: 36.5},
					{ s: 27, l: 22.45, h: 38},
					{ s: 28, l: 22.45, h: 39},
					{ s: 29, l: 24.15, h: 40.5},
				]
			}
		} else {
//		if( isIE11 ) {
			return { 
				px: [
					{ s: 4, l: 3.25, h: 4.5},
					{ s: 5, l: 3.85, h: 5.5},
					{ s: 6, l: 4.445, h: 7},
					{ s: 7, l: 5.05, h: 8},
					{ s: 8, l: 5.65, h: 9},
					{ s: 9, l: 6.25, h: 10},
					{ s: 10, l: 6.85, h: 11.5},
					{ s: 11, l: 7.45, h: 12.5},
					{ s: 12, l: 8.05, h: 13.5},
					{ s: 13, l: 8.65, h: 14.5},
					{ s: 14, l: 9.25, h: 16},
					{ s: 15, l: 9.85, h: 17},
					{ s: 16, l: 10.45, h: 18},
					{ s: 17, l: 11.05, h: 19.5},
					{ s: 18, l: 11.65, h: 20.5},
					{ s: 19, l: 12.25, h: 21.5},
					{ s: 20, l: 12.85, h: 22.5},
					{ s: 21, l: 13.45, h: 24},
					{ s: 22, l: 14.05, h: 25},
					{ s: 23, l: 14.65, h: 26},
					{ s: 24, l: 15.25, h: 27},
					{ s: 25, l: 15.85, h: 28.5},
					{ s: 26, l: 16.45, h: 29.5},
					{ s: 27, l: 17.05, h: 30.5},
					{ s: 28, l: 17.65, h: 31.5},
					{ s: 29, l: 18.25, h: 33},
				],
				pt: [
					{ s: 4, l: 4.05, h: 6},
					{ s: 5, l: 4.85, h: 7.5},
					{ s: 6, l: 5.56, h: 9},
					{ s: 7, l: 6.45, h: 10.5},
					{ s: 8, l: 7.25, h: 12},
					{ s: 9, l: 8.05, h: 13.5},
					{ s: 10, l: 8.85, h: 15},
					{ s: 11, l: 9.65, h: 16.5},
					{ s: 12, l: 10.45, h: 18},
					{ s: 13, l: 11.25, h: 19.5},
					{ s: 14, l: 12.05, h: 21},
					{ s: 15, l: 12.85, h: 22.5},
					{ s: 16, l: 13.65, h: 24},
					{ s: 17, l: 14.45, h: 25.5},
					{ s: 18, l: 15.25, h: 27},
					{ s: 19, l: 16.05, h: 28.5},
					{ s: 20, l: 16.85, h: 30},
					{ s: 21, l: 17.65, h: 31.5},
					{ s: 22, l: 18.45, h: 33},
					{ s: 23, l: 19.25, h: 34.5},
					{ s: 24, l: 20.05, h: 36},
					{ s: 25, l: 20.85, h: 37.5},
					{ s: 26, l: 21.65, h: 39},
					{ s: 27, l: 22.45, h: 40.5},
					{ s: 28, l: 23.25, h: 42},
					{ s: 29, l: 24.05, h: 43.5},
				]
			}
		}
	} else if (isGecko){
		var isFF =  check(/firefox/);
		if(isFF){
			return { px: [{ s: 14, l: 8.1, h: 17}]};
		}
	} else if(isSafari){
		return { 
			px: [
				{ s: 4, l: 3.05, h: 4},
				{ s: 5, l: 3.8, h: 6},
				{ s: 6, l: 4.75, h: 7},
				{ s: 7, l: 5.3, h: 8},
				{ s: 8, l: 6.05, h: 9},
				{ s: 9, l: 6.8, h: 10},
				{ s: 10, l: 7.55, h: 11},
				{ s: 11, l: 8.3, h: 12},
				{ s: 12, l: 9.05, h: 14},
				{ s: 13, l: 9.85, h: 15},
				{ s: 14, l: 10.55, h: 16},
				{ s: 15, l: 11.3, h: 17},
				{ s: 16, l: 12.05, h: 18},
				{ s: 17, l: 12.8, h: 19},
				{ s: 18, l: 13.55, h: 20},
				{ s: 19, l: 14.3, h: 22},
				{ s: 20, l: 15.05, h: 23},
				{ s: 21, l: 15.8, h: 23},
				{ s: 22, l: 16.55, h: 25},
				{ s: 23, l: 17.3, h: 26},
				{ s: 24, l: 18.05, h: 27},
				{ s: 25, l: 18.8, h: 29},
				{ s: 26, l: 19.55, h: 30},
				{ s: 27, l: 20.3, h: 30},
				{ s: 28, l: 21.05, h: 31},
				{ s: 29, l: 21.85, h: 33},
			],
			pt: [
				{ s: 4, l: 3.8, h: 6},
				{ s: 5, l: 5.3, h: 8},
				{ s: 6, l: 6.05, h: 9},
				{ s: 7, l: 6.8, h: 10},
				{ s: 8, l: 8.3, h: 12},
				{ s: 9, l: 9.05, h: 14},
				{ s: 10, l: 9.8, h: 15},
				{ s: 11, l: 11.3, h: 17},
				{ s: 12, l: 12.05, h: 18},
				{ s: 13, l: 12.8, h: 19},
				{ s: 14, l: 14.3, h: 22},
				{ s: 15, l: 15.05, h: 23},
				{ s: 16, l: 15.8, h: 23},
				{ s: 17, l: 17.3, h: 26},
				{ s: 18, l: 18.05, h: 27},
				{ s: 19, l: 18.8, h: 29},
				{ s: 20, l: 20.3, h: 30},
				{ s: 21, l: 21.05, h: 31},
				{ s: 22, l: 21.8, h: 33},
				{ s: 23, l: 23.3, h: 35},
				{ s: 24, l: 24.05, h: 37},
				{ s: 25, l: 24.8, h: 37},
				{ s: 26, l: 26.3, h: 40},
				{ s: 27, l: 27.05, h: 41},
				{ s: 28, l: 27.8, h: 42},
				{ s: 29, l: 29.3, h: 44},
			]
		}
	}
	return { 
		px: [
			{ s: 4, l: 3.25, h: 4.5},
			{ s: 5, l: 3.85, h: 5.5},
			{ s: 6, l: 4.445, h: 7},
			{ s: 7, l: 5.05, h: 8},
			{ s: 8, l: 5.65, h: 9},
			{ s: 9, l: 6.25, h: 10},
			{ s: 10, l: 6.85, h: 11.5},
			{ s: 11, l: 7.45, h: 12.5},
			{ s: 12, l: 8.05, h: 13.5},
			{ s: 13, l: 8.65, h: 14.5},
			{ s: 14, l: 9.25, h: 16},
			{ s: 15, l: 9.85, h: 17},
			{ s: 16, l: 10.45, h: 18},
			{ s: 17, l: 11.05, h: 19.5},
			{ s: 18, l: 11.65, h: 20.5},
			{ s: 19, l: 12.25, h: 21.5},
			{ s: 20, l: 12.85, h: 22.5},
			{ s: 21, l: 13.45, h: 24},
			{ s: 22, l: 14.05, h: 25},
			{ s: 23, l: 14.65, h: 26},
			{ s: 24, l: 15.25, h: 27},
			{ s: 25, l: 15.85, h: 28.5},
			{ s: 26, l: 16.45, h: 29.5},
			{ s: 27, l: 17.05, h: 30.5},
			{ s: 28, l: 17.65, h: 31.5},
			{ s: 29, l: 18.25, h: 33},
		],
		pt: [
			{ s: 4, l: 4.05, h: 6},
			{ s: 5, l: 4.85, h: 7.5},
			{ s: 6, l: 5.56, h: 9},
			{ s: 7, l: 6.45, h: 10.5},
			{ s: 8, l: 7.25, h: 12},
			{ s: 9, l: 8.05, h: 13.5},
			{ s: 10, l: 8.85, h: 15},
			{ s: 11, l: 9.65, h: 16.5},
			{ s: 12, l: 10.45, h: 18},
			{ s: 13, l: 11.25, h: 19.5},
			{ s: 14, l: 12.05, h: 21},
			{ s: 15, l: 12.85, h: 22.5},
			{ s: 16, l: 13.65, h: 24},
			{ s: 17, l: 14.45, h: 25.5},
			{ s: 18, l: 15.25, h: 27},
			{ s: 19, l: 16.05, h: 28.5},
			{ s: 20, l: 16.85, h: 30},
			{ s: 21, l: 17.65, h: 31.5},
			{ s: 22, l: 18.45, h: 33},
			{ s: 23, l: 19.25, h: 34.5},
			{ s: 24, l: 20.05, h: 36},
			{ s: 25, l: 20.85, h: 37.5},
			{ s: 26, l: 21.65, h: 39},
			{ s: 27, l: 22.45, h: 40.5},
			{ s: 28, l: 23.25, h: 42},
			{ s: 29, l: 24.05, h: 43.5},
		]
	};
}
 
})(Assistant)


