var _style_has_been_init = false;

function buildTextDifferer(textarea, classOverrideName) {
	initDiffererStyle();
	var className = classOverrideName || null;
	textarea = $(textarea);
	var div = $("<div>");
	
	differerCloneStyle(textarea, div);
	differerRegister(textarea, div);
	if (className != null) {
		div.addClass(classOverrideName);
	}
	textarea.after(div);
}

function initDiffererStyle() {	
	if (!_style_has_been_init) {
		_style_has_been_init = true;
		document.querySelector('style').textContent += "@media print {.differer-div-style { display: block; }}";
		document.querySelector('style').textContent += "@media print {.differer-textarea-style { display: none; }}";
		document.querySelector('style').textContent += "@media screen {.differer-div-style { display: none; }}";
	}
}

function differerCloneStyle(textarea, div) {
	div.attr("style", textarea.attr("style"));
	div.attr("class", textarea.attr("class"));
	
	div.addClass("differer-div-style");
	textarea.addClass("differer-textarea-style");
}

function differerRegister(textarea, div) {
	_textarea_div.push({textarea: textarea, div: div});
}


var _textarea_div = [];
_differCount = 0;
_differTimeout = 50;

function _differCloneText() {
	for (var i = 0; i < _textarea_div.length; i++) {
		_textarea_div[i].div.html(_textarea_div[i].textarea.val().replace(/\n/g,"<br/>").replace(/  /g," &nbsp;"));
	}
	if(_differCount < 21){
		_differTimeout = _differTimeout + (_differCount * 10)
		_differCount = _differCount + 1;
	}
	setTimeout(_differCloneText, _differTimeout);
}

$(document).ready(function() {
	_differCloneText();
});

