/*function getAssistText() {

//	return "[{\"id\":12015,\"name\":\"labo mémoire\",\"text\":\"Labos re problème congitif: FSC, TSH, folate, b12, ca, alb, gaj, creat, E+\",\"type\":20,\"user\":{\"id\":111,\"idUser\":3733,\"application\":\"ofys\",\"idClient\":180},\"isHtml\":false,\"isClientPrivate\":false,\"type2\":\"ENCOUNTER_NOTE\",\"flag\":1}]";
	return "[]";
}
*/


var AutoComplete = {
	//Determines sync and async execution flow. legacy code using SWT BrowserFunction requires the isWebVersion to be false.
	isWebVersion: false,
	//Activates angular model update
	hasAngular: false,
	//An environment provided api. Legacy code api is on the window. 
	//The api provides autocomplete template interactions 
	//( getAssistText - Returns list of templates, 
	//  assistantSelectedCount - Logs template use count, 
	//  gabaritGetDescription - returns the template description DEPRECATED used in legacy code only,
	//  gabaritGetFinalText - returns a resolved template with ready to use text,
	//  openTemplateEditor - opens the template edition/creation editor)
	api: window,
	isFrench: function () {
		return typeof APPLANG === 'undefined' || APPLANG === 'fr'
	}
};

(function(assist) {
	assist.util = {isPromise: function(obj){
		return !!obj && (typeof obj === 'object' || typeof obj === 'function') && typeof obj.then === 'function';
	}};
	assist.eformWrap = function (id, fnOnSelect, delegate) {
		var isFrench = AutoComplete.isFrench()

		function eformFnGetItemList(text) {

			var list = new Array();
			if (typeof (this.originalSel) != 'undefined') {
				var txtAdd = $(this.element).val();
				var idType = $(this.element).attr("idType");
				if (this.originalSel.s != this.originalSel.e) {
					txtAdd = txtAdd.substring(this.originalSacA, this.originalSel.e);
				}
			}


			try {
				var idType = $(this.element).attr("idType");
				var sObj = AutoComplete.api.getAssistText(idType, text);
				if (typeof sObj === "string") {
					var obj = $.parseJSON(sObj);
					for (var i = 0; i < obj.length; i++) {
						list.push(obj[i]);
					}
				} else if (typeof sObj === "function" || typeof sObj === "object") {
					return sObj;
				}


			} catch (e) {
				alert(e.description || e.message)
			};

			return list;

		}

		function eformFnDefaultShowItemName(text) {
			var div = $("<div>");
			var name = this.name;
			if (typeof (text) != 'undefined' && text.trim().length > 0) {
				name = name.replace(new RegExp(text.trim(), "gi"), "<span style='font-weight: bolder; background-color: yellow;'>" + text + "</span>");
			}
			if (typeof (this.flag) != 'undefined') {
				if (this.flag == 1) {
					div.css("background", "rgb(142, 207, 255)")
				} else if (this.flag == 2) {
					div.css("background", "rgb(245, 242, 255)")
				} else if (this.flag == 3) {
					div.css("background", "rgb(168, 235, 239)")
				} else if (this.flag == 4) {
//					div.css("background", "rgb(201, 232, 255)")
				}
			}
			div.html(name);
			div.css("cursor", "pointer");
			return div;
		}

		function eformFnGetdefaultShowItemDescription(text) {
			var div = $("<div>");
			if (!this.computeDescription) {
				try {
					this.computeDescription = AutoComplete.api.gabaritGetDescription(this.text);
				} catch (e) {
					this.computeDescription = this.text;
				}
			}

			var desc = this.computeDescription;

			if (typeof (text) != 'undefined' && text.trim().length > 0) {
				desc = desc.replace(new RegExp(text.trim(), "gi"), "<span style='font-weight: bolder; background-color: yellow;'>" + text + "</span>");
			}
			div.html(desc);
			div.css("word-wrap", "break-word");
			return div;
		}

		function eformFnSetOpenTrigger(baseElement, assistant) {
			baseElement.keydown(function (e) {
				if (e.ctrlKey && e.which == 32) {
					e.preventDefault();
					e.stopPropagation();
					assistant.openAssistant();
				}
			});
		}

		function eformFnSelect(assistant) { //onselect
			var sel = assistant.sel || {
				s: assistant.element.val().length(),
				e: assistant.element.val().length()
			};
			var transformtxt = ((delegate && delegate.transformTxt) || function (txt) {
				return txt;
			});

			var val = assistant.element.val();

			var insertText = ((delegate && delegate.insertText) || function (res, s) {
				var txt = val.substring(0, sel.s);
				txt += transformtxt(res);
				var cursor = txt.length;

				txt += val.substring(sel.e);
				assistant.element.val(txt);

				if (assist.hasAngular) { //Make sure angular mode is updated after value set in input
					assistant.element.trigger('input'); // Use for Chrome/Firefox/Edge
					assistant.element.trigger('change');
				}
				//Place the cursor to the right place
				assistant.element.get(0).selectionStart = cursor;
				assistant.element.get(0).selectionEnd = cursor;
			});

			try {
				var t;
				if (assist.isWebVersion) {
					t = AutoComplete.api.gabaritGetFinalText(this.text, this);
				} else {
					t = AutoComplete.api.gabaritGetFinalText(this.text);
				}
				if (assist.isWebVersion) {
					if (assist.util.isPromise(t)) {
						t.then(function (res) {
							insertText(res, sel)
							selectionDone();
							if (assist.mustCloseWhenSelect && assist.isWebVersion) {
								this.closeAssistant();
							}
						});
					} else if (typeof t === "string") {
						insertText(t, sel)
						selectionDone();
						if (assist.mustCloseWhenSelect && assist.isWebVersion) {
							this.closeAssistant();
						}
					}
				} else {
					insertText(t, sel)
				}
			} catch (e) {
				console.error("Erreur de gabarit: impossible d'inserer le gabarit");
				console.error(e);
				// insertText(t)
			}

			function selectionDone() {
				if (typeof (this.id) != 'undefined') {
					AutoComplete.api.assistantSelectedCount(this.id);
				}

				if (fnOnSelect) {
					fnOnSelect();
				}
			}

			if (!assist.isWebVersion) {
				selectionDone();
			}
		}

		function eformFnPositionning(assistant) { //positioning
			
			function getCursorSelectionObj(assistant){
				var sel = {
						s: assistant.element.get(0).selectionStart || 0,
						e: assistant.element.get(0).selectionEnd || 0
				};
				assistant.originalSel = {
						s: assistant.element.get(0).selectionStart || 0,
						e: assistant.element.get(0).selectionEnd || 0
				};
				
				return {
						s: Math.min(sel.s, sel.e),
						e: Math.max(sel.s, sel.e)
				}
			}
			assistant.sel = ((delegate && delegate.getCursorSelectionObj) || getCursorSelectionObj)(assistant);
//			assistant.sel = getCursorSelectionObj(assistant);
			function getHeightTextArea(assistant){
				var m = Math.max(assistant.sel.s, assistant.sel.e);
				var txt = assistant.element.val().substring(0, m).replace("  ", "&nbsp; ").replace("\r\n", "</br>").replace("\n\r", "</br>").replace("\n", "</br>").replace("\r", "</br>");
				if (m == 0) {
					txt = "&nbsp;";
				}
				txt += "</br>"
				var div = $("<div>");
				div.html(txt);
				div.css(getComputedStyle(assistant.element.get(0)));
				
				div.css("width", assistant.element.width() + "px");
				// div.css("height", "");
				
				div.css("visibility", "hidden");
				div.css("position", "absolute");
				var start = $("<span>");
				start.css("display", "inline-block");
				start.append("&nbsp;");
				div.append(start);
				assistant.element.parent().prepend(div);
				

				var h = start.get(0).offsetTop;

				//Scroll check
				if (h > assistant.element.height()) {
					h -= assistant.element.scrollTop();
				}
				
				
				if (typeof (document.documentMode) == 'undefined') {
					h += 4;
				}
				div.remove();
				return h + 2;
			}
			
			function getHeight(assistant){
				if(assistant.element.is("textarea")){
					return getHeightTextArea(assistant);
				}
				var m = Math.max(assistant.sel.s, assistant.sel.e);
				var txt = assistant.element.val().substring(0, m).replace("  ", "&nbsp; ").replace("\r\n", "</br>").replace("\n\r", "</br>").replace("\n", "</br>").replace("\r", "</br>");
				if (m == 0) {
					txt = "&nbsp;";
				}
				var div = $("<div>");
				div.html(txt);
				div.css(getComputedStyle(assistant.element.get(0)));
				
				div.css("width", assistant.element.width() + "px");
				div.css("height", "");
				
				div.css("visibility", "hidden");
				div.css("position", "absolute");
				$(document.body).append(div);
				
				var h = div.height();
				
				//Scroll check
				if (h > assistant.element.height()) {
					h -= assistant.element.scrollTop();
				}
				
				
				if (typeof (document.documentMode) == 'undefined') {
					h += 4;
				}
				div.remove();
				return h + 2;
			}
			return ((delegate && delegate.getHeight) || getHeight)(assistant);
//			return getHeight(assistant);
		}

		function eformFnOpen() { //onOpen
			var autocomplete = this;
			function searchVal(sel){
				if (sel) {
					//first step, if nothing select, try to get the word before.
					var txt = autocomplete.element.val();
					var unacceptChar = "  ;.,:'()$%&*/|!@#<>=+~\\\"\n\r\t≖";
					if (sel.s == sel.e) {
						while (sel.s > 0) {
							var c = txt.substring(sel.s - 1, sel.s);
							if (unacceptChar.indexOf(c) != -1) {
								break;
							}
							sel.s--;
						}
					}
					//second step, if we finaly have something selected, copy it as start value for search
					if (sel.s != sel.e) {
						return txt.substring(sel.s, sel.e);
					}
				}
				return "";
			}
			var val =  ((delegate && delegate.searchVal) || searchVal)(autocomplete.sel);
			this.filterInput.val("");
			this.searchInput.val(val.trim());

			var toFocus = this.searchInput;
			if (val.trim().length > 0) {
				toFocus = this.filterInput;
			}
			var that = this;
			setTimeout(function () {
				that.searchInput.val(that.searchInput.val().trim());
				that.filterInput.val(that.filterInput.val().trim());
			}, 200);
			if (typeof (this.searchInput.get(0).selectionStart) != 'undefined') {
				this.searchInput.get(0).selectionStart = val.trim().length;
				this.searchInput.get(0).selectionEnd = val.trim().length;
			}
			toFocus.focus();
		}

		function eformFnLegend() { //fnLegend
			var main = $("<div>");
			var clear = $("<div>");
			main.css("width", "100%");
			clear.css("clear", "both");

			var tableA = $("<table>");
			var trA = $("<tr>");
			var tdA1 = $("<td>");
			var tdA2 = $("<td>");
			var divA = $("<div>");


			main.css({
				"border-top": "solid 1px #e9e9e9",
			});
			tableA.css({
				"float": "left",
				"border-collapse": "collapse",
				"box-sizing": "border-box",
				"-moz-box-sizing": "border-box",
				"margin-left": "5px",
			});
			tdA1.css("vertical-align", "middle");
			tdA2.css("vertical-align", "middle");
			divA.css({
				"width": "14px",
				"height": "14px",
				"box-sizing": "border-box",
				"-moz-box-sizing": "border-box",
				"border": "1px solid black",
				"background-color": "rgb(142, 207, 255)",
			});
			tdA2.text(isFrench ? "Derniers utilis\u00E9s (moi)": "Last used (by me)");
			tdA1.append(divA);
			trA.append(tdA1).append(tdA2);
			tableA.append(trA);
			main.append(tableA);


			var tableB = $("<table>");
			var trB = $("<tr>");
			var tdB1 = $("<td>");
			var tdB2 = $("<td>");
			var divB = $("<div>");

			tableB.css({
				"float": "left",
				"border-collapse": "collapse",
				"box-sizing": "border-box",
				"-moz-box-sizing": "border-box",
				"margin-left": "5px",
			});
			tdB1.css("vertical-align", "middle");
			tdB2.css("vertical-align", "middle");
			divB.css({
				"width": "14px",
				"height": "14px",
				"box-sizing": "border-box",
				"-moz-box-sizing": "border-box",
				"border": "1px solid black",
				"background-color": "rgb(245, 242, 255)",
			});
			tdB2.text(isFrench ? "Plus utilis\u00E9s (moi)": "Most used (by me)");
			tdB1.append(divB);
			trB.append(tdB1).append(tdB2);
			tableB.append(trB);
			main.append(tableB);


			var tableC = $("<table>");
			var trC = $("<tr>");
			var tdC1 = $("<td>");
			var tdC2 = $("<td>");
			var divC = $("<div>");

			tableC.css({
				"float": "left",
				"border-collapse": "collapse",
				"box-sizing": "border-box",
				"-moz-box-sizing": "border-box",
				"margin-left": "5px",
			});
			tdC1.css("vertical-align", "middle");
			tdC2.css("vertical-align", "middle");
			divC.css({
				"width": "14px",
				"height": "14px",
				"box-sizing": "border-box",
				"-moz-box-sizing": "border-box",
				"border": "1px solid black",
				"background-color": "rgb(168, 235, 239)",
			});
			tdC2.text(isFrench ? "Plus utilis\u00E9s (clinique)": "Most used (clinic)");
			tdC1.append(divC);
			trC.append(tdC1).append(tdC2);
			tableC.append(trC);
			main.append(tableC);


			var tableD = $("<table>");
			var trD = $("<tr>");
			var tdD1 = $("<td>");
			var tdD2 = $("<td>");
			var divD = $("<div>");

			tableD.css({
				"float": "left",
				"border-collapse": "collapse",
				"box-sizing": "border-box",
				"-moz-box-sizing": "border-box",
				"margin-left": "5px",
			});
			tdD1.css("vertical-align", "middle");
			tdD2.css("vertical-align", "middle");
			divD.css({
				"width": "14px",
				"height": "14px",
				"box-sizing": "border-box",
				"-moz-box-sizing": "border-box",
				"border": "1px solid black",
				// "background-color": "rgb(201, 232, 255)",
			});
			tdD2.text(isFrench ? "Plus utilis\u00E9s (partag\u00E9s)": "Most used (shared)");
			tdD1.append(divD);
			trD.append(tdD1).append(tdD2);
			tableD.append(trD);
			main.append(tableD);

			main.append(clear);

			return main;
		}
		function eformFnOnBuild() {
			//				<div class="template-i-positionner"><div class="template-i-obj" onclick="openTemplateEditor(18)"></div></div>
			try {
				var divP = $("<div>");
				var divI = $("<div>");

				divP.css({
					"position": "relative",
					"top": "0px",
				});
				divI.css({
					"position": "absolute",
					"top": "0px",
					"left": "-10px",
					"width": "8px",
					"height": "8px",
					"background-image": "url('https://ofys.ca/formulaires/images/i8.png')",
					"cursor": "pointer",
					"z-index": "1000",
				});
				divP.addClass("hide-on-print");
				divP.append(divI);
				document.querySelector('style').textContent += "@media print {.hide-on-print { display: none; }}";
				var that = this;
				divI.click(function () {
					AutoComplete.api.openTemplateEditor(parseInt(that.element.attr("idType")));
				});
				this.element.before(divP);
			} catch (e) {
				alert("" + e.message)
			}
		}
		assist.NEW(
			id, 
			eformFnGetItemList,
			eformFnDefaultShowItemName, 
			eformFnGetdefaultShowItemDescription, 
			((delegate && delegate.openTrigger) || eformFnSetOpenTrigger),
			eformFnSelect, 
			eformFnPositionning, 
			null, //otherObject
			null, //endFocus on close
			eformFnOpen,
			eformFnLegend,
			eformFnOnBuild
		);
	}
	
	function getComputedStyle( dom ) {
        var style;
        var returns = {};
        // FireFox and Chrome way
        if(window.getComputedStyle){
            style = window.getComputedStyle(dom, null);
            for(var i = 0, l = style.length; i < l; i++){
                var prop = style[i];
                var val = style.getPropertyValue(prop);
                returns[prop] = val;
            }
            return returns;
        }
        // IE and Opera way
        if(dom.currentStyle){
            style = dom.currentStyle;
            for(var prop in style){
                returns[prop] = style[prop];
            }
            return returns;
        }
        // Style from style attribute
        if(style = dom.style){
            for(var prop in style){
                if(typeof style[prop] != 'function'){
                    returns[prop] = style[prop];
                }
            }
            return returns;
        }
        return returns;
    };
	
	assist.NEW = function(id, fnIL, fnSIN, fnSID, fnSetOpenTrigger, fnSelect, fnPositionning, otherObject, fnFocus, fnOpen, fnLegend, fnOnBuild) {
		return new Autocomplete(id, fnIL, fnSIN, fnSID, fnSetOpenTrigger, fnSelect, fnPositionning, otherObject, fnFocus, fnOpen, fnLegend, fnOnBuild);
	}

	function Autocomplete(id, fnIL, fnSIN, fnSID, fnSetOpenTrigger, fnSelect, fnPositionning, otherObject, fnFocus, fnOpen, fnLegend, fnOnBuild) {
		var isFrench = AutoComplete.isFrench();
		//Stores reference to the autocomplete object.
		var acA = this;
		
		acA.id = id;
		//Must be redefined
		acA.getItemList = fnIL || function() { return [];}
		acA.defaultShowItemName = fnSIN || function() {return "";}
		acA.defaultShowItemDescription = fnSID || function() {return "";}
		acA.defaultSelect = fnSelect || function(autoComplete) {
			alert(this.description)	;
		}
		acA.defaultMustCloseWhenSelect = true;
		//Can be redefined
		acA.getSpecialItemList = function() { return [];}
		acA.defaultShowSpecialItemName = function() {return "";}
		acA.defaultShowSpecialItemDescription = function() {return "";}
		acA.setOpenTrigger = fnSetOpenTrigger || function(baseElement) {};
		acA.getVerticalPosition = fnPositionning || function(){return 0;};
		acA.otherObject = otherObject;
		acA.open = false;
		acA.regainFocus = fnFocus || function(){getAutoElement().focus();};
		acA.onOpen = fnOpen || function(){acA.searchInput.focus();};
		acA.cache = new CacheList();
		acA.buildLegend = fnLegend || function(){ return null;}
		acA.buildExtension = fnOnBuild || function() {};
		//Contains a list of currently loaded templates.
		acA.itemList = [];
		acA.currentItem = {}//currently loaded template item object.
		
		acA.showThisOne = function(divElement) {
			$(".auto-list-selected").css("background-color", $(".auto-list-selected").attr("originalbg")).removeClass("auto-list-selected");
			divElement.attr("originalbg",divElement.css("background-color"));
			divElement.addClass("auto-list-selected").css("background-color",acA.selectedColor);
			var desc = divElement.get(0).assistElement.showItemDescription(acA.filterInput.val());
			acA.rightPanel.children().html(desc);
			acA.rightPanel.children().children().css("word-wrap","break-word");
			var pC = acA.rightPanel;
			var pI = acA.rightPanel.children();
			if (pI.height() > pC.height()) {
				pC.css("overflow-y","scroll");
				pC.scrollTop(0);
			} else {
				pC.css("overflow-y","hidden");
			}
			
			var p = divElement.parent().parent();
			var s = divElement;
			if (
				p.css("overflow-y") == "scroll" && 
				(s.offset().top - p.offset().top + s.height() ) > (p.height())
			) {
				p.scrollTop( (s.offset().top - p.offset().top + s.height() + p.scrollTop()) -  p.height() );
			} else if (
				p.css("overflow-y") == "scroll" && 
				(s.offset().top - p.offset().top ) < 0
			){
				p.scrollTop( p.scrollTop() + (s.offset().top - p.offset().top ) );
			}
		}
		acA.showItemList = function() {
			var text = acA.searchInput.val();
			var list = [];
			if ( typeof(text) != 'undefined' && text != null) { // && text.length > 0) {
				var c = acA.cache.get(text);
				if ( c != null) {
					list = c;
				} else {
					list = acA.getItemList(text);
					if(Array.isArray(list)){//call is not async 
						acA.cache.put(text, list);
					}
				}
			}
			
			if(assist.util.isPromise(list)){
				//To support promise for async loading of templates search
				list.then(function(res){
					var itemList = res.data || res;
					//if promise does not yeild a list of template items, proceed with empty list
					if(!Array.isArray(itemList)){
						itemList = [];//
					}
					acA.cache.put(text, itemList);
					renderItemList(text, itemList);
				});
			}else{
				renderItemList(text, list);
			}
		}
		
		function getAutoElement(){
			var elemRef = typeof acA.id; 
			if(elemRef === 'string'){
				return $('#'+ acA.id);
			}else{
				return acA.id;
			}
		}
		
		//Prepare the template list for DOM insertion.
		function renderItemList(text, list){

			acA.itemList = list;
			var listS = acA.getSpecialItemList(text);
			if (list.length == 0 ){
				var e = {
					showItemName : function() {
						var div = $("<div>");
						div.text(isFrench ? "Aucun assistant disponible": "No template available");
						return div;
					},
					showItemDescription : function() {
						var div = $("<div>");
						var div2 = $("<div>");
						var h = $("<h5>");
						h.text(isFrench ? "Aucun assistant disponible": "No template available");
						h.css("margin-top", "3px");
						h.css("margin-bottom", "3px");
						if (text.length >= 3) {
							div2.text(isFrench ? ("Aucun assistant \u00E0 \u00E9t\u00E9 trouv\u00E9 avec le terme '" + text + "'."): ("No template was found with the term '"+ text +"'."));
						} else {
							div2.text(isFrench ? "Vous devez entrer 3 caract\u00E8res pour que la recherche soit effectu\u00E9e.": "Enter atleast 3 characters to start searching.")
						}
						div.append(h).append(div2);
						return div;
					},mustCloseWhenSelect: false,
					select: function() {
						acA.searchInput.focus();
					}
				};
				listS.push(e);
			}
			//Prepare elements
			for (var i = 0; i < list.length; i++) {
				if ( ! list[i].showItemName) {
					list[i].showItemName = acA.defaultShowItemName;
				}
				if ( ! list[i].showItemDescription) {
					list[i].showItemDescription = acA.defaultShowItemDescription;
				}
				if ( ! list[i].select) {
					list[i].select = acA.defaultSelect;
				}
				if ( typeof(list[i].mustCloseWhenSelect) == 'undefined' || list[i].mustCloseWhenSelect == null) {
					list[i].mustCloseWhenSelect = acA.defaultMustCloseWhenSelect;
				}
			}
			
			//FILTER
			var f = acA.filterInput.val().trim();
			if (f.length > 0) {
				var list2 = list;
				list = new Array();
				for (var i = 0; i < list2.length; i++) {
					var t = $("<div>").html(list2[i].showItemDescription()).text();
					var n = $("<div>").html(list2[i].showItemName()).text();
					if (n.indexOf(f) != -1 || t.indexOf(f) != -1) {
						list.push(list2[i]);
					}
				}
			}
			
			for (var i = 0; i < listS.length; i++) {
				if ( ! listS[i].showItemName) {
					listS[i].showItemName = acA.defaultSpecialShowItemName;
				}
				if ( ! listS[i].showItemDescription) {
					listS[i].showItemDescription = acA.defaultSpecialShowItemDescription;
				}
				if ( ! listS[i].select) {
					listS[i].select = acA.defaultSelect;
				}
				if ( typeof(listS[i].mustCloseWhenSelect) == 'undefined' || listS[i].mustCloseWhenSelect == null) {
					listS[i].mustCloseWhenSelect = acA.defaultMustCloseWhenSelect;
				}
			}
			
			acA.leftPanel.children().children().remove();

			var fnOver = function() {
				acA.showThisOne($(this));
			}
			var fnClick = function() {
				acA.selectSelected();
			}
			
			for (var i = 0; i < listS.length; i++) {
				var d = listS[i].showItemName(f);
				d.get(0).assistElement = listS[i];
				d.addClass("auto-left-panel-element");
				applyCss("left-panel-element",d);
				acA.leftPanel.children().append(d);
				d.mouseover(fnOver);
				d.click(fnClick);
			}
			for (var i = 0; i < list.length; i++) {
				var d = list[i].showItemName(f);
				d.get(0).assistElement = list[i];
				d.addClass("auto-left-panel-element");
				applyCss("left-panel-element",d);
				acA.leftPanel.children().append(d);
				d.mouseover(fnOver);
				d.click(fnClick);
			}
			
			var pC = acA.leftPanel;
			var pI = acA.leftPanel.children();
			if (pI.height() > pC.height()) {
				pC.css("overflow-y","scroll");
			} else {
				pC.css("overflow-y","hidden");
			}
			if (acA.leftPanel.children().children().length) {
				acA.showThisOne(acA.leftPanel.children().children().first());
			}
		}
		
		acA.init = function() {
			acA.element = getAutoElement();
			
			var positionner = $("<div>");
			var container = $("<div>");
			var table = $("<table>");
			acA.assistDiv = container;
			
			positionner.addClass("auto-positionner");
			positionner.css("position","relative");

			//Calculate maxWidth
			var w = Math.max(acA.size.minWidth, acA.element.width());
			w = Math.min(w, acA.size.maxWidth);

			var tr1 = $("<tr>");
			var tr2 = $("<tr>");
			var tr3 = $("<tr>");
			var tdInput = $("<td>");
			var tdList = $("<td>");
			var tdDescription = $("<td>");
			var tdLegend = $("<td>");
			
			//Set the general table
			container.css({
				"visibility":"hidden",
				"position":"absolute",
				"box-sizing":"border-box",
				"-moz-box-sizing":"border-box",
				"z-index":"100",
				"width": (w+5)+"px",
			});
			table.css({
				"border-collapse":"separate",
				"box-shadow":"1px 1px 4px 2px rgba(0,0,0,0.1)",
				"border":"solid 1px #b9b9b9",
				"border-collapse":"separate",
				"border-spacing":"2px;",
				"box-sizing":"border-box",
				"-moz-box-sizing":"border-box",
			});
			tdDescription.css({
				"vertical-align":"top",
				"border-left":"solid 1px #e9e9e9"
			});
			tdList.css("vertical-align","top");
			applyCss("container-td",tdInput);
			applyCss("container-td",tdList);
			applyCss("container-td",tdDescription);
			applyCss("container-td",tdLegend);
			
			tdDescription.attr("rowspan","2");
			tdLegend.attr("colspan","2");
			
			var lw = Math.floor(acA.size.nWidth / 100 * w - acA.size.distance);
			tdInput.css({
				"width":lw+"px",
				"border-radius":"0px",
				"border-right":"solid 1px #b9b9b9",
				});
			tdDescription.css("width",(w-lw)+"px");
			
			//BUILD INPUT
			var hInput = $("<input type='text' placeholder='"+(isFrench?'Recherche titre':'Search by title')+"'>");
			var fInput = $("<input type='text' placeholder='"+(isFrench?'Recherche description':'Search by description')+"'>");
			
			applyCss("search-input",hInput);
			applyCss("search-input",fInput);
			
			tdInput.append(hInput);
			tdInput.append(fInput);
			
			acA.searchInput = hInput;
			acA.filterInput = fInput;
			//BUILD LIST
			var panelLC = $("<div>");
			var panelL = $("<div>");
			acA.leftPanel = panelLC;
			panelLC.append(panelL);
			tdList.append(panelLC);
			applyCss("container-div",panelLC);

			//BUILD DESCRIPTION
			var panelRC = $("<div>");
			var panelR = $("<div>");
			acA.rightPanel = panelRC;
			panelRC.append(panelR);
			tdDescription.append(panelRC);
			applyCss("container-div",panelRC);
			
			//RECONSTITUTION
			tr1.append(tdInput).append(tdDescription);
			tr2.append(tdList);
			tr3.append(tdLegend);
			table.append(tr1).append(tr2);

			container.append(table);
			positionner.append(container);
			
			acA.element.before(positionner);
			acA.open = false;
			acA.setOpenTrigger(getAutoElement(), acA);
			acA.initSearchInput();
			acA.initFilterInput();
			positionner.click(function(e) {
				e.stopPropagation();
				e.preventDefault();
			});
			var that = acA;
			$(document).click(function(e) {
				that.closeAssistant();
			});
			
			//BUILD AND FIX WIDTH LEGEND
			var legend = acA.buildLegend();
			if (legend != null) {
				table.append(tr3);
				tdLegend.width(tdLegend.width()+"px");
			}
			if (legend != null) {
				tdLegend.append(legend);
			}

			//FIX HEIGHT
			tdList.height(acA.size.height+"px");
			var h1 = tdDescription.height();
			tdDescription.height(h1+"px");
			var h2 = tdDescription.height();
			if (h1 != h2) {
				tdDescription.height((h1+(h2-h1))+"px");
			}
			panelRC.height(panelRC.height()+"px");
			panelLC.height(panelLC.height()+"px");
			
			//FIX WIDTH 
			panelRC.width(panelRC.width()+"px");
			panelLC.width(panelLC.width()+"px");
			
			//FORCE LAST CSS
			container.css({
				"visibility":"",
				"display":"none",
			});

			acA.buildExtension();
		}
		
		acA.selectSelected = function() {
			var s = acA.leftPanel.find(".auto-left-panel-element.auto-list-selected");
			if (s.length == 1) {
				var assist = s.get(0).assistElement;
				assist.select(this);
				if (assist.mustCloseWhenSelect && !assist.isWebVersion) {
					this.closeAssistant();
				}
			}
		}
		
		acA.initSearchInput = function() {
			var input = acA.searchInput;
			var that = acA;
			input.keyup(function(e) {
			
				if (e.which == 27) {
					e.preventDefault();
					e.stopPropagation();
					that.closeAssistant();
				} else if (e.which == 40) {
					e.preventDefault();
					e.stopPropagation();
					var s = that.leftPanel.find(".auto-left-panel-element.auto-list-selected").next();
					if (s.length == 0) {
						s = that.leftPanel.find(".auto-left-panel-element").first();
					}
					that.showThisOne(s);
				} else if (e.which == 38) {
					e.preventDefault();
					e.stopPropagation();
					var s = that.leftPanel.find(".auto-left-panel-element.auto-list-selected").prev();
					if (s.length == 0) {
						s = that.leftPanel.find(".auto-left-panel-element").last();
					}
					that.showThisOne(s);
				} else if (e.which == 13) {
					e.preventDefault();
					e.stopPropagation();
					that.selectSelected();
				} else if (
					e.which != 9
					&& e.which != 16
					&& e.which != 17
					&& e.which != 18
				){
					that.showItemList();
				}

			});
		}
		
		acA.initFilterInput = function() {
			var input = acA.filterInput;
			var that = acA;
			input.keyup(function(e) {
			
				if (e.which == 27) {
					e.preventDefault();
					e.stopPropagation();
					that.closeAssistant();
				} else if (e.which == 40) {
					e.preventDefault();
					e.stopPropagation();
					var s = that.leftPanel.find(".auto-left-panel-element.auto-list-selected").next();
					if (s.length == 0) {
						s = that.leftPanel.find(".auto-left-panel-element").first();
					}
					that.showThisOne(s);
				} else if (e.which == 38) {
					e.preventDefault();
					e.stopPropagation();
					var s = that.leftPanel.find(".auto-left-panel-element.auto-list-selected").prev();
					if (s.length == 0) {
						s = that.leftPanel.find(".auto-left-panel-element").last();
					}
					that.showThisOne(s);
				} else if (e.which == 13) {
					e.preventDefault();
					e.stopPropagation();
					that.selectSelected();
				} else if (
					e.which != 9
					&& e.which != 16
					&& e.which != 17
					&& e.which != 18
				){
					that.showItemList();
				}
			});
		}
		
		acA.openAssistant = function() {
			var vPos = acA.getVerticalPosition(acA);
			acA.assistDiv.css("top",vPos+"px");
			acA.assistDiv.show();
			acA.onOpen();
			acA.showItemList();
			acA.activeTime = (new Date()).getTime();
		}
		acA.closeAssistant = function() {
			var nTime = (new Date()).getTime();
			var oTime = acA.activeTime || null;
			if (oTime != null && nTime - oTime > 300) {
				acA.activeTime = null;
				acA.assistDiv.hide();
				acA.regainFocus();
			}
		}

		acA.id = id;
		acA.size = {
			height: 250,	//Hauteur total
			dWidth: 50,		//Largeur description (%)
			nWidth: 50,		//Largeur nom (%)
			minWidth: 400,	//Largeur min (px)
			maxWidth: 900,	//Largeur min (px)
			distance: 2		//Distance entre les paneaux
		}
		acA.selectedColor = "#e9e9e9";
		
		
		this.init();

	}
	
	function applyCss(cssClass, element) {
		var css = CSS[cssClass];
		if (css != null && typeof(css) != 'undefined') {
			element.css(css);
		} else {
//			console.log("failed to "+cssClass);
		}
	}
	
	
	
	function CacheList() {
		var cache = {};//{key:?, obj:[?]}
		
		this.get = function(key) {
			return cache[key] || null;
		}
		
		this.put = function( key, obj) {
			if (typeof(key) != 'undefined' && key != null) {
				cache[key] = obj;
			}
		}
	}
	
	
	CSS = {}
/*	private static final Color BG_COLOR = ResourceGetter.getColor(201,156,71);
	private static final Color INNER_COLOR = ResourceGetter.getColor(242,232,187);
	private static final Color TEXT_COLOR = ResourceGetter.getColor(31,32,25);
	private static final Color SEARCH_COLOR = ResourceGetter.getColor(255,255,255);
*/
	CSS['container-td'] = {
		"padding":"1px",
		"background-color":"rgb(255,255,255)",
		"border-left":"1px solid #e9e9e9",
		"color":"rgb(31,32,25)",
		"box-sizing":"border-box",
		"-moz-box-sizing":"border-box",
	};
	CSS['container-div'] = {
		"width":"100%",
		"height":"100%",
		"box-sizing":"border-box",
		"-moz-box-sizing":"border-box",
		"overflow":"hidden",
	};
	CSS['auto-panel'] = {
		"width":"100%",
		"box-sizing":"border-box",
		"-moz-box-sizing":"border-box",
	};
	CSS['search-input'] = {
		"width":"100%",
		"box-sizing":"border-box",
		"-moz-box-sizing":"border-box",
		"margin-bottom":"1px",
		"border":"none",
		"border-radius":"0",
		"border-bottom":"solid 1px #b9b9b9"
	};
	CSS['left-panel-element'] = {
		"overflow":"hidden",
		"padding":"2px 5px",
	};


})(AutoComplete)
