/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.util.kryoserializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class FastUtilSerializer<T>
extends Serializer<T> {
    private static final String[] PRIMITIVE_TYPES = new String[]{"Boolean", "Byte", "Short", "Int", "Long", "Float", "Double", "Char", "Object"};
    private static final String[] PRIMITIVE_KEY_TYPES = new String[]{"Byte", "Short", "Int", "Long", "Float", "Double", "Char", "Object"};
    private final FieldSerializer<T> fieldSerializer;
    private final Method writeMethod;
    private final Method readMethod;
    private final FastutilKryoObjectOutputStream outputWrapper;
    private final FastutilKryoObjectInputStream inputWrapper;

    public FastUtilSerializer(Kryo kryo, Class<T> type) {
        this.fieldSerializer = new FieldSerializer(kryo, type);
        this.fieldSerializer.getFieldSerializerConfig().setIgnoreSyntheticFields(false);
        try {
            this.writeMethod = type.getDeclaredMethod("writeObject", ObjectOutputStream.class);
            this.writeMethod.setAccessible(true);
            this.readMethod = type.getDeclaredMethod("readObject", ObjectInputStream.class);
            this.readMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Fastutil class " + type + " doesn't have readObject/writeObject methods", e);
        }
        try {
            this.outputWrapper = new FastutilKryoObjectOutputStream();
            this.inputWrapper = new FastutilKryoObjectInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void register(Kryo kryo, Class<?> fastutilClass) {
        kryo.register(fastutilClass, new FastUtilSerializer(kryo, fastutilClass));
    }

    public static void registerAll(Kryo kryo) {
        FastUtilSerializer.registerArrayLists(kryo);
        FastUtilSerializer.registerArrayBigList(kryo);
        FastUtilSerializer.registerOpenHashSets(kryo);
        FastUtilSerializer.registerArraySets(kryo);
        FastUtilSerializer.registerRBTreeSets(kryo);
        FastUtilSerializer.registerAVLTreeSets(kryo);
        FastUtilSerializer.registerOpenHashMaps(kryo);
        FastUtilSerializer.registerRBTreeMaps(kryo);
        FastUtilSerializer.registerAVLTreeMaps(kryo);
    }

    public static void registerArrayLists(Kryo kryo) {
        FastUtilSerializer.registerAll(kryo, FastUtilSerializer.singleTypes("it.unimi.dsi.fastutil._t1_s._T1_ArrayList", PRIMITIVE_TYPES));
    }

    public static void registerArrayBigList(Kryo kryo) {
        FastUtilSerializer.registerAll(kryo, FastUtilSerializer.singleTypes("it.unimi.dsi.fastutil._t1_s._T1_BigArrayBigList", PRIMITIVE_TYPES));
    }

    public static void registerOpenHashSets(Kryo kryo) {
        FastUtilSerializer.registerAll(kryo, FastUtilSerializer.singleTypes("it.unimi.dsi.fastutil._t1_s._T1_OpenHashSet", PRIMITIVE_TYPES));
    }

    public static void registerArraySets(Kryo kryo) {
        FastUtilSerializer.registerAll(kryo, FastUtilSerializer.singleTypes("it.unimi.dsi.fastutil._t1_s._T1_ArraySet", PRIMITIVE_TYPES));
    }

    public static void registerRBTreeSets(Kryo kryo) {
        FastUtilSerializer.registerAll(kryo, FastUtilSerializer.singleTypes("it.unimi.dsi.fastutil._t1_s._T1_RBTreeSet", PRIMITIVE_KEY_TYPES));
    }

    public static void registerAVLTreeSets(Kryo kryo) {
        FastUtilSerializer.registerAll(kryo, FastUtilSerializer.singleTypes("it.unimi.dsi.fastutil._t1_s._T1_AVLTreeSet", PRIMITIVE_KEY_TYPES));
    }

    public static void registerOpenHashMaps(Kryo kryo) {
        FastUtilSerializer.registerAll(kryo, FastUtilSerializer.doubleTypes("it.unimi.dsi.fastutil._t1_s._T1_2_T2_OpenHashMap", PRIMITIVE_KEY_TYPES, PRIMITIVE_TYPES));
    }

    public static void registerRBTreeMaps(Kryo kryo) {
        FastUtilSerializer.registerAll(kryo, FastUtilSerializer.doubleTypes("it.unimi.dsi.fastutil._t1_s._T1_2_T2_RBTreeMap", PRIMITIVE_KEY_TYPES, PRIMITIVE_TYPES));
    }

    public static void registerAVLTreeMaps(Kryo kryo) {
        FastUtilSerializer.registerAll(kryo, FastUtilSerializer.doubleTypes("it.unimi.dsi.fastutil._t1_s._T1_2_T2_AVLTreeMap", PRIMITIVE_KEY_TYPES, PRIMITIVE_TYPES));
    }

    private static void registerAll(Kryo kryo, ArrayList<Class<?>> types) {
        for (Class<?> type : types) {
            FastUtilSerializer.register(kryo, type);
        }
    }

    private static ArrayList<Class<?>> singleTypes(String pattern, String[] types) {
        ArrayList result = new ArrayList();
        for (String type : types) {
            try {
                result.add(Class.forName(pattern.replaceAll("_T1_", type).replaceAll("_t1_", type.toLowerCase())));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(pattern + " " + type, e);
            }
        }
        return result;
    }

    private static ArrayList<Class<?>> doubleTypes(String pattern, String[] types1, String[] types2) {
        ArrayList result = new ArrayList();
        for (String type1 : types1) {
            for (String type2 : types2) {
                try {
                    result.add(Class.forName(pattern.replaceAll("_T1_", type1).replaceAll("_t1_", type1.toLowerCase()).replaceAll("_T2_", type2).replaceAll("_t2_", type2.toLowerCase())));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(pattern + " " + type1 + " " + type2, e);
                }
            }
        }
        return result;
    }

    public void write(Kryo kryo, Output output, T object) {
        this.fieldSerializer.write(kryo, output, object);
        this.outputWrapper.set(output, kryo);
        try {
            this.writeMethod.invoke(object, this.outputWrapper);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("writeObject failed", e);
        }
    }

    public T read(Kryo kryo, Input input, Class<? extends T> type) {
        Object result = this.fieldSerializer.read(kryo, input, type);
        if (result != null) {
            this.inputWrapper.set(input, kryo);
            try {
                this.readMethod.invoke(result, this.inputWrapper);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("readObject failed", e);
            }
        }
        return (T)result;
    }

    private static class FastutilKryoObjectInputStream
    extends ObjectInputStream {
        private Input input;
        private Kryo kryo;

        FastutilKryoObjectInputStream() throws IOException {
        }

        public void set(Input input, Kryo kryo) {
            this.input = input;
            this.kryo = kryo;
        }

        @Override
        public void defaultReadObject() throws IOException, ClassNotFoundException {
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.input.readBoolean();
        }

        @Override
        public byte readByte() throws IOException {
            return this.input.readByte();
        }

        @Override
        public char readChar() throws IOException {
            return this.input.readChar();
        }

        @Override
        public short readShort() throws IOException {
            return this.input.readShort();
        }

        @Override
        public int readInt() throws IOException {
            return this.input.readInt(false);
        }

        @Override
        public long readLong() throws IOException {
            return this.input.readLong(false);
        }

        @Override
        public float readFloat() throws IOException {
            return this.input.readFloat();
        }

        @Override
        public double readDouble() throws IOException {
            return this.input.readDouble();
        }

        @Override
        protected Object readObjectOverride() throws IOException, ClassNotFoundException {
            return this.kryo.readClassAndObject(this.input);
        }
    }

    private static class FastutilKryoObjectOutputStream
    extends ObjectOutputStream {
        private Output output;
        private Kryo kryo;

        FastutilKryoObjectOutputStream() throws IOException {
        }

        public void set(Output output, Kryo kryo) {
            this.output = output;
            this.kryo = kryo;
        }

        @Override
        public void defaultWriteObject() throws IOException {
        }

        @Override
        public void writeBoolean(boolean val) throws IOException {
            this.output.writeBoolean(val);
        }

        @Override
        public void writeByte(int val) throws IOException {
            this.output.writeByte(val);
        }

        @Override
        public void writeShort(int val) throws IOException {
            this.output.writeShort(val);
        }

        @Override
        public void writeChar(int val) throws IOException {
            this.output.writeChar((char)val);
        }

        @Override
        public void writeInt(int val) throws IOException {
            this.output.writeInt(val, false);
        }

        @Override
        public void writeLong(long val) throws IOException {
            this.output.writeLong(val, false);
        }

        @Override
        public void writeFloat(float val) throws IOException {
            this.output.writeFloat(val);
        }

        @Override
        public void writeDouble(double val) throws IOException {
            this.output.writeDouble(val);
        }

        @Override
        protected void writeObjectOverride(Object obj) throws IOException {
            this.kryo.writeClassAndObject(this.output, obj);
        }
    }
}

