/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.patient;

import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.util.math.NumberUtils;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;

public final class NAM_QC {
    private static final Pattern NAM_PATTERN = Pattern.compile("^[A-Z]{4}[0-9]{8}[A-Z]?$", 2);

    private NAM_QC() {
    }

    public static boolean validateExpirationCAM(String expirationCam) {
        if (StringUtils.isBlank((CharSequence)expirationCam)) {
            return false;
        }
        if ((expirationCam = expirationCam.trim()).length() != 4) {
            return false;
        }
        if (!NumberUtils.isNumber(expirationCam)) {
            return false;
        }
        try {
            if (Integer.parseInt(expirationCam.substring(2)) > 12) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Object[] extractBirthdateAndSex(String nam) {
        Object[] res = new Object[2];
        if (NAM_QC.validateNAM(nam)) {
            boolean woman = NAM_QC.isWoman(nam);
            res[0] = woman;
            List<LocalDate> dates = NAM_QC.getPossibleBirthdates(nam, NAM_QC.isWoman(nam));
            res[1] = dates.size() > 0 ? NAM_QC.getPossibleBirthdates(nam, woman) : null;
        }
        return res;
    }

    public static LocalDate extractBirthdate(String nam) {
        List<LocalDate> dates;
        if (NAM_QC.validateNAM(nam) && (dates = NAM_QC.getPossibleBirthdates(nam, NAM_QC.isWoman(nam))).size() > 0) {
            return dates.get(0);
        }
        return null;
    }

    public static XPerson.Gender extractSex(String nam) {
        if (NAM_QC.validateNAM(nam)) {
            return NAM_QC.isWoman(nam) ? XPerson.Gender.FEMININ : XPerson.Gender.MASCULIN;
        }
        return null;
    }

    public static boolean validateNAM(String nam, String firstName, String lastName, LocalDate birthdate, XPerson.Gender sex) {
        List<LocalDate> dates;
        if (!NAM_QC.validateNAM(nam)) {
            return false;
        }
        nam = nam.toUpperCase();
        if (lastName != null) {
            String lastName2 = StringUtils.NormalizeToUppercase((String)lastName);
            lastName2 = lastName2.replaceAll("[ '-]", "");
            if (StringUtils.isBlank((CharSequence)(lastName2 = StringUtils.padRight((String)lastName2, (int)3, (char)'X'))) || !nam.substring(0, 3).equals(lastName2.substring(0, 3))) {
                return false;
            }
        }
        if (firstName != null) {
            String firstName2 = StringUtils.NormalizeToUppercase((String)firstName);
            if (StringUtils.isBlank((CharSequence)(firstName2 = firstName2.replaceAll("[ '-]", ""))) || nam.charAt(3) != firstName2.charAt(0)) {
                return false;
            }
        }
        boolean woman = NAM_QC.isWoman(nam);
        if (sex != null && sex != XPerson.Gender.INCONNU) {
            if (woman && sex != XPerson.Gender.FEMININ) {
                return false;
            }
            if (!woman && sex != XPerson.Gender.MASCULIN) {
                return false;
            }
        }
        return birthdate == null || (dates = NAM_QC.getPossibleBirthdates(nam, woman)).contains(birthdate);
    }

    private static List<LocalDate> getPossibleBirthdates(String nam, boolean woman) {
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        String birthdate = nam.substring(4, 10);
        if (woman) {
            birthdate = StringUtils.replace((String)birthdate, (int)2, (char)((char)(birthdate.charAt(2) - 5)));
        }
        String[] century = new String[]{"20", "19", "18"};
        LocalDate today = LocalDate.today();
        for (String element : century) {
            try {
                LocalDate date = LocalDateFormat.parse((String)(element + birthdate), (String)"yyyyMMdd");
                if (date.after((IPartialDate)today)) continue;
                dates.add(date);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (dates.size() <= 1) {
            return dates;
        }
        return dates;
    }

    public static boolean validateNAM(String nam) {
        if (StringUtils.isBlank((CharSequence)nam) || nam.length() != 12) {
            return false;
        }
        boolean valid = NAM_QC.validateName(nam = nam.toUpperCase()) && NAM_QC.validateSex(nam) && NAM_QC.validateBirthdate(nam, NAM_QC.isWoman(nam)) && NAM_QC.validateChecksum(nam, NAM_QC.isWoman(nam));
        return valid;
    }

    public static boolean validateNAMLength(String nam) {
        return StringUtils.isNotBlank((String)nam) && nam.trim().length() == 12;
    }

    public static boolean validateNAMPattern(String nam) {
        return StringUtils.isNotBlank((String)nam) && nam.trim().length() == 12 && NAM_PATTERN.matcher(nam).matches();
    }

    private static boolean validateName(String nam) {
        return nam.toUpperCase().substring(0, 4).matches("[A-Z][A-Z][A-Z][A-Z|*]");
    }

    private static boolean isWoman(String nam) {
        return nam.charAt(6) > '1';
    }

    private static boolean validateSex(String nam) {
        return StringUtils.isNumeric((char)nam.charAt(6));
    }

    private static boolean validateBirthdate(String nam, boolean woman) {
        return NAM_QC.getPossibleBirthdates(nam, woman) != null;
    }

    private static boolean validateChecksum(String nam, boolean woman) {
        String[] century;
        String expandedNam;
        if (nam.charAt(10) == 'I' || nam.charAt(10) == 'O') {
            return false;
        }
        if (nam.startsWith("XXXX") || nam.startsWith("ZZZZ")) {
            return true;
        }
        if (woman) {
            char month = (char)(nam.charAt(6) - 5);
            expandedNam = new StringBuilder(13).append(nam.substring(0, 6)).append('F').append(month).append(nam.substring(7, 12)).toString();
        } else {
            expandedNam = new StringBuilder(13).append(nam.substring(0, 6)).append('M').append(nam.substring(6, 12)).toString();
        }
        for (String element : century = new String[]{"19", "20", "18"}) {
            char[] raw = (expandedNam.substring(0, 4) + element + expandedNam.substring(4)).toCharArray();
            int validationNumber = Character.digit(raw[14], 10);
            int hash = NAM_QC.hash(raw);
            if (hash != validationNumber) continue;
            return true;
        }
        return false;
    }

    private static int hash(char[] raw) {
        assert (raw.length == 15);
        int[] iDec = new int[14];
        for (int j = 0; j < 14; ++j) {
            iDec[j] = NAM_QC.prehash(raw[j]);
        }
        int hash = (iDec[0] + 3 * iDec[1] + 7 * iDec[2] + 9 * iDec[3] + iDec[4] + 7 * iDec[5] + iDec[6] + 3 * iDec[7] + 4 * iDec[8] + 5 * iDec[9] + 7 * iDec[10] + 6 * iDec[11] + 9 * iDec[12] + iDec[13]) % 10;
        return hash;
    }

    private static int prehash(char ch) {
        if ("ABCDEFGHI".indexOf(ch) != -1) {
            return ch + 128;
        }
        if ("JKLMNOPQR".indexOf(ch) != -1) {
            return ch + 135;
        }
        if ("STUVWXYZ".indexOf(ch) != -1) {
            return ch + 143;
        }
        if ("0123456789".indexOf(ch) != -1) {
            return ch + 192;
        }
        return 0;
    }

    public static void main(String[] args) {
        String firstName = "Laine";
        String lastName = "Merino";
        XPerson.Gender gender = XPerson.Gender.FEMININ;
        LocalDate date = LocalDate.from((int)1, (int)7, (int)2020);
        System.out.println(NAM_QC.generateRandomNam("Laine", "Merino", gender, date));
    }

    private static String generateRandomNam(String firstName, String lastName, XPerson.Gender gender, LocalDate date) {
        Random random = new Random();
        String base = lastName.substring(0, 3) + firstName.substring(0, 1);
        String nam = "";
        nam = nam + base;
        nam = nam + String.valueOf(date.year).substring(2, 4);
        nam = nam + (gender == XPerson.Gender.FEMININ ? String.valueOf(date.month + 50) : StringUtils.leftPad((String)String.valueOf(date.month), (int)2, (char)'0'));
        nam = nam + StringUtils.leftPad((String)String.valueOf(date.day), (int)2, (char)'0');
        for (int i = 10; i < 20; ++i) {
            String nam2 = (nam + i).toUpperCase();
            boolean valid = NAM_QC.validateNAM(nam2);
            if (!valid) continue;
            return nam2;
        }
        System.err.println("no valid not found");
        return null;
    }
}

