/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.label;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.label.XLabelResType;
import ca.infodata.ofys.util.EnumWithValue;
import ca.infodata.util1.StringUtils;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public final class XLabelDef
extends EditableDataObject {
    private static final long serialVersionUID = 1L;
    private Integer id;
    private Integer idRes;
    private String name;
    private XLabelResType type;
    private Boolean isDeleted;
    private Set<Integer> fusions = new HashSet<Integer>();
    public static final Integer SOMMAIRE = new Integer(-1);
    public static final Integer ENCOUNTER = new Integer(-2);
    public static final Integer ARCHIVE = new Integer(-3);
    public static final Integer ORDER_RESPONSE = new Integer(-4);
    public static final Integer ORDER_REQUEST = new Integer(-5);
    public static final Integer LABO_SCAN = new Integer(-50);
    public static Comparator<XLabelDef> sortLabels = new Comparator<XLabelDef>(){

        @Override
        public int compare(XLabelDef lbl1, XLabelDef lbl2) {
            if (lbl1 == lbl2) {
                return 0;
            }
            if (lbl1 == null) {
                return -1;
            }
            if (lbl2 == null) {
                return 1;
            }
            if (lbl1.getName() == lbl2.getName()) {
                return 0;
            }
            if (lbl1.getName() == null) {
                return -1;
            }
            if (lbl2.getName() == null) {
                return 1;
            }
            if (lbl1.getId() != null && lbl2.getId() != null) {
                if (lbl1.getId() < 0 && lbl2.getId() < 0) {
                    return -lbl1.getId().compareTo(lbl2.getId());
                }
                if (lbl1.getId() < 0 || lbl2.getId() < 0) {
                    return lbl1.getId().compareTo(lbl2.getId());
                }
            }
            return StringUtils.compareAscii((String)lbl1.getName(), (String)lbl2.getName());
        }
    };

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
        this.setUpdated();
    }

    public Integer getIdRes() {
        return this.idRes;
    }

    public void setIdRes(Integer idDef) {
        this.idRes = idDef;
    }

    public String getName() {
        XLabelDefStaticType xlabelDef;
        String theName = this.name;
        if (this.id != null && this.id < 0 && (xlabelDef = XLabelDefStaticType.from(this.id)) != null) {
            theName = xlabelDef.toString();
        }
        return theName;
    }

    public void setName(String name) {
        this.name = name;
        this.setUpdated();
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
        this.setUpdated();
    }

    @Override
    public XLabelDef clone() {
        XLabelDef c = (XLabelDef)super.clone();
        c.fusions = this.fusions == null ? null : new HashSet<Integer>(this.fusions);
        return c;
    }

    public XLabelResType getType() {
        return this.type;
    }

    public void setType(XLabelResType type) {
        this.type = type;
        this.setUpdated();
    }

    public Set<Integer> getFusions() {
        return this.fusions;
    }

    public void setFusions(Set<Integer> fusions) {
        this.fusions = fusions;
        this.setUpdated();
    }

    @Override
    public String toString() {
        return String.format("XLabelDef [id=%s, name=%s, type=%s, isDeleted=%s]", this.id, this.name, this.type, this.isDeleted);
    }

    public static enum XLabelDefStaticType implements EnumWithValue<XLabelDefStaticType>
    {
        IS_SOMMAIRE(-1, false){

            public String toString() {
                return Messages.getString("IS_SUMMARY", new String[0]);
            }
        }
        ,
        IS_ENCOUNTER(-2, false){

            public String toString() {
                return Messages.getString("IS_ENCOUNTER", new String[0]);
            }
        }
        ,
        IS_ARCHIVE(-3, false){

            public String toString() {
                return Messages.getString("IS_ARCHIVE", new String[0]);
            }
        }
        ,
        IS_ORDER_RESPONSE(-4, false){

            public String toString() {
                return Messages.getString("IS_ORDER_RESPONSE", new String[0]);
            }
        }
        ,
        IS_ORDER_REQUEST(-5, false){

            public String toString() {
                return Messages.getString("IS_ORDER_REQUEST", new String[0]);
            }
        }
        ,
        IS_LABO_SCAN(-50, false){

            public String toString() {
                return Messages.getString("IS_LABO_SCAN", new String[0]);
            }
        };

        public final int id;
        public final boolean showInPreferences;

        private XLabelDefStaticType(int id, boolean showInPreferences) {
            this.id = id;
            this.showInPreferences = showInPreferences;
        }

        @Override
        public int getValue() {
            return this.id;
        }

        public static XLabelDefStaticType from(Integer s) {
            if (s != null) {
                for (XLabelDefStaticType rt : XLabelDefStaticType.values()) {
                    if (rt.id != s) continue;
                    return rt;
                }
            }
            return null;
        }

        @Override
        public XLabelDefStaticType fromValue(Integer id) {
            return XLabelDefStaticType.from(id);
        }
    }
}

