/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.encounter;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CEncounter;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDrugType;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescriptionDrugNameFormat;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.util.EnumWithValue;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import java.text.MessageFormat;

public final class CPrescriptionFormatter {
    private static final String ADD_BY_ON = Messages.getString("ADD_BY_ON", new String[0]);
    private static final String nodata = "?";
    private static final String space = " ";
    private static XPrescriptionDrugNameFormat format = XPrescriptionDrugNameFormat.COMMERCIAL_AND_GENERIC;

    public static String formatDrugNameWithBrackets(CEncounter.Prescription p) {
        return CPrescriptionFormatter.formatDrugNameWithBrackets(p, null, null);
    }

    public static String formatDrugNameWithBrackets(CEncounter.Prescription p, XPrescriptionDrugNameFormat dnf, Integer limitNameLength) {
        StringBuilder name = new StringBuilder();
        String commercialName = p.name;
        String genericName = p.baseDrugName;
        XPrescriptionDrugNameFormat format = dnf == null ? CPrescriptionFormatter.getDrugNameFormat() : dnf;
        switch (format) {
            case COMMERCIAL: {
                name.append(commercialName);
                break;
            }
            case GENERIC: {
                name.append(genericName);
                break;
            }
            case COMMERCIAL_AND_GENERIC: {
                if (!StringUtils.isBlank((CharSequence)commercialName)) {
                    name.append(commercialName);
                }
                if (StringUtils.isBlank((CharSequence)genericName) || genericName.equalsIgnoreCase(commercialName)) break;
                name.append(" (").append(genericName).append(") ");
                break;
            }
            case GENERIC_AND_COMMERCIAL: {
                if (!StringUtils.isBlank((CharSequence)genericName)) {
                    name.append(genericName);
                }
                if (StringUtils.isBlank((CharSequence)commercialName) || commercialName.equalsIgnoreCase(genericName)) break;
                name.append(" (").append(commercialName).append(") ");
                break;
            }
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            name.append(nodata);
        } else {
            if (limitNameLength != null && name.length() > limitNameLength) {
                name.setLength(0);
                name.append(StringUtils.truncate((String)name.toString(), (int)limitNameLength)).append("...");
            }
            if (p.getBaseDrugType() == null) {
                p.setBaseDrugType(XDrugType.REGULAR.value);
            }
            boolean isDrug = p.getBaseDrugType() != XDrugType.FOURNITURE.value;
            StringBuilder strength = new StringBuilder().append(StringUtils.isEmpty((String)p.getStrength()) ? "" : p.getStrength());
            if (isDrug) {
                if (StringUtils.isNotEmpty((String)p.getName())) {
                    String drugName = p.getName();
                    if (drugName.indexOf(strength.toString()) == -1) {
                        name.append(space).append((CharSequence)strength);
                    }
                } else {
                    name.append(space).append((CharSequence)strength);
                }
            }
        }
        return name.toString();
    }

    public static String formatDrugNameWithComma(CEncounter.Prescription p) {
        String name = nodata;
        String commercialName = p.name;
        String genericName = p.baseDrugName;
        XPrescriptionDrugNameFormat format = CPrescriptionFormatter.getDrugNameFormat();
        switch (format) {
            case COMMERCIAL: {
                name = commercialName;
                break;
            }
            case GENERIC: {
                name = genericName;
                break;
            }
            case COMMERCIAL_AND_GENERIC: {
                name = new JoinList(", ", 2).setNoDuplicate(true).addUpperCase(commercialName).addUpperCase(genericName).toString();
                break;
            }
            case GENERIC_AND_COMMERCIAL: {
                name = new JoinList(", ", 2).setNoDuplicate(true).addUpperCase(genericName).addUpperCase(commercialName).toString();
                break;
            }
        }
        return name;
    }

    public static void setDrugNameFormat(XPrescriptionDrugNameFormat f) {
        format = f;
    }

    public static XPrescriptionDrugNameFormat getDrugNameFormat() {
        return format;
    }

    public static String format(CEncounter.Prescription p, ShowMedFileDetail detail) {
        String rxAddedBy;
        if (p.getBaseDrugType() == null) {
            p.setBaseDrugType(XDrugType.REGULAR.value);
        }
        boolean isDrug = p.getBaseDrugType() != XDrugType.FOURNITURE.value;
        String posology = "";
        String format = "";
        String frequency = "";
        String quantity = "";
        if (detail.showMoreThan(ShowMedFileDetail.MOYEN)) {
            posology = p.getPosology() == null ? "" : p.getPosology();
            String string = frequency = p.getFrequency() == null ? "" : p.getFrequency();
            if (detail.showMoreThan(ShowMedFileDetail.SUPERIEUR)) {
                String string2 = format = p.getFormatS() == null ? "" : p.getFormatS();
                if (p.getQuantity() == null || p.getQuantity() == 0) {
                    if (p.getTreatmentDuration() != null) {
                        quantity = p.getTreatmentDuration().toString() + space + Messages.getString("JRS.", new String[0]);
                    }
                } else {
                    quantity = p.getQuantity().toString();
                    quantity = quantity + space;
                    if (isDrug && p.getFormatS() != null) {
                        quantity = quantity + p.getFormatS();
                    }
                }
            }
        }
        String rx = "";
        String startdate = "";
        String note = "";
        if (detail.showMoreThan(ShowMedFileDetail.SUPERIEUR)) {
            rx = p.getRx() == null ? "" : p.getRx().toString();
            String string = startdate = p.getStartDateSD() == null ? "" : p.getStartDateSD();
            if (detail.showMoreThan(ShowMedFileDetail.MAXIMUM)) {
                note = p.getNote() == null ? "" : p.getNote();
                note = note.length() > 50 ? note.substring(0, 50) : note;
            }
        }
        String otherProf = "";
        if (detail.showMoreThan(ShowMedFileDetail.SUPERIEUR)) {
            otherProf = new Integer(1).equals(p.getFromProfExterne()) ? Messages.getString("PrescriptionSubControl.FROM_PROF_EXTERNE", new String[0]) : "";
        }
        StringBuilder b = new StringBuilder(100);
        if (posology.length() > 0) {
            b.append(posology);
            b.append(space);
        }
        if (format != null && format.length() > 0) {
            b.append(format);
            b.append(space);
        }
        if (frequency != null && frequency.length() > 0) {
            b.append(frequency);
            b.append(space);
        }
        if (quantity != null && quantity.length() > 0) {
            b.append(quantity);
        }
        if (rx != null && rx.length() > 0) {
            b.append(", R x ");
            b.append(rx);
            b.append(space);
            b.append(Messages.getString("LE", new String[0]));
            b.append(space);
            b.append(startdate);
        }
        if (note.length() > 0) {
            b.append(space);
            b.append(note);
        }
        if (otherProf.length() > 0) {
            b.append(", ");
            b.append(otherProf);
        }
        if (detail.showMoreThan(ShowMedFileDetail.MAXIMUM) && (rxAddedBy = MessageFormat.format(ADD_BY_ON, p.profNom, p.getEntryDateSD())).length() > 0) {
            b.append(", ");
            b.append(rxAddedBy);
        }
        if (detail.showMoreThan(ShowMedFileDetail.SUPERIEUR) && StringUtils.isNotEmpty((String)p.expiredDateSD)) {
            b.append("\n").append(Messages.getString("DATE_DE_FIN", new String[0])).append(space).append(p.expiredDateSD);
        }
        return b.toString();
    }

    public static String formatLastPrescription(CEncounter.Prescription p, ShowMedFileDetail detail) {
        String rxAddedBy;
        if (p == null) {
            throw new NullPointerException("prescription");
        }
        if (p.getBaseDrugType() == null) {
            p.setBaseDrugType(XDrugType.REGULAR.value);
        }
        boolean isDrug = p.getBaseDrugType() != XDrugType.FOURNITURE.value;
        String strength = p.getStrength() == null ? nodata : p.getStrength();
        String posology = "";
        String frequency = "";
        String quantity = "";
        String rx = "";
        if (detail.showMoreThan(ShowMedFileDetail.MOYEN)) {
            posology = p.getPosology() == null ? "" : p.getPosology();
            String string = frequency = p.getFrequency() == null ? "" : p.getFrequency();
            if (detail.showMoreThan(ShowMedFileDetail.SUPERIEUR)) {
                quantity = "";
                if (p.getQuantity() == null || p.getQuantity() == 0) {
                    quantity = p.getTreatmentDuration().toString() + space + Messages.getString("JRS.", new String[0]);
                } else {
                    quantity = p.getQuantity().toString();
                    quantity = quantity + space;
                    if (isDrug && p.getFormatS() != null) {
                        quantity = quantity + p.getFormatS();
                    }
                }
                rx = p.getRx() == null ? "" : p.getRx().toString();
            }
        }
        StringBuilder b = new StringBuilder(100);
        if (isDrug) {
            b.append(strength);
            b.append(space);
        }
        if (StringUtils.isNotBlank((String)posology)) {
            b.append(posology);
            b.append(space);
        }
        if (isDrug && StringUtils.isNotBlank((String)frequency)) {
            b.append(frequency);
            b.append(", ");
        }
        if (StringUtils.isNotBlank((String)quantity)) {
            b.append(quantity);
        }
        if (StringUtils.isNotBlank((String)rx)) {
            b.append(", R x ");
            b.append(rx);
        }
        if (detail.showMoreThan(ShowMedFileDetail.MAXIMUM) && (rxAddedBy = MessageFormat.format(ADD_BY_ON, p.profNom, p.getEntryDateSD())).length() > 0) {
            b.append(", ");
            b.append(rxAddedBy);
        }
        return b.toString();
    }

    public static String formatActive(CEncounter.Prescription p, ShowMedFileDetail detail) {
        String rxAddedBy;
        if (p == null) {
            throw new NullPointerException("prescription");
        }
        if (p.getBaseDrugType() == null) {
            p.setBaseDrugType(XDrugType.REGULAR.value);
        }
        boolean isDrug = p.getBaseDrugType() != XDrugType.FOURNITURE.value;
        String strength = p.getStrength() == null ? nodata : p.getStrength();
        String quantity = "";
        String rx = "";
        if (detail.showMoreThan(ShowMedFileDetail.SUPERIEUR)) {
            if (p.getQuantity() == null || p.getQuantity() == 0) {
                if (p.getTreatmentDuration() != null) {
                    quantity = p.getTreatmentDuration().toString() + space + Messages.getString("JRS.", new String[0]);
                }
            } else {
                quantity = p.getQuantity().toString();
                quantity = quantity + space;
                if (isDrug && p.getFormatS() != null) {
                    quantity = quantity + p.getFormatS();
                }
            }
            rx = p.getRx() == null ? nodata : p.getRx().toString();
        }
        String startdate = "";
        String enddate = "";
        String drugname = null;
        if (detail.showMoreThan(ShowMedFileDetail.SUPERIEUR)) {
            String string = startdate = p.getStartDateSD() == null ? "" : p.getStartDateSD();
        }
        if (StringUtils.isNotEmpty((String)p.getName())) {
            drugname = p.getName();
        }
        if (detail.showMoreThan(ShowMedFileDetail.SUPERIEUR) && p.getEndDateSD() != null) {
            enddate = " (" + Messages.getString("FIN", new String[0]) + space + p.getEndDateSD() + ")";
        }
        StringBuilder b = new StringBuilder(100);
        if (startdate.length() > 0) {
            b.append(startdate);
            b.append(": ");
        }
        if (drugname != null) {
            b.append(drugname);
            b.append(space);
        }
        if (quantity.length() > 0) {
            b.append(quantity);
            b.append(space);
        }
        if (isDrug && strength.length() > 0 && drugname.indexOf(strength) == -1) {
            b.append(strength);
            b.append(space);
        }
        if (rx.length() > 0) {
            b.append(rx);
            b.append(space);
            b.append(Messages.getString("RENOUVELLEMENTS", new String[0]).toLowerCase());
        }
        if (enddate.length() > 0) {
            b.append(enddate);
        }
        if (detail.showMoreThan(ShowMedFileDetail.MAXIMUM) && (rxAddedBy = MessageFormat.format(ADD_BY_ON, p.profNom, p.getEntryDateSD())).length() > 0) {
            b.append(", ");
            b.append(rxAddedBy);
        }
        return b.toString();
    }

    public static String formatInactive(CEncounter.Prescription p, ShowMedFileDetail detail) {
        String rxAddedBy;
        if (p == null) {
            throw new NullPointerException("prescription");
        }
        if (p.getBaseDrugType() == null) {
            p.setBaseDrugType(XDrugType.REGULAR.value);
        }
        boolean isDrug = p.getBaseDrugType() != XDrugType.FOURNITURE.value;
        String _ARRETER_LE_ = Messages.getString("BasePrescriptionSwitchTable._ARRETEE_LE_", new String[0]);
        String _FIN_ = Messages.getString("BasePrescriptionSwitchTable._FIN_", new String[0]);
        String strength = p.getStrength() == null ? nodata : p.getStrength();
        String quantity = "";
        String rx = "";
        if (detail.showMoreThan(ShowMedFileDetail.SUPERIEUR)) {
            if (p.getQuantity() == null || p.getQuantity() == 0) {
                if (p.getTreatmentDuration() != null) {
                    quantity = p.getTreatmentDuration().toString() + space + Messages.getString("JRS.", new String[0]);
                }
            } else {
                quantity = p.getQuantity().toString();
                quantity = quantity + space;
                if (isDrug && p.getFormatS() != null) {
                    quantity = quantity + p.getFormatS();
                }
            }
            rx = p.getRx() == null ? "" : p.getRx().toString();
        }
        String startdate = "";
        StringBuilder stopdate = new StringBuilder();
        String drugname = null;
        if (detail.showMoreThan(ShowMedFileDetail.SUPERIEUR)) {
            String string = startdate = p.getStartDateSD() == null ? "" : p.getStartDateSD();
        }
        if (!StringUtils.isBlank((CharSequence)p.getName())) {
            drugname = p.getName();
        }
        if (detail.showMoreThan(ShowMedFileDetail.SUPERIEUR)) {
            if (p.getStopDateSD() != null) {
                stopdate.append(_ARRETER_LE_).append(space).append(p.getStopDateSD());
                if (p.getStopReason() != null) {
                    stopdate.append(":").append(p.getStopReason());
                }
                stopdate.append(")");
            }
            if (p.getEndDateSD() != null) {
                stopdate.append(_FIN_).append(p.getEndDateSD()).append(")");
            }
        }
        StringBuilder b = new StringBuilder(100);
        if (startdate.length() > 0) {
            b.append(startdate);
            b.append(": ");
        }
        if (drugname != null) {
            b.append("(");
            b.append(drugname);
            b.append(") ");
        }
        if (quantity.length() > 0) {
            b.append(quantity);
            b.append(space);
        }
        if (isDrug && strength.length() > 0) {
            b.append(Messages.getString("DE", new String[0]).toLowerCase());
            b.append(space);
            b.append(strength);
            b.append(space);
        }
        if (rx.length() > 0) {
            b.append(rx);
            b.append(space);
            b.append(Messages.getString("RENOUVELLEMENTS", new String[0]).toLowerCase());
        }
        if (stopdate.length() > 0) {
            b.append((CharSequence)stopdate);
        }
        if (detail.showMoreThan(ShowMedFileDetail.MAXIMUM) && (rxAddedBy = MessageFormat.format(ADD_BY_ON, p.profNom, p.getEntryDateSD())).length() > 0) {
            b.append(", ");
            b.append(rxAddedBy);
        }
        return b.toString();
    }

    public static String getFormattedText(CEncounter.Prescription p, boolean isPrescriptionActive, ShowMedFileDetail detail) {
        String rxAddedBy;
        if (p.getBaseDrugType() == null) {
            p.setBaseDrugType(XDrugType.REGULAR.value);
        }
        boolean isDrug = p.getBaseDrugType() != XDrugType.FOURNITURE.value;
        String name = nodata;
        name = CPrescriptionFormatter.formatDrugNameWithComma(p);
        String strength = p.getStrength() == null ? "" : (p.getStrength() == null ? nodata : p.getStrength());
        String posology = "";
        String frequency = "";
        String quantity = "";
        String rx = "";
        if (detail.showMoreThan(ShowMedFileDetail.MOYEN)) {
            String string = posology = p.getPosology() == null ? "" : p.getPosology();
            String string2 = p.getFrequency() == null ? "" : (frequency = p.getFrequency() == null ? "" : p.getFrequency());
            if (detail.showMoreThan(ShowMedFileDetail.SUPERIEUR)) {
                if (p.getTreatmentDuration() != null && p.getTreatmentDuration() > 0) {
                    quantity = p.getTreatmentDuration().toString() + space + Messages.getString("JRS.", new String[0]);
                } else if (p.getQuantity() != null && p.getQuantity() > 0) {
                    quantity = p.getQuantity().toString();
                    quantity = quantity + space;
                    if (p.getFormatS() != null) {
                        quantity = quantity + p.getFormatS();
                    }
                }
            }
        }
        String startdate = "";
        String enddate = "";
        if (detail.showMoreThan(ShowMedFileDetail.SUPERIEUR)) {
            rx = p.getRx() == null ? "" : p.getRx().toString();
            String string = startdate = p.getStartDateSD() == null ? "" : p.getStartDateSD();
            if (p.getStopDateSD() != null) {
                enddate = " (" + Messages.getString("ARRETEE_LE", new String[0]) + space + p.getStopDateSD() + ")";
            } else if (p.getEndDateSD() != null) {
                enddate = " (" + Messages.getString("FIN", new String[0]) + space + p.getEndDateSD() + ")";
            }
        }
        StringBuilder b = new StringBuilder(100);
        b.append(name);
        if (isDrug) {
            b.append(space);
            b.append(strength);
            b.append(space);
        }
        if (posology.length() > 0) {
            b.append(posology);
            b.append(space);
        }
        if (isDrug && frequency.length() > 0) {
            b.append(frequency);
            b.append(space);
        }
        if (quantity.length() > 0) {
            b.append(quantity);
            b.append(space);
        }
        if (p.getRx() != null && p.getRx() > 0 && isPrescriptionActive && rx.length() > 0) {
            b.append(", R x ");
            b.append(rx);
            b.append(space);
            b.append(Messages.getString("LE", new String[0]));
            b.append(space);
            b.append(startdate);
            b.append(space);
        }
        if (enddate.length() > 0) {
            b.append(enddate);
            LocalDate presumedEndDate = p.getPresumedDateToRenew();
            String finDate = presumedEndDate == null ? "" : " * FIN: " + LocalDateFormat.format((LocalDate)presumedEndDate, (String)FormatDateProvider.getFormatDate().toString());
            b.append(finDate);
        }
        if (detail.showMoreThan(ShowMedFileDetail.MAXIMUM) && (rxAddedBy = MessageFormat.format(ADD_BY_ON, p.profNom, p.getEntryDateSD())).length() > 0) {
            b.append(", ");
            b.append(rxAddedBy);
        }
        return b.toString();
    }

    public static enum ShowMedFileDetail implements EnumWithValue<ShowMedFileDetail>
    {
        MINIMAL(0){

            public String toString() {
                return Messages.getString("DETAIL_MINIMAL", new String[0]);
            }
        }
        ,
        MOYEN(1){

            public String toString() {
                return Messages.getString("DETAIL_MOYEN", new String[0]);
            }
        }
        ,
        SUPERIEUR(2){

            public String toString() {
                return Messages.getString("DETAIL_SUPERIEUR", new String[0]);
            }
        }
        ,
        MAXIMUM(3){

            public String toString() {
                return Messages.getString("DETAIL_MAXIMAUX", new String[0]);
            }
        };

        private final int value;

        private ShowMedFileDetail(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static ShowMedFileDetail from(Integer value) {
            if (value != null) {
                int intValue = value;
                for (ShowMedFileDetail e : ShowMedFileDetail.values()) {
                    if (e.value != intValue) continue;
                    return e;
                }
            }
            return null;
        }

        public boolean showMoreThan(ShowMedFileDetail i) {
            return this.value >= i.value;
        }

        @Override
        public ShowMedFileDetail fromValue(Integer id) {
            return ShowMedFileDetail.from(id);
        }
    }
}

