/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.b2b;

import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XVulnerability;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XDisabilityCode;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XInscriptionCategory;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XInscriptionEndReason;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XInscriptionStatus;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XPatientB2b;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XPatientB2bModifAction;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XPatientRepresentativeType;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.date.LocalDate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class XPatientB2bModif
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Integer idPatient;
    private Integer idTreatingProfessionnal;
    private Integer idPatientRepresentative;
    private XPatientRepresentativeType patientRepresentativeType;
    private String repLastName;
    private String repFirstName;
    private String repNam;
    private Integer idProfessionnalResident;
    private Integer idSiteFollow;
    private LocalDate siteFollowStartDate;
    private XInscriptionStatus status;
    private XInscriptionCategory category;
    private LocalDate startDate;
    private LocalDate endDate;
    private XInscriptionEndReason endReason;
    private List<XVulnerability> vulnerabilities;
    private transient XPatient source;
    private transient XPatientB2b sourceB2b;
    public List<XPatientB2bModifAction> actions;

    public XPatientB2bModif() {
    }

    public XPatientB2bModif(XPatient patient) {
        this.source = patient;
        if (this.source != null) {
            this.setIdPatient(this.source.getId());
            this.setIdTreatingProfessionnal(patient.getTreatingProfessionnal());
            this.sourceB2b = this.source.b2bInformation;
            if (this.sourceB2b != null) {
                if (patient.id.equals(this.sourceB2b.idPatientRepresentative)) {
                    this.sourceB2b.idPatientRepresentative = null;
                    this.sourceB2b.patientRepresentativeType = XPatientRepresentativeType.SO;
                } else if (this.sourceB2b.idPatientRepresentative != null) {
                    this.setIdPatientRepresentative(this.sourceB2b.idPatientRepresentative);
                    this.setPatientRepresentativeType(this.sourceB2b.patientRepresentativeType);
                    if (this.sourceB2b.getPatientRepresentative() != null) {
                        this.setRepFirstName(this.sourceB2b.getPatientRepresentative().getFirstName());
                        this.setRepLastName(this.sourceB2b.getPatientRepresentative().getLastName());
                        this.setRepNam(this.sourceB2b.getPatientRepresentative().getHealthInsuranceNumber());
                    }
                }
                if (this.sourceB2b.idPatientRepresentative == null && (StringUtils.isNotBlank((CharSequence)this.sourceB2b.getRepFirstName()) || StringUtils.isNotBlank((CharSequence)this.sourceB2b.getRepLastName()) || StringUtils.isNotBlank((CharSequence)this.sourceB2b.getRepNam()))) {
                    this.setRepFirstName(this.sourceB2b.getRepFirstName());
                    this.setRepLastName(this.sourceB2b.getRepLastName());
                    this.setRepNam(this.sourceB2b.getRepNam());
                    this.setPatientRepresentativeType(this.sourceB2b.patientRepresentativeType);
                }
                this.setIdProfessionnalResident(this.sourceB2b.idProfessionnalResident);
                this.setIdSiteFollow(this.sourceB2b.idSiteFollow);
                this.setSiteFollowStartDate(this.sourceB2b.siteFollowStartDate);
                this.setStatus(this.sourceB2b.status);
                this.setCategory(this.sourceB2b.category);
                this.setStartDate(this.sourceB2b.startDate);
                this.setEndDate(this.sourceB2b.endDate);
                this.setEndReason(this.sourceB2b.endReason);
                this.setVulnerabilities(MiscUtil.deepClone(this.sourceB2b.getVulnerabilities()));
            }
        }
    }

    public void setSource(XPatient source) {
        this.source = source;
        this.sourceB2b = this.source == null ? null : this.source.b2bInformation;
    }

    public boolean hasDiffFromSource() {
        if (this.source == null) {
            throw new IllegalArgumentException("this method cant be called if source is null");
        }
        if (!MiscUtil.areObjectsEquals(this.source.getId(), this.idPatient)) {
            throw new RuntimeException("source.idPatient != idPatient is not a supported case");
        }
        if (!MiscUtil.areObjectsEquals(this.source.getTreatingProfessionnal(), this.idTreatingProfessionnal)) {
            return true;
        }
        if (!MiscUtil.areObjectsEquals(this.sourceB2b.idPatientRepresentative, this.idPatientRepresentative)) {
            return true;
        }
        if (!MiscUtil.areObjectsEquals(this.sourceB2b.patientRepresentativeType, this.patientRepresentativeType)) {
            return true;
        }
        if (!MiscUtil.areObjectsEquals(this.sourceB2b.repLastName, this.repLastName)) {
            return true;
        }
        if (!MiscUtil.areObjectsEquals(this.sourceB2b.repFirstName, this.repFirstName)) {
            return true;
        }
        if (!MiscUtil.areObjectsEquals(this.sourceB2b.repNam, this.repNam)) {
            return true;
        }
        if (!MiscUtil.areObjectsEquals(this.sourceB2b.idProfessionnalResident, this.idProfessionnalResident)) {
            return true;
        }
        if (!MiscUtil.areObjectsEquals(this.sourceB2b.idSiteFollow, this.idSiteFollow)) {
            return true;
        }
        if (!MiscUtil.areObjectsEquals(this.sourceB2b.siteFollowStartDate, this.siteFollowStartDate)) {
            return true;
        }
        if (!MiscUtil.areObjectsEquals(this.sourceB2b.status, this.status)) {
            return true;
        }
        if (!MiscUtil.areObjectsEquals(this.sourceB2b.category, this.category)) {
            return true;
        }
        if (!MiscUtil.areObjectsEquals(this.sourceB2b.startDate, this.startDate)) {
            return true;
        }
        if (!MiscUtil.areObjectsEquals(this.sourceB2b.endDate, this.endDate)) {
            return true;
        }
        if (!MiscUtil.areObjectsEquals(this.sourceB2b.endReason, this.endReason)) {
            return true;
        }
        if (this.sourceB2b.vulnerabilities != this.vulnerabilities) {
            if (this.sourceB2b.vulnerabilities == null && this.vulnerabilities != null) {
                return true;
            }
            if (this.sourceB2b.vulnerabilities != null && this.vulnerabilities == null) {
                return true;
            }
            ArrayList<XVulnerability> list1 = new ArrayList<XVulnerability>();
            for (XVulnerability x : this.sourceB2b.vulnerabilities) {
                if (x == null || x.disCode == null || x.disCode == XDisabilityCode.C00) continue;
                list1.add(x);
            }
            ArrayList<XVulnerability> list2 = new ArrayList<XVulnerability>();
            for (XVulnerability x : this.vulnerabilities) {
                if (x == null || x.disCode == null || x.disCode == XDisabilityCode.C00) continue;
                list2.add(x);
            }
            for (XVulnerability x : list1) {
                if (list2.contains(x)) continue;
                return true;
            }
            for (XVulnerability x : list2) {
                if (list1.contains(x)) continue;
                return true;
            }
        }
        return !MiscUtil.areObjectsEquals(this.sourceB2b.vulnerabilities, this.vulnerabilities);
    }

    public XPatientB2bModif clone() {
        try {
            XPatientB2bModif c = (XPatientB2bModif)super.clone();
            c.idPatient = this.idPatient;
            c.idPatientRepresentative = this.idPatientRepresentative;
            c.patientRepresentativeType = this.patientRepresentativeType;
            c.idProfessionnalResident = this.idProfessionnalResident;
            c.idSiteFollow = this.idSiteFollow;
            c.siteFollowStartDate = this.siteFollowStartDate;
            c.status = this.status;
            c.category = this.category;
            c.startDate = this.startDate;
            c.endDate = this.endDate;
            c.endReason = this.endReason;
            c.vulnerabilities = MiscUtil.deepClone(this.vulnerabilities);
            c.source = this.source;
            c.sourceB2b = this.sourceB2b;
            c.actions = this.actions == null ? null : new ArrayList<XPatientB2bModifAction>(this.actions);
            return c;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "XPatientB2bModif [idPatient=" + this.getIdPatient() + ", idPatientRepresentative=" + this.getIdPatientRepresentative() + ", patientRepresentativeType=" + this.getPatientRepresentativeType() + ", idProfessionnalResident=" + this.getIdProfessionnalResident() + ", idSiteFollow=" + this.getIdSiteFollow() + ", siteFollowStartDate=" + this.getSiteFollowStartDate() + ", status=" + this.getStatus() + ", category=" + this.getCategory() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", endReason=" + this.getEndReason() + ", vulnerabilities=" + this.getVulnerabilities() + "]";
    }

    public Integer getIdPatient() {
        return this.idPatient;
    }

    public void setIdPatient(Integer idPatient) {
        this.idPatient = idPatient;
    }

    public Integer getIdPatientRepresentative() {
        return this.idPatientRepresentative;
    }

    public void setIdPatientRepresentative(Integer idPatientRepresentative) {
        this.idPatientRepresentative = idPatientRepresentative;
    }

    public XPatientRepresentativeType getPatientRepresentativeType() {
        return this.patientRepresentativeType;
    }

    public void setPatientRepresentativeType(XPatientRepresentativeType patientRepresentativeType) {
        this.patientRepresentativeType = patientRepresentativeType;
    }

    public final String getRepLastName() {
        return this.repLastName;
    }

    public final void setRepLastName(String repLastName) {
        this.repLastName = repLastName;
    }

    public final String getRepFirstName() {
        return this.repFirstName;
    }

    public final void setRepFirstName(String repFirstName) {
        this.repFirstName = repFirstName;
    }

    public final String getRepNam() {
        return this.repNam;
    }

    public final void setRepNam(String repNam) {
        this.repNam = repNam;
    }

    public Integer getIdProfessionnalResident() {
        return this.idProfessionnalResident;
    }

    public void setIdProfessionnalResident(Integer idProfessionnalResident) {
        this.idProfessionnalResident = idProfessionnalResident;
    }

    public Integer getIdSiteFollow() {
        return this.idSiteFollow;
    }

    public void setIdSiteFollow(Integer idSiteFollow) {
        this.idSiteFollow = idSiteFollow;
    }

    public LocalDate getSiteFollowStartDate() {
        return this.siteFollowStartDate;
    }

    public void setSiteFollowStartDate(LocalDate siteFollowStartDate) {
        this.siteFollowStartDate = siteFollowStartDate;
    }

    public XInscriptionStatus getStatus() {
        return this.status;
    }

    public void setStatus(XInscriptionStatus status) {
        this.status = status;
    }

    public XInscriptionCategory getCategory() {
        return this.category;
    }

    public void setCategory(XInscriptionCategory category) {
        this.category = category;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public XInscriptionEndReason getEndReason() {
        return this.endReason;
    }

    public void setEndReason(XInscriptionEndReason endReason) {
        this.endReason = endReason;
    }

    public List<XVulnerability> getVulnerabilities() {
        return this.vulnerabilities;
    }

    public XVulnerability getVulnerabilities(int index) {
        if (this.vulnerabilities == null) {
            this.vulnerabilities = new ArrayList<XVulnerability>(3);
        }
        if (this.vulnerabilities.isEmpty()) {
            this.vulnerabilities.add(new XVulnerability(null, null));
            this.vulnerabilities.add(new XVulnerability(null, null));
            this.vulnerabilities.add(new XVulnerability(null, null));
        }
        return this.vulnerabilities.get(index);
    }

    public void setVulnerabilities(List<XVulnerability> vulnerabilities) {
        this.vulnerabilities = vulnerabilities;
    }

    public Integer getIdTreatingProfessionnal() {
        return this.idTreatingProfessionnal;
    }

    public void setIdTreatingProfessionnal(Integer idTreatingProfessionnal) {
        this.idTreatingProfessionnal = idTreatingProfessionnal;
    }
}

