/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.appointment;

import ca.infodata.ofys.data.middle.dataobjects.IClient;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPersonType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IVisualAppointment;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.util.UUID;

public final class XReservedAppointment
implements IMinimalEditableDataObject,
Comparable<XReservedAppointment>,
IVisualAppointment,
IClient {
    private static final long serialVersionUID = 1L;
    public Integer id;
    public Integer idClient;
    public Short startTime;
    public Short endTime;
    public LocalDate date;
    public Integer idProfessional;
    public Integer idSite;
    public XPersonType idPatientType;
    public Integer idPatient;
    public boolean invalidateMe = false;
    public Integer tag = UUID.randomUUID().hashCode();
    public Integer numberOfSecToExpire;
    public Long timeOfExpiration;

    @Override
    public void initialize() {
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    public final Integer getIdClient() {
        return this.idClient;
    }

    public final void setIdClient(Integer idClient) {
        this.idClient = idClient;
    }

    @Override
    public String toString() {
        return Messages.getString("RESERVE_RDV", new String[0]) + DateUtil.convertTimeToString((Integer)this.getStartTime().intValue(), (Character)Character.valueOf('H')) + " - " + DateUtil.convertTimeToString((Integer)this.getEndTime().intValue(), (Character)Character.valueOf('H'));
    }

    public String toDebugString() {
        return "XReservedAppointment [id=" + this.id + ", idClient=" + this.idClient + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", date=" + this.date + ", idProfessional=" + this.idProfessional + ", idSite=" + this.idSite + ", idPatientType=" + this.idPatientType + ", idPatient=" + this.idPatient + ", invalidateMe=" + this.invalidateMe + ", tag=" + this.tag + ", numberOfSecToExpire=" + this.numberOfSecToExpire + ", timeOfExpiration=" + this.timeOfExpiration + "]";
    }

    @Override
    public Short getStartTime() {
        return this.startTime;
    }

    @Override
    public Short getEndTime() {
        return this.endTime;
    }

    public void setStartTime(Short startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Short endTime) {
        this.endTime = endTime;
    }

    @Override
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    @Override
    public final Integer getIdProfessional() {
        return this.idProfessional;
    }

    public final void setIdProfessional(Integer idProfessional) {
        this.idProfessional = idProfessional;
    }

    @Override
    public XReservedAppointment clone() {
        XReservedAppointment c = new XReservedAppointment();
        c.id = this.id;
        c.idClient = this.idClient;
        c.startTime = this.startTime;
        c.endTime = this.endTime;
        c.date = this.date;
        c.idProfessional = this.idProfessional;
        c.idSite = this.idSite;
        c.idPatientType = this.idPatientType;
        c.idPatient = this.idPatient;
        c.invalidateMe = this.invalidateMe;
        c.numberOfSecToExpire = this.numberOfSecToExpire;
        c.timeOfExpiration = this.timeOfExpiration;
        return c;
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof XReservedAppointment) {
            equals = this.getXReservationKey().equals(((XReservedAppointment)obj).getXReservationKey());
        }
        return equals;
    }

    public Integer getIdSite() {
        return this.idSite;
    }

    public void setIdSite(Integer idSite) {
        this.idSite = idSite;
    }

    public final Integer getNumberOfSecToExpire() {
        return this.numberOfSecToExpire;
    }

    public final void setNumberOfSecToExpire(Integer numberOfSecToExpire) {
        this.numberOfSecToExpire = numberOfSecToExpire;
    }

    public final Long getTimeOfExpiration() {
        return this.timeOfExpiration;
    }

    public final void setTimeOfExpiration(Long timeOfExpiration) {
        this.timeOfExpiration = timeOfExpiration;
    }

    public final boolean isInvalidateMe() {
        return this.invalidateMe;
    }

    public final void setInvalidateMe(boolean invalidateMe) {
        this.invalidateMe = invalidateMe;
    }

    @Override
    public final Integer getTag() {
        return this.tag;
    }

    @Override
    public final void setTag(Integer tag) {
        this.tag = tag;
    }

    public Integer getIdPatient() {
        return this.idPatient;
    }

    public void setIdPatient(Integer idPatient) {
        this.idPatient = idPatient;
    }

    public XPersonType getIdPatientType() {
        return this.idPatientType;
    }

    public void setIdPatientType(XPersonType idPatientType) {
        this.idPatientType = idPatientType;
    }

    @Override
    public int compareTo(XReservedAppointment o) {
        int i = this.getIdProfessional().compareTo(o.getIdProfessional());
        if (i == 0 && (i = this.getDate().compareTo((IPartialDate)o.getDate())) == 0) {
            if (this.getStartTime() != null && o.getStartTime() != null) {
                return this.getStartTime().compareTo(o.getStartTime());
            }
            if (this.getStartTime() != null) {
                return -1;
            }
            if (o.getStartTime() != null) {
                return 1;
            }
        }
        return i;
    }

    @Override
    public void setModificationStatus(ModificationStatus newStatus) {
    }

    @Override
    public ModificationStatus getModificationStatus() {
        return null;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public IStatus valid() {
        return null;
    }

    @Override
    public IStatus validQuestion() {
        return null;
    }

    @Override
    public void setTag() {
    }

    @Override
    public final boolean equalsByTag(IMinimalEditableDataObject other) {
        return other != null && this.getTag() != null && other.getTag() != null && this.getTag().equals(other.getTag());
    }

    public int hashCode() {
        return this.getXReservationKey();
    }

    @Override
    public Object cloneSetIdNull() {
        XReservedAppointment c = this.clone();
        c.setId(null);
        return c;
    }

    public Integer getXReservationKey() {
        return XReservedAppointment.getXReservationKey(this.idProfessional, this.idSite, this.date.dayFrom1970, this.startTime);
    }

    public static Integer getXReservationKey(Integer idProf, Integer idSite, Integer date, Short start) {
        return (idProf + ";" + idSite + ";" + date + ";" + start).hashCode();
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this.timeOfExpiration;
    }
}

