/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.appointment;

import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.util.MiscUtil;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;

public final class XAppointmentPeriod
extends EditableDataObject
implements KryoSerializable {
    private static final long serialVersionUID = 1L;
    public static final int APPOINTMENT_TYPE_ADMINISTRATION = 2;
    public static final int APPOINTMENT_TYPE_FOLLOW_UP = 4;
    public static final int APPOINTMENT_TYPE_NEW_AND_ECM = 5;
    public static final int APPOINTMENT_TYPE_NORMAL = 0;
    public static final int APPOINTMENT_TYPE_OTHER = 7;
    public static final int APPOINTMENT_TYPE_RESERVED_PROFESSIONNAL = 3;
    public static final int APPOINTMENT_TYPE_VACCINES = 6;
    public static final int APPOINTMENT_TYPE_WITHOUT_APPOINTMENT = 1;
    public Integer id = null;
    public String nomPeriod = "";
    public Integer appointmentPeriodType = null;
    public Integer defaultLength = 15;
    public Integer endTime = 1200;
    public Integer startTime = 480;
    public Integer idSite = null;
    public Boolean isClosed = null;
    public Boolean isSofyEnabled = null;
    public Boolean isSofyTreatingRestricted = null;
    public Integer visibleNbMinBefore = null;

    @Override
    public void write(Kryo k, Output output) {
        output.writeInt(MiscUtil.fromInt(this.id));
        output.writeString(MiscUtil.fromString(this.nomPeriod));
        output.writeInt(MiscUtil.fromInt(this.appointmentPeriodType));
        output.writeShort(MiscUtil.fromInt(this.defaultLength));
        output.writeShort(MiscUtil.fromInt(this.endTime));
        output.writeShort(MiscUtil.fromInt(this.startTime));
        output.writeInt(MiscUtil.fromInt(this.idSite));
        output.writeByte(MiscUtil.fromBoolean(this.isClosed));
        output.writeByte(MiscUtil.fromBoolean(this.isSofyEnabled));
        output.writeByte(MiscUtil.fromBoolean(this.isSofyTreatingRestricted));
        output.writeInt(MiscUtil.fromInt(this.visibleNbMinBefore));
        super.write(k, output);
    }

    @Override
    public void read(Kryo k, Input input) {
        this.id = MiscUtil.toInt(input.readInt());
        this.nomPeriod = MiscUtil.toString(input.readString());
        this.appointmentPeriodType = MiscUtil.toInt(input.readInt());
        this.defaultLength = MiscUtil.toInt(input.readShort());
        this.endTime = MiscUtil.toInt(input.readShort());
        this.startTime = MiscUtil.toInt(input.readShort());
        this.idSite = MiscUtil.toInt(input.readInt());
        this.isClosed = MiscUtil.toBoolean(input.readByte());
        this.isSofyEnabled = MiscUtil.toBoolean(input.readByte());
        this.isSofyTreatingRestricted = MiscUtil.toBoolean(input.readByte());
        this.visibleNbMinBefore = MiscUtil.toInt(input.readInt());
        super.read(k, input);
    }

    @Override
    public XAppointmentPeriod clone() {
        XAppointmentPeriod c = (XAppointmentPeriod)super.clone();
        c.id = this.id;
        c.startTime = this.startTime;
        c.endTime = this.endTime;
        c.defaultLength = this.defaultLength;
        c.appointmentPeriodType = this.appointmentPeriodType;
        c.nomPeriod = this.nomPeriod;
        c.idSite = this.idSite;
        c.isClosed = this.isClosed;
        c.isSofyEnabled = this.isSofyEnabled;
        c.isSofyTreatingRestricted = this.isSofyTreatingRestricted;
        c.visibleNbMinBefore = this.visibleNbMinBefore;
        return c;
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof XAppointmentPeriod) {
            equals = this.getId() == null ? super.equals(obj) : this.hashCode() == obj.hashCode();
        }
        return equals;
    }

    public Integer getAppointmentPeriodType() {
        return this.appointmentPeriodType;
    }

    public Integer getDefaultLength() {
        return this.defaultLength;
    }

    public Integer getEndTime() {
        return this.endTime;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public int getNbSpace() {
        int result = this.getEndTime() - this.getStartTime() / this.getDefaultLength();
        return result < 0 ? -result : result;
    }

    public String getNomPeriod() {
        return this.nomPeriod;
    }

    public Integer getStartTime() {
        return this.startTime;
    }

    public Integer getLength() {
        Integer startTime2 = this.getStartTime();
        Integer endTime2 = this.getEndTime();
        if (startTime2 == null || endTime2 == null) {
            return null;
        }
        return endTime2 - startTime2;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : ("XAppointmentPeriod" + this.getId().hashCode()).hashCode();
        return hashCode;
    }

    @Override
    @Deprecated
    public void initialize() {
    }

    @Override
    public boolean isDirty() {
        return super.isDirty();
    }

    @Override
    public IStatus valid() {
        MultiStatus status = new MultiStatus();
        status.add(super.valid());
        if (this.getAppointmentPeriodType() == null) {
            status.add(new Status(IStatus.Severity.ERROR, "Period must have a type"));
        }
        return status;
    }

    public void setAppointmentPeriodType(Integer appointmentPeriodType) {
        this.appointmentPeriodType = appointmentPeriodType;
        this.setUpdated();
    }

    public void setDefaultLength(Integer defaultLength) {
        this.defaultLength = defaultLength;
        this.setUpdated();
    }

    public void setEndTime(Integer endTime) {
        this.endTime = endTime;
        this.setUpdated();
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
        this.setUpdated();
    }

    public void setNomPeriod(String nomPeriod) {
        this.nomPeriod = nomPeriod;
        this.setUpdated();
    }

    public void setStartTime(Integer startTime) {
        this.startTime = startTime;
        this.setUpdated();
    }

    @Override
    public String toString() {
        return String.format("XPeriod id=%s, name=%s, start=%s, end=%s, defaultLength=%s, type=%s", this.getId(), this.getNomPeriod(), this.getStartTime(), this.getEndTime(), this.getDefaultLength(), this.getAppointmentPeriodType());
    }

    public Integer getIdSite() {
        return this.idSite;
    }

    public void setIdSite(Integer idSite) {
        this.idSite = idSite;
        this.setUpdated();
    }

    public void setIsClosed(Boolean isClosed) {
        this.isClosed = isClosed;
        this.setUpdated();
    }

    public boolean isClosed() {
        return Boolean.TRUE.equals(this.isClosed);
    }

    public boolean isSofyEnabled() {
        return Boolean.TRUE.equals(this.isSofyEnabled);
    }

    public void setIsSofyEnabled(Boolean isSofyEnabled) {
        this.isSofyEnabled = isSofyEnabled;
        this.setUpdated();
    }

    public boolean isSofyTreatingRestricted() {
        return Boolean.TRUE.equals(this.isSofyTreatingRestricted);
    }

    public void setIsSofyTreatingRestricted(Boolean isSofyTreatingRestricted) {
        this.isSofyTreatingRestricted = isSofyTreatingRestricted;
        this.setUpdated();
    }

    public Integer getVisibleNbMinBefore() {
        return this.visibleNbMinBefore;
    }

    public void setVisibleNbMinBefore(Integer rvsqVisibleDateTime) {
        this.visibleNbMinBefore = rvsqVisibleDateTime;
        this.setUpdated();
    }
}

