/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.appointment;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriod;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.ofys.mb.listener.object.ObjectListenerManager;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.IntegerRange;
import ca.infodata.util1.Range;
import ca.infodata.util1.RangeNotation;
import ca.infodata.util1.StringUtils;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class XAppointmentDateTemplate
extends EditableDataObject
implements KryoSerializable {
    private static final long serialVersionUID = 1L;
    public EditableDataObject.Property<Integer> id = this.newProperty("id", null);
    public EditableDataObject.Property<Integer> professionnal;
    public EditableDataObject.Property<String> note;
    public EditableDataObject.Property<Boolean> isReusable;
    public EditableDataObject.Property<Boolean> isDeleted;
    public EditableDataObject.Property<Short> startHour;
    public EditableDataObject.Property<Short> endHour;
    public EditableDataObject.Property<Short> scale;
    public EditableDataObject.Property<IEditableDataObjectList<XAppointmentPeriod>> lstPeriods;
    public static final Comparator<XAppointmentPeriod> sortByStartTimeAsc = new Comparator<XAppointmentPeriod>(){

        @Override
        public int compare(XAppointmentPeriod o1, XAppointmentPeriod o2) {
            return o1.getStartTime() - o2.getStartTime();
        }
    };

    @Override
    public void write(Kryo k, Output output) {
        output.writeInt(MiscUtil.fromInt(this.id.get()));
        output.writeInt(MiscUtil.fromInt(this.professionnal.get()));
        output.writeString(MiscUtil.fromString(this.note.get()));
        output.writeByte(MiscUtil.fromBoolean(this.isReusable.get()));
        output.writeByte(MiscUtil.fromBoolean(this.isDeleted.get()));
        output.writeShort((int)MiscUtil.fromShort(this.startHour.get()));
        output.writeShort((int)MiscUtil.fromShort(this.endHour.get()));
        output.writeShort((int)MiscUtil.fromShort(this.scale.get()));
        if (this.lstPeriods.get() == null) {
            output.writeShort(0);
        } else {
            output.writeShort(this.lstPeriods.get().size());
            for (XAppointmentPeriod x : this.lstPeriods.get()) {
                k.writeObject(output, (Object)x);
            }
        }
        super.write(k, output);
    }

    @Override
    public void read(Kryo k, Input input) {
        this.id.plain_set(MiscUtil.toInt(input.readInt()));
        this.professionnal.plain_set(MiscUtil.toInt(input.readInt()));
        this.note.plain_set(MiscUtil.toString(input.readString()));
        this.isReusable.plain_set(MiscUtil.toBoolean(input.readByte()));
        this.isDeleted.plain_set(MiscUtil.toBoolean(input.readByte()));
        this.startHour.plain_set(MiscUtil.toShort(input.readShort()));
        this.endHour.plain_set(MiscUtil.toShort(input.readShort()));
        this.scale.plain_set(MiscUtil.toShort(input.readShort()));
        int s = input.readShort();
        if (s > 0) {
            EditableDataObjectList periods = new EditableDataObjectList();
            this.lstPeriods = this.newProperty("periods", periods);
            for (int i = 0; i < s; ++i) {
                this.lstPeriods.get().add((XAppointmentPeriod)((IMinimalEditableDataObject)k.readObject(input, XAppointmentPeriod.class)));
            }
        }
        super.read(k, input);
    }

    public XAppointmentDateTemplate() {
        EditableDataObjectList periods = new EditableDataObjectList();
        this.lstPeriods = this.newProperty("periods", periods);
        this.professionnal = this.newProperty("professionnal", null, false);
        this.note = this.newProperty("note", "");
        this.isReusable = this.newProperty("isReusable", true);
        this.isDeleted = this.newProperty("isDeleted", false);
        this.startHour = this.newProperty("startHour", (short)8);
        this.endHour = this.newProperty("endHour", (short)20);
        this.scale = this.newProperty("scale", (short)15);
    }

    @Override
    protected void childModified(Object object) {
        this.setModificationStatus(ModificationStatus.STATUS_UPDATED);
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || this.getPeriods() != null && this.getPeriods().isDirty();
    }

    @Override
    public Integer getId() {
        return this.id.get();
    }

    @Override
    public void setId(Integer id) {
        this.id.set(id);
    }

    public String getNote() {
        return this.note.get();
    }

    public void setNote(String note) {
        this.note.set(note);
    }

    public boolean getIsDeleted() {
        return this.isDeleted.get();
    }

    public void setIsDeleted(boolean isDeleted) {
        if (this.isNewOrNewUpdated()) {
            this.isDeleted.set((Boolean)isDeleted, ModificationStatus.STATUS_DELETED);
        } else {
            this.isDeleted.set(isDeleted);
        }
    }

    public boolean getIsReusable() {
        return this.isReusable.get();
    }

    public void setIsReusable(boolean isReusable) {
        this.isReusable.set(isReusable);
    }

    public Integer getProfessionnal() {
        return this.professionnal.get();
    }

    public void setProfessionnal(Integer professionnal) {
        this.professionnal.set(professionnal);
    }

    public Short getEndHour() {
        return this.endHour.get();
    }

    public void setEndHour(Short endHour) {
        this.endHour.set(endHour);
    }

    public Short getScale() {
        return this.scale.get();
    }

    public void setScale(Short scale) {
        this.scale.set(scale);
    }

    public Short getStartHour() {
        return this.startHour.get();
    }

    public void setStartHour(Short startHour) {
        this.startHour.set(startHour);
    }

    public int changePeriodTime(XAppointmentPeriod period, int startTime, int endTime) {
        if (period == null) {
            throw new NullPointerException("period");
        }
        if (startTime >= endTime || startTime < 0 || endTime < 0 || startTime > 1440 || endTime > 1440) {
            return -2;
        }
        if (endTime - startTime < period.getDefaultLength()) {
            return -2;
        }
        if (this.getStartHour() != null && this.getStartHour() * 60 > startTime) {
            return -2;
        }
        if (this.getEndHour() != null && this.getEndHour() * 60 < endTime) {
            return -2;
        }
        if (this.getPeriods() != null) {
            boolean overlap;
            List<XAppointmentPeriod> periods = this.getPeriods(startTime, endTime);
            periods.remove(period);
            boolean bl = overlap = !periods.isEmpty();
            if (overlap) {
                return -3;
            }
            int modulo = (endTime - startTime) % period.getDefaultLength();
            if (modulo != 0) {
                endTime -= modulo;
            }
            period.setStartTime(startTime);
            if (endTime != 0) {
                period.setEndTime(endTime);
            }
            return 0;
        }
        return -1;
    }

    public int changeScale(int newScale) {
        if (newScale > 0) {
            this.setScale((short)newScale);
            return 1;
        }
        return 0;
    }

    public IEditableDataObjectList<XAppointmentPeriod> getPeriods() {
        return this.lstPeriods.get();
    }

    public List<XAppointmentPeriod> getSortedPeriods() {
        IEditableDataObjectList<XAppointmentPeriod> list = this.lstPeriods.get();
        Collections.sort(list, sortByStartTimeAsc);
        return list;
    }

    public void setPeriods(List<XAppointmentPeriod> lstPeriods) {
        ObjectListenerManager.disable(this.lstPeriods.get());
        this.lstPeriods.get().clear();
        this.lstPeriods.get().addAll(lstPeriods);
        ObjectListenerManager.enable(this.lstPeriods.get(), true);
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof XAppointmentDateTemplate) {
            equals = this.getId() == null ? super.equals(obj) : this.hashCode() == obj.hashCode();
        }
        return equals;
    }

    @Override
    public int hashCode() {
        Integer id = this.getId();
        if (id == null) {
            return super.hashCode();
        }
        return ("XAppointmentDateTemplate" + String.valueOf(id)).hashCode();
    }

    @Override
    public String toString() {
        return String.format("XAppointmentDateTemplate [id=%d, idProf=%s, hashcode=%d, note=%s, motificationStatus=%s, tag=%d", this.getId(), this.getProfessionnal(), this.hashCode(), this.getNote(), this.getModificationStatus(), this.getTag());
    }

    @Override
    public XAppointmentDateTemplate clone() {
        XAppointmentDateTemplate c = (XAppointmentDateTemplate)super.clone();
        c.id = this.clonePropertyTo(c, this.id);
        c.note = this.clonePropertyTo(c, this.note);
        c.isReusable = this.clonePropertyTo(c, this.isReusable);
        c.isDeleted = this.clonePropertyTo(c, this.isDeleted);
        c.startHour = this.clonePropertyTo(c, this.startHour);
        c.endHour = this.clonePropertyTo(c, this.endHour);
        c.scale = this.clonePropertyTo(c, this.scale);
        c.lstPeriods = this.clonePropertyTo(c, this.lstPeriods);
        c.professionnal = this.clonePropertyTo(c, this.professionnal);
        return c;
    }

    public XAppointmentPeriod getPeriod(Integer startTime, Integer endTime) {
        if (startTime == null || endTime == null || startTime == endTime) {
            return null;
        }
        Collections.sort(this.getPeriods(), sortByStartTimeAsc);
        IntegerRange range = new IntegerRange(startTime, endTime, RangeNotation.LEFT_CLOSED);
        IntegerRange range2 = new IntegerRange();
        for (XAppointmentPeriod period : this.getPeriods().getNotDeleted()) {
            range2.start = period.getStartTime();
            range2.end = period.getEndTime();
            if ((Integer)range2.start >= (Integer)range2.end) continue;
            range2.notation = RangeNotation.LEFT_CLOSED;
            if (!range.intersect((Range)range2)) continue;
            return period;
        }
        return null;
    }

    public List<XAppointmentPeriod> getPeriods(int startTime, int endTime) {
        if (this.getPeriods().isEmpty() || startTime == endTime) {
            return Collections.emptyList();
        }
        Collections.sort(this.getPeriods(), sortByStartTimeAsc);
        ArrayList<XAppointmentPeriod> periods = new ArrayList<XAppointmentPeriod>();
        IntegerRange range = new IntegerRange(Integer.valueOf(startTime), Integer.valueOf(endTime), RangeNotation.LEFT_CLOSED);
        IntegerRange range2 = new IntegerRange();
        for (XAppointmentPeriod period : this.getPeriods().getNotDeleted()) {
            range2.start = period.getStartTime();
            range2.end = period.getEndTime();
            if ((Integer)range2.start >= (Integer)range2.end) continue;
            range2.notation = RangeNotation.LEFT_CLOSED;
            if (!range.intersect((Range)range2)) continue;
            periods.add(period);
        }
        return periods;
    }

    public static boolean hasPeriodConflict(int[] perToTest, List<int[]> periodes) {
        if (periodes == null || periodes.isEmpty() || perToTest[0] == perToTest[1]) {
            return false;
        }
        IntegerRange range = new IntegerRange(Integer.valueOf(perToTest[0]), Integer.valueOf(perToTest[1]), RangeNotation.LEFT_CLOSED);
        IntegerRange range2 = new IntegerRange();
        for (int[] period : periodes) {
            range2.start = Integer.valueOf(period[0]);
            range2.end = Integer.valueOf(period[1]);
            if ((Integer)range2.start >= (Integer)range2.end) continue;
            range2.notation = RangeNotation.LEFT_CLOSED;
            if (!range.intersect((Range)range2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IStatus valid() {
        MultiStatus status = new MultiStatus();
        status.add(super.valid());
        if (!this.getIsDeleted() && !this.isNonExisting()) {
            if (StringUtils.isBlank((CharSequence)this.getNote())) {
                status.add(new Status(IStatus.Severity.ERROR, Messages.getString("__ENTREZ_UNE_DESCRIPTION_DE_LA_JOURNEE", new String[0])));
            }
            if (this.getScale() != null && this.getScale().intValue() < 0) {
                status.add(new Status(IStatus.Severity.ERROR, Messages.getString("__ENTREZ_UN_NOMBRE_PLUS_GRAND_QUE_0", new String[0])));
            }
        }
        return status;
    }

    @Override
    @Deprecated
    public void initialize() {
    }
}

