/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseUser;
import ca.infodata.ofys.data.middle.dataobjects.XFacturationType;
import ca.infodata.ofys.data.middle.dataobjects.XUserRole;
import ca.infodata.ofys.data.middle.dataobjects.preferences.XUserPreferences;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.util.EnumWithValueFactory;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.EnumSet;

public final class XUser
extends XBaseUser
implements KryoSerializable {
    private static final long serialVersionUID = 8619378203322060925L;
    public String name;
    public String encryptedPassword;
    public String encryptedPasswordConfirm;
    public Boolean isDeleted;
    public boolean mustChangePassword;
    public XUserPreferences userPreferences;
    public Integer basePerson;
    public LocalDate passwordCreationDate;
    public LocalDate validFromDate;
    public LocalDate validToDate;
    public EnumSet<XUserRole> role;
    public EnumSet<XUserRole> crisisRole;
    public Boolean crisisRoleEnabled;
    public LocalDate crisisRoleEndDate;
    public XFacturationType factType;
    public String factCodeProf;
    public String factUsername;
    public String factPswd;
    public String factNoagenceRamq;
    public Boolean twoFactorSuspended;
    public Boolean twoFactorActive;
    public Boolean twoFactorConfigured;
    public String twoFactorEmail;

    @Override
    public void write(Kryo k, Output out) {
        out.writeString(MiscUtil.fromString(this.name));
        out.writeString(MiscUtil.fromString(this.encryptedPassword));
        out.writeString(MiscUtil.fromString(this.encryptedPasswordConfirm));
        out.writeBoolean(Boolean.TRUE.equals(this.isDeleted));
        out.writeBoolean(this.mustChangePassword);
        out.writeInt(MiscUtil.fromInt(this.basePerson));
        out.writeShort((int)MiscUtil.fromLocalDateToShort(this.passwordCreationDate));
        out.writeShort((int)MiscUtil.fromLocalDateToShort(this.validFromDate));
        out.writeShort((int)MiscUtil.fromLocalDateToShort(this.validToDate));
        out.writeInt(EnumWithValueFactory.to(this.role).intValue(), true);
        EnumSet<XUserRole> cr = this.crisisRole == null ? EnumSet.noneOf(XUserRole.class) : this.crisisRole;
        out.writeInt(EnumWithValueFactory.to(cr).intValue(), true);
        out.writeBoolean(Boolean.TRUE.equals(this.crisisRoleEnabled));
        out.writeShort((int)MiscUtil.fromLocalDateToShort(this.crisisRoleEndDate));
        out.writeShort((int)((short)(this.getFactType() == null ? 0 : (short)this.getFactType().getValue())));
        out.writeString(MiscUtil.fromString(this.getFactCodeProf()));
        out.writeString(MiscUtil.fromString(this.getFactNoagenceRamq()));
        out.writeString(MiscUtil.fromString(this.getFactUsername()));
        out.writeString(MiscUtil.fromString(this.getFactPswd()));
        out.writeBoolean(Boolean.TRUE.equals(this.twoFactorSuspended));
        out.writeBoolean(Boolean.TRUE.equals(this.twoFactorActive));
        out.writeBoolean(Boolean.TRUE.equals(this.twoFactorConfigured));
        out.writeString(MiscUtil.fromString(this.getTwoFactorEmail()));
        k.writeObjectOrNull(out, (Object)this.userPreferences, XUserPreferences.class);
        super.write(k, out);
    }

    @Override
    public void read(Kryo k, Input in) {
        this.name = MiscUtil.toString(in.readString());
        this.encryptedPassword = MiscUtil.toString(in.readString());
        this.encryptedPasswordConfirm = MiscUtil.toString(in.readString());
        this.isDeleted = in.readBoolean();
        this.mustChangePassword = in.readBoolean();
        this.basePerson = MiscUtil.toInt(in.readInt());
        this.passwordCreationDate = MiscUtil.toLocalDate(in.readShort());
        this.validFromDate = MiscUtil.toLocalDate(in.readShort());
        this.validToDate = MiscUtil.toLocalDate(in.readShort());
        this.role = EnumWithValueFactory.fromSet(XUserRole.class, in.readInt(true));
        this.crisisRole = EnumWithValueFactory.fromSet(XUserRole.class, in.readInt(true));
        this.crisisRoleEnabled = in.readBoolean();
        this.crisisRoleEndDate = MiscUtil.toLocalDate(in.readShort());
        this.factType = EnumWithValueFactory.fromInt(XFacturationType.class, in.readShort());
        this.factCodeProf = MiscUtil.toString(in.readString());
        this.factNoagenceRamq = MiscUtil.toString(in.readString());
        this.factUsername = MiscUtil.toString(in.readString());
        this.factPswd = MiscUtil.toString(in.readString());
        this.twoFactorSuspended = in.readBoolean();
        this.twoFactorActive = in.readBoolean();
        this.twoFactorConfigured = in.readBoolean();
        this.twoFactorEmail = MiscUtil.toString(in.readString());
        this.userPreferences = (XUserPreferences)k.readObjectOrNull(in, XUserPreferences.class);
        super.read(k, in);
    }

    @Override
    public void initialize() {
        this.setNew();
        this.setIsDeleted(false);
        this.setName("");
        this.setMustChangePassword(true);
        this.setEncryptedPassword("");
        this.role = EnumSet.noneOf(XUserRole.class);
        this.crisisRole = EnumSet.noneOf(XUserRole.class);
    }

    @Override
    public boolean isDirty() {
        boolean dirty = super.isDirty() || this.userPreferences != null && this.userPreferences.isDirty();
        return dirty;
    }

    public void setEncryptedPassword(String encryptedPassword) {
        this.encryptedPassword = encryptedPassword;
        this.setUpdated();
    }

    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public void setEncryptedPasswordConfirm(String encryptedPasswordConfirm) {
        this.encryptedPasswordConfirm = encryptedPasswordConfirm;
        this.setUpdated();
    }

    public String getEncryptedPasswordConfirm() {
        return this.encryptedPasswordConfirm;
    }

    public XUserPreferences getUserPreferences() {
        return this.userPreferences;
    }

    public void setUserPreferences(XUserPreferences userPreferences) {
        this.userPreferences = userPreferences;
        this.setUpdated();
    }

    public boolean hasOneOfRoles(XUserRole ... roles) {
        EnumSet<XUserRole> role2 = this.getCrisisManagedRole();
        for (XUserRole role3 : roles) {
            if (!role2.contains(role3)) continue;
            return true;
        }
        return false;
    }

    public EnumSet<XUserRole> getCrisisManagedRole() {
        EnumSet<XUserRole> crisisRole2 = this.getCrisisRole();
        if (crisisRole2 != null && crisisRole2.size() > 0 && Boolean.TRUE.equals(this.getCrisisRoleEnabled()) && (this.getCrisisRoleEndDate() == null || LocalDate.today().beforeOrEquals(this.getCrisisRoleEndDate()))) {
            return crisisRole2;
        }
        return this.getRole();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.setUpdated();
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
        this.setUpdated();
    }

    public boolean isMustChangePassword() {
        return this.mustChangePassword;
    }

    public void setMustChangePassword(boolean mustChangePassword) {
        this.mustChangePassword = mustChangePassword;
        this.setUpdated();
    }

    public Integer getBasePerson() {
        return this.basePerson;
    }

    public void setBasePerson(Integer basePerson) {
        this.basePerson = basePerson;
        this.setUpdated();
    }

    public LocalDate getPasswordCreationDate() {
        return this.passwordCreationDate;
    }

    public void setPasswordCreationDate(LocalDate passwordCreationDate) {
        this.passwordCreationDate = passwordCreationDate;
        this.setUpdated();
    }

    @Override
    public XUser clone() {
        XUser c = (XUser)super.clone();
        c.id = this.id;
        c.name = this.name;
        c.encryptedPassword = this.encryptedPassword;
        c.encryptedPasswordConfirm = this.encryptedPasswordConfirm;
        c.isDeleted = this.isDeleted;
        c.isBlocked = this.isBlocked;
        c.mustChangePassword = this.mustChangePassword;
        c.passwordCreationDate = this.passwordCreationDate;
        c.role = this.role;
        c.crisisRole = this.crisisRole;
        c.crisisRoleEnabled = this.crisisRoleEnabled;
        c.crisisRoleEndDate = this.crisisRoleEndDate;
        c.validFromDate = this.validFromDate;
        c.validToDate = this.validToDate;
        c.basePerson = this.basePerson;
        c.twoFactorSuspended = this.twoFactorSuspended;
        c.twoFactorActive = this.twoFactorActive;
        c.twoFactorConfigured = this.twoFactorConfigured;
        c.twoFactorEmail = this.twoFactorEmail;
        if (this.userPreferences != null) {
            c.userPreferences = this.userPreferences.clone();
        }
        return c;
    }

    @Override
    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return super.toString();
    }

    @Override
    public IStatus valid() {
        IStatus status = super.valid();
        if (status.isOK() && (this.getId() != null || !Boolean.TRUE.equals(this.getIsDeleted()))) {
            if (StringUtils.isBlank((CharSequence)this.getName())) {
                status = new Status(IStatus.Severity.ERROR, Messages.getString("ENTREZ_UN_NOM_UTILISATEUR", new String[0]));
            } else if (this.getName().length() < 5) {
                status = new Status(IStatus.Severity.ERROR, Messages.getString("NOM_UTILISATEUR_DOIT_AVOIR_MINIMUM_5_CARACTERES", new String[0]));
            } else if (StringUtils.isBlank((CharSequence)this.getEncryptedPassword())) {
                status = new Status(IStatus.Severity.ERROR, Messages.getString("ENTREZ_UN_MOT_DE_PASSE", new String[0]));
            } else if (!this.getEncryptedPassword().equals(this.getEncryptedPasswordConfirm())) {
                status = new Status(IStatus.Severity.ERROR, Messages.getString("MOT_DE_PASSE_CONFIRMATION_INCORRECT", new String[0]));
            } else if (this.getRole().size() <= 0) {
                status = new Status(IStatus.Severity.ERROR, Messages.getString("USER_ROLE_INVALIDE", new String[0]));
            }
        }
        return status;
    }

    public boolean isAdmin() {
        return this.getCrisisManagedRole().contains(XUserRole.ADMIN);
    }

    public boolean isOnlyAdmin() {
        return this.isAdmin() && this.getCrisisManagedRole().size() == 1;
    }

    public LocalDate getValidFromDate() {
        return this.validFromDate;
    }

    public void setValidFromDate(LocalDate validFromDate) {
        this.validFromDate = validFromDate;
        this.setUpdated();
    }

    public LocalDate getValidToDate() {
        return this.validToDate;
    }

    public void setValidToDate(LocalDate validToDate) {
        this.validToDate = validToDate;
        this.setUpdated();
    }

    public EnumSet<XUserRole> getRole() {
        return this.role;
    }

    public void setRole(EnumSet<XUserRole> role) {
        this.role = role;
        this.setUpdated();
    }

    public EnumSet<XUserRole> getCrisisRole() {
        return this.crisisRole;
    }

    public void setCrisisRole(EnumSet<XUserRole> crisisRole) {
        this.crisisRole = crisisRole;
        this.setUpdated();
    }

    public Boolean getCrisisRoleEnabled() {
        return this.crisisRoleEnabled;
    }

    public void setCrisisRoleEnabled(Boolean crisisRoleEnabled) {
        this.crisisRoleEnabled = crisisRoleEnabled;
        this.setUpdated();
    }

    public LocalDate getCrisisRoleEndDate() {
        return this.crisisRoleEndDate;
    }

    public void setCrisisRoleEndDate(LocalDate crisisRoleEndDate) {
        this.crisisRoleEndDate = crisisRoleEndDate;
        this.setUpdated();
    }

    public XFacturationType getFactType() {
        return this.factType;
    }

    public void setFactType(XFacturationType factType) {
        this.factType = factType;
    }

    public final String getFactCodeProf() {
        return this.factCodeProf;
    }

    public final void setFactCodeProf(String factCodeProf) {
        this.factCodeProf = factCodeProf;
    }

    public String getFactUsername() {
        return this.factUsername;
    }

    public void setFactUsername(String factUsername) {
        this.factUsername = factUsername;
    }

    public String getFactPswd() {
        return this.factPswd;
    }

    public void setFactPswd(String factPswd) {
        this.factPswd = factPswd;
    }

    public String getFactNoagenceRamq() {
        return this.factNoagenceRamq;
    }

    public void setFactNoagenceRamq(String factNoagenceRamq) {
        this.factNoagenceRamq = factNoagenceRamq;
    }

    public Boolean getTwoFactorActive() {
        return this.twoFactorActive;
    }

    public void setTwoFactorActive(Boolean twoFactorActive) {
        this.twoFactorActive = twoFactorActive;
    }

    public Boolean getTwoFactorSuspended() {
        return this.twoFactorSuspended;
    }

    public void setTwoFactorSuspended(Boolean twoFactorSuspended) {
        this.twoFactorSuspended = twoFactorSuspended;
    }

    public Boolean getTwoFactorConfigured() {
        return this.twoFactorConfigured;
    }

    public void setTwoFactorConfigured(Boolean twoFactorConfigured) {
        this.twoFactorConfigured = twoFactorConfigured;
    }

    public String getTwoFactorEmail() {
        return this.twoFactorEmail;
    }

    public void setTwoFactorConfigured(String twoFactorEmail) {
        this.twoFactorEmail = twoFactorEmail;
    }
}

