/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects;

import ca.infodata.ofys.data.middle.dataobjects.XGenericReportColumn;
import ca.infodata.ofys.data.middle.dataobjects.XReport;

public final class XGenericReport
extends XReport {
    private static final long serialVersionUID = 1L;
    public static int[][] SIZE_LIST = new int[][]{{216, 72}, {216, 144}, {252, 72}, {252, 79}, {252, 103}, {288, 72}, {288, 103}, {360, 72}};
    public XGenericReportColumn columnOne;
    public XGenericReportColumn columnThree;
    public XGenericReportColumn columnTwo;
    @Deprecated
    public boolean isLandscape;
    public int nbColumns;
    public int horizontalSize;
    public int verticalSize;

    public static float convertMmToPixel(float mm) {
        float inches = mm / 25.4f;
        float pixels = inches * 72.0f;
        return pixels;
    }

    public static float convertPixelToMM(float pixel) {
        float inches = pixel / 72.0f;
        float mm = inches * 25.4f;
        return mm;
    }

    public static String convertPixelToCm(int pixel) {
        int size = (int)((double)pixel / 28.0 * 100.0);
        return String.valueOf((double)size / 100.0);
    }

    public static String convertPixelToInches(int pixel) {
        int size = (int)((double)pixel / 72.0 * 100.0);
        return String.valueOf((double)size / 100.0);
    }

    public static String getFormatedSize(int pos) {
        return XGenericReport.convertPixelToInches(SIZE_LIST[pos][0]) + "\" X " + XGenericReport.convertPixelToInches(SIZE_LIST[pos][1]) + "\" (" + XGenericReport.convertPixelToCm(SIZE_LIST[pos][0]) + " cm X " + XGenericReport.convertPixelToCm(SIZE_LIST[pos][1]) + " cm) ";
    }

    @Override
    public XGenericReport clone() {
        XGenericReport c = (XGenericReport)super.clone();
        c.nbColumns = this.nbColumns;
        c.verticalSize = this.verticalSize;
        c.horizontalSize = this.horizontalSize;
        c.isLandscape = this.isLandscape;
        if (this.columnOne != null) {
            c.columnOne = this.columnOne.clone();
        }
        if (this.columnTwo != null) {
            c.columnTwo = this.columnTwo.clone();
        }
        if (this.columnThree != null) {
            c.columnThree = this.columnThree.clone();
        }
        return c;
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof XGenericReport) {
            equals = this.getId() == null ? super.equals(obj) : this.hashCode() == obj.hashCode();
        }
        return equals;
    }

    public XGenericReportColumn getColumnOne() {
        return this.columnOne;
    }

    public XGenericReportColumn getColumnThree() {
        return this.columnThree;
    }

    public XGenericReportColumn getColumnTwo() {
        return this.columnTwo;
    }

    public String getFormatedHeight() {
        return XGenericReport.convertPixelToInches(SIZE_LIST[this.getSizeListPosition()][1]) + "\" (" + XGenericReport.convertPixelToCm(SIZE_LIST[this.getSizeListPosition()][1]) + " cm)";
    }

    public String getFormatedWith() {
        return XGenericReport.convertPixelToInches(SIZE_LIST[this.getSizeListPosition()][0]) + "\" (" + XGenericReport.convertPixelToCm(SIZE_LIST[this.getSizeListPosition()][0]) + " cm)";
    }

    public Integer getHorizontalSize() {
        return this.horizontalSize;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Deprecated
    public boolean getIsLandscape() {
        return this.isLandscape;
    }

    public int getNbColumns() {
        return this.nbColumns;
    }

    public int getSizeListPosition() {
        int ret = -1;
        for (int i = 0; i < SIZE_LIST.length; ++i) {
            if (SIZE_LIST[i][0] != this.getHorizontalSize() || SIZE_LIST[i][1] != this.getVerticalSize()) continue;
            ret = i;
        }
        return ret;
    }

    public int getVerticalSize() {
        return this.verticalSize;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : ("XGenericReport" + this.getId().hashCode()).hashCode();
        return hashCode;
    }

    @Override
    public void initialize() {
        this.setNew();
        this.setNbColumns(new Integer(1));
        this.setVerticalSize(new Integer(72));
        this.setHorizontalSize(new Integer(216));
        this.setIsLandscape(false);
        this.setColumnOne(new XGenericReportColumn());
        this.columnOne.initialize();
        this.setColumnTwo(new XGenericReportColumn());
        this.columnTwo.initialize();
        this.setColumnThree(new XGenericReportColumn());
        this.columnThree.initialize();
    }

    @Override
    public boolean isDirty() {
        boolean dirty = super.isDirty() || this.columnOne != null && this.columnOne.isDirty() || this.nbColumns > 1 && this.columnTwo != null && this.columnTwo.isDirty() || this.nbColumns > 2 && this.columnThree != null && this.columnThree.isDirty();
        return dirty;
    }

    public void setColumnOne(XGenericReportColumn columnOne) {
        this.columnOne = columnOne;
        this.setUpdated();
    }

    public void setColumnThree(XGenericReportColumn columnThree) {
        this.columnThree = columnThree;
        this.setUpdated();
    }

    public void setColumnTwo(XGenericReportColumn columnTwo) {
        this.columnTwo = columnTwo;
        this.setUpdated();
    }

    public void setHorizontalSize(Integer horizontalSize) {
        this.horizontalSize = horizontalSize;
        this.setUpdated();
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
        this.setUpdated();
    }

    @Deprecated
    public void setIsLandscape(boolean isLandscape) {
        this.isLandscape = isLandscape;
        this.setUpdated();
    }

    public void setNbColumns(int nbColumns) {
        this.nbColumns = nbColumns;
        this.setUpdated();
    }

    public void setVerticalSize(int verticalSize) {
        this.verticalSize = verticalSize;
        this.setUpdated();
    }

    @Override
    public String toString() {
        return String.format("XGenericReport [id=%s, version=%s, isLandscape=%s, v_size=%s, h_size=%s, nbCol=%s, %s, %s, %s]", this.getId(), this.getVersion(), this.getIsLandscape(), this.getVerticalSize(), this.getHorizontalSize(), this.getNbColumns(), this.getColumnOne(), this.getColumnTwo(), this.getColumnThree());
    }
}

