/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq.RabbitMqThreadFactory;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.date.DateUtil;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ExceptionHandler;
import com.rabbitmq.client.Recoverable;
import com.rabbitmq.client.RecoveryListener;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.TopologyRecoveryException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class RabbitMqConnection {
    private static final Logger logger = Logger.getLogger(RabbitMqConnection.class.getName());
    private static final String mqUser = "ofys5Desktop" + (UI.OS_MAC ? "Mac" : (UI.OS_WINDOWS ? "Win" : "Lin"));
    private static final String mqPswd = "mq#dWsP@!o5%pq";
    private static final String exchange = "ofys_app";
    private static final String type = "topic";
    private ExecutorService bindingExecutor;
    private final ExecutorService handleDeliveryExecutor;
    private ScheduledExecutorService testServiceExecutor;
    private Connection connection;
    private final ReentrantLock publishChannelLock = new ReentrantLock();
    private final ReentrantLock consumeChannelLock = new ReentrantLock();
    private Channel publishChannel;
    private Channel consumeChannel;
    private Consumer consumer;
    private final String queueName;
    private final XSession session;
    private volatile boolean active;

    public RabbitMqConnection(XSession session, ExecutorService handleDeliveryExecutor) throws Exception {
        this.session = session;
        this.handleDeliveryExecutor = handleDeliveryExecutor;
        int sessionId = session.id;
        String userName = session.user.name;
        String clientCode = session.getClient().getClientCode();
        this.queueName = String.valueOf(clientCode) + ":" + userName + ":" + sessionId;
        this.createConnexion(this.session, this.handleDeliveryExecutor);
        this.createChannel();
        if (this.consumeChannel != null) {
            this.createQueue();
            this.createConsumer();
            this.bindingExecutor = Executors.newCachedThreadPool(new RabbitMqThreadFactory("rabbitmq-binding"));
            this.active = true;
        }
    }

    private void createQueue() throws IOException {
        logger.log(Level.INFO, "createQueue");
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put("u", String.valueOf(this.session.user.id));
        arguments.put("x-expires", TimeUnit.MINUTES.toMillis(90L));
        arguments.put("x-message-ttl", TimeUnit.MINUTES.toMillis(5L));
        arguments.put("v", LibPlugin.getVersion());
        arguments.put("t", DateUtil.format((Long)System.currentTimeMillis(), (String)"yyyy-MM-dd HH:mm"));
        AMQP.Queue.DeclareOk declareOk = this.consumeChannel.queueDeclare(this.queueName, true, false, false, arguments);
        logger.info(String.valueOf(declareOk));
    }

    private void createChannel() throws IOException {
        if (this.connection != null) {
            logger.log(Level.INFO, "createChannel");
            this.consumeChannel = this.connection.createChannel();
            ChannelRecoveryListener recListenerConsume = new ChannelRecoveryListener(this.consumeChannel);
            ((Recoverable)this.consumeChannel).addRecoveryListener((RecoveryListener)recListenerConsume);
            this.publishChannel = this.connection.createChannel();
            ChannelRecoveryListener recListenerPublish = new ChannelRecoveryListener(this.publishChannel);
            ((Recoverable)this.publishChannel).addRecoveryListener((RecoveryListener)recListenerPublish);
            this.createExchange(this.consumeChannel);
            this.createExchange(this.publishChannel);
        }
    }

    private void createExchange(Channel channel) throws IOException {
        Map arguments = null;
        AMQP.Exchange.DeclareOk declareOk = channel.exchangeDeclare(exchange, type, true, false, false, arguments);
        logger.info(String.valueOf(declareOk));
    }

    private void createConnexion(XSession session, ExecutorService executorService) {
        HashMap<String, String> clientProp = new HashMap<String, String>();
        String clientCode = "inc";
        String user = "inc";
        if (session != null && session.getClient() != null) {
            clientCode = session.getClient().getClientCode();
            if (session.getUser() != null) {
                user = session.getUser().getPersonNameOrTextOrEmpty();
            }
        }
        clientProp.put("Code client", clientCode);
        clientProp.put("User", user);
        clientProp.put("Version", LibPlugin.getVersion());
        ConnectionFactory factory = new ConnectionFactory();
        factory.setUsername(mqUser);
        factory.setPassword(mqPswd);
        factory.setHost(Application.get().getGlobalInstances().getMessageQueueConnectionInfo().getAddress());
        factory.setPort(Application.get().getGlobalInstances().getMessageQueueConnectionInfo().getMqPort());
        factory.setAutomaticRecoveryEnabled(true);
        factory.setNetworkRecoveryInterval(5);
        factory.setTopologyRecoveryEnabled(true);
        factory.setConnectionTimeout(20000);
        factory.setRequestedHeartbeat(3);
        factory.setExceptionHandler(new ExceptionHandler(){

            public void handleBlockedListenerException(Connection c, Throwable t) {
                logger.info("ExceptionHandler.handleBlockedListenerException " + RabbitMqConnection.this.formatConnection(c) + "\n" + RabbitMqConnection.this.getStackTraceAsString(t));
            }

            public void handleChannelRecoveryException(Channel h, Throwable t) {
                logger.info("ExceptionHandler.handleChannelRecoveryException " + RabbitMqConnection.this.formatChannel(h) + "\n" + RabbitMqConnection.this.getStackTraceAsString(t));
            }

            public void handleConfirmListenerException(Channel h, Throwable t) {
                logger.info("ExceptionHandler.handleConfirmListenerException " + RabbitMqConnection.this.formatChannel(h) + "\n" + RabbitMqConnection.this.getStackTraceAsString(t));
            }

            public void handleConnectionRecoveryException(Connection c, Throwable t) {
                logger.info("ExceptionHandler.handleConnectionRecoveryException " + RabbitMqConnection.this.formatConnection(c) + "\n" + RabbitMqConnection.this.getStackTraceAsString(t));
            }

            public void handleConsumerException(Channel h, Throwable t, Consumer s, String arg3, String arg4) {
                logger.info("ExceptionHandler.handleConsumerException " + RabbitMqConnection.this.formatChannel(h) + "\n" + s.toString() + "\n" + RabbitMqConnection.this.getStackTraceAsString(t));
            }

            public void handleReturnListenerException(Channel h, Throwable t) {
                logger.info("ExceptionHandler.handleReturnListenerException " + RabbitMqConnection.this.formatChannel(h) + "\n" + RabbitMqConnection.this.getStackTraceAsString(t));
            }

            public void handleTopologyRecoveryException(Connection c, Channel h, TopologyRecoveryException tr) {
                logger.info("ExceptionHandler.handleTopologyRecoveryException " + RabbitMqConnection.this.formatConnection(c) + "\n" + RabbitMqConnection.this.formatChannel(h) + "\n" + tr.getMessage());
            }

            public void handleUnexpectedConnectionDriverException(Connection c, Throwable t) {
                logger.info("ExceptionHandler.handleUnexpectedConnectionDriverException " + RabbitMqConnection.this.formatConnection(c) + "\n" + RabbitMqConnection.this.getStackTraceAsString(t));
            }
        });
        factory.setClientProperties(clientProp);
        try {
            if (Application.get().getGlobalInstances().getMessageQueueConnectionInfo().isMqSSL()) {
                factory.useSslProtocol();
            }
            this.connection = factory.newConnection(executorService);
            ((Recoverable)this.connection).addRecoveryListener(new RecoveryListener(){

                public void handleRecovery(Recoverable r) {
                    logger.info("RecoveryListener handleRecovery " + RabbitMqConnection.this.formatConnection(RabbitMqConnection.this.connection));
                }

                public void handleRecoveryStarted(Recoverable r) {
                    logger.info("RecoveryListener handleRecoveryStarted " + RabbitMqConnection.this.formatConnection(RabbitMqConnection.this.connection));
                }
            });
        }
        catch (Exception e) {
            logger.info("createConnexion - newConnection error " + e.getMessage());
        }
    }

    protected abstract void onFailure();

    private synchronized void fail() {
        if (this.isActive()) {
            logger.info("RabbitMqConnection.fail()");
            this.close(false);
            this.onFailure();
        } else {
            logger.info("RabbitMqConnection already has failed.");
        }
    }

    private void setInactive() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    private void createConsumer() throws IOException {
        logger.log(Level.INFO, "createConsumer");
        this.consumer = new DefaultConsumerExtension(this.consumeChannel);
        this.consumeChannel.basicConsume(this.queueName, false, this.consumer);
    }

    public void basicPublish(String routingKey, AMQP.BasicProperties properties, byte[] body) throws Exception {
        block6: {
            if (this.isActive()) {
                try {
                    logger.info("basic publish to " + routingKey);
                    this.publishChannelLock.lock();
                    this.publishChannel.basicPublish(exchange, routingKey, properties, body);
                    break block6;
                }
                finally {
                    this.publishChannelLock.unlock();
                }
            }
            logger.log(Level.SEVERE, "Failed to publish on channel with binding " + routingKey + " to exchange " + exchange + " because connection has failed");
        }
    }

    public void queueBindAsync(String bindingKey) {
        if (this.isActive()) {
            this.bindingExecutor.submit(new QueueBindRunnable(bindingKey));
        } else {
            logger.log(Level.SEVERE, "Failed to ADD bindingKey " + bindingKey + " to queue " + this.queueName + " because connection has failed");
        }
    }

    public void queueUnbindAsync(String bindingKey) {
        if (this.isActive()) {
            this.bindingExecutor.submit(new QueueUnbindRunnable(bindingKey));
        } else {
            logger.log(Level.SEVERE, "Failed to REMOVE bindingKey " + bindingKey + " from queue " + this.queueName + " because connection has failed");
        }
    }

    private String formatChannel(Channel c) {
        String f;
        if (c == null) {
            f = "channel is null";
        } else {
            ArrayList<String> l = new ArrayList<String>();
            l.add("channelNumber:" + c.getChannelNumber());
            if (c.getDefaultConsumer() != null) {
                l.add("defaultConsumer non null");
            }
            if (c.getCloseReason() != null) {
                l.add("closeReason: " + this.getStackTraceAsString((Throwable)c.getCloseReason()));
            }
            f = new JoinList(",", l).toString();
        }
        return f;
    }

    private String formatConnection(Connection c) {
        String f;
        if (c == null) {
            f = "connection is null";
        } else {
            ArrayList<String> l = new ArrayList<String>();
            if (c.isOpen()) {
                l.add("isOpen");
            }
            if (c.getAddress() != null) {
                l.add("hostAddress:" + c.getAddress().getHostAddress());
            }
            l.add("port:" + c.getPort());
            f = new JoinList(",", l).toString();
        }
        return f;
    }

    private String getStackTraceAsString(Throwable t) {
        StringWriter errors = new StringWriter();
        t.printStackTrace(new PrintWriter(errors));
        return errors.toString();
    }

    public void applicationShudown() {
        this.setInactive();
        try {
            if (this.testServiceExecutor != null) {
                this.testServiceExecutor.shutdownNow();
            }
        }
        catch (Exception e1) {
            logger.log(Level.INFO, "RabbitMqProducer.executorTestService.shutdown", e1);
        }
        try {
            if (this.bindingExecutor != null && !this.bindingExecutor.isShutdown()) {
                this.bindingExecutor.shutdownNow();
            }
        }
        catch (Exception e1) {
            logger.log(Level.INFO, "RabbitMqProducer.executorService.shutdown", e1);
        }
        if (this.connection != null) {
            logger.log(Level.INFO, "Close: Connection abort");
            try {
                try {
                    this.connection.abort(500);
                }
                catch (Exception exception) {
                    this.connection = null;
                }
            }
            finally {
                this.connection = null;
            }
        }
    }

    public void close(boolean deleteQueue) {
        block19: {
            logger.log(Level.FINE, "RabbitMqConnection.close");
            this.setInactive();
            try {
                if (this.testServiceExecutor != null) {
                    this.testServiceExecutor.shutdownNow();
                }
            }
            catch (Exception e1) {
                logger.log(Level.INFO, "RabbitMqProducer.executorTestService.shutdown", e1);
            }
            try {
                if (this.bindingExecutor != null && !this.bindingExecutor.isShutdown()) {
                    this.bindingExecutor.shutdownNow();
                }
            }
            catch (Exception e1) {
                logger.log(Level.INFO, "RabbitMqProducer.executorService.shutdown", e1);
            }
            if (deleteQueue) {
                try {
                    try {
                        logger.log(Level.INFO, "Close: Queue delete");
                        this.consumeChannelLock.lock();
                        if (this.consumeChannel != null && this.queueName != null) {
                            this.consumeChannel.queueDelete(this.queueName);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.INFO, "Failed to delete queue", e);
                        this.consumeChannelLock.unlock();
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    this.consumeChannelLock.unlock();
                    throw throwable;
                }
                this.consumeChannelLock.unlock();
            }
        }
        if (this.connection != null) {
            logger.log(Level.INFO, "Close: Connection abort");
            try {
                try {
                    this.connection.abort(500);
                }
                catch (Exception exception) {
                    this.connection = null;
                }
            }
            finally {
                this.connection = null;
            }
        }
    }

    public abstract void handleDelivery(ExecutorService var1, Envelope var2, AMQP.BasicProperties var3, byte[] var4) throws IOException;

    class ChannelRecoveryListener
    implements RecoveryListener {
        private Channel channel;

        public ChannelRecoveryListener(Channel c) {
            this.channel = c;
        }

        public void handleRecovery(Recoverable r) {
            logger.info("RecoveryListener handleRecovery " + RabbitMqConnection.this.formatChannel(this.channel));
        }

        public void handleRecoveryStarted(Recoverable r) {
            logger.info("RecoveryListener handleRecoveryStarted " + RabbitMqConnection.this.formatChannel(this.channel));
        }
    }

    private final class DefaultConsumerExtension
    extends DefaultConsumer {
        private DefaultConsumerExtension(Channel channel) {
            super(channel);
        }

        public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
            block4: {
                if (RabbitMqConnection.this.handleDeliveryExecutor.isShutdown()) break block4;
                try {
                    this.getChannel().basicAck(envelope.getDeliveryTag(), false);
                }
                catch (Exception e1) {
                    logger.log(Level.SEVERE, "consumer handleDelivery", e1);
                }
                RabbitMqConnection.this.handleDelivery(RabbitMqConnection.this.handleDeliveryExecutor, envelope, properties, body);
            }
        }

        public void handleConsumeOk(String consumerTag) {
            super.handleConsumeOk(consumerTag);
            logger.log(Level.INFO, "handleConsumeOk: " + consumerTag);
        }

        public void handleCancelOk(String consumerTag) {
            super.handleCancelOk(consumerTag);
            logger.log(Level.INFO, "handleCancelOk: " + consumerTag);
        }

        public void handleShutdownSignal(String consumerTag, ShutdownSignalException sig) {
            super.handleShutdownSignal(consumerTag, sig);
            logger.log(Level.INFO, "handleShutdownSignal: " + consumerTag, (Throwable)sig);
        }

        public void handleRecoverOk(String consumerTag) {
            super.handleRecoverOk(consumerTag);
            logger.log(Level.INFO, "handleRecoverOk: " + consumerTag);
        }
    }

    private final class QueueBindRunnable
    implements Runnable {
        private final String bindingKey;

        private QueueBindRunnable(String bindingKey) {
            this.bindingKey = bindingKey;
        }

        @Override
        public void run() {
            try {
                try {
                    RabbitMqConnection.this.consumeChannelLock.lock();
                    RabbitMqConnection.this.consumeChannel.queueBind(RabbitMqConnection.this.queueName, RabbitMqConnection.exchange, this.bindingKey);
                    logger.log(Level.INFO, "ADDED bindingKey " + this.bindingKey + " to queue " + RabbitMqConnection.this.queueName);
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Failed to ADD bindingKey " + this.bindingKey + " to queue " + RabbitMqConnection.this.queueName, e);
                    RabbitMqConnection.this.consumeChannelLock.unlock();
                }
            }
            finally {
                RabbitMqConnection.this.consumeChannelLock.unlock();
            }
        }
    }

    private final class QueueUnbindRunnable
    implements Runnable {
        private final String bindingKey;

        private QueueUnbindRunnable(String bindingKey) {
            this.bindingKey = bindingKey;
        }

        @Override
        public void run() {
            try {
                try {
                    RabbitMqConnection.this.consumeChannelLock.lock();
                    RabbitMqConnection.this.consumeChannel.queueUnbind(RabbitMqConnection.this.queueName, RabbitMqConnection.exchange, this.bindingKey);
                    logger.log(Level.INFO, "REMOVED bindingKey " + this.bindingKey + " from queue " + RabbitMqConnection.this.queueName);
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Failed to REMOVE bindingKey " + this.bindingKey + " from queue " + RabbitMqConnection.this.queueName, e);
                    RabbitMqConnection.this.consumeChannelLock.unlock();
                }
            }
            finally {
                RabbitMqConnection.this.consumeChannelLock.unlock();
            }
        }
    }
}

