/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.util;

import ca.infodata.ofys.data.dataaccess.util.ISessionLock;
import ca.infodata.ofys.data.dataaccess.util.SessionLockException;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.util1.StringUtils;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SessionLock
implements ISessionLock {
    private static final Logger logger = Logger.getLogger(SessionLock.class.getName());
    private final File file;
    private RandomAccessFile raFile;
    private FileChannel fc;
    private FileLock fileLock;

    public SessionLock(XSession session) {
        this.file = new File(LibPlugin.OFYS_HOME_FILE, String.valueOf(SessionLock.getStoreFileName(session)) + ".lock");
        this.file.deleteOnExit();
    }

    public SessionLock(String username) {
        this.file = new File(LibPlugin.OFYS_HOME_FILE, String.valueOf(SessionLock.getStoreFileName(username)) + ".lock");
        this.file.deleteOnExit();
    }

    @Override
    public void tryLockAndRelease() throws SessionLockException {
        try {
            this.tryLock();
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public synchronized void tryLock() throws SessionLockException {
        if (this.raFile == null) {
            try {
                this.raFile = new RandomAccessFile(this.file, "rw");
                this.fc = this.raFile.getChannel();
            }
            catch (Exception e) {
                try {
                    if (this.fc != null) {
                        this.fc.close();
                    }
                }
                catch (Exception e1) {
                    logger.log(Level.WARNING, "Failed to close fileChannel for file " + this.file, e1);
                }
                try {
                    if (this.raFile != null) {
                        this.raFile.close();
                    }
                }
                catch (Exception e1) {
                    logger.log(Level.WARNING, "Failed to close randomAccessFile for file " + this.file, e1);
                }
                this.raFile = null;
                this.fc = null;
                logger.log(Level.SEVERE, "Failed to acquired fileBased session lock", e);
                throw new SessionLockException("Erreur lors de l'acquision du verrou sur la session", e);
            }
        }
        try {
            this.fileLock = this.fc.tryLock();
            if (this.fileLock == null) {
                throw new SessionLockException("Une session avec cet utilisateur est d\u00e9j\u00e0 ouverte sur cet ordinateur.");
            }
        }
        catch (StatusException e) {
            throw e;
        }
        catch (Exception exception) {
            try {
                this.fc.close();
            }
            catch (Exception e1) {
                logger.log(Level.WARNING, "Failed to close fileChannel for file " + this.file, e1);
            }
            try {
                this.raFile.close();
            }
            catch (Exception e1) {
                logger.log(Level.WARNING, "Failed to close randomAccessFile for file " + this.file, e1);
            }
            throw new SessionLockException("Une session avec cet utilisateur est d\u00e9j\u00e0 ouverte sur cet ordinateur.");
        }
    }

    @Override
    public synchronized void releaseLock() {
        try {
            if (this.fileLock != null && this.fileLock.isValid()) {
                this.fileLock.release();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to release fileBase session lock", e);
        }
        try {
            if (this.fileLock != null) {
                this.fileLock.close();
            }
        }
        catch (Exception e1) {
            logger.log(Level.WARNING, "Failed to close fileChannel for file " + this.file, e1);
        }
        try {
            this.fc.close();
        }
        catch (Exception e1) {
            logger.log(Level.WARNING, "Failed to close fileChannel for file " + this.file, e1);
        }
        try {
            this.raFile.close();
        }
        catch (Exception e1) {
            logger.log(Level.WARNING, "Failed to close randomAccessFile for file " + this.file, e1);
        }
    }

    private static String getStoreFileName(XSession session) {
        return SessionLock.getStoreFileName(SessionLock.getNewSessionName(session));
    }

    private static String getStoreFileName(String username) {
        String nn = username.toLowerCase();
        String n = nn.toLowerCase().replace('0', 'j').replace('1', 'i').replace('2', 'h').replace('3', 'g').replace('4', 'f').replace('5', 'e').replace('6', 'd').replace('7', 'c').replace('8', 'b').replace('9', 'a').replace('-', 'z').replace('.', 'm');
        String encName = "";
        int i = 0;
        while (i < n.length()) {
            int tmp = n.charAt(i) - 65;
            int rotated = (tmp - 4) % 25;
            int shift = rotated + 65;
            encName = String.valueOf(encName) + (char)shift;
            ++i;
        }
        if (StringUtils.isEmpty((String)encName)) {
            encName = n;
        }
        return encName.toLowerCase();
    }

    private static String getNewSessionName(XSession session) {
        try {
            if (session != null && session.getUser() != null) {
                return session.getUser().name;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to get codeClient from xsession bug", e);
        }
        return null;
    }
}

