/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.IPatientImageAccessor;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.scan.XScanImageContainer;
import ca.infodata.ofys.data.middle.dataobjects.scan.XScanImageNumberContainer;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.util1.JoinList;

public class PatientImageAccessorClient
extends BaseAccessorClient {
    private static PatientImageAccessorClient instance;
    private final IPatientImageAccessor accessor;

    public static PatientImageAccessorClient getInstance() throws CannotConnectToServerException {
        return PatientImageAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static PatientImageAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new PatientImageAccessorClient(serverConnectionInfo);
        } else if (!serverConnectionInfo.isAccessible()) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(serverConnectionInfo);
            logger.throwing(instance.getClass().getName(), "getInstance", (Throwable)e2);
            throw e2;
        }
        return instance;
    }

    private PatientImageAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getPatientImageAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(this.getClass().getName(), "cinit", (Throwable)e2);
            throw e2;
        }
    }

    protected IPatientImageAccessor getAccessor() {
        return this.accessor;
    }

    public void findBasePatientImage(final int uniqueKey, XSession session, final ICallback callback, final XScanImageContainer scanImageContainer) {
        if (this.isOkToCallFunction("PatientImageAccessorClient.findBasePatientImage" + uniqueKey, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.findBasePatientImage(scanImageContainer));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            PatientImageAccessorClient.this.functionCallEnded("PatientImageAccessorClient.findBasePatientImage" + uniqueKey, callback);
                        }
                    }
                    finally {
                        PatientImageAccessorClient.this.functionCallEnded("PatientImageAccessorClient.findBasePatientImage" + uniqueKey, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getNumber(final int uniqueKey, XSession session, final XScanImageNumberContainer container, final ICallback callback) {
        if (this.isOkToCallFunction("PatientImageAccessorClient.getNumberAsync" + uniqueKey, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.getNumber(container));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            PatientImageAccessorClient.this.functionCallEnded("PatientImageAccessorClient.findBasePatientImage" + uniqueKey, callback);
                        }
                    }
                    finally {
                        PatientImageAccessorClient.this.functionCallEnded("PatientImageAccessorClient.findBasePatientImage" + uniqueKey, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public XScanImageNumberContainer getNumber(int uniqueKey, XSession session, XScanImageNumberContainer container) throws Exception {
        XScanImageNumberContainer number = null;
        String function = "PatientImageAccessorClient.getNumber" + uniqueKey;
        if (this.isOkToCallFunction(function)) {
            try {
                try {
                    ReturnObject returnObject = PatientImageAccessorClient.instance.accessor.getNumber(container);
                    if (returnObject != null && returnObject.getObj() instanceof Integer) {
                        number = (XScanImageNumberContainer)returnObject.getObj();
                    }
                }
                catch (Exception e) {
                    Log.severe((String)"Erreur", (Exception)e);
                    throw e;
                }
            }
            finally {
                this.functionCallEnded(function);
            }
        }
        return number;
    }

    public void getPatientImageAndSetSeenStatusNoThread(int uniqueKey, XSession session, ICallback callback, int idPatientImage) {
        if (this.isOkToCallFunction("PatientImageAccessorClient.getPatientImageAndSetSeenStatus" + uniqueKey, callback)) {
            try {
                try {
                    callback.response(PatientImageAccessorClient.instance.accessor.getPatientImageAndSetSeenStatus(idPatientImage, true));
                }
                catch (Exception e) {
                    callback.exception(e);
                    Log.severe((String)"Erreur", (Exception)e);
                    this.functionCallEnded("PatientImageAccessorClient.getPatientImageAndSetSeenStatus" + uniqueKey, callback);
                }
            }
            finally {
                this.functionCallEnded("PatientImageAccessorClient.getPatientImageAndSetSeenStatus" + uniqueKey, callback);
            }
        }
    }

    public void getPatientImageAndSetSeenStatus(final int uniqueKey, XSession session, final ICallback callback, final int idPatientImage) {
        if (this.isOkToCallFunction("PatientImageAccessorClient.getPatientImageAndSetSeenStatus" + uniqueKey, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.getPatientImageAndSetSeenStatus(idPatientImage, true));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            PatientImageAccessorClient.this.functionCallEnded("PatientImageAccessorClient.getPatientImageAndSetSeenStatus" + uniqueKey, callback);
                        }
                    }
                    finally {
                        PatientImageAccessorClient.this.functionCallEnded("PatientImageAccessorClient.getPatientImageAndSetSeenStatus" + uniqueKey, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void setPatientImageProfessionnalEnumSetStatus(XSession session, final ICallback callback, final int[] ids, final Integer enumSetStatus, final Integer idPatient) {
        final String function = "PatientImageAccessorClient.setPatientImageProfessionnalEnumSetStatus:" + new JoinList("'", ids).toString() + ":" + enumSetStatus;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.setPatientImageProfessionnalEnumSetStatus(ids, enumSetStatus, idPatient));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            PatientImageAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        PatientImageAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findLastUsedBasePatientImage(int uniqueKey, XSession session, final ICallback callback, final XScanImageContainer scanImageContainer) {
        final String function = "PatientImageAccessorClient.findLastUsedBasePatientImage" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.findLastUsedBasePatientImage(scanImageContainer));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            PatientImageAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        PatientImageAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }
}

