/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.ILoginAccessor;
import ca.infodata.ofys.data.dataaccess.callback.DefaultCallback;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.status.service.DefaultService;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.Util;
import ca.infodata.util1.date.LocaleProvider;
import java.io.Serializable;
import java.util.logging.Level;

public class LoginAccessorClient
extends BaseAccessorClient {
    private static LoginAccessorClient instance;
    private final ILoginAccessor accessor;
    public static final String logInFunction = "LoginAccessorClient.logIn";

    public static LoginAccessorClient getInstance() throws CannotConnectToServerException {
        return LoginAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static LoginAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new LoginAccessorClient(serverConnectionInfo);
        }
        return instance;
    }

    private LoginAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getLoginAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(this.getClass().getName(), "cinit", e2);
            throw e2;
        }
    }

    protected ILoginAccessor getAccessor() {
        return this.accessor;
    }

    public void logIn(final ICallback callback, final String user, final String password, final Integer twoFactorCode, final String clientCode, final String uid, final boolean autolog) {
        final String function = "LoginAccessorClient.logIn." + user + clientCode;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    ReturnObject returnObject = null;
                    Exception ex = null;
                    Integer desktopOS = UI.OS_MAC ? 7 : 6;
                    try {
                        returnObject = LoginAccessorClient.this.accessor.logIn(user, password, twoFactorCode, uid, Boolean.valueOf(autolog), Util.getMacAddress(), System.getProperty("user.name"), Util.getIp(), LocaleProvider.getLocale().toString(), clientCode, desktopOS);
                    }
                    catch (Exception e) {
                        ex = e;
                    }
                    try {
                        try {
                            callback.response(returnObject);
                            if (ex != null) {
                                callback.exception(ex);
                            }
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Error in callback response", e);
                            LoginAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        LoginAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void logOut(XSession session, ICallback callback) {
        this.logOut(session, callback, null);
    }

    public void logOut(XSession session, final ICallback callback, final Integer idAnotherSession) {
        if (session == null) {
            throw new IllegalArgumentException("session cant be null");
        }
        final String function = "LoginAccessorClient.logOut_" + session.getId();
        new BaseAccessorClient.DoThread(this){

            @Override
            public ICallback run() {
                try {
                    try {
                        LoginAccessorClient.this.accessor.logOut(idAnotherSession);
                        if (callback != null) {
                            callback.response(null);
                        }
                    }
                    catch (Exception e) {
                        callback.exception(e);
                        logger.log(Level.SEVERE, "Erreur", e);
                        LoginAccessorClient.this.functionCallEnded(function, null);
                    }
                }
                finally {
                    LoginAccessorClient.this.functionCallEnded(function, null);
                }
                return null;
            }
        };
    }

    public void setSessionSite(final XSite site, XSession session, final ICallback callback) {
        if (session == null) {
            throw new IllegalArgumentException("session cant be null");
        }
        if (site == null) {
            throw new NullPointerException("site");
        }
        final String function = "LoginAccessorClient.setSessionSite" + session.getId();
        new BaseAccessorClient.DoThread(this){

            @Override
            public ICallback run() {
                try {
                    try {
                        LoginAccessorClient.this.accessor.setUserSessionSite(site.getId().intValue());
                        callback.response(new ReturnObject((Serializable)Status.OK_STATUS));
                    }
                    catch (Exception e) {
                        callback.exception(e);
                        logger.log(Level.SEVERE, "Erreur", e);
                        LoginAccessorClient.this.functionCallEnded(function, null);
                    }
                }
                finally {
                    LoginAccessorClient.this.functionCallEnded(function, null);
                }
                return null;
            }
        };
    }

    public void findActiveSessions(XSession session, final ICallback callback) {
        if (session == null) {
            throw new IllegalArgumentException("session cant be null");
        }
        final String function = "LoginAccessorClient.findActiveSessions" + session.getId();
        new BaseAccessorClient.DoThread(this){

            @Override
            public ICallback run() {
                try {
                    try {
                        ReturnObject ret = LoginAccessorClient.this.accessor.findActiveSessions();
                        callback.response(ret);
                    }
                    catch (Exception e) {
                        callback.exception(e);
                        logger.log(Level.SEVERE, "Erreur", e);
                        LoginAccessorClient.this.functionCallEnded(function, null);
                    }
                }
                finally {
                    LoginAccessorClient.this.functionCallEnded(function, null);
                }
                return null;
            }
        };
    }

    public void validateAiResponsabilities(XSession session, final ICallback callback) {
        if (session == null) {
            throw new IllegalArgumentException("session cant be null");
        }
        final String function = "LoginAccessorClient.validateAiResponsabilities" + session.getId();
        new BaseAccessorClient.DoThread(this){

            @Override
            public ICallback run() {
                try {
                    try {
                        ReturnObject ret = LoginAccessorClient.this.accessor.validateAiResponsabilities();
                        callback.response(ret);
                    }
                    catch (Exception e) {
                        callback.exception(e);
                        logger.log(Level.SEVERE, "Erreur", e);
                        LoginAccessorClient.this.functionCallEnded(function, null);
                    }
                }
                finally {
                    LoginAccessorClient.this.functionCallEnded(function, null);
                }
                return null;
            }
        };
    }

    public void newMetabaseToken(XSession session, final ICallback callback) {
        if (session == null) {
            throw new IllegalArgumentException("session cant be null");
        }
        final String function = "LoginAccessorClient.newMetabaseToken" + session.getId();
        new BaseAccessorClient.DoThread(this){

            @Override
            public ICallback run() {
                try {
                    try {
                        ReturnObject ret = LoginAccessorClient.this.accessor.newMetabaseToken(null);
                        callback.response(ret);
                    }
                    catch (Exception e) {
                        callback.exception(e);
                        logger.log(Level.SEVERE, "Erreur", e);
                        LoginAccessorClient.this.functionCallEnded(function, null);
                    }
                }
                finally {
                    LoginAccessorClient.this.functionCallEnded(function, null);
                }
                return null;
            }
        };
    }

    public void metabaseQuestion(XSession session, final ICallback callback) {
        if (session == null) {
            throw new IllegalArgumentException("session cant be null");
        }
        final String function = "LoginAccessorClient.metabaseQuestion" + session.getId();
        new BaseAccessorClient.DoThread(this){

            @Override
            public ICallback run() {
                try {
                    try {
                        ReturnObject ret = LoginAccessorClient.this.accessor.metabaseQuestion();
                        callback.response(ret);
                    }
                    catch (Exception e) {
                        callback.exception(e);
                        logger.log(Level.SEVERE, "Erreur", e);
                        LoginAccessorClient.this.functionCallEnded(function, null);
                    }
                }
                finally {
                    LoginAccessorClient.this.functionCallEnded(function, null);
                }
                return null;
            }
        };
    }

    public void newRxVigilanceToken(XSession session, final ICallback callback) {
        if (session == null) {
            throw new IllegalArgumentException("session cant be null");
        }
        final String function = "LoginAccessorClient.newRxVigilanceToken" + session.getId();
        new BaseAccessorClient.DoThread(this){

            @Override
            public ICallback run() {
                try {
                    try {
                        ReturnObject ret = LoginAccessorClient.this.accessor.newRxVigilanceToken();
                        callback.response(ret);
                    }
                    catch (Exception e) {
                        callback.exception(e);
                        logger.log(Level.SEVERE, "Erreur", e);
                        LoginAccessorClient.this.functionCallEnded(function, null);
                    }
                }
                finally {
                    LoginAccessorClient.this.functionCallEnded(function, null);
                }
                return null;
            }
        };
    }

    public void lockSession(XSession session) {
        if (session == null) {
            throw new IllegalArgumentException("session cant be null");
        }
        final String function = "LoginAccessorClient.lockSession" + session.getId();
        final DefaultCallback callback = new DefaultCallback();
        new BaseAccessorClient.DoThread(this){

            @Override
            public ICallback run() {
                try {
                    try {
                        LoginAccessorClient.this.accessor.lockSession();
                        callback.response(null);
                    }
                    catch (Exception e) {
                        callback.exception(e);
                        logger.log(Level.WARNING, "Erreur", e);
                        LoginAccessorClient.this.functionCallEnded(function, callback);
                    }
                }
                finally {
                    LoginAccessorClient.this.functionCallEnded(function, callback);
                }
                return null;
            }
        };
    }

    public IStatus unlockSession(XSession session) {
        if (session == null) {
            throw new IllegalArgumentException("session cant be null");
        }
        String function = "LoginAccessorClient.unlockSession" + session.getId();
        this.isOkToCallFunction(function);
        try {
            ReturnObject returnObject = this.accessor.unlockSession();
            MultiStatus multiStatus = returnObject.getStatus();
            return multiStatus;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Erreur", e);
            IStatus iStatus = DefaultService.newUNEXCEPTED_ERROR();
            return iStatus;
        }
        finally {
            this.functionCallEnded(function);
        }
    }
}

