/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.IFacilityAccessor;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.ui.library.log.Log;

public class FacilityAccessorClient
extends BaseAccessorClient {
    private static FacilityAccessorClient instance;
    private final IFacilityAccessor accessor;

    public static FacilityAccessorClient getInstance() throws CannotConnectToServerException {
        return FacilityAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static FacilityAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new FacilityAccessorClient(serverConnectionInfo);
        } else if (!serverConnectionInfo.isAccessible()) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(serverConnectionInfo);
            logger.throwing(instance.getClass().getName(), "getInstance", (Throwable)e2);
            throw e2;
        }
        return instance;
    }

    private FacilityAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getFacilityAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(this.getClass().getName(), "cinit", (Throwable)e2);
            throw e2;
        }
    }

    public void findSiteB2BLogHeaders(final ICallback callback, final int idSite, final Integer limit, XSession session) {
        if (this.isOkToCallFunction("FacilityAccessorClient.findSiteB2BLogHeaders", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.findSiteB2bLogHeaders(idSite, limit));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            FacilityAccessorClient.this.functionCallEnded("FacilityAccessorClient.findSiteB2BLogHeaders", callback);
                        }
                    }
                    finally {
                        FacilityAccessorClient.this.functionCallEnded("FacilityAccessorClient.findSiteB2BLogHeaders", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void readB2BSyncLog(final ICallback callback, final int idSiteB2bLog, XSession session) {
        if (this.isOkToCallFunction("FacilityAccessorClient.readB2BSyncLog", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.readB2bSyncLog(idSiteB2bLog));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            FacilityAccessorClient.this.functionCallEnded("FacilityAccessorClient.readB2BSyncLog", callback);
                        }
                    }
                    finally {
                        FacilityAccessorClient.this.functionCallEnded("FacilityAccessorClient.readB2BSyncLog", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findFixedPharmacies(final ICallback callback, final String searchString) {
        if (this.isOkToCallFunction("FacilityAccessorClient.findFixedPharmacies", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.findFixedPharmacies(searchString));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            FacilityAccessorClient.this.functionCallEnded("FacilityAccessorClient.findFixedPharmacies", callback);
                        }
                    }
                    finally {
                        FacilityAccessorClient.this.functionCallEnded("FacilityAccessorClient.findFixedPharmacies", callback);
                    }
                    return callback;
                }
            };
        }
    }

    protected IFacilityAccessor getAccessor() {
        return this.accessor;
    }
}

