/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.ICompletionComboAccessor;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesAdapter;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesListener;
import ca.infodata.ofys.data.dataaccess.util.notification.DataObjectNotificationHandler;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICompletionComboItem;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.util.LZMAClientSerialiser;
import ca.infodata.ofys.util.MiscUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.mb.listeners.GenListenerManager;
import org.mb.listeners.IListenerManager;

public class CompletionComboAccessorClient
extends BaseAccessorClient {
    private static CompletionComboAccessorClient instance;
    private static final ConcurrentMap<String, IListenerManager<CompletionComboListener>> typeMapListeners;
    private static final ConcurrentMap<String, List<? extends ICompletionComboItem>> typeMapCache;
    private static final ConcurrentMap<String, Boolean> typeMapHasCache;
    protected Cache<String, ReturnObject> cache;
    private final ICompletionComboAccessor accessor;
    private final DataObjectNotificationHandler handler;
    private final GlobalInstancesListener listener;

    static {
        typeMapListeners = new ConcurrentHashMap<String, IListenerManager<CompletionComboListener>>();
        typeMapCache = new ConcurrentHashMap<String, List<? extends ICompletionComboItem>>();
        typeMapHasCache = new ConcurrentHashMap<String, Boolean>();
    }

    public static synchronized void addListener(String type, CompletionComboListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        IListenerManager manager = (IListenerManager)typeMapListeners.get(type);
        if (manager == null) {
            manager = new GenListenerManager(CompletionComboListener.class);
            typeMapListeners.put(type, (IListenerManager<CompletionComboListener>)manager);
        }
        manager.addListener((Object)listener);
    }

    public static void removeListener(String type, CompletionComboListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        IListenerManager manager = (IListenerManager)typeMapListeners.get(type);
        if (manager != null) {
            manager.removeListener((Object)listener);
        }
    }

    public static CompletionComboAccessorClient getInstance() throws CannotConnectToServerException {
        return CompletionComboAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static synchronized CompletionComboAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new CompletionComboAccessorClient(serverConnectionInfo);
        } else if (!serverConnectionInfo.isAccessible()) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(serverConnectionInfo);
            logger.throwing(instance.getClass().getName(), "getInstance", e2);
            throw e2;
        }
        return instance;
    }

    private CompletionComboAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getCompletionComboAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(this.getClass().getName(), "cinit", e2);
            throw e2;
        }
        this.handler = new DataObjectNotificationHandler(){

            public void handle(DataObjectUpdatedNotification notification) {
                IDataObject object = notification.getObject();
                if (object instanceof ICompletionComboItem) {
                    ICompletionComboItem item = (ICompletionComboItem)object;
                    CompletionComboAccessorClient.this.fireShouldRefresh(item);
                }
            }
        };
        Application.get().getGlobalInstances().getNotificationSystem().addDataObjectNotificationHandler(this.handler);
        this.cache = Caffeine.newBuilder().maximumSize(30L).expireAfterWrite(20L, TimeUnit.SECONDS).build();
        this.listener = new GlobalInstancesAdapter(){
            private String codeClient;

            public void sessionChanged() {
                String newCodeClient = this.getNewCodeClient();
                if (!MiscUtil.areObjectsEquals((Object)this.codeClient, (Object)newCodeClient)) {
                    this.codeClient = newCodeClient;
                    CompletionComboAccessorClient.this.setShouldRefreshForAllTypes();
                }
            }

            public void logout() {
                instance.cache.invalidateAll();
                this.codeClient = null;
                CompletionComboAccessorClient.this.setShouldRefreshForAllTypes();
                super.logout();
            }

            private String getNewCodeClient() {
                try {
                    XSession session = Application.get().getGlobalInstances().getSession();
                    if (session != null) {
                        return session.getClient().getClientCode();
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to get codeClient from xsession bug", e);
                }
                return null;
            }
        };
        Application.get().getGlobalInstances().addGlobalInstancesListener(this.listener);
    }

    public void findAllAsync(XSession session, ICallback callback, String type) throws Exception {
        this.findAll(session, callback, type);
    }

    public void findAll(XSession session, ICallback callback, String type) throws Exception {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        if (session == null) {
            throw new NullPointerException("session");
        }
        String function = "CompletionComboAccessorClient.findAll" + type;
        this.isOkToCallFunction(function, callback);
        try {
            if (this.shouldRefresh(type)) {
                logger.fine("refreshing combo proposals from server for type " + type);
                String key = String.valueOf(type) + session.client.getClientCode();
                ReturnObject response = (ReturnObject)this.cache.getIfPresent((Object)key);
                if (response == null && (response = this.findAllCompletionComboType(session, type)) != null) {
                    if (response.getObj() instanceof List) {
                        this.clearCache(type);
                        this.fillCache(type, (List)response.getObj());
                        this.cache.put((Object)key, (Object)response);
                    } else if (response.getObj() instanceof byte[]) {
                        this.clearCache(type);
                        List list = (List)LZMAClientSerialiser.deserialize((byte[])((byte[])response.getObj()));
                        this.fillCache(type, list);
                        this.cache.put((Object)key, (Object)response);
                    }
                }
                this.setShouldRefresh(type, response == null || !response.getStatus().isOkToProceed());
            } else {
                logger.fine("using combo proposals cache for type " + type);
            }
        }
        catch (Exception e) {
            callback.exception(e);
            Log.severe((String)"Erreur", (Exception)e);
        }
        callback.response(new ReturnObject(this.getCache(type)));
        this.functionCallEnded(function, callback);
    }

    public ReturnObject findAllCompletionComboType(XSession session, String type) throws Exception {
        ReturnObject returnObject = this.accessor.findAllCompletionComboType(type);
        return returnObject;
    }

    private ArrayList<?> getCache(String type) {
        List list = (List)typeMapCache.get(type);
        return list == null ? null : new ArrayList(list);
    }

    private void fillCache(String type, List list) {
        typeMapCache.put(type, list);
    }

    private void clearCache(String type) {
        try {
            String key = String.valueOf(type) + Application.get().getGlobalInstances().getSession().getClient().getClientCode();
            this.cache.invalidate((Object)key);
            typeMapCache.remove(type);
            this.setShouldRefresh(type, true);
        }
        catch (Exception exception) {}
    }

    private void fireShouldRefresh(ICompletionComboItem item) {
        logger.info("CompletionComboAccessorClient.fireShouldRefresh() " + item);
        if (item != null && item.getType() != null) {
            this.clearCache(item.getType());
            IListenerManager manager = (IListenerManager)typeMapListeners.get(item.getType());
            if (manager != null) {
                ((CompletionComboListener)manager.getProxy()).shouldRefresh(item);
            }
        }
    }

    private boolean shouldRefresh(String type) {
        Boolean b = (Boolean)typeMapHasCache.get(type);
        return b == null || b == false;
    }

    private void setShouldRefresh(String type, boolean b) {
        typeMapHasCache.put(type, !b);
    }

    public void setShouldRefreshForAllTypes() {
        typeMapHasCache.clear();
    }

    public void cleanType(final int uniqueKey, XSession session, final ICallback callback, final String type) {
        if (this.isOkToCallFunction("CompletionComboAccessorClient.cleanType" + uniqueKey, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            CompletionComboAccessorClient.this.setShouldRefresh(type, true);
                            callback.response(CompletionComboAccessorClient.this.accessor.cleanType(type));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            CompletionComboAccessorClient.this.functionCallEnded("CompletionComboAccessorClient.cleanType" + uniqueKey, callback);
                        }
                    }
                    finally {
                        CompletionComboAccessorClient.this.functionCallEnded("CompletionComboAccessorClient.cleanType" + uniqueKey, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void desactiveComboItem(final int uniqueKey, XSession session, final ICallback callback, final String type, final ArrayList<ICompletionComboItem> items) {
        if (this.isOkToCallFunction("CompletionComboAccessorClient.desactiveComboItem" + uniqueKey, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            CompletionComboAccessorClient.this.setShouldRefresh(type, true);
                            callback.response(CompletionComboAccessorClient.this.accessor.desactiveComboItem(type, items));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            CompletionComboAccessorClient.this.functionCallEnded("CompletionComboAccessorClient.desactiveComboItem" + uniqueKey, callback);
                        }
                    }
                    finally {
                        CompletionComboAccessorClient.this.functionCallEnded("CompletionComboAccessorClient.desactiveComboItem" + uniqueKey, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void replaceComboItem(final int uniqueKey, XSession session, final ICallback callback, final String type, final ArrayList<ICompletionComboItem> items, final ICompletionComboItem item) {
        if (this.isOkToCallFunction("CompletionComboAccessorClient.replaceComboItem" + uniqueKey, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            CompletionComboAccessorClient.this.setShouldRefresh(type, true);
                            callback.response(CompletionComboAccessorClient.this.accessor.replaceComboItem(type, items, item));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            CompletionComboAccessorClient.this.functionCallEnded("CompletionComboAccessorClient.replaceComboItem" + uniqueKey, callback);
                        }
                    }
                    finally {
                        CompletionComboAccessorClient.this.functionCallEnded("CompletionComboAccessorClient.replaceComboItem" + uniqueKey, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getCompletionComboTypes(XSession session, final ICallback callback) {
        final String function = "CompletionComboAccessorClient.getCompletionComboTypes" + CompletionComboAccessorClient.getNextUniqueKey();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(CompletionComboAccessorClient.this.accessor.getCompletionComboTypes());
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            CompletionComboAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        CompletionComboAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    protected ICompletionComboAccessor getAccessor() {
        return this.accessor;
    }

    public static interface CompletionComboListener {
        public void shouldRefresh(ICompletionComboItem var1);
    }
}

