/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.ConnectionInfo;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.IDeleteAccessor;
import ca.infodata.ofys.data.dataaccess.ISaveAccessor;
import ca.infodata.ofys.data.dataaccess.callback.DefaultCallback;
import ca.infodata.ofys.data.dataaccess.callback.DeleteCallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.SaveCallback;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.util1.EventLock;
import ca.infodata.util1.Pair;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public abstract class BaseAccessorClient {
    protected static final Logger logger = Logger.getLogger("dataaccess.accessor.client");
    protected IConnectionInfo connectionInfo;
    private static final ExecutorService executorService;
    private static final ArrayDeque<Pair<Long, String>> last20Calls;
    protected static ConcurrentHashMap<String, Long> lastConnexionTime;
    private static ConcurrentHashMap<String, FunctionTimeout> runningCalls;
    private static final List<FutureTask<ICallback>> futures;
    private static final Timer futuresCleanTimer;
    private static final TimerTask futuresCleanTask;
    public static IStatusHandler defaultStatusHandler;
    private static long uniqueKeyCount;

    static {
        last20Calls = new ArrayDeque(100);
        lastConnexionTime = new ConcurrentHashMap(3);
        runningCalls = new ConcurrentHashMap();
        executorService = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "executorService Thread");
                thread.setDaemon(true);
                return thread;
            }
        });
        futures = new ArrayList<FutureTask<ICallback>>();
        futuresCleanTimer = new Timer("futuresCleanTimer", true);
        futuresCleanTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = futures;
                synchronized (list) {
                    Iterator iterator = futures.iterator();
                    while (iterator.hasNext()) {
                        FutureTask task = (FutureTask)iterator.next();
                        if (!task.isDone()) continue;
                        BaseAccessorClient.logTaskDone(task);
                        iterator.remove();
                    }
                }
            }
        };
        futuresCleanTimer.schedule(futuresCleanTask, 0L, 2000L);
    }

    protected BaseAccessorClient(IConnectionInfo connectionInfo) {
        if (connectionInfo == null) {
            throw new IllegalArgumentException("serverConnectionInfo cant be null");
        }
        this.connectionInfo = connectionInfo;
    }

    protected IConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    protected abstract Object getAccessor();

    private static void logTaskDone(FutureTask<ICallback> task) {
        Log.log((Logger)logger, (String)"BaseAccessorClient.logTaskDone", (String[])new String[]{"task"}, (Object[])new Object[]{task});
        try {
            ICallback callback = task.get();
            if (callback != null) {
                logger.fine("FutureTask DONE : " + String.valueOf(callback.getFunctionName()));
            } else {
                logger.fine("FutureTask DONE : ICallback null");
            }
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "task is supposed to be done. " + task, e);
        }
        catch (ExecutionException e) {
            logger.log(Level.SEVERE, "task is supposed to be done. " + task, e);
        }
        catch (CancellationException e) {
            logger.log(Level.WARNING, "task was cancelled. " + task, e);
        }
        catch (NullPointerException e) {
            logger.log(Level.SEVERE, "NPE in logTaskDone " + String.valueOf(task), e);
        }
    }

    public static synchronized String getNextUniqueKey() {
        return "GeneratedUniqueKey" + uniqueKeyCount++;
    }

    public static synchronized int getNextUniqueKey2() {
        return BaseAccessorClient.getNextUniqueKey().hashCode();
    }

    protected boolean isOkToCallFunction(String function) {
        return this.isOkToCallFunction(function, null);
    }

    public static void validThatServerIsAccessible(IConnectionInfo connectionInfo) {
        BaseAccessorClient.validThatServerIsAccessible(connectionInfo.getServerAddress());
    }

    public static void validThatServerIsAccessible(final String serverAddress) {
        if (!lastConnexionTime.containsKey(serverAddress) || System.currentTimeMillis() - lastConnexionTime.get(serverAddress) > TimeUnit.MINUTES.toMillis(1L)) {
            final ConnectionInfo connectionInfo = new ConnectionInfo(serverAddress, (int)TimeUnit.SECONDS.toMillis(2L));
            if (!connectionInfo.isAccessible2()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        final EventLock lock = new EventLock();
                        ProgressMonitorDialog dialog = new ProgressMonitorDialog(UI.getWorkbenchShell());
                        dialog.setOpenOnRun(true);
                        dialog.setCancelable(true);
                        try {
                            dialog.run(true, true, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    monitor.beginTask("Tentative de connexion au serveur infodata", -1);
                                    int count = 0;
                                    boolean isAccessible = false;
                                    do {
                                        isAccessible = connectionInfo.isAccessible2();
                                        Thread.sleep(TimeUnit.SECONDS.toMillis(2L));
                                    } while (!monitor.isCanceled() && !isAccessible && (count += 2) < 30);
                                    lock.eventOccured();
                                    if (isAccessible) {
                                        lastConnexionTime.put(serverAddress, new Long(System.currentTimeMillis()));
                                    }
                                }
                            });
                            lock.waitUntilEvent((long)connectionInfo.getTimeoutInMillis());
                        }
                        catch (InvocationTargetException invocationTargetException) {
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                });
            } else {
                lastConnexionTime.put(serverAddress, new Long(System.currentTimeMillis()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isOkToCallFunction(String function, ICallback callback) {
        boolean isRunning;
        if (function == null) {
            throw new IllegalArgumentException("function is null");
        }
        BaseAccessorClient.validThatServerIsAccessible(this.connectionInfo);
        if (callback == null) {
            callback = new DefaultCallback();
        }
        ArrayDeque<Pair<Long, String>> arrayDeque = last20Calls;
        synchronized (arrayDeque) {
            if (last20Calls.size() >= 100) {
                last20Calls.pollLast();
            }
            last20Calls.offerFirst((Pair<Long, String>)Pair.newPair((Object)System.currentTimeMillis(), (Object)function));
        }
        ConcurrentHashMap<String, FunctionTimeout> concurrentHashMap = runningCalls;
        synchronized (concurrentHashMap) {
            isRunning = false;
        }
        if (callback != null) {
            callback.setFunctionName(function);
        }
        if (isRunning && callback != null) {
            callback.kill();
        }
        if (isRunning) {
            logger.log(Level.INFO, String.valueOf(function) + " is running");
        } else {
            logger.fine("OK to call function : " + function);
        }
        return !isRunning;
    }

    public void functionCallEnded(String function) {
        this.functionCallEnded(function, null);
    }

    public void functionCallEnded(String function, ICallback callback) {
        if (callback != null) {
            if (callback.getException() == null) {
                lastConnexionTime.put(this.connectionInfo.getServerAddress(), new Long(System.currentTimeMillis()));
            }
            callback.kill();
        }
        BaseAccessorClient.serverResponseReceived(function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serverResponseReceived(String function) {
        ConcurrentHashMap<String, FunctionTimeout> concurrentHashMap = runningCalls;
        synchronized (concurrentHashMap) {
            FunctionTimeout timeout = runningCalls.get(function);
            if (timeout != null) {
                timeout.kill();
                runningCalls.remove(function);
            }
        }
    }

    public ReturnObject saveSync(int uniqueKey, XSession session, SaveCallback saveCallback, Serializable dataObject, boolean askQuestion) {
        saveCallback.setAccessorClient(this);
        saveCallback.setDataObject(dataObject);
        ReturnObject response = this.saveSync(uniqueKey, session, dataObject, askQuestion);
        saveCallback.response(response);
        saveCallback.kill();
        return response;
    }

    public ReturnObject saveSync(int uniqueKey, XSession session, Serializable dataObject, boolean askQuestion) {
        ReturnObject returnObject;
        block18: {
            returnObject = null;
            String function = "AccessorClient.saveSync" + uniqueKey;
            boolean okToCallFunction = this.isOkToCallFunction(function);
            if (session != null && okToCallFunction) {
                try {
                    try {
                        if (dataObject instanceof IMinimalEditableDataObject) {
                            IStatus validStatus = ((IMinimalEditableDataObject)dataObject).valid();
                            IStatus validQuestionStatus = ((IMinimalEditableDataObject)dataObject).validQuestion();
                            if (!validStatus.isOK() || !validQuestionStatus.isOK()) {
                                returnObject = new ReturnObject();
                                returnObject.setObj((Object)dataObject);
                                if (!validStatus.isOK()) {
                                    returnObject.getStatus().add(validStatus);
                                } else if (!validQuestionStatus.isOK()) {
                                    returnObject.getStatus().add(validQuestionStatus);
                                }
                            } else {
                                ISaveAccessor saveAccessor = (ISaveAccessor)this.getAccessor();
                                returnObject = saveAccessor.save((IDataObject)dataObject, askQuestion);
                            }
                        } else {
                            returnObject = (ReturnObject)this.getAccessor().getClass().getMethod("save", Serializable.class, Boolean.TYPE).invoke(this.getAccessor(), dataObject, askQuestion);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, String.format("Error in save call. {session=%s, dataObject=%s }", session, dataObject), e);
                        returnObject = new ReturnObject();
                        returnObject.getStatus().add((IStatus)new Status(IStatus.Severity.BUG, (Throwable)e));
                        this.functionCallEnded(function);
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    this.functionCallEnded(function);
                    throw throwable;
                }
                this.functionCallEnded(function);
            } else if (session == null) {
                returnObject = new ReturnObject();
                returnObject.getStatus().add((IStatus)new Status(IStatus.Severity.BUG, "Aucune session active"));
            } else if (!okToCallFunction) {
                returnObject = new ReturnObject();
                returnObject.getStatus().add((IStatus)new Status(IStatus.Severity.BUG, "Op\u00e9ration en cours... "));
            }
        }
        if (returnObject != null && returnObject.getStatus() != null && returnObject.getStatus().isOkToProceed() && returnObject.getObj() instanceof IDataObject) {
            Application.get().getGlobalInstances().getNotificationSystem().sendDataObjectUpdatedNotification((IDataObject)returnObject.getObj(), session);
        }
        return returnObject;
    }

    public void save(final int uniqueKey, final XSession session, final SaveCallback callback, final Serializable dataObject, final boolean askQuestion) {
        if (session != null && this.isOkToCallFunction("AccessorClient.save" + uniqueKey, callback)) {
            IStatus validQuestionStatus;
            IStatus validStatus;
            if (dataObject instanceof IMinimalEditableDataObject) {
                validStatus = ((IMinimalEditableDataObject)dataObject).valid();
                validQuestionStatus = ((IMinimalEditableDataObject)dataObject).validQuestion();
            } else {
                validStatus = Status.OK_STATUS;
                validQuestionStatus = Status.OK_STATUS;
            }
            new DoThread(this){

                @Override
                public ICallback run() {
                    block10: {
                        try {
                            try {
                                callback.setAccessorClient(this);
                                callback.setDataObject(dataObject);
                                if (!validStatus.isOK() || !validQuestionStatus.isOK()) {
                                    ReturnObject returnObject = new ReturnObject();
                                    returnObject.setObj((Object)dataObject);
                                    if (!validStatus.isOK()) {
                                        returnObject.getStatus().add(validStatus);
                                    } else if (!validQuestionStatus.isOK()) {
                                        returnObject.getStatus().add(validQuestionStatus);
                                    }
                                    callback.response(returnObject);
                                    break block10;
                                }
                                if (dataObject instanceof IDataObject) {
                                    ISaveAccessor saveAccessor = (ISaveAccessor)this.getAccessor();
                                    callback.response(saveAccessor.save((IDataObject)dataObject, askQuestion));
                                    break block10;
                                }
                                callback.response((ReturnObject)this.getAccessor().getClass().getMethod("save", Serializable.class, Boolean.TYPE).invoke(this.getAccessor(), dataObject, new Boolean(askQuestion)));
                            }
                            catch (Exception e) {
                                callback.exception(e);
                                logger.log(Level.SEVERE, String.format("Error in save call. {session=%s, callback=%s, dataObject=%s, askQuestion=%s}", session, callback, dataObject, askQuestion), e);
                                this.functionCallEnded("AccessorClient.save" + uniqueKey, callback);
                            }
                        }
                        finally {
                            this.functionCallEnded("AccessorClient.save" + uniqueKey, callback);
                        }
                    }
                    return callback;
                }
            };
        }
    }

    public void save(final int uniqueKey, final XSession session, final SaveCallback callback, final IDataObject dataObject, final boolean askQuestion) {
        if (session != null && this.isOkToCallFunction("AccessorClient.save" + uniqueKey, callback)) {
            new DoThread(this){

                @Override
                public ICallback run() {
                    block6: {
                        try {
                            try {
                                callback.setAccessorClient(this);
                                callback.setDataObject((Serializable)dataObject);
                                if (dataObject instanceof IDataObject) {
                                    ISaveAccessor saveAccessor = (ISaveAccessor)this.getAccessor();
                                    callback.response(saveAccessor.save(dataObject, askQuestion));
                                    break block6;
                                }
                                callback.response((ReturnObject)this.getAccessor().getClass().getMethod("save", Serializable.class, Boolean.TYPE).invoke(this.getAccessor(), dataObject, new Boolean(askQuestion)));
                            }
                            catch (Exception e) {
                                callback.exception(e);
                                logger.log(Level.SEVERE, String.format("Error in save call. {session=%s, callback=%s, dataObject=%s, askQuestion=%s}", session, callback, dataObject, askQuestion), e);
                                this.functionCallEnded("AccessorClient.save" + uniqueKey, callback);
                            }
                        }
                        finally {
                            this.functionCallEnded("AccessorClient.save" + uniqueKey, callback);
                        }
                    }
                    return callback;
                }
            };
        }
    }

    public final void delete(final int uniqueKey, final XSession session, final DeleteCallback callback, final IDataObject dataObject, final boolean askQuestion) {
        if (session != null && this.isOkToCallFunction("AccessorClient.delete" + uniqueKey, callback)) {
            new DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.setAccessorClient(this);
                            callback.setDataObject(dataObject);
                            IDeleteAccessor deleteAccessor = (IDeleteAccessor)this.getAccessor();
                            callback.response(deleteAccessor.delete(dataObject, askQuestion));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, String.format("Error in delete call. {session=%s, callback=%s, dataObject=%s, askQuestion=%s}", session, callback, dataObject, askQuestion), e);
                            this.functionCallEnded("AccessorClient.saveQuick" + uniqueKey, callback);
                        }
                    }
                    finally {
                        this.functionCallEnded("AccessorClient.saveQuick" + uniqueKey, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void deleteSync(IDataObject dataObject, XSession session, DeleteCallback callback, boolean askQuestion) {
        try {
            try {
                callback.setAccessorClient(this);
                callback.setDataObject(dataObject);
                IDeleteAccessor deleteAccessor = (IDeleteAccessor)this.getAccessor();
                ReturnObject r = deleteAccessor.delete(dataObject, askQuestion);
                callback.response(r);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, String.format("Error in delete call. {session=%s, callback=%s, dataObject=%s, askQuestion=%s}", session, callback, dataObject, askQuestion), e);
                callback.exception(e);
                this.functionCallEnded("AccessorClient.deleteSync0", callback);
            }
        }
        finally {
            this.functionCallEnded("AccessorClient.deleteSync0", callback);
        }
    }

    public MultiStatus validForSaveSync(IMinimalEditableDataObject dataObject, XSession session) {
        if (session == null) {
            logger.log(Level.WARNING, "XSession is null on validForSaveSync for " + dataObject + ". " + Log.getPrintedStackTrace());
        }
        String function = "EncounterAccessorClient.validForSaveSync" + (dataObject == null ? 0 : dataObject.hashCode());
        MultiStatus status = new MultiStatus();
        if (dataObject != null && session != null) {
            status.add(dataObject.valid());
            if (status.isOkToProceed()) {
                try {
                    ReturnObject returnObject = (ReturnObject)this.getAccessor().getClass().getMethod("validForSave", IDataObject.class).invoke(this.getAccessor(), dataObject);
                    if (returnObject != null && returnObject.getStatus() != null) {
                        status.add((IStatus)returnObject.getStatus());
                    } else {
                        logger.log(Level.SEVERE, String.format("Error in validation call. {session=%s, dataObject=%s }", session, dataObject));
                        status.add((IStatus)new Status(IStatus.Severity.BUG, Messages.getString((String)"UNE_ERREUR_EST_SURVENUE_PENDANT_LAPPEL_DE_CETTE_FONCTION", (String[])new String[0])));
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, String.format("Error in validation call. {session=%s, dataObject=%s }", session, dataObject), e);
                    status.add((IStatus)new Status(IStatus.Severity.BUG, Messages.getString((String)"UNE_ERREUR_EST_SURVENUE_PENDANT_LAPPEL_DE_CETTE_FONCTION", (String[])new String[0])));
                }
            }
            this.functionCallEnded(function);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Long, String>> getLastCalls() {
        ArrayDeque<Pair<Long, String>> arrayDeque = last20Calls;
        synchronized (arrayDeque) {
            return new ArrayList<Pair<Long, String>>(last20Calls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt(int callid) {
        List<FutureTask<ICallback>> list = futures;
        synchronized (list) {
            for (FutureTask<ICallback> futur : futures) {
                if (futur.hashCode() != callid) continue;
                futur.cancel(true);
            }
        }
    }

    protected void latency() throws InterruptedException {
    }

    protected static String replaceTildeInverse(String s) {
        return s.replace("~!~", "~").replace("~!n~", "\n");
    }

    public static int[] transfertIntToIntegerArray(Integer intValue) {
        if (intValue == null) {
            return null;
        }
        int[] ret = new int[]{(intValue & 0xFF0000) / 65536, (intValue & 0xFF00) / 256 % 256, intValue % 256};
        return ret;
    }

    protected abstract class DoThread {
        private final Callable<ICallback> call = new Callable<ICallback>(){

            @Override
            public ICallback call() throws Exception {
                BaseAccessorClient.this.latency();
                return DoThread.this.run();
            }
        };
        public final int id;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DoThread() {
            FutureTask<ICallback> futur = new FutureTask<ICallback>(this.call);
            this.id = futur.hashCode();
            List list = futures;
            synchronized (list) {
                futures.add(futur);
            }
            executorService.execute(futur);
        }

        public abstract ICallback run() throws Exception;
    }

    private class FunctionTimeout {
        private boolean killed = false;
        private Timer timer = new Timer("functionTimeout", true);

        public FunctionTimeout(final String function, final ICallback callback) {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (runningCalls.containsKey(function) && !FunctionTimeout.this.killed) {
                        logger.log(Level.SEVERE, String.valueOf(Messages.getString((String)"COMMUNICATION_AU_SERVEUR_DIFFICILE", (String[])new String[0])) + " function timeout (" + callback.getFunctionName() + ")");
                        BaseAccessorClient.this.functionCallEnded(function, callback);
                    }
                    if (FunctionTimeout.this.timer != null) {
                        FunctionTimeout.this.timer.cancel();
                    }
                }
            }, TimeUnit.SECONDS.toMillis(30L));
        }

        public void kill() {
            this.killed = true;
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
    }
}

