/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.tools;

import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;

public class DocumentBuilderFactoryCache {
    private static final ConcurrentHashMap<DocumentBuilderFactoryArg, DocumentBuilderFactory> cache = new ConcurrentHashMap();

    public static DocumentBuilderFactory getInstance() {
        return DocumentBuilderFactoryCache.getInstance(new DocumentBuilderFactoryArg());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentBuilderFactory getInstance(DocumentBuilderFactoryArg arg) {
        if (arg == null) {
            throw new NullPointerException("documentBuilderFactoryArg cant be null");
        }
        DocumentBuilderFactory factory = cache.get(arg);
        if (factory == null) {
            ConcurrentHashMap<DocumentBuilderFactoryArg, DocumentBuilderFactory> concurrentHashMap = cache;
            synchronized (concurrentHashMap) {
                factory = cache.get(arg);
                if (factory == null) {
                    factory = DocumentBuilderFactory.newInstance();
                    if (arg.isNamespaceAware() != null) {
                        factory.setNamespaceAware(arg.isNamespaceAware());
                    }
                    if (arg.isValidating() != null) {
                        factory.setValidating(arg.isValidating());
                    }
                    if (arg.getSchema() != null) {
                        factory.setSchema(arg.getSchema());
                    }
                    cache.put(arg, factory);
                }
            }
        }
        return factory;
    }

    public static class DocumentBuilderFactoryArg {
        private Boolean namespaceAware;
        private Boolean validating;
        private String schemaName;
        private Schema schema;

        public Boolean isNamespaceAware() {
            return this.namespaceAware;
        }

        public DocumentBuilderFactoryArg setNamespaceAware(boolean namespaceAware) {
            this.namespaceAware = namespaceAware;
            return this;
        }

        public Boolean isValidating() {
            return this.validating;
        }

        public DocumentBuilderFactoryArg setValidating(boolean validating) {
            this.validating = validating;
            return this;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public DocumentBuilderFactoryArg setSchema(String name, Schema schema) {
            this.schemaName = name;
            this.schema = schema;
            return this;
        }

        public String toString() {
            return "DocumentBuilderFactoryArg [namespaceAware=" + this.namespaceAware + ", validating=" + this.validating + ", schemaName=" + this.schemaName + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.namespaceAware == null ? 0 : this.namespaceAware.hashCode());
            result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
            result = 31 * result + (this.validating == null ? 0 : this.validating.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DocumentBuilderFactoryArg other = (DocumentBuilderFactoryArg)obj;
            if (this.namespaceAware == null ? other.namespaceAware != null : !this.namespaceAware.equals(other.namespaceAware)) {
                return false;
            }
            if (this.schema == null ? other.schema != null : !this.schema.equals(other.schema)) {
                return false;
            }
            return !(this.validating == null ? other.validating != null : !this.validating.equals(other.validating));
        }
    }
}

