/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.domain;

import ca.infodata.dsq.domain.Address;
import ca.infodata.dsq.domain.ILocation;
import ca.infodata.dsq.domain.NIU_LDS;

public final class Location
implements ILocation {
    private static final long serialVersionUID = 1L;
    private final NIU_LDS niu;
    private final String name;
    private final Address address;
    private final String code;

    public Location(NIU_LDS niu, String name, String code, Address address) {
        if (niu == null) {
            throw new NullPointerException("niu");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (address.street == null || address.city == null || address.state == null || address.postalCode == null || address.country == null || address.city == null) {
            throw new IllegalArgumentException("address should not contains null fields");
        }
        this.niu = niu;
        this.name = name;
        this.address = address;
        this.code = code;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getNIU() == null ? 0 : this.getNIU().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ILocation)) {
            return false;
        }
        return obj.hashCode() == this.hashCode();
    }

    public String toString() {
        return String.format("Location [%s %s %s]", this.getName(), this.getNIU(), this.getCode());
    }

    @Override
    public NIU_LDS getNIU() {
        return this.niu;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public String getCode() {
        return this.code;
    }
}

