/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.solver;

import java.text.DecimalFormat;
import org.ejml.UtilEjml;

public class Polynomial {
    public double[] c;
    public int size;

    public static Polynomial wrap(double ... coefficients) {
        Polynomial p = new Polynomial(coefficients.length);
        p.setTo(coefficients, coefficients.length);
        return p;
    }

    public Polynomial(int maxCoefficients) {
        this.c = new double[maxCoefficients];
        this.size = maxCoefficients;
    }

    public Polynomial(Polynomial original) {
        this.size = original.size;
        this.c = new double[this.size];
        System.arraycopy(original.c, 0, this.c, 0, this.size);
    }

    public double evaluate(double variable) {
        if (this.size == 0) {
            return 0.0;
        }
        if (this.size == 1) {
            return this.c[0];
        }
        if (Double.isInfinite(variable)) {
            int degree = this.computeDegree();
            if (degree % 2 == 0) {
                variable = Double.POSITIVE_INFINITY;
            }
            if (this.c[degree] < 0.0) {
                variable = variable == Double.POSITIVE_INFINITY ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            return variable;
        }
        double total = this.c[this.size - 1];
        for (int i = this.size - 2; i >= 0; --i) {
            total = this.c[i] + total * variable;
        }
        return total;
    }

    public void setTo(Polynomial source) {
        this.size = source.size;
        System.arraycopy(source.c, 0, this.c, 0, this.size);
    }

    public void setTo(double[] coefficients, int size) {
        this.size = size;
        System.arraycopy(coefficients, 0, this.c, 0, size);
    }

    public void resize(int size) {
        if (this.c.length < size) {
            this.c = new double[size];
        }
        this.size = size;
    }

    public void zero() {
        for (int i = 0; i < this.size; ++i) {
            this.c[i] = 0.0;
        }
    }

    public int computeDegree() {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.c[i] == 0.0) continue;
            return i;
        }
        return -1;
    }

    public boolean isIdentical(Polynomial p, double tol) {
        int i;
        int m = Math.max(p.size(), this.size());
        for (i = p.size; i < m; ++i) {
            if (!(Math.abs(this.c[i]) > tol)) continue;
            return false;
        }
        for (i = this.size; i < m; ++i) {
            if (!(Math.abs(p.c[i]) > tol)) continue;
            return false;
        }
        int n = Math.min(p.size(), this.size());
        for (int i2 = 0; i2 < n; ++i2) {
            if (!(Math.abs(this.c[i2] - p.c[i2]) > tol)) continue;
            return false;
        }
        return true;
    }

    public void truncateZeros(double tol) {
        int i;
        for (i = this.size - 1; i >= 0 && !(Math.abs(this.c[i]) > tol); --i) {
        }
        this.size = i + 1;
    }

    public String toString() {
        DecimalFormat format = new DecimalFormat("#");
        String ret = "Poly(" + this.size + ")[ ";
        for (int i = 0; i < this.size; ++i) {
            ret = ret + UtilEjml.fancyString(this.c[i], format, 9, 4);
            if (i > 0) {
                ret = ret + "*x^" + i;
            }
            ret = ret + " ";
        }
        return ret + "]";
    }

    public void print() {
        System.out.println(this);
    }

    public double[] getCoefficients() {
        return this.c;
    }

    public int size() {
        return this.size;
    }

    public double get(int i) {
        return this.c[i];
    }
}

