/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.trustregion;

import java.io.PrintStream;
import javax.annotation.Nullable;
import org.ddogleg.optimization.GaussNewtonBase_F64;
import org.ddogleg.optimization.OptimizationException;
import org.ddogleg.optimization.math.HessianMath;
import org.ddogleg.optimization.trustregion.ConfigTrustRegion;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.NormOps_DDRM;

public abstract class TrustRegionBase_F64<S extends DMatrix, HM extends HessianMath>
extends GaussNewtonBase_F64<ConfigTrustRegion, HM> {
    protected ParameterUpdate<S> parameterUpdate;
    protected DMatrixRMaj tmp_p = new DMatrixRMaj(1, 1);
    double regionRadius;
    public double gradientNorm;

    public TrustRegionBase_F64(ParameterUpdate<S> parameterUpdate, HM hessian) {
        super(hessian);
        this.configure(new ConfigTrustRegion());
        this.parameterUpdate = parameterUpdate;
        this.hessian = hessian;
    }

    public void initialize(double[] initial, int numberOfParameters, double minimumFunctionValue) {
        super.initialize(initial, numberOfParameters);
        this.tmp_p.reshape(numberOfParameters, 1);
        this.regionRadius = ((ConfigTrustRegion)this.config).regionInitial;
        this.fx = this.cost(this.x);
        if (this.verbose != null) {
            this.verbose.println("Steps     fx        change      |step|   f-test     g-test    tr-ratio  region ");
            this.verbose.printf("%-4d  %9.3E  %10.3E  %9.3E  %9.3E  %9.3E  %6.2f   %6.2E\n", this.totalSelectSteps, this.fx, 0.0, 0.0, 0.0, 0.0, 0.0, this.regionRadius);
        }
        this.parameterUpdate.initialize(this, numberOfParameters, minimumFunctionValue);
        if (this.fx <= minimumFunctionValue) {
            if (this.verbose != null) {
                this.verbose.println("Converged minimum value");
            }
            this.mode = GaussNewtonBase_F64.Mode.CONVERGED;
        } else {
            this.mode = GaussNewtonBase_F64.Mode.COMPUTE_DERIVATIVES;
        }
    }

    @Override
    protected boolean updateDerivates() {
        this.functionGradientHessian(this.x, this.sameStateAsCost, this.gradient, this.hessian);
        if (((ConfigTrustRegion)this.config).hessianScaling) {
            this.computeHessianScaling();
            this.applyHessianScaling();
        }
        if (this.checkConvergenceGTest(this.gradient)) {
            if (this.verbose != null) {
                this.verbose.println("Converged g-test");
            }
            return true;
        }
        this.gradientNorm = NormOps_DDRM.normF(this.gradient);
        if (UtilEjml.isUncountable(this.gradientNorm)) {
            throw new OptimizationException("Uncountable. gradientNorm=" + this.gradientNorm);
        }
        this.parameterUpdate.initializeUpdate();
        return false;
    }

    @Override
    protected boolean computeStep() {
        if (this.regionRadius == -1.0) {
            this.parameterUpdate.computeUpdate(this.p, Double.MAX_VALUE);
            this.regionRadius = this.parameterUpdate.getStepLength();
            if (this.regionRadius == Double.MAX_VALUE || UtilEjml.isUncountable(this.regionRadius)) {
                if (this.verbose != null) {
                    this.verbose.println("unconstrained initialization failed. Using Cauchy initialization instead.");
                }
                this.regionRadius = -2.0;
            } else if (this.verbose != null) {
                this.verbose.println("unconstrained initialization radius=" + this.regionRadius);
            }
        }
        if (this.regionRadius == -2.0) {
            this.regionRadius = this.solveCauchyStepLength() * 10.0;
            this.parameterUpdate.computeUpdate(this.p, this.regionRadius);
            if (this.verbose != null) {
                this.verbose.println("cauchy initialization radius=" + this.regionRadius);
            }
        } else {
            this.parameterUpdate.computeUpdate(this.p, this.regionRadius);
        }
        if (((ConfigTrustRegion)this.config).hessianScaling) {
            this.undoHessianScalingOnParameters(this.p);
        }
        CommonOps_DDRM.add((DMatrixD1)this.x, this.p, (DMatrixD1)this.x_next);
        double fx_candidate = this.cost(this.x_next);
        if (UtilEjml.isUncountable(fx_candidate)) {
            throw new OptimizationException("Uncountable candidate cost. " + fx_candidate);
        }
        this.sameStateAsCost = true;
        return this.considerCandidate(fx_candidate, this.fx, this.parameterUpdate.getPredictedReduction(), this.parameterUpdate.getStepLength());
    }

    protected boolean acceptNewState(boolean converged, double fx_candidate) {
        this.fx = fx_candidate;
        DMatrixRMaj tmp = this.x;
        this.x = this.x_next;
        this.x_next = tmp;
        if (converged) {
            this.mode = GaussNewtonBase_F64.Mode.CONVERGED;
            return true;
        }
        this.mode = GaussNewtonBase_F64.Mode.COMPUTE_DERIVATIVES;
        return false;
    }

    protected double solveCauchyStepLength() {
        double gBg = this.hessian.innerVectorHessian(this.gradient);
        return this.gradientNorm * this.gradientNorm / gBg;
    }

    protected boolean considerCandidate(double fx_candidate, double fx_prev, double predictedReduction, double stepLength) {
        double actualReduction = fx_prev - fx_candidate;
        if (actualReduction == 0.0 || predictedReduction == 0.0) {
            if (this.verbose != null) {
                this.verbose.println(this.totalFullSteps + " reduction of zero");
            }
            return true;
        }
        double ratio = actualReduction / predictedReduction;
        if (fx_candidate > fx_prev || ratio < 0.25) {
            this.regionRadius = 0.5 * this.regionRadius;
        } else if (ratio > 0.75) {
            this.regionRadius = Math.min(Math.max(3.0 * stepLength, this.regionRadius), ((ConfigTrustRegion)this.config).regionMaximum);
        }
        if (fx_candidate < fx_prev && ratio > 0.0) {
            boolean converged = this.checkConvergenceFTest(fx_candidate, fx_prev);
            if (this.verbose != null) {
                this.verbose.printf("%-4d  %9.3E  %10.3E  %9.3E  %9.3E  %9.3E  %6.2f   %6.2E\n", this.totalSelectSteps, fx_candidate, fx_candidate - fx_prev, stepLength, this.ftest_val, this.gtest_val, ratio, this.regionRadius);
                if (converged) {
                    System.out.println("Converged f-test");
                }
            }
            return this.acceptNewState(converged, fx_candidate);
        }
        this.mode = GaussNewtonBase_F64.Mode.DETERMINE_STEP;
        return false;
    }

    protected abstract double cost(DMatrixRMaj var1);

    protected boolean checkConvergenceFTest(double fx, double fx_prev) {
        if (UtilEjml.isUncountable(this.regionRadius) || this.regionRadius <= 0.0) {
            throw new OptimizationException("Failing to converge. Region size hit a wall. r=" + this.regionRadius);
        }
        if (fx > fx_prev) {
            throw new RuntimeException("BUG! Shouldn't have gotten this far");
        }
        this.ftest_val = 1.0 - fx / fx_prev;
        return ((ConfigTrustRegion)this.config).ftol * fx_prev >= fx_prev - fx;
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, int level) {
        super.setVerbose(out, level);
        if (level > 0) {
            this.parameterUpdate.setVerbose(this.verbose, level);
        }
    }

    public void configure(ConfigTrustRegion config) {
        if (config.regionInitial <= 0.0 && config.regionInitial != -1.0 && config.regionInitial != -2.0) {
            throw new IllegalArgumentException("Invalid regionInitial. Read javadoc and try again.");
        }
        this.config = config.copy();
    }

    public ConfigTrustRegion getConfig() {
        return (ConfigTrustRegion)this.config;
    }

    public static interface ParameterUpdate<S extends DMatrix> {
        public void initialize(TrustRegionBase_F64<S, ?> var1, int var2, double var3);

        public void initializeUpdate();

        public void computeUpdate(DMatrixRMaj var1, double var2);

        public double getPredictedReduction();

        public double getStepLength();

        public void setVerbose(PrintStream var1, int var2);
    }
}

