/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.compress.archivers.sevenz.Coder;
import org.apache.commons.compress.archivers.sevenz.LZMA2Decoder;
import org.apache.commons.compress.archivers.sevenz.SevenZMethod;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.tukaani.xz.LZMAInputStream;

class Coders {
    static CoderId[] coderTable = new CoderId[]{new CoderId(SevenZMethod.COPY, new CopyDecoder()), new CoderId(SevenZMethod.LZMA, new LZMADecoder()), new CoderId(SevenZMethod.LZMA2, new LZMA2Decoder()), new CoderId(SevenZMethod.DEFLATE, new DeflateDecoder()), new CoderId(SevenZMethod.BZIP2, new BZIP2Decoder()), new CoderId(SevenZMethod.AES256SHA256, new AES256SHA256Decoder())};

    Coders() {
    }

    static InputStream addDecoder(InputStream is, Coder coder, byte[] password) throws IOException {
        for (CoderId coderId : coderTable) {
            if (!Arrays.equals(coderId.method.getId(), coder.decompressionMethodId)) continue;
            return coderId.coder.decode(is, coder, password);
        }
        throw new IOException("Unsupported compression method " + Arrays.toString(coder.decompressionMethodId));
    }

    static OutputStream addEncoder(OutputStream out, SevenZMethod method, byte[] password) throws IOException {
        for (CoderId coderId : coderTable) {
            if (!coderId.method.equals((Object)method)) continue;
            return coderId.coder.encode(out, password);
        }
        throw new IOException("Unsupported compression method " + (Object)((Object)method));
    }

    private static class DummyByteAddingInputStream
    extends FilterInputStream {
        private boolean addDummyByte = true;

        private DummyByteAddingInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            int result = super.read();
            if (result == -1 && this.addDummyByte) {
                this.addDummyByte = false;
                result = 0;
            }
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result = super.read(b, off, len);
            if (result == -1 && this.addDummyByte) {
                this.addDummyByte = false;
                b[off] = 0;
                return 1;
            }
            return result;
        }
    }

    static class AES256SHA256Decoder
    extends CoderBase {
        AES256SHA256Decoder() {
        }

        @Override
        InputStream decode(final InputStream in, final Coder coder, final byte[] passwordBytes) throws IOException {
            return new InputStream(){
                private boolean isInitialized = false;
                private CipherInputStream cipherInputStream = null;

                private CipherInputStream init() throws IOException {
                    byte[] aesKeyBytes;
                    if (this.isInitialized) {
                        return this.cipherInputStream;
                    }
                    int byte0 = 0xFF & coder.properties[0];
                    int numCyclesPower = byte0 & 0x3F;
                    int byte1 = 0xFF & coder.properties[1];
                    int saltSize = (byte0 >> 7 & 1) + (byte1 >> 4);
                    int ivSize = (byte0 >> 6 & 1) + (byte1 & 0xF);
                    if (2 + saltSize + ivSize > coder.properties.length) {
                        throw new IOException("Salt size + IV size too long");
                    }
                    byte[] salt = new byte[saltSize];
                    System.arraycopy(coder.properties, 2, salt, 0, saltSize);
                    byte[] iv = new byte[16];
                    System.arraycopy(coder.properties, 2 + saltSize, iv, 0, ivSize);
                    if (passwordBytes == null) {
                        throw new IOException("Cannot read encrypted files without a password");
                    }
                    if (numCyclesPower == 63) {
                        aesKeyBytes = new byte[32];
                        System.arraycopy(salt, 0, aesKeyBytes, 0, saltSize);
                        System.arraycopy(passwordBytes, 0, aesKeyBytes, saltSize, Math.min(passwordBytes.length, aesKeyBytes.length - saltSize));
                    } else {
                        MessageDigest digest;
                        try {
                            digest = MessageDigest.getInstance("SHA-256");
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            IOException ioe = new IOException("SHA-256 is unsupported by your Java implementation");
                            ioe.initCause(noSuchAlgorithmException);
                            throw ioe;
                        }
                        byte[] extra = new byte[8];
                        block4: for (long j = 0L; j < 1L << numCyclesPower; ++j) {
                            digest.update(salt);
                            digest.update(passwordBytes);
                            digest.update(extra);
                            for (int k = 0; k < extra.length; ++k) {
                                int n = k;
                                extra[n] = (byte)(extra[n] + 1);
                                if (extra[k] != 0) continue block4;
                            }
                        }
                        aesKeyBytes = digest.digest();
                    }
                    SecretKeySpec aesKey = new SecretKeySpec(aesKeyBytes, "AES");
                    try {
                        Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
                        cipher.init(2, (Key)aesKey, new IvParameterSpec(iv));
                        this.cipherInputStream = new CipherInputStream(in, cipher);
                        this.isInitialized = true;
                        return this.cipherInputStream;
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        IOException ioe = new IOException("Decryption error (do you have the JCE Unlimited Strength Jurisdiction Policy Files installed?)");
                        ioe.initCause(generalSecurityException);
                        throw ioe;
                    }
                }

                @Override
                public int read() throws IOException {
                    return this.init().read();
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return this.init().read(b, off, len);
                }

                @Override
                public void close() {
                }
            };
        }
    }

    static class BZIP2Decoder
    extends CoderBase {
        BZIP2Decoder() {
        }

        @Override
        InputStream decode(InputStream in, Coder coder, byte[] password) throws IOException {
            return new BZip2CompressorInputStream(in);
        }

        @Override
        OutputStream encode(OutputStream out, byte[] password) throws IOException {
            return new BZip2CompressorOutputStream(out);
        }
    }

    static class DeflateDecoder
    extends CoderBase {
        DeflateDecoder() {
        }

        @Override
        InputStream decode(InputStream in, Coder coder, byte[] password) throws IOException {
            return new InflaterInputStream(new DummyByteAddingInputStream(in), new Inflater(true));
        }

        @Override
        OutputStream encode(OutputStream out, byte[] password) {
            return new DeflaterOutputStream(out, new Deflater(9, true));
        }
    }

    static class LZMADecoder
    extends CoderBase {
        LZMADecoder() {
        }

        @Override
        InputStream decode(InputStream in, Coder coder, byte[] password) throws IOException {
            byte propsByte = coder.properties[0];
            long dictSize = coder.properties[1];
            for (int i = 1; i < 4; ++i) {
                dictSize |= (long)(coder.properties[i + 1] << 8 * i);
            }
            if (dictSize > 0x7FFFFFF0L) {
                throw new IOException("Dictionary larger than 4GiB maximum size");
            }
            return new LZMAInputStream(in, -1L, propsByte, (int)dictSize);
        }
    }

    static class CopyDecoder
    extends CoderBase {
        CopyDecoder() {
        }

        @Override
        InputStream decode(InputStream in, Coder coder, byte[] password) throws IOException {
            return in;
        }

        @Override
        OutputStream encode(OutputStream out, byte[] password) {
            return out;
        }
    }

    static abstract class CoderBase {
        CoderBase() {
        }

        abstract InputStream decode(InputStream var1, Coder var2, byte[] var3) throws IOException;

        OutputStream encode(OutputStream out, byte[] password) throws IOException {
            throw new UnsupportedOperationException("method doesn't support writing");
        }
    }

    static class CoderId {
        final SevenZMethod method;
        final CoderBase coder;

        CoderId(SevenZMethod method, CoderBase coder) {
            this.method = method;
            this.coder = coder;
        }
    }
}

