/*
 * Decompiled with CFR 0.152.
 */
package georegression.transform.se;

import georegression.geometry.GeometryMath_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Point4D_F32;
import georegression.struct.point.Vector3D_F32;
import georegression.struct.se.Se2_F32;
import georegression.struct.se.Se3_F32;
import java.util.List;
import org.ejml.data.FMatrixRMaj;

public class SePointOps_F32 {
    public static Point2D_F32 transform(Se2_F32 se, Point2D_F32 orig, Point2D_F32 result) {
        if (result == null) {
            result = new Point2D_F32();
        }
        float c = se.getCosineYaw();
        float s = se.getSineYaw();
        float x = orig.x;
        float y = orig.y;
        result.x = se.getX() + x * c - y * s;
        result.y = se.getY() + x * s + y * c;
        return result;
    }

    public static Point2D_F32 transform(Se2_F32 se, float x, float y, Point2D_F32 result) {
        if (result == null) {
            result = new Point2D_F32();
        }
        float c = se.getCosineYaw();
        float s = se.getSineYaw();
        result.x = se.getX() + x * c - y * s;
        result.y = se.getY() + x * s + y * c;
        return result;
    }

    public static Point2D_F32 transformReverse(Se2_F32 se, Point2D_F32 orig, Point2D_F32 result) {
        if (result == null) {
            result = new Point2D_F32();
        }
        float c = se.getCosineYaw();
        float s = se.getSineYaw();
        float x = orig.x - se.getX();
        float y = orig.y - se.getY();
        result.x = x * c + y * s;
        result.y = -x * s + y * c;
        return result;
    }

    public static void transform(Se2_F32 se, Point2D_F32[] points, int length) {
        float tranX = se.getX();
        float tranY = se.getY();
        float c = se.getCosineYaw();
        float s = se.getSineYaw();
        for (int i = 0; i < length; ++i) {
            Point2D_F32 pt = points[i];
            float x = pt.x;
            float y = pt.y;
            pt.x = tranX + x * c - y * s;
            pt.y = tranY + x * s + y * c;
        }
    }

    public static void transform(Se2_F32 se, List<Point2D_F32> points) {
        float tranX = se.getX();
        float tranY = se.getY();
        float c = se.getCosineYaw();
        float s = se.getSineYaw();
        for (Point2D_F32 pt : points) {
            float x = pt.x;
            float y = pt.y;
            pt.x = tranX + x * c - y * s;
            pt.y = tranY + x * s + y * c;
        }
    }

    public static void transform(Se3_F32 se, Point3D_F32[] points, int start, int length) {
        for (int i = 0; i < length; ++i) {
            Point3D_F32 p = points[i + start];
            SePointOps_F32.transform(se, p, p);
        }
    }

    public static void transform(Se3_F32 se, List<Point3D_F32> points) {
        for (Point3D_F32 p : points) {
            SePointOps_F32.transform(se, p, p);
        }
    }

    public static Point3D_F32 transform(Se3_F32 se, Point3D_F32 origPt, Point3D_F32 tranPt) {
        if (tranPt == null) {
            tranPt = new Point3D_F32();
        }
        FMatrixRMaj R = se.getR();
        Vector3D_F32 T = se.getT();
        GeometryMath_F32.mult(R, origPt, tranPt);
        GeometryMath_F32.add(tranPt, T, tranPt);
        return tranPt;
    }

    public static Point3D_F32 transform(Se3_F32 se, Point4D_F32 origPt, Point3D_F32 tranPt) {
        if (tranPt == null) {
            tranPt = new Point3D_F32();
        }
        FMatrixRMaj R = se.getR();
        Vector3D_F32 T = se.getT();
        float P11 = R.data[0];
        float P12 = R.data[1];
        float P13 = R.data[2];
        float P14 = T.x;
        float P21 = R.data[3];
        float P22 = R.data[4];
        float P23 = R.data[5];
        float P24 = T.y;
        float P31 = R.data[6];
        float P32 = R.data[7];
        float P33 = R.data[8];
        float P34 = T.z;
        tranPt.x = P11 * origPt.x + P12 * origPt.y + P13 * origPt.z + P14 * origPt.w;
        tranPt.y = P21 * origPt.x + P22 * origPt.y + P23 * origPt.z + P24 * origPt.w;
        tranPt.z = P31 * origPt.x + P32 * origPt.y + P33 * origPt.z + P34 * origPt.w;
        return tranPt;
    }

    public static Point3D_F32 transformReverse(Se3_F32 se, Point3D_F32 origPt, Point3D_F32 tranPt) {
        if (tranPt == null) {
            tranPt = new Point3D_F32();
        }
        FMatrixRMaj R = se.getR();
        Vector3D_F32 T = se.getT();
        GeometryMath_F32.sub(origPt, T, tranPt);
        GeometryMath_F32.multTran(R, tranPt, tranPt);
        return tranPt;
    }
}

