/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.curves;

import georegression.fitting.curves.FitPolynomialSolverTall_F32;
import georegression.struct.curve.PolynomialCubic1D_F32;
import georegression.struct.curve.PolynomialQuadratic1D_F32;
import georegression.struct.curve.PolynomialQuadratic2D_F32;
import javax.annotation.Nullable;
import org.ejml.data.FMatrix3x3;
import org.ejml.data.FMatrix4x4;
import org.ejml.data.FMatrix6x6;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.fixed.CommonOps_FDF3;
import org.ejml.dense.fixed.CommonOps_FDF4;
import org.ejml.dense.row.CommonOps_FDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_FDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;
import org.ejml.ops.ConvertFMatrixStruct;

public class FitCurve_F32 {
    public static boolean fitMM(float[] data, int offset, int length, PolynomialQuadratic1D_F32 output, @Nullable FMatrix3x3 work) {
        if (work == null) {
            work = new FMatrix3x3();
        }
        int N = length / 2;
        float sx0 = N;
        float sx1 = 0.0f;
        float sx2 = 0.0f;
        float sx3 = 0.0f;
        float sx4 = 0.0f;
        float b0 = 0.0f;
        float b1 = 0.0f;
        float b2 = 0.0f;
        int end = offset + length;
        for (int i = offset; i < end; i += 2) {
            float x = data[i];
            float y = data[i + 1];
            float x2 = x * x;
            sx1 += x;
            sx2 += x2;
            sx3 += x2 * x;
            sx4 += x2 * x2;
            b0 += y;
            b1 += x * y;
            b2 += x2 * y;
        }
        FMatrix3x3 A = work;
        A.set(sx0, sx1, sx2, sx1, sx2, sx3, sx2, sx3, sx4);
        if (!CommonOps_FDF3.invert(A, A)) {
            return false;
        }
        output.a = A.a11 * b0 + A.a12 * b1 + A.a13 * b2;
        output.b = A.a21 * b0 + A.a22 * b1 + A.a23 * b2;
        output.c = A.a31 * b0 + A.a32 * b1 + A.a33 * b2;
        return true;
    }

    public static boolean fitQRP(float[] data, int offset, int length, PolynomialQuadratic1D_F32 output) {
        FitPolynomialSolverTall_F32 solver = new FitPolynomialSolverTall_F32();
        return solver.process(data, offset, length, output);
    }

    public static boolean fitMM(float[] data, int offset, int length, PolynomialCubic1D_F32 output, @Nullable FMatrix4x4 A) {
        int N;
        if (A == null) {
            A = new FMatrix4x4();
        }
        if ((N = length / 2) < 4) {
            throw new IllegalArgumentException("Need at least 4 points and not " + N);
        }
        float sx1 = 0.0f;
        float sx2 = 0.0f;
        float sx3 = 0.0f;
        float sx4 = 0.0f;
        float sx5 = 0.0f;
        float sx6 = 0.0f;
        float b0 = 0.0f;
        float b1 = 0.0f;
        float b2 = 0.0f;
        float b3 = 0.0f;
        int end = offset + length;
        for (int i = offset; i < end; i += 2) {
            float x = data[i];
            float y = data[i + 1];
            float x2 = x * x;
            float x3 = x2 * x;
            float x4 = x2 * x2;
            sx1 += x;
            sx2 += x2;
            sx3 += x3;
            sx4 += x4;
            sx5 += x4 * x;
            sx6 += x4 * x2;
            b0 += y;
            b1 += x * y;
            b2 += x2 * y;
            b3 += x3 * y;
        }
        A.set(N, sx1, sx2, sx3, sx1, sx2, sx3, sx4, sx2, sx3, sx4, sx5, sx3, sx4, sx5, sx6);
        if (!CommonOps_FDF4.invert(A, A)) {
            return false;
        }
        output.a = A.a11 * b0 + A.a12 * b1 + A.a13 * b2 + A.a14 * b3;
        output.b = A.a21 * b0 + A.a22 * b1 + A.a23 * b2 + A.a24 * b3;
        output.c = A.a31 * b0 + A.a32 * b1 + A.a33 * b2 + A.a34 * b3;
        output.d = A.a41 * b0 + A.a42 * b1 + A.a43 * b2 + A.a44 * b3;
        return true;
    }

    public static boolean fit(float[] data, int offset, int length, PolynomialQuadratic2D_F32 output) {
        int N = length / 3;
        if (N < 6) {
            throw new IllegalArgumentException("Need at least 6 points and not " + N);
        }
        float sx1 = 0.0f;
        float sy1 = 0.0f;
        float sx1y1 = 0.0f;
        float sx2 = 0.0f;
        float sy2 = 0.0f;
        float sx2y1 = 0.0f;
        float sx1y2 = 0.0f;
        float sx2y2 = 0.0f;
        float sx3 = 0.0f;
        float sy3 = 0.0f;
        float sx3y1 = 0.0f;
        float sx1y3 = 0.0f;
        float sx4 = 0.0f;
        float sy4 = 0.0f;
        float b0 = 0.0f;
        float b1 = 0.0f;
        float b2 = 0.0f;
        float b3 = 0.0f;
        float b4 = 0.0f;
        float b5 = 0.0f;
        int end = offset + length;
        for (int i = offset; i < end; i += 3) {
            float x = data[i];
            float y = data[i + 1];
            float z = data[i + 2];
            float x2 = x * x;
            float x3 = x2 * x;
            float x4 = x2 * x2;
            float y2 = y * y;
            float y3 = y2 * y;
            float y4 = y2 * y2;
            sx1 += x;
            sx2 += x2;
            sx3 += x3;
            sx4 += x4;
            sy1 += y;
            sy2 += y2;
            sy3 += y3;
            sy4 += y4;
            sx1y1 += x * y;
            sx2y1 += x2 * y;
            sx1y2 += x * y2;
            sx2y2 += x2 * y2;
            sx3y1 += x3 * y;
            sx1y3 += x * y3;
            b0 += z;
            b1 += x * z;
            b2 += y * z;
            b3 += x * y * z;
            b4 += x2 * z;
            b5 += y2 * z;
        }
        FMatrix6x6 A = new FMatrix6x6();
        A.set(N, sx1, sy1, sx1y1, sx2, sy2, sx1, sx2, sx1y1, sx2y1, sx3, sx1y2, sy1, sx1y1, sy2, sx1y2, sx2y1, sy3, sx1y1, sx2y1, sx1y2, sx2y2, sx3y1, sx1y3, sx2, sx3, sx2y1, sx3y1, sx4, sx2y2, sy2, sx1y2, sy3, sx1y3, sx2y2, sy4);
        FMatrixRMaj _A = new FMatrixRMaj(6, 6);
        ConvertFMatrixStruct.convert(A, _A);
        LinearSolverDense<FMatrixRMaj> solver = LinearSolverFactory_FDRM.pseudoInverse(true);
        if (!solver.setA(_A)) {
            return false;
        }
        solver.invert(_A);
        FMatrixRMaj B = new FMatrixRMaj(6, 1, true, b0, b1, b2, b3, b4, b5);
        FMatrixRMaj Y2 = new FMatrixRMaj(6, 1);
        CommonOps_FDRM.mult(_A, B, Y2);
        output.a = Y2.data[0];
        output.b = Y2.data[1];
        output.c = Y2.data[2];
        output.d = Y2.data[3];
        output.e = Y2.data[4];
        output.f = Y2.data[5];
        return true;
    }
}

