/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.GrayF;
import boofcv.struct.image.ImageAccessException;
import boofcv.struct.image.ImageDataType;

public class GrayF64
extends GrayF<GrayF64> {
    public double[] data;

    public GrayF64(int width, int height) {
        super(width, height);
    }

    public GrayF64() {
    }

    public double get(int x, int y) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds: " + x + " " + y);
        }
        return this.unsafe_get(x, y);
    }

    public double unsafe_get(int x, int y) {
        return this.data[this.getIndex(x, y)];
    }

    public void set(int x, int y, double value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds: " + x + " " + y);
        }
        this.unsafe_set(x, y, value);
    }

    public void unsafe_set(int x, int y, double value) {
        this.data[this.getIndex((int)x, (int)y)] = value;
    }

    @Override
    public void print() {
        this.print("%4.1f");
    }

    public void print(String format) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                System.out.printf(format + " ", this.unsafe_get(x, y));
            }
            System.out.println();
        }
    }

    public void printInt() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                System.out.printf("%3d ", (int)this.unsafe_get(x, y));
            }
            System.out.println();
        }
    }

    @Override
    protected Object _getData() {
        return this.data;
    }

    @Override
    protected void _setData(Object data) {
        this.data = (double[])data;
    }

    @Override
    public GrayF64 createNew(int imgWidth, int imgHeight) {
        if (imgWidth == -1 || imgHeight == -1) {
            return new GrayF64();
        }
        return new GrayF64(imgWidth, imgHeight);
    }

    @Override
    public void copyCol(int col, int row0, int row1, int offset, Object array) {
        int idxSrc;
        double[] dst = (double[])array;
        int idxDst = offset;
        int end = idxSrc + (row1 - row0) * this.stride;
        for (idxSrc = this.startIndex + this.stride * row0 + col; idxSrc < end; idxSrc += this.stride) {
            dst[idxDst++] = this.data[idxSrc];
        }
    }

    @Override
    public ImageDataType getDataType() {
        return ImageDataType.F64;
    }

    public double[] getData() {
        return this.data;
    }

    public void setData(double[] data) {
        this.data = data;
    }
}

