/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.convolve;

import boofcv.abst.filter.convolve.ConvolveInterface;
import boofcv.abst.filter.convolve.GenericConvolve;
import boofcv.alg.filter.convolve.ConvolveImage;
import boofcv.alg.filter.convolve.ConvolveImageNoBorder;
import boofcv.alg.filter.convolve.ConvolveImageNormalized;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.struct.border.BorderType;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.convolve.Kernel2D;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.testing.BoofTesting;
import java.lang.reflect.Method;

public class FactoryConvolve {
    public static <Input extends ImageBase<Input>, Output extends ImageBase<Output>> ConvolveInterface<Input, Output> convolve(Kernel1D kernel, ImageType<Input> inputType, ImageType<Output> outputType, BorderType border, boolean isHorizontal) {
        Method m;
        if (inputType.getFamily() != ImageType.Family.GRAY) {
            throw new IllegalArgumentException("Currently only gray scale image supported");
        }
        Class _inputType = inputType.getImageClass();
        Class _outputType = outputType == null ? null : outputType.getImageClass();
        _outputType = (Class)BoofTesting.convertToGenericType(_outputType);
        Class<ImageBorder> borderClassType = FactoryImageBorder.lookupBorderClassType(_inputType);
        String direction = isHorizontal ? "horizontal" : "vertical";
        try {
            switch (border) {
                case SKIP: {
                    m = ConvolveImageNoBorder.class.getMethod(direction, kernel.getClass(), _inputType, _outputType);
                    break;
                }
                case EXTENDED: {
                    m = BoofTesting.findMethod(ConvolveImage.class, direction, kernel.getClass(), _inputType, _outputType, borderClassType);
                    break;
                }
                case REFLECT: {
                    m = BoofTesting.findMethod(ConvolveImage.class, direction, kernel.getClass(), _inputType, _outputType, borderClassType);
                    break;
                }
                case WRAP: {
                    m = BoofTesting.findMethod(ConvolveImage.class, direction, kernel.getClass(), _inputType, _outputType, borderClassType);
                    break;
                }
                case NORMALIZED: {
                    m = ConvolveImageNormalized.class.getMethod(direction, kernel.getClass(), _inputType, _outputType);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown border type " + (Object)((Object)border));
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The specified convolution cannot be found");
        }
        return new GenericConvolve<Input, Output>(m, kernel, border, inputType, outputType);
    }

    public static <Input extends ImageGray<Input>, Output extends ImageGray<Output>> ConvolveInterface<Input, Output> convolve(Kernel2D kernel, Class<Input> inputType, Class<Output> outputType, BorderType borderType) {
        Method m;
        outputType = (Class)BoofTesting.convertToGenericType(outputType);
        Class<ImageBorder> borderClassType = FactoryImageBorder.lookupBorderClassType(inputType);
        try {
            switch (borderType) {
                case SKIP: {
                    m = ConvolveImageNoBorder.class.getMethod("convolve", kernel.getClass(), inputType, outputType);
                    break;
                }
                case EXTENDED: {
                    m = BoofTesting.findMethod(ConvolveImage.class, "convolve", kernel.getClass(), inputType, outputType, borderClassType);
                    break;
                }
                case REFLECT: {
                    m = BoofTesting.findMethod(ConvolveImage.class, "convolve", kernel.getClass(), inputType, outputType, borderClassType);
                    break;
                }
                case WRAP: {
                    m = BoofTesting.findMethod(ConvolveImage.class, "convolve", kernel.getClass(), inputType, outputType, borderClassType);
                    break;
                }
                case NORMALIZED: {
                    m = ConvolveImageNormalized.class.getMethod("convolve", kernel.getClass(), inputType, outputType);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown border type " + (Object)((Object)borderType));
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The specified convolution cannot be found");
        }
        return new GenericConvolve(m, kernel, borderType, ImageType.single(inputType), ImageType.single(outputType));
    }
}

