/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.pyramid;

import boofcv.abst.filter.convolve.ConvolveDown;
import boofcv.factory.filter.convolve.FactoryConvolveDown;
import boofcv.struct.border.BorderType;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import boofcv.struct.pyramid.PyramidDiscrete;

public class PyramidDiscreteSampleBlur<T extends ImageBase<T>>
extends PyramidDiscrete<T> {
    private T temp;
    ConvolveDown<T, T> horizontal;
    ConvolveDown<T, T> vertical;
    double[] sigmas;

    public PyramidDiscreteSampleBlur(Kernel1D kernel, double sigma, ImageType<T> imageType, boolean saveOriginalReference, int ... scaleFactors) {
        super(imageType, saveOriginalReference, scaleFactors);
        this.horizontal = FactoryConvolveDown.convolve(kernel, BorderType.NORMALIZED, true, 1, imageType, imageType);
        this.vertical = FactoryConvolveDown.convolve(kernel, BorderType.NORMALIZED, false, 1, imageType, imageType);
        this.sigmas = new double[scaleFactors.length];
        this.sigmas[0] = 0.0;
        for (int i = 1; i < this.sigmas.length; ++i) {
            double prev = this.sigmas[i - 1];
            double applied = sigma * (double)scaleFactors[i - 1];
            this.sigmas[i] = Math.sqrt(prev * prev + applied * applied);
        }
    }

    @Override
    public void process(T input) {
        super.initialize(((ImageBase)input).width, ((ImageBase)input).height);
        if (this.temp == null) {
            this.temp = ((ImageBase)input).createNew(1, 1);
        }
        if (this.scale[0] == 1) {
            if (this.isSaveOriginalReference()) {
                this.setFirstLayer(input);
            } else {
                ((ImageBase)this.getLayer(0)).setTo(input);
            }
        } else {
            int skip = this.scale[0];
            this.horizontal.setSkip(skip);
            this.vertical.setSkip(skip);
            ((ImageBase)this.temp).reshape(((ImageBase)input).width / skip, ((ImageBase)input).height);
            this.horizontal.process(input, this.temp);
            this.vertical.process(this.temp, this.getLayer(0));
        }
        for (int index = 1; index < this.getNumLayers(); ++index) {
            int skip = this.scale[index] / this.scale[index - 1];
            Object prev = this.getLayer(index - 1);
            ((ImageBase)this.temp).reshape(((ImageBase)prev).width / skip, ((ImageBase)prev).height);
            this.horizontal.setSkip(skip);
            this.vertical.setSkip(skip);
            this.horizontal.process(prev, this.temp);
            this.vertical.process(this.temp, this.getLayer(index));
        }
    }

    @Override
    public double getSampleOffset(int layer) {
        return 0.0;
    }

    @Override
    public double getSigma(int layer) {
        return this.sigmas[layer];
    }
}

