/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.meanshift;

import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.RectangleRotate_F32;
import boofcv.struct.image.ImageBase;
import georegression.struct.point.Point2D_F32;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.stats.UtilGaussian;

public class LocalWeightedHistogramRotRect<T extends ImageBase<T>> {
    private InterpolatePixelMB<T> interpolate;
    private float[] value;
    protected float maxPixelValue;
    private int numBins;
    protected float c;
    protected float s;
    public float imageX;
    public float imageY;
    protected int[] sampleHistIndex;
    protected float[] weights;
    protected float[] histogram;
    protected List<Point2D_F32> samplePts = new ArrayList<Point2D_F32>();

    public LocalWeightedHistogramRotRect(int numSamples, double numSigmas, int numHistogramBins, int numBands, float maxPixelValue, InterpolatePixelMB<T> interpolate) {
        this.numBins = numHistogramBins;
        this.maxPixelValue = maxPixelValue * 1.0001f;
        this.interpolate = interpolate;
        this.sampleHistIndex = new int[numSamples * numSamples];
        this.histogram = new float[(int)Math.pow(numHistogramBins, numBands)];
        this.value = new float[numBands];
        this.createSamplePoints(numSamples);
        this.computeWeights(numSamples, numSigmas);
    }

    protected void computeWeights(int numSamples, double numSigmas) {
        this.weights = new float[numSamples * numSamples];
        float[] w = new float[numSamples];
        for (int i = 0; i < numSamples; ++i) {
            float x = (float)i / (float)(numSamples - 1);
            w[i] = (float)UtilGaussian.computePDF(0.0, 1.0, 2.0 * numSigmas * (double)(x - 0.5f));
        }
        for (int y = 0; y < numSamples; ++y) {
            for (int x = 0; x < numSamples; ++x) {
                this.weights[y * numSamples + x] = w[y] * w[x];
            }
        }
    }

    protected void createSamplePoints(int numSamples) {
        for (int y = 0; y < numSamples; ++y) {
            float regionY = (float)y / ((float)numSamples - 1.0f) - 0.5f;
            for (int x = 0; x < numSamples; ++x) {
                float regionX = (float)x / ((float)numSamples - 1.0f) - 0.5f;
                this.samplePts.add(new Point2D_F32(regionX, regionY));
            }
        }
    }

    public void computeHistogram(T image, RectangleRotate_F32 region) {
        this.interpolate.setImage(image);
        this.c = (float)Math.cos(region.theta);
        this.s = (float)Math.sin(region.theta);
        for (int i = 0; i < this.histogram.length; ++i) {
            this.histogram[i] = 0.0f;
        }
        if (this.isInFastBounds(region)) {
            this.computeHistogramInside(region);
        } else {
            this.computeHistogramBorder(image, region);
        }
        this.normalizeHistogram();
    }

    protected void computeHistogramInside(RectangleRotate_F32 region) {
        for (int i = 0; i < this.samplePts.size(); ++i) {
            int indexHistogram;
            Point2D_F32 p = this.samplePts.get(i);
            this.squareToImageSample(p.x, p.y, region);
            this.interpolate.get_fast(this.imageX, this.imageY, this.value);
            this.sampleHistIndex[i] = indexHistogram = this.computeHistogramBin(this.value);
            int n = indexHistogram;
            this.histogram[n] = this.histogram[n] + this.weights[i];
        }
    }

    protected void computeHistogramBorder(T image, RectangleRotate_F32 region) {
        for (int i = 0; i < this.samplePts.size(); ++i) {
            int indexHistogram;
            Point2D_F32 p = this.samplePts.get(i);
            this.squareToImageSample(p.x, p.y, region);
            if (!BoofMiscOps.checkInside(image, this.imageX, this.imageY)) {
                this.sampleHistIndex[i] = -1;
                continue;
            }
            this.interpolate.get(this.imageX, this.imageY, this.value);
            this.sampleHistIndex[i] = indexHistogram = this.computeHistogramBin(this.value);
            int n = indexHistogram;
            this.histogram[n] = this.histogram[n] + this.weights[i];
        }
    }

    protected int computeHistogramBin(float[] value) {
        int indexHistogram = 0;
        int binStride = 1;
        for (int bandIndex = 0; bandIndex < value.length; ++bandIndex) {
            int bin = (int)((float)this.numBins * value[bandIndex] / this.maxPixelValue);
            indexHistogram += bin * binStride;
            binStride *= this.numBins;
        }
        return indexHistogram;
    }

    protected boolean isInFastBounds(RectangleRotate_F32 region) {
        this.squareToImageSample(-0.5f, -0.5f, region);
        if (!this.interpolate.isInFastBounds(this.imageX, this.imageY)) {
            return false;
        }
        this.squareToImageSample(-0.5f, 0.5f, region);
        if (!this.interpolate.isInFastBounds(this.imageX, this.imageY)) {
            return false;
        }
        this.squareToImageSample(0.5f, 0.5f, region);
        if (!this.interpolate.isInFastBounds(this.imageX, this.imageY)) {
            return false;
        }
        this.squareToImageSample(0.5f, -0.5f, region);
        return this.interpolate.isInFastBounds(this.imageX, this.imageY);
    }

    protected void normalizeHistogram() {
        int i;
        float total = 0.0f;
        for (i = 0; i < this.histogram.length; ++i) {
            total += this.histogram[i];
        }
        i = 0;
        while (i < this.histogram.length) {
            int n = i++;
            this.histogram[n] = this.histogram[n] / total;
        }
    }

    protected void squareToImageSample(float x, float y, RectangleRotate_F32 region) {
        this.imageX = (x *= region.width - 1.0f) * this.c - (y *= region.height - 1.0f) * this.s + region.cx;
        this.imageY = x * this.s + y * this.c + region.cy;
    }

    public float[] getHistogram() {
        return this.histogram;
    }

    public int[] getSampleHistIndex() {
        return this.sampleHistIndex;
    }

    public List<Point2D_F32> getSamplePts() {
        return this.samplePts;
    }
}

