/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure2;

import boofcv.abst.geo.bundle.SceneStructureProjective;
import boofcv.alg.geo.pose.CompatibleProjectiveHomography;
import boofcv.alg.sfm.structure2.LookupSimilarImages;
import boofcv.alg.sfm.structure2.PairwiseImageGraph2;
import boofcv.alg.sfm.structure2.ProjectiveInitializeAllCommon;
import boofcv.alg.sfm.structure2.SceneWorkingGraph;
import java.util.ArrayList;
import org.ddogleg.struct.GrowQueue_I32;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class ProjectiveExpandToNeighbors {
    ProjectiveInitializeAllCommon computeStructure;
    CompatibleProjectiveHomography findCompatible;
    SceneWorkingGraph workGraph;

    public void process(LookupSimilarImages db, PairwiseImageGraph2.View seed, SceneWorkingGraph workGraph, SceneStructureProjective structure) {
        this.workGraph = workGraph;
        SceneWorkingGraph.View wseed = workGraph.lookupView(seed.id);
        for (int motionIdxB = 0; motionIdxB < seed.connections.size; ++motionIdxB) {
            PairwiseImageGraph2.Motion conn_B_to_C;
            PairwiseImageGraph2.View viewB;
            PairwiseImageGraph2.Motion motionB = seed.connections.get(motionIdxB);
            if (!motionB.is3D || workGraph.isKnown(viewB = motionB.other(seed)) || (conn_B_to_C = this.selectThirdView(viewB, seed)) == null) continue;
            PairwiseImageGraph2.View viewC = conn_B_to_C.other(viewB);
            int motionIdxC = seed.findMotionIdx(viewC);
            if (motionIdxC < 0) {
                throw new RuntimeException("BUG!");
            }
            if (!this.computeStructure.projectiveCameras3(db, seed, motionIdxC, motionIdxB)) continue;
            SceneWorkingGraph.View wviewC = workGraph.lookupView(viewC.id);
            ArrayList<DMatrixRMaj> cameras1 = new ArrayList<DMatrixRMaj>();
            ArrayList<DMatrixRMaj> cameras2 = new ArrayList<DMatrixRMaj>();
            DMatrixRMaj H = new DMatrixRMaj(4, 4);
            DMatrixRMaj H_inv = new DMatrixRMaj(4, 4);
            cameras1.add(this.computeStructure.P1);
            cameras1.add(wviewC.camera);
            cameras2.add(this.computeStructure.P1);
            cameras2.add(this.computeStructure.P2);
            this.findCompatible.fitCameras(cameras1, cameras2, H);
            CommonOps_DDRM.invert(H, H_inv);
            SceneWorkingGraph.View wviewB = workGraph.addViewAndFeatures(viewB);
            CommonOps_DDRM.mult(this.computeStructure.P2, H_inv, wviewB.camera);
            cameras1.add(wviewB.camera);
            int N = this.computeStructure.ransac.getMatchSet().size();
            for (int i = 0; i < N; ++i) {
            }
        }
    }

    void addCameraMatrix(int viewIdx, GrowQueue_I32 featsIdx) {
    }

    public PairwiseImageGraph2.Motion selectThirdView(PairwiseImageGraph2.View target, PairwiseImageGraph2.View seed) {
        int bestScore = 0;
        PairwiseImageGraph2.Motion bestView = null;
        for (int i = 0; i < target.connections.size; ++i) {
            PairwiseImageGraph2.View viewC;
            PairwiseImageGraph2.Motion m = target.connections.get(i);
            if (!m.is3D || (viewC = m.other(target)) == seed || !this.workGraph.isKnown(viewC)) continue;
            boolean isSrc = m.src == target;
            int totalKnown = 0;
            for (int j = 0; j < m.inliers.size; ++j) {
                SceneWorkingGraph.Feature f = isSrc ? this.workGraph.lookupFeature(target, m.inliers.get((int)j).src) : this.workGraph.lookupFeature(target, m.inliers.get((int)j).dst);
                if (!f.known) continue;
                ++totalKnown;
            }
            if (totalKnown <= bestScore) continue;
            bestScore = totalKnown;
            bestView = m;
        }
        return bestView;
    }
}

