/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation.ms;

import boofcv.alg.segmentation.ms.RegionMergeTree;
import boofcv.alg.segmentation.ms.SegmentMeanShiftSearch;
import boofcv.struct.image.GrayS32;
import georegression.struct.point.Point2D_I32;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public class MergeRegionMeanShift
extends RegionMergeTree {
    private int maxSpacialDistanceSq;
    private float maxColorDistanceSq;
    private int searchRadius;

    public MergeRegionMeanShift(int maxSpacialDistance, float maxColorDistance) {
        this.searchRadius = maxSpacialDistance;
        this.maxSpacialDistanceSq = maxSpacialDistance * maxSpacialDistance;
        this.maxColorDistanceSq = maxColorDistance * maxColorDistance;
    }

    public void process(GrayS32 pixelToRegion, GrowQueue_I32 regionMemberCount, FastQueue<float[]> regionColor, FastQueue<Point2D_I32> modeLocation) {
        this.stopRequested = false;
        this.initializeMerge(regionMemberCount.size);
        this.markMergeRegions(regionColor, modeLocation, pixelToRegion);
        if (this.stopRequested) {
            return;
        }
        this.performMerge(pixelToRegion, regionMemberCount);
    }

    protected void markMergeRegions(FastQueue<float[]> regionColor, FastQueue<Point2D_I32> modeLocation, GrayS32 pixelToRegion) {
        for (int targetId = 0; targetId < modeLocation.size && !this.stopRequested; ++targetId) {
            float[] color = regionColor.get(targetId);
            Point2D_I32 location = modeLocation.get(targetId);
            int x0 = location.x - this.searchRadius;
            int x1 = location.x + this.searchRadius + 1;
            int y0 = location.y - this.searchRadius;
            int y1 = location.y + this.searchRadius + 1;
            if (x0 < 0) {
                x0 = 0;
            }
            if (x1 > pixelToRegion.width) {
                x1 = pixelToRegion.width;
            }
            if (y0 < 0) {
                y0 = 0;
            }
            if (y1 > pixelToRegion.height) {
                y1 = pixelToRegion.height;
            }
            for (int y = y0; y < y1; ++y) {
                for (int x = x0; x < x1; ++x) {
                    float[] candidateColor;
                    float colorDistance;
                    Point2D_I32 p;
                    int candidateId = pixelToRegion.unsafe_get(x, y);
                    if (candidateId == targetId || (p = modeLocation.get(candidateId)).distance2(location) > this.maxSpacialDistanceSq || !((colorDistance = SegmentMeanShiftSearch.distanceSq(color, candidateColor = regionColor.get(candidateId))) <= this.maxColorDistanceSq)) continue;
                    this.markMerge(targetId, candidateId);
                }
            }
        }
    }
}

