/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration.cameras;

import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.alg.geo.bundle.cameras.BundleUniversalOmni;
import boofcv.alg.geo.calibration.cameras.Zhang99Camera;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraUniversalOmni;
import org.ejml.data.DMatrixRMaj;

public class Zhang99CameraUniversalOmni
implements Zhang99Camera {
    boolean assumeZeroSkew;
    boolean includeTangential;
    public boolean fixedMirror;
    int numRadial;
    double mirror;

    public Zhang99CameraUniversalOmni(boolean assumeZeroSkew, boolean includeTangential, int numRadial, double mirror) {
        this.assumeZeroSkew = assumeZeroSkew;
        this.includeTangential = includeTangential;
        this.fixedMirror = true;
        this.mirror = mirror;
        this.numRadial = numRadial;
    }

    public Zhang99CameraUniversalOmni(boolean assumeZeroSkew, boolean includeTangential, int numRadial) {
        this.assumeZeroSkew = assumeZeroSkew;
        this.includeTangential = includeTangential;
        this.fixedMirror = false;
        this.numRadial = numRadial;
    }

    @Override
    public BundleAdjustmentCamera initalizeCamera(DMatrixRMaj K, double[] radial) {
        BundleUniversalOmni cam = new BundleUniversalOmni(this.assumeZeroSkew, this.numRadial, this.includeTangential, this.fixedMirror);
        System.arraycopy(radial, 0, cam.radial, 0, radial.length);
        cam.setK(K);
        cam.mirrorOffset = this.fixedMirror ? this.mirror : 0.0;
        cam.t2 = 0.0;
        cam.t1 = 0.0;
        return cam;
    }

    @Override
    public CameraModel getCameraModel(BundleAdjustmentCamera bundleCam) {
        BundleUniversalOmni cam = (BundleUniversalOmni)bundleCam;
        CameraUniversalOmni out = new CameraUniversalOmni(cam.radial.length);
        cam.convert(out);
        return out;
    }

    @Override
    public boolean isZeroSkew() {
        return this.assumeZeroSkew;
    }

    @Override
    public int numRadial() {
        return this.numRadial;
    }
}

