/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.describe;

import boofcv.abst.filter.blur.BlurFilter;
import boofcv.alg.feature.describe.brief.BinaryCompareDefinition_I32;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.feature.TupleDesc_B;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_I32;
import java.util.Arrays;

public class DescribePointBriefSO<T extends ImageGray<T>> {
    protected BinaryCompareDefinition_I32 definition;
    protected BlurFilter<T> filterBlur;
    protected T blur;
    protected InterpolatePixelS<T> interp;
    float[] values;

    public DescribePointBriefSO(BinaryCompareDefinition_I32 definition, BlurFilter<T> filterBlur, InterpolatePixelS<T> interp) {
        this.definition = definition;
        this.filterBlur = filterBlur;
        this.interp = interp;
        Class imageType = filterBlur.getInputType().getImageClass();
        this.blur = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.values = new float[definition.samplePoints.length];
    }

    public TupleDesc_B createFeature() {
        return new TupleDesc_B(this.definition.getLength());
    }

    public void setImage(T image) {
        ((ImageGray)this.blur).reshape(((ImageGray)image).width, ((ImageGray)image).height);
        this.filterBlur.process(image, this.blur);
        this.interp.setImage(this.blur);
    }

    public void process(float c_x, float c_y, float orientation, float radius, TupleDesc_B feature) {
        float y0;
        float x0;
        Point2D_I32 a;
        int i;
        float scale = (float)((double)radius / 2.0);
        boolean isInside = BoofMiscOps.checkInside(this.blur, c_x, c_y, (float)this.definition.radius * scale);
        float c = (float)Math.cos(orientation);
        float s = (float)Math.sin(orientation);
        Arrays.fill(feature.data, 0);
        if (isInside) {
            for (i = 0; i < this.definition.samplePoints.length; ++i) {
                a = this.definition.samplePoints[i];
                x0 = c_x + (c * (float)a.x - s * (float)a.y) * scale;
                y0 = c_y + (s * (float)a.x + c * (float)a.y) * scale;
                this.values[i] = this.interp.get_fast(x0, y0);
            }
        } else {
            for (i = 0; i < this.definition.samplePoints.length; ++i) {
                a = this.definition.samplePoints[i];
                x0 = c_x + (c * (float)a.x - s * (float)a.y) * scale;
                y0 = c_y + (s * (float)a.x + c * (float)a.y) * scale;
                if (!BoofMiscOps.checkInside(this.blur, x0, y0)) continue;
                this.values[i] = this.interp.get(x0, y0);
            }
        }
        for (i = 0; i < this.definition.compare.length; ++i) {
            Point2D_I32 comp = this.definition.compare[i];
            if (!(this.values[comp.x] < this.values[comp.y])) continue;
            int n = i / 32;
            feature.data[n] = feature.data[n] | 1 << i % 32;
        }
    }

    public BinaryCompareDefinition_I32 getDefinition() {
        return this.definition;
    }
}

