/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detdesc;

import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.abst.feature.detdesc.DetectDescribeMulti;
import boofcv.abst.feature.detdesc.PointDescSet;
import boofcv.abst.feature.detect.interest.DetectorInterestPointMulti;
import boofcv.abst.feature.detect.interest.FoundPointSO;
import boofcv.abst.feature.orientation.OrientationImage;
import boofcv.alg.descriptor.UtilFeature;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import org.ddogleg.struct.FastQueue;

public class DetectDescribeMultiFusion<T extends ImageGray<T>, TD extends TupleDesc>
implements DetectDescribeMulti<T, TD> {
    private DetectorInterestPointMulti<T> detector;
    private OrientationImage<T> orientation;
    private DescribeRegionPoint<T, TD> describe;
    private SetInfo<TD>[] info;

    public DetectDescribeMultiFusion(DetectorInterestPointMulti<T> detector, OrientationImage<T> orientation, DescribeRegionPoint<T, TD> describe) {
        this.detector = detector;
        this.orientation = orientation;
        this.describe = describe;
        this.info = new SetInfo[detector.getNumberOfSets()];
        for (int i = 0; i < this.info.length; ++i) {
            this.info[i] = new SetInfo();
            this.info[i].descriptors = UtilFeature.createQueue(describe, 10);
        }
    }

    @Override
    public void process(T image) {
        this.detector.detect(image);
        this.describe.setImage(image);
        if (this.orientation != null) {
            this.orientation.setImage(image);
        }
        for (int i = 0; i < this.info.length; ++i) {
            FoundPointSO points = this.detector.getFeatureSet(i);
            SetInfo<TD> setInfo = this.info[i];
            setInfo.reset();
            for (int j = 0; j < points.getNumberOfFeatures(); ++j) {
                TupleDesc d;
                Point2D_F64 p = points.getLocation(j);
                double radius = points.getRadius(j);
                double ori = points.getOrientation(j);
                if (this.orientation != null) {
                    this.orientation.setObjectRadius(radius);
                    ori = this.orientation.compute(p.x, p.y);
                }
                if (this.describe.process(p.x, p.y, ori, radius, d = (TupleDesc)setInfo.descriptors.grow())) {
                    setInfo.location.grow().set(p);
                    continue;
                }
                setInfo.descriptors.removeTail();
            }
        }
    }

    @Override
    public int getNumberOfSets() {
        return this.info.length;
    }

    @Override
    public PointDescSet<TD> getFeatureSet(int set) {
        return this.info[set];
    }

    @Override
    public TD createDescription() {
        return (TD)this.describe.createDescription();
    }

    @Override
    public Class<TD> getDescriptionType() {
        return this.describe.getDescriptionType();
    }

    private class SetInfo<TD extends TupleDesc>
    implements PointDescSet<TD> {
        FastQueue<Point2D_F64> location = new FastQueue<Point2D_F64>(10, Point2D_F64.class, true);
        FastQueue<TD> descriptors;

        private SetInfo() {
        }

        public void reset() {
            this.location.reset();
            this.descriptors.reset();
        }

        @Override
        public int getNumberOfFeatures() {
            return this.location.size;
        }

        @Override
        public Point2D_F64 getLocation(int featureIndex) {
            return this.location.get(featureIndex);
        }

        @Override
        public TD getDescription(int index) {
            return (TD)((TupleDesc)this.descriptors.get(index));
        }
    }
}

