(function(){
	var crds = angular.module("crds",['ui.grid', 'ui.grid.selection']);
	
	crds.factory('CrdsAccessor', ['DashAPI','model', function(DashAPI, model) {
		var accessor = {
//				getRequestLists: function (callback, error){
//					return DashAPI.get('/dashboard/crds/ws/getRequestLists', callback, error);
//				},
				getRequest : function (requestId, callback, error){
					return DashAPI.get('/dashboard/crds/ws/getRequest?requestId=' + requestId, callback, error);
				},
				saveAddedFiles: function (cformdata, callback, error) {
				    return DashAPI.post('/dashboard/crds/ws/saveAddedFiles', cformdata, callback, error);
				},
				sendAddedFilesToCrds : function (cformdata, callback, error) {
                    return DashAPI.post('/dashboard/crds/ws/sendAddedFilesToCrds', cformdata, callback, error);
                },
				findCrdsForms : function (csearchcrdscriteria, callback, error) {
                    return DashAPI.post('/dashboard/crds/ws/findCrdsForms', csearchcrdscriteria, callback, error);
                },
				listRequestByPatient : function(patientId, callback, error){
					return DashAPI.get('/dashboard/crds/ws/listRequestByPatient?patientId=' + patientId, callback, error)
				}				
		};
		return accessor;
	}]);	
	
	crds.controller('CrdsController', ['$q','$scope','$log','$stateParams', '$timeout', 'PatientFormService', 'model', '$filter', 'CrdsAccessor','FormAccessor', 'patientShowTitles', 'LoadStatus',
	                                      function($q, $scope, $log, $stateParams, $timeout, PatientFormService, model, $filter, CrdsAccessor, FormAccessor, patientShowTitles,LoadStatus){
		var that = this;
		$scope.LoadStatus = LoadStatus;
		$scope.model = model;
		model.activeController('crds');
		model.activeMenu('safir');
		var MAX_NO_OF_LISTS = 10;
		// var listIdCounter = 0;

		function getNextListId(){
			// listIdCounter = listIdCounter + 1;
			// return listIdCounter;
			
			var index= _.indexBy(model.crds().crdsUserList, "id");
			for (let i = 1; i <= MAX_NO_OF_LISTS; i++) {
				if(index[i] == null){
					return i;
				}
			}
			return MAX_NO_OF_LISTS;
		}

		that.currentList = 0;
		// model.crds().crdsUserList = [{}];
		$scope.crdsStatus = [{i18n: ""}];
		$scope.emptySubStatus = [{i18n: ""}];

		$scope.searchShorthandsList = [
			// 'EN_REDACTION',
			'CONS_CRDS_PRE_MANQ',
			'CONS_CRDS_A_COMPLET',
			'CONS_CRDS_A_VERIF',
			'CLOSED'
		]
		$scope.searchShorthands = {
			EN_REDACTION: {
				namei18n:'EN_REDACTION',
				getCount: function(){
					return $q(function(resolve, reject){
						$scope.searchShorthands.EN_REDACTION.loaded = LoadStatus.UNLOADED;
						model.callDashBoardCountSafir(function(){
							$scope.searchShorthands.EN_REDACTION.count = model.dayData().cnts.crds_red_id.length;
							$scope.searchShorthands.EN_REDACTION.loaded =  LoadStatus.LOADED;
							resolve();
						}, false);
					});
				},
				search:function(){
					return {
						title: $filter("translate")("EN_REDACTION"),
						formAnchorIds: model.dayData().cnts.crds_red_id
					}
				}
			},
			CLOSED: {
				namei18n:'CRDSSearchClosed',
				getCount: function(){
					return $q(function(resolve, reject){
						$scope.searchShorthands.CLOSED.count = 0;
						$scope.searchShorthands.CLOSED.loaded = LoadStatus.LOADED;
						resolve();
					});
				},
				search:function(){
					return {
						title: $filter("translate")("CRDSSearchClosed"),
						stat: 9
					}
				}
			},
			CONS_CRDS_PRE_MANQ: {
				namei18n:'CONS_CRDS_PRE_MANQ',
				getCount: function(){
					return $q(function(resolve, reject){
						$scope.searchShorthands.CONS_CRDS_PRE_MANQ.count = model.dayData().cnts.saf_prer_id.length;
						$scope.searchShorthands.CONS_CRDS_PRE_MANQ.loaded = LoadStatus.LOADED;
						resolve();
					});
				},
				search:function(){
					return {
						title: $filter("translate")("CONS_CRDS_PRE_MANQ"),
						aStat: 1
					};
				}
			},
			CONS_CRDS_A_COMPLET:{
				namei18n:'CONS_CRDS_A_COMPLET',
				getCount: function(){
					return $q(function(resolve, reject){
						$scope.searchShorthands.CONS_CRDS_A_COMPLET.count = model.dayData().cnts.saf_compl_id.length;
						$scope.searchShorthands.CONS_CRDS_A_COMPLET.loaded = LoadStatus.LOADED;
						resolve();
					});
				},
				search:function(){
					return {
						title: $filter("translate")("CONS_CRDS_A_COMPLET"),
						aStat: 2
					};
				}
			},
			CONS_CRDS_A_VERIF:{
				namei18n:'CONS_CRDS_A_VERIF',
				getCount: function(){
					return $q(function(resolve, reject){
						$scope.searchShorthands.CONS_CRDS_A_VERIF.count = model.dayData().cnts.saf_valid_id.length;
						$scope.searchShorthands.CONS_CRDS_A_VERIF.loaded = LoadStatus.LOADED;
						resolve();
					});
				},
				search:function(){
					return {
						title: $filter("translate")("CONS_CRDS_A_VERIF"),
						aStat: 4
					};
				}
			},
		};

		function initialiseShortHand(){
			for (let i = 0; i < $scope.searchShorthandsList.length; i++) {
				$scope.openShorthand($scope.searchShorthands[$scope.searchShorthandsList[i]]);
			}
		}

		$scope.openShorthand = function(shorthand){
			var shortSearch = defaultSearchObject(shorthand.search());
			var checklist = ['idProf','stat','sStat','aStat', 'lastint', 'start', 'end', 'formAnchorIds', 'formId', 'lastunit'];
			var i = model.crds().crdsUserList.find(function(e){
				return OfysUtils.sameObj(e.search, shortSearch, checklist);
			});
			if(i == null){
				var list = initSearchList(model.crds().crdsUserList[model.crds().crdsUserList.length - 1]);
				list.search = shortSearch;
				list.find();
				// $scope.showSearch(list);
				addNewListColumn();
			}else{
				i.seekAttention();
			}
		}

		$scope.addSearch = function(list){
			initSearchList(list);
			$scope.showSearch(list);
			addNewListColumn();
		}

		function addNewListColumn(){
			if(model.crds().crdsUserList.length < MAX_NO_OF_LISTS){
				model.crds().crdsUserList.push({unsaved: true});// for add new button
			}
		}

		function updateUserPrefCRDSSearch(search){
			if(search != undefined){
				var listObj = model.user().sessionUser.user.userPreferences.crdsSearch == null ? {}: JSON.parse(model.user().sessionUser.user.userPreferences.crdsSearch);
				listObj[search.id] = search;
				model.user().sessionUser.user.userPreferences.crdsSearch = JSON.stringify(listObj);
			}
		}
		function initSearchList (list){
			list.search = defaultSearchObject(list.search);//CSearchCRDSCriteria Object
			list.listdata = [];
			if(list.id == null){
				list.id = getNextListId();
			}
			list.search.id = list.id;
			list.loaded = LoadStatus.UNLOADED;
			list.premanq = function(v){
				if(arguments.length == 0){
					return list.search.aStat == 1;
				}else{
					list.search.aStat = v?1: null;
				}
			}
			list.seekAttention = function(){
				if(list.scrollToScreen){
					list.scrollToScreen();
				}
				$timeout(function(){
					list.doSeekAttention = true;
					$timeout(function(){
						list.doSeekAttention = false;
					},1000)
				},400)
			}

			list.acompleter = function(v){
				if(arguments.length == 0){
					return list.search.aStat == 2;
				}else{
					list.search.aStat = v?2: null;
				}
			}
			list.averifier = function(v){
				if(arguments.length == 0){
					return list.search.aStat == 4;
				}else{
					list.search.aStat = v?4: null;
				}
			}
			list.selectProf = function(prof){
				list.search.profCode = prof.code;
				list.search.idProf = prof.id;
				list.search.profName = prof.lastName + ', '+ prof.firstName;
				// scope.setFormStatus("dirty");
			}

			list.removeProf = function(){
				delete list.search.profCode;
				delete list.search.idProf;
				delete list.search.profName;
			}

			list.selectForm = function(frm){
				list.search.formId = frm.id;
				list.search.formcode = frm.code;
				list.search.formName = frm.name; 
			}

			list.removeForm = function(frm){
				delete list.search.formId;
				delete list.search.formcode;
				delete list.search.formName; 
			}
			list.SubStatus = {
				parent: -1
			}
			list.getStatus = function(status){
				if($scope.crdsStatus.length == 1){
					if(model.enums().crdsStatut != null){
						$scope.crdsStatus = $scope.crdsStatus.concat(Object.values(model.enums().crdsStatut));
					}
				}
				return $scope.crdsStatus;
			}
			list.getSousStatus = function(status){
				if(list.search.stat != null){
					// changed the status

					// if(list.SubStatus.list.length == 1 || list.search.sousStatut == null || 
					// 	(model.enums().crdsSousStatut[list.search.sousStatut] != null &&
					// 	list.search.statut != list.search.sousStatut)){
					if(list.SubStatus.parent != list.search.stat){
						list.SubStatus.parent = list.search.stat;
						list.search.sStat = undefined;
						var subs = Object.values(model.enums().crdsSousStatut).filter(function(e){return model.enums().crdsStatut[e.parent].value == list.search.stat})
						list.SubStatus.list = [{i18n: ""}].concat(subs);
					}
				}else{
					list.SubStatus.list = $scope.emptySubStatus;
				}
				return list.SubStatus.list;
			}
			list.uiFind = function(frm){
				frm.emptycriteria.$validate();// revalidate criterias
				list.formErrors = PatientFormService.getFormErrors(frm,null,{validfn:'Invalid'});
				if(frm.$valid){
					list.find();
				}
			}

			list.clearStartEnd = function(){
				list.search.start = null;
				list.search.end = null;
			}

			list.clearLastint = function(){
				list.search.lastint = null;
			}

			list.find = function(){
				list.loaded = LoadStatus.LOADING;
				if (list.listdata==undefined) {
					list.listdata = [];
				} else {
					list.listdata.length = 0;					
				}
				if(list.search.formAnchorIds){
					if (list.search.formAnchorIds.length>0) {
						return FormAccessor.byIdAnchors(list.search.formAnchorIds, function(res) {
							list.updateList(res);
						}, function() {
							$log.log("FormAccessor.byIdAnchors fail");
							list.loaded = LoadStatus.FAILED;
						});
					} else {
						list.loaded = LoadStatus.LOADED;
					}
				}else{
					return CrdsAccessor.findCrdsForms(list.search, function(res) {
						list.unsaved = false;
						list.updateList(res);
						// that.crdsRequestLists.data[t] = res;
						// that.crdsRequestLists.loaded[t]=1;
						$scope.resetFilter();
						updateUserPrefCRDSSearch(list.search);
					}, function() {
						list.loaded = LoadStatus.FAILED;
						$log.log("findCrdsForms fail");
						// that.crdsRequestLists.loaded[t]=1;
					});

				}
			}
			list.updateList =  function(res){
				list.loaded = LoadStatus.LOADED;
				list.listdata = res;
				$scope.resetFilter();
				list.showSearchForm = false;
			}

			list.closeList = function(){
				list.search.deleted = true;
				if(!!list.unsaved){
					list.find();
				}
				var listIndex = model.crds().crdsUserList.indexOf(list);
				if(model.crds().crdsUserList.length >= MAX_NO_OF_LISTS && model.crds().crdsUserList[model.crds().crdsUserList.length -1].id != null){
					model.crds().crdsUserList.push({});
				}
				if(listIndex > -1){
					model.crds().crdsUserList.splice(listIndex, 1);
				}
			}

			list.emptyCriteria = function(val){
				return (list.search.stat != null ||
					list.search.formId != null ||
					list.search.idProf != null ||
					list.search.sStat != null ||
					list.search.aStat != null ||
					!!list.search.lastint ||
					!!list.search.start ||
					!!list.search.end);
			}

			list.greaterThanStart = function(val){
				if(list.search.start != undefined){
					return val >= list.search.start;
				}
				return true;
			}
			
			list.smallerThanEnd = function(val){
				if(list.search.end != undefined && val != undefined){
					return val <= list.search.end ;
				}
				return true;
			}

			if(list.search.idProf != null && !list.search.profName){
				model.store.profs.get(list.search.idProf, list.selectProf);
			}

			if(list.search.formId != null && !!list.search.formName){
				model.store.form.get(list.search.idProf, list.selectForm);
			}

			return list;
		}

		$scope.addForm = function(frm){
			model.crds().crdsUserList[that.currentList].selectForm(frm);
		}

		$scope.showSearch = function(list){
			list.showSearchForm = !list.showSearchForm;
			setCurrentList(list);
		}
		
		function setCurrentList(list){
			var listIndex = model.crds().crdsUserList.indexOf(list);
			if(listIndex > -1 && listIndex != that.currentList){
				if(model.crds().crdsUserList[that.currentList] != null){
					model.crds().crdsUserList[that.currentList].showSearchForm =  false;
				}
				that.currentList = listIndex;
			}
		}

		that.crdsRequestLists = {data: {crdsRed:[], missingFile:[], toBeCompleted:[], toBeChecked:[]},
				loaded: {crdsRed:LoadStatus.LOADING, missingFile:LoadStatus.LOADING, toBeCompleted:LoadStatus.LOADING, toBeChecked:LoadStatus.LOADING}};
		
		$scope.def = {
				filter_form_and: function(val) {
					if (arguments.length) {
						model.prefSettings('filterFormAnd', val);
						$scope.resetFilter();
					} else {
						return model.prefSettings('filterFormAnd');
					}
				},
				filter_form_terms: function(val) {
					if (arguments.length) {
						model.prefSettings('filterFormTerms', val);
						$scope.searchText=val;
						//$scope.resetFilter();
					} else {
						$scope.searchText = model.prefSettings('filterFormTerms');
						// possible d'avoir une valeur autre qu'un string et ca cause des erreurs en prod.
						if(typeof $scope.searchText !== "string"){ 
							$scope.searchText = "";
						}
						return $scope.searchText;
					}
				}
		};
		
		function loading() {
			that.crdsRequestLists.loaded.crdsRed=2;
			that.crdsRequestLists.loaded.missingFile=2;
			that.crdsRequestLists.loaded.toBeCompleted=2;
			that.crdsRequestLists.loaded.toBeChecked=2;
		}
		function doneLoading() {
			that.crdsRequestLists.loaded.crdsRed=1;
			that.crdsRequestLists.loaded.missingFile=1;
			that.crdsRequestLists.loaded.toBeCompleted=1;
			that.crdsRequestLists.loaded.toBeChecked=1;		
		}
		
		// on a les données du counts tout frais ici.
		var update = function() {
			updateIndividually(model.dayData().cnts.crds_red_id, 'crdsRed');
			updateIndividually(model.dayData().cnts.saf_prer_id, 'missingFile');
			updateIndividually(model.dayData().cnts.saf_compl_id, 'toBeCompleted');
			updateIndividually(model.dayData().cnts.saf_valid_id, 'toBeChecked');
		};
		
		// -> le click de DataItem lance le openActivity dans patient.js, ligne 1608. Il prend alors les options définis ci-bas
		$scope.actOptions = {'mode' : 'qv', 'newAct' : true };
		
		// pas utilisé si dataItem.
		that.openFormData = function(formData) {
			var options = {'mode' : 'qv', 'newAct' : true };
			patientShowTitles.openActivity(formData, options, formData.patient);
		};
		
		// v = les id, t = le type de data (missingFile, toBeCompleted, toBeChecked)
		function updateIndividually(v, t) {
			that.crdsRequestLists.data[t].length=0;
			if (v && v.length>0) {
				that.crdsRequestLists.loaded[t]=2;
				FormAccessor.byIdAnchors(v, function(res) {
					that.crdsRequestLists.data[t] = res;
					that.crdsRequestLists.loaded[t]=1;
					$scope.resetFilter();
				}, function() {
					$log.log("FormAccessor.byIdAnchors fail");
					that.crdsRequestLists.loaded[t]=1;
				}
				);
			} else {
				that.crdsRequestLists.loaded[t]=1;
			}
		}
		var hadIds = false;
		// param possible: ids_saf_prer, ids_saf_compl, ids_saf_valid
		if ($stateParams.ids_crds_red != null) {
			updateIndividually($stateParams.ids_crds_red, 'crdsRed');
			hadIds = true;
		}
		if ($stateParams.ids_saf_prer != null) {
			updateIndividually($stateParams.ids_saf_prer, 'missingFile');
			hadIds = true;
		}
		if ($stateParams.ids_saf_compl != null) {
			updateIndividually($stateParams.ids_saf_compl, 'toBeCompleted');
			hadIds = true;
		}
		if ($stateParams.ids_saf_valid != null) {
			updateIndividually($stateParams.ids_saf_valid, 'toBeChecked');
			hadIds = true;
		}
		if (!hadIds) {
			loading();
			model.callDashBoardCountSafir(update, false);	// update called after the return of data from counts.
		}
		
		$scope.searchText = "";
		
		$scope.resetFilter = function() {
			if ($scope.searchText && $scope.searchText.trim().length>0) {
				$scope.searchUpdated();
			}
		};
		
		$scope.searchUpdated = function() {
			if ($scope.searchText && $scope.searchText.length>2) {
				var x = $scope.searchText.split(' '); var len = x.length;
				if (model.prefSettings('filterFormAnd')===true) {
					delete $scope.searchTextRegExpOR;
					$scope.searchTextRegExpAND = [];
					for(var i=0;i<len;i++) {
						$scope.searchTextRegExpAND.push(new RegExp(x[i], 'i'));			
					}
				} else {
					delete $scope.searchTextRegExpAND;
					$scope.searchTextRegExpOR = [];
					for(var i=0;i<len;i++) {
						$scope.searchTextRegExpOR.push(new RegExp(x[i], 'i'));			
					}
				}
			} else {
				delete $scope.searchTextRegExpAND;
				delete $scope.searchTextRegExpOR;
			}
			model.actUpdated(true);
		};
		
		$scope.filterForm = function(oo) {
			var b = true;
			if ($scope.searchTextRegExpAND || $scope.searchTextRegExpOR) {
				var s = "";
				for (var prop in oo) {
				    if (oo.hasOwnProperty(prop)) {
				    	if (prop==='form') {
				    		s+= oo[prop].name + "~";
				    	} else if (prop==='patient') {
				    		s+= oo[prop].birthDate + "~" + oo[prop].firstName + "~" + oo[prop].lastName + "~" + oo[prop].healthInsuranceNumber + "~";
				    	} else if (prop!=='className' && prop!=='addedLinks' && prop!=='idPatient' && prop!=='crdsRequestId' && prop!=='id' && prop!=='idAnchor' && prop!=='idAuthor' && prop!=='idForm' && prop!=='deleted' && prop!=='tag' && prop!=='uid') {
				    		s += oo[prop] + "~";
				    	}
				    }
				}
				// $log.log(s);
				b = matchInArray(s);
			}
			return b;
		};
		function matchInArray(string) {
			if ($scope.searchTextRegExpAND) {
				var len = $scope.searchTextRegExpAND.length, i=0, found=false;
				for (; i < len; i++) {
					if (!$scope.searchTextRegExpAND[i].test(string)) {
						return false;
					}
				}
				return true;
			} else if ($scope.searchTextRegExpOR) {
				var len = $scope.searchTextRegExpOR.length, i=0, found=false;
				for (; i < len; i++) {
					if ($scope.searchTextRegExpOR[i].test(string)) {
						return true;
					}
				}
				return false;
			}
			return true;
		}
		
		$scope.forceReload = function() {
			// pour montrer que requête en cours
			loading();
			// je le reset tout de suite car je ne voudrais pas 2 calls exactement en même temps.
			model.callDashBoardCountSafir(update, true);	// update called after the return of data from counts.
		}
		function initCtrler(){
			// initialiseShortHand();
			model.callDashBoardCount();
			if(model.crds().loaded == false){
				model.crds().loaded = true;
				var unsent = initSearchList(model.crds().crdsUserList[model.crds().crdsUserList.length - 1]);
				unsent.loaded = 2;
				unsent.search = defaultSearchObject({title: $filter("translate")("EN_REDACTION") });
				unsent.lockEdit = true;
				addNewListColumn();
				model.callDashBoardCountSafir(function(){
					unsent.search.formAnchorIds = model.dayData().cnts.crds_red_id;
					unsent.find();
				}, false);
				if(model.user().sessionUser.user.userPreferences.crdsSearch != undefined){
					var listObj = JSON.parse(model.user().sessionUser.user.userPreferences.crdsSearch);
					Object.keys(listObj).sort().forEach(function(search){
						if(!listObj[search].deleted){
							var l = angular.extend(model.crds().crdsUserList[model.crds().crdsUserList.length - 1], {id: listObj[search].id, search: listObj[search]});
							initSearchList(l);
							addNewListColumn();
							// l.find();
						}
					})
				}else{
					initialiseShortHand();
				}
			}
		}
		function defaultSearchObject(v){
			if(v== undefined){
				v = {};
			}
			return angular.extend({lastunit: "j"},v)
		}
		initCtrler();
	}]);
	
		
})();