/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.dsq.domain.labo.getreport.pdf.LaboReportHeaderFlat;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CIaData;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.CEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.label.XLabelDef;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageProfessionnal;
import ca.infodata.ofys.ui.dashboard.models.CAppointment;
import ca.infodata.ofys.ui.dashboard.models.CBasePatientImage;
import ca.infodata.ofys.ui.dashboard.models.CBaseProfessionnal;
import ca.infodata.ofys.ui.dashboard.models.CEditableDataObjectList;
import ca.infodata.ofys.ui.dashboard.models.CImagingResultExam;
import ca.infodata.ofys.ui.dashboard.models.CLabelDef;
import ca.infodata.ofys.ui.dashboard.models.CPatient;
import ca.infodata.ofys.ui.dashboard.models.CPatientDischargeCareDetail;
import ca.infodata.ofys.ui.dashboard.models.CPatientImageProfessionnal;
import ca.infodata.ofys.ui.dashboard.models.DocDescription;
import ca.infodata.ofys.ui.dashboard.models.Utils;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class CPatientImage
extends CBasePatientImage {
    private static final long serialVersionUID = 1L;
    static final Comparator<CPatientImageProfessionnal> compCPtImgProf = new Comparator<CPatientImageProfessionnal>(){

        @Override
        public int compare(CPatientImageProfessionnal o1, CPatientImageProfessionnal o2) {
            if (o2.dateAssigned.equals(o1.dateAssigned)) {
                return o2.id.compareTo(o1.id);
            }
            return o2.dateAssigned.compareTo(o1.dateAssigned);
        }
    };
    public static final String PDF_TYPE = "pdf";
    public static final String IMG_TYPE = "img";
    public static final String NAN_TYPE = "nan";
    public String type;
    public String viewerUrl;
    public String printUrl;
    public byte[] pictureToPrint;
    public byte[] picture;
    public String notesHistory;
    public Integer idUserAnchor;
    public String userName;
    public LaboReportHeaderFlat valDsq;
    public CImagingResultExam dsqImagingResultExam;
    public CPatientDischargeCareDetail dsqDischargeCare;
    public Boolean scannedAsResultToOrderId;
    public Integer orderId;
    public Boolean orderWasRejected;
    public Boolean scannedAsSendOrder;
    public Integer sentOrderTargetProfessionnalId;
    public Integer speciality;
    public Boolean scannedAsReceivedOrder;
    public boolean doCreateTaskOnSave;
    public Integer receivedOrderFromProfessionnalId;
    public DocDescription meta;
    public CBaseProfessionnal encounterProfessional;

    public CPatientImage() {
    }

    public CPatientImage(XPatientImage x) {
        super(x);
        this.init(x, null, null);
    }

    public CPatientImage(XPatientImage x, Integer activeIdProf, Integer selectedIdProf) {
        super(x);
        this.init(x, activeIdProf, selectedIdProf);
    }

    public void init(XPatientImage x, Integer activeIdProf, Integer selectedIdProf) {
        XBaseProfessionnal professionnal;
        this.className = CPatientImage.class.getSimpleName();
        this.patient = x.getPatient() == null ? null : CPatient.c((XPatient)x.getPatient());
        this.idPatient = x.idPatient;
        this.name = x.name;
        this.picture = x.picture;
        this.pictureToPrint = x.pictureToPrint;
        if (x.labels != null) {
            this.labels = new ArrayList();
            for (XLabelDef l : x.labels) {
                this.labels.add(new CLabelDef(l));
            }
        }
        this.result = x.result;
        this.datetimeScanned = x.datetimeScanned;
        this.date = Utils.IPToNullableHyStr((IPartialDate)x.documentDate);
        this.notesHistory = x.notesHistory;
        this.idUserAnchor = x.idUserAnchor;
        this.userName = x.userName;
        this.scannedAsResultToOrderId = x.scannedAsResultToOrderId;
        this.orderId = x.orderId;
        this.orderWasRejected = x.orderWasRejected;
        this.scannedAsSendOrder = x.scannedAsReceivedOrder;
        this.sentOrderTargetProfessionnalId = x.sentOrderTargetProfessionnalId;
        this.speciality = x.speciality;
        this.scannedAsReceivedOrder = x.scannedAsReceivedOrder;
        this.receivedOrderFromProfessionnalId = x.receivedOrderFromProfessionnalId;
        if (x.dsqImagingResultExam != null) {
            this.dsqImagingResultExam = new CImagingResultExam(x.dsqImagingResultExam);
        }
        if (x.iaData != null) {
            this.iaData = new CIaData(x.iaData);
        }
        if (activeIdProf == null && (professionnal = Application.get().getPersonPluginController().getSessionProfessionnal()) != null) {
            activeIdProf = professionnal.id;
        }
        if (selectedIdProf == null) {
            selectedIdProf = activeIdProf;
        }
        if (x.getProfessionnals() != null) {
            for (XPatientImageProfessionnal imgProf : x.getProfessionnals()) {
                CPatientImageProfessionnal cPatientImageProfessionnal = new CPatientImageProfessionnal(imgProf);
                this.hasNote = this.hasNote || StringUtils.isNotEmpty((String)imgProf.getNote());
                this.profs.add(cPatientImageProfessionnal);
                if (imgProf.getProfessionnal() == null) continue;
                if (imgProf.getProfessionnal().equals(activeIdProf)) {
                    this.activeProf = cPatientImageProfessionnal;
                }
                if (!imgProf.getProfessionnal().equals(selectedIdProf)) continue;
                this.selectedProf = cPatientImageProfessionnal;
            }
            Collections.sort(this.profs, compCPtImgProf);
        }
        this.type = PDF_TYPE;
    }

    public String getFileName() {
        String res = "";
        if (this.name != null && !this.name.equals("")) {
            res = res + this.name.replaceAll("[\\s \\/]", "_");
        }
        return res;
    }

    public XPatientImage x() {
        XPatientImage x = new XPatientImage();
        super.x((EditableDataObject)x);
        x.id = this.id;
        x.patient = this.patient == null ? null : this.patient.x();
        x.idPatient = this.idPatient;
        x.name = this.name != null && this.name.length() > 100 ? this.name.substring(0, 99) : this.name;
        x.picture = this.picture;
        x.pictureToPrint = this.pictureToPrint;
        x.labels = CLabelDef.CLablelToXList(this.labels);
        x.result = this.result;
        x.datetimeScanned = this.datetimeScanned;
        x.documentDate = Utils.strToLocalDate(this.date);
        x.notesHistory = this.notesHistory;
        x.idUserAnchor = this.idUserAnchor;
        x.userName = this.userName;
        x.valDsq = this.valDsq;
        x.dsqImagingResultExam = this.dsqImagingResultExam != null ? this.dsqImagingResultExam.res : null;
        x.setProfessionnals(CEditableDataObjectList.x(this.profs));
        if (this.encounterProfessional != null) {
            x.setEncounterProfessionnal(CBaseProfessionnal.toX(this.encounterProfessional));
        }
        x.scannedAsResultToOrderId = this.scannedAsResultToOrderId;
        x.orderId = this.orderId;
        x.orderWasRejected = this.orderWasRejected;
        x.scannedAsSendOrder = this.scannedAsSendOrder;
        x.receivedOrderFromProfessionnalId = this.receivedOrderFromProfessionnalId;
        x.futurApts = CAppointment.cToXList(this.futurApts);
        x.doCreateTaskOnSave = this.doCreateTaskOnSave;
        return x;
    }

    @Override
    public <T> CEditableDataObject convertc(T type) {
        XPatientImage x = (XPatientImage)XPatientImage.class.cast(type);
        this.init((IEditableDataObject)x);
        return this;
    }

    public XPatientImage convertx() {
        return this.x();
    }
}

