/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.IProvider;
import ca.infodata.dsq.domain.NIU_SH;
import ca.infodata.dsq.service.sommhosp.get.PatientDischargeCareDetail;
import ca.infodata.dsq.service.sommhosp.list.PatientDischargeCareSummary;
import ca.infodata.ofys.ui.dashboard.models.Utils;
import ca.infodata.util1.JoinList;

public class CPatientDischargeCareSummary {
    public String className = CPatientDischargeCareSummary.class.getSimpleName();
    public int uid;
    public String timeOfDsqRequest;
    public NIU_SH id;
    public String version;
    public String author;
    public String admissionDate;
    public String departureDate;
    public String location;
    public String title;
    public String status;

    public CPatientDischargeCareSummary(PatientDischargeCareSummary res, String timeOfRequest) {
        this.timeOfDsqRequest = timeOfRequest;
        this.uid = Utils.getNewAtomicInteger();
        this.id = res.id;
        this.version = res.version;
        this.author = this.formatAuthor(res.author);
        this.admissionDate = res.effectiveTimeStart == null ? null : res.effectiveTimeStart.formatHyphen();
        this.departureDate = res.effectiveTimeEnd == null ? null : res.effectiveTimeEnd.formatHyphen();
        this.location = res.location == null ? null : res.location.getName();
        this.title = res.title;
        this.status = this.formatStatus(res.status);
    }

    public CPatientDischargeCareSummary(PatientDischargeCareDetail res, String timeOfRequest) {
        this.timeOfDsqRequest = timeOfRequest;
        this.uid = Utils.getNewAtomicInteger();
        this.id = res.id;
        this.version = res.version;
        this.author = this.formatAuthor(res.author);
        this.admissionDate = res.effectiveTimeStart == null ? null : res.effectiveTimeStart.formatHyphen();
        this.departureDate = res.effectiveTimeEnd == null ? null : res.effectiveTimeEnd.formatHyphen();
        this.location = res.location == null ? null : res.location.getName();
        this.title = res.title;
        this.status = this.formatStatus(res.status);
    }

    private String formatStatus(Code code) {
        String status = code == null ? "" : ("completed".equalsIgnoreCase(code.code) ? "" : ("active".equalsIgnoreCase(code.code) ? "Rectifi\u00e9" : ("new".equalsIgnoreCase(code.code) ? "Amend\u00e9" : "")));
        return status;
    }

    private String formatAuthor(IProvider provider) {
        if (provider == null) {
            return "";
        }
        String name = new JoinList(", ").add((CharSequence)provider.getFirstName()).add((CharSequence)provider.getLastName()).toString();
        if (provider.getNIU_COLLEGE() != null) {
            return name + " (" + provider.getNIU_COLLEGE().value() + ")";
        }
        return name;
    }
}

