/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.impl;

import ca.infodata.ofys.data.dataaccess.IBillingNBAccessor;
import ca.infodata.ofys.data.dataaccess.IConnectionInfoProvider;
import ca.infodata.ofys.data.dataaccess.ISessionProvider;
import ca.infodata.ofys.data.dataaccess.impl.BaseAccessor;
import ca.infodata.ofys.data.dataaccess.impl.RestfulClient;
import ca.infodata.ofys.data.dataaccess.impl.WebBuilder;
import ca.infodata.ofys.data.dataaccess.impl.WebBuilderWithSession;
import ca.infodata.ofys.data.middle.dataobjects.billingnb.XBillingSearchCriteria;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.date.LocalDate;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;

public class BillingNBAccessor
extends BaseAccessor
implements IBillingNBAccessor {
    private static String getPath() {
        return "/" + contextRoot + "/jaxrs/BillingNBAccessor";
    }

    public BillingNBAccessor(RestfulClient restfulClient, IConnectionInfoProvider connectionInfoProvider, ISessionProvider sessionProvider) {
        super(restfulClient, connectionInfoProvider, sessionProvider);
    }

    @Override
    public ReturnObject createNewBillingFromAppointment(int idBilling, int idAppointment) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(BillingNBAccessor.getPath() + "/createNewBillingFromAppointment"), "application/octet-stream", "application/json");
        wb.disableStandardRetry();
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("idBilling", idBilling);
        post.put("idAppointment", idAppointment);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject createNewBillingSamePatient(int idBilling) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(BillingNBAccessor.getPath() + "/createNewBillingSamePatient"), "application/octet-stream", "application/json");
        wb.disableStandardRetry();
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("id", idBilling);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject createNewBillingSameService(int idBilling) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(BillingNBAccessor.getPath() + "/createNewBillingSameService"), "application/octet-stream", "application/json");
        wb.disableStandardRetry();
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("id", idBilling);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject delete(IDataObject dataObject, boolean askQuestion) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(BillingNBAccessor.getPath() + "/delete"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("dataObject", this.serialize((Serializable)dataObject));
        post.put("askQuestion", askQuestion);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject doNotBillThisAppointment(int idAppointment) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(BillingNBAccessor.getPath() + "/doNotBillThisAppointment"), "application/octet-stream", "application/json");
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("id", idAppointment);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject findAllBillingNotSent() {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(BillingNBAccessor.getPath() + "/findAllBillingNotSent"), "application/octet-stream", "application/json");
        HashMap post = new HashMap();
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject findAppointmentForBilling(int idProfessionnal, LocalDate date) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(BillingNBAccessor.getPath() + "/findAppointmentForBilling"), "application/octet-stream", "application/json");
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("id", idProfessionnal);
        post.put("date", this.dayFrom1970(date));
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject findBillingNotSentByProfessionnal(int idProfessionnal) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(BillingNBAccessor.getPath() + "/findBillingNotSentByProfessionnal"), "application/octet-stream", "application/json");
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("id", idProfessionnal);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject loadBilling(Collection<Integer> ids) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(BillingNBAccessor.getPath() + "/loadBilling"), "application/octet-stream", "application/json");
        HashMap<String, String> post = new HashMap<String, String>();
        post.put("ids", new JoinList(",", ids).toString());
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject findBilling(XBillingSearchCriteria bcriteria) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(BillingNBAccessor.getPath() + "/findBilling"), "application/octet-stream", "application/json");
        HashMap<String, byte[]> post = new HashMap<String, byte[]>();
        post.put("dataObject", this.serialize((Serializable)bcriteria));
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject findImmunization(String serviceCode) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(BillingNBAccessor.getPath() + "/findImmunization"), "application/octet-stream", "application/json");
        HashMap<String, String> post = new HashMap<String, String>();
        post.put("serviceCode", serviceCode);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getAllCommunicationLog(LocalDate startDate, LocalDate endDate) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(BillingNBAccessor.getPath() + "/getAllCommunicationLog"), "application/octet-stream", "application/json");
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("startDate", this.dayFrom1970(startDate));
        post.put("endDate", this.dayFrom1970(endDate));
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getCommunicationLog(int idCommunicationLog) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(BillingNBAccessor.getPath() + "/getCommunicationLog"), "application/octet-stream", "application/json");
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("id", idCommunicationLog);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getNewDefaultBilling(int idProfessionnal) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(BillingNBAccessor.getPath() + "/getNewDefaultBilling"), "application/octet-stream", "application/json");
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("id", idProfessionnal);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject save(IDataObject dataObject, boolean askQuestion) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(BillingNBAccessor.getPath() + "/save"), "application/octet-stream", "application/json");
        wb.disableStandardRetry();
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("dataObject", this.serialize((Serializable)dataObject));
        post.put("askQuestion", askQuestion);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject validForSave(IDataObject obj) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(BillingNBAccessor.getPath() + "/validForSave"), "application/octet-stream", "application/json");
        HashMap<String, byte[]> post = new HashMap<String, byte[]>();
        post.put("dataObject", this.serialize((Serializable)obj));
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }
}

