/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.impl;

import ca.infodata.ofys.data.dataaccess.IApssAccessor;
import ca.infodata.ofys.data.dataaccess.IConnectionInfoProvider;
import ca.infodata.ofys.data.dataaccess.ISessionProvider;
import ca.infodata.ofys.data.dataaccess.impl.BaseAccessor;
import ca.infodata.ofys.data.dataaccess.impl.RestfulClient;
import ca.infodata.ofys.data.dataaccess.impl.WebBuilder;
import ca.infodata.ofys.data.dataaccess.impl.WebBuilderWithSession;
import ca.infodata.ofys.data.middle.dataobjects.eform.ApssFormId;
import ca.infodata.ofys.data.middle.dataobjects.eform.ApssRequestOperation;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.dashboard.models.CSearchCRDSCriteria;
import ca.infodata.ofys.util.LZMAClientSerialiser;
import ca.infodata.util1.Pair;
import com.google.gson.Gson;
import com.sun.jersey.core.util.Base64;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class ApssAccessor
extends BaseAccessor
implements IApssAccessor {
    private final Gson gson = new Gson();

    private static String getPath() {
        return "/" + contextRoot + "/jaxrs/ApssAccessor";
    }

    public ApssAccessor(RestfulClient restfulClient, IConnectionInfoProvider connectionInfoProvider, ISessionProvider sessionProvider) {
        super(restfulClient, connectionInfoProvider, sessionProvider);
    }

    @Override
    public ReturnObject listRequestByPatient(Integer patientId) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(ApssAccessor.getPath() + "/listRequestByPatient"), "application/octet-stream", "application/json");
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("patientId", patientId);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject listFormId() {
        WebBuilderWithSession wb = super.buildWebBuilderWithSession(this.getSecureURI(ApssAccessor.getPath() + "/listFormId"), "application/octet-stream", "application/json");
        HashMap post = new HashMap();
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getForm(ApssFormId formId) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(ApssAccessor.getPath() + "/getForm"), "application/octet-stream", "application/json");
        HashMap<String, byte[]> post = new HashMap<String, byte[]>();
        post.put("dataObject", this.serialize((Serializable)formId));
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getRequest(Integer requestId) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(ApssAccessor.getPath() + "/getRequest"), "application/octet-stream", "application/json");
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("requestId", requestId);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject updateRequest(String requestId, ApssRequestOperation operation) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(ApssAccessor.getPath() + "/updateRequest"), "application/octet-stream", "application/json");
        wb.disableStandardRetry();
        HashMap<String, String> post = new HashMap<String, String>();
        post.put("requestId", requestId);
        post.put("operation", operation.name());
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject findCrdsForms(CSearchCRDSCriteria c) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(ApssAccessor.getPath() + "/findCrdsForms"), "application/octet-stream", "application/json");
        wb.disableStandardRetry();
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("id", c.id);
        post.put("title", c.title);
        if (c.formId != null) {
            post.put("formId", c.formId);
        }
        if (c.idProf != null) {
            post.put("idProf", c.idProf);
        }
        if (c.stat != null) {
            post.put("stat", c.stat);
        }
        if (c.sStat != null) {
            post.put("sStat", c.sStat);
        }
        if (c.aStat != null) {
            post.put("aStat", c.aStat);
        }
        if (c.start != null) {
            post.put("start", c.start);
        }
        if (c.end != null) {
            post.put("end", c.end);
        }
        if (c.lastint != null) {
            post.put("lastint", c.lastint);
        }
        if (c.lastunit != null) {
            post.put("lastunit", c.lastunit);
        }
        if (c.deleted != null) {
            post.put("deleted", c.deleted);
        }
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public CloseableHttpResponse submit(int idEformData, String path, List<Pair<String, String>> headers, byte[] entity) throws Exception {
        CloseableHttpClient client = this.getRestfulClient().getApacheClient();
        URL address = this.getConnectionInfoProvider().get().getServerUrl();
        HttpHost target = new HttpHost(InetAddress.getByName(address.getHost()), address.getPort(), address.getProtocol());
        HttpPost baseSubmit = new HttpPost("/" + BaseAccessor.contextRoot + "/jaxrs/ApssAccessor/submit");
        HttpPost request = (HttpPost)baseSubmit.clone();
        HashMap<String, Object> post = new HashMap<String, Object>();
        WebBuilderWithSession.addSessionParametersToPost(this.getSession(), post);
        post.put("idEformData", idEformData);
        post.put("path", path);
        byte[] headersByte = LZMAClientSerialiser.serialize(headers, (boolean)true);
        post.put("criteria", new String(Base64.encode((byte[])headersByte), StandardCharsets.UTF_8));
        String encodedEntity = new String(Base64.encode((byte[])LZMAClientSerialiser.serialize((Object)entity, (boolean)true)), StandardCharsets.UTF_8);
        post.put("dataObject", encodedEntity);
        String json = this.gson.toJson(post);
        request.addHeader("Accept", "text/html");
        request.addHeader("Accept", "text/plain");
        request.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        CloseableHttpResponse r = client.execute(target, (HttpRequest)request);
        return r;
    }
}

