/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.IPrintController;
import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.controller.EncounterController;
import ca.infodata.ofys.client.web.core.ActionResult;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.middle.dataobjects.XObjectContainer;
import ca.infodata.ofys.data.middle.dataobjects.XReportContainer;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IReport;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.service.XBilledRessource;
import ca.infodata.ofys.data.middle.dataobjects.service.XBillingRessource;
import ca.infodata.ofys.data.middle.dataobjects.service.XRessource;
import ca.infodata.ofys.data.middle.dataobjects.service.XRessourceDefData;
import ca.infodata.ofys.data.middle.dataobjects.service.XSecteur;
import ca.infodata.ofys.data.middle.dataobjects.service.XTaxeDef;
import ca.infodata.ofys.ui.dashboard.accessor.RessourceSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.models.CBilledRessource;
import ca.infodata.ofys.ui.dashboard.models.CBillingRessource;
import ca.infodata.ofys.ui.dashboard.models.CEditableDataObjectList;
import ca.infodata.ofys.ui.dashboard.models.CFinancialReportCriteria;
import ca.infodata.ofys.ui.dashboard.models.CFinishedReportQuery;
import ca.infodata.ofys.ui.dashboard.models.CPatient;
import ca.infodata.ofys.ui.dashboard.models.CRessource;
import ca.infodata.ofys.ui.dashboard.models.CRessourceCriteria;
import ca.infodata.ofys.ui.dashboard.models.CRessourceDefData;
import ca.infodata.ofys.ui.dashboard.models.CSecteur;
import ca.infodata.ofys.ui.dashboard.models.CTaxDef;
import ca.infodata.ofys.ui.dashboard.models.IName;
import ca.infodata.util1.date.LocaleProvider;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class RessourceController
extends AbstractWebController {
    private final RessourceSyncAccessorClient accessor;
    private final Comparator<IName> CompIName = new Comparator<IName>(){

        @Override
        public int compare(IName o1, IName o2) {
            int i = 0;
            try {
                String d2;
                String d1;
                String l = LocaleProvider.getLocale().getLanguage().toLowerCase().substring(0, 2);
                if ("en".equals(l)) {
                    d1 = o1.getNameEn();
                    d2 = o2.getNameEn();
                } else if ("fr".equals(l)) {
                    d1 = o1.getNameFr();
                    d2 = o2.getNameFr();
                } else {
                    d1 = o1.getNameFr();
                    d2 = o2.getNameFr();
                }
                i = d1.compareTo(d2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return i;
        }
    };

    public RessourceController() {
        this.accessor = new RessourceSyncAccessorClient();
        this.getNotificationSystemConsumer().setHandleMethod(this::handleNofitication);
    }

    private void handleNofitication(DataObjectUpdatedNotification notification) throws Exception {
        IDataObject object = notification.getObject();
        if (object instanceof XBillingRessource) {
            CBillingRessource jMsg = new CBillingRessource();
            jMsg.init((XBillingRessource)object);
            ServerResponses.sendJsonToClient(notification.getClientId(), "billing.resource.update", (Object)jMsg);
        }
    }

    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes("/dashboard/ress/ws", RouterFunctions.routeAction("/secteur/list", this::listSecteurs), RouterFunctions.routeAction("/defData/list", this::listResources), RouterFunctions.routeAction("/tax/list", this::listTaxes), RouterFunctions.routeAction("/billingDefData/list", this::listBySecteur), RouterFunctions.routeAction("/billingDefDataIdPts/list", this::listByPatients), RouterFunctions.routeAction("/list/bypat", this::listByPatient), RouterFunctions.routeAction("/ressourceBilling/post", this::save), RouterFunctions.routeAction("/ress/getByCriteria", this::getRessByCriteria), RouterFunctions.routeAction("/ressDefData/getByCriteria", this::getRessDefDataByCriteria), RouterFunctions.routeAction("/secteur/save", this::saveSecteurs), RouterFunctions.routeAction("/ress/save", this::saveResources), RouterFunctions.routeAction("/tax/save", this::saveTaxes), RouterFunctions.routeAction("/billed/save", this::saveBilledRessource), RouterFunctions.routeAction("/billed/sendByEmail", this::sendByEmailBilledRessource), RouterFunctions.routeAction("/billedDefIdPat/list", this::getBilledByPat), RouterFunctions.routeAction("/getFinancialReport", this::getFinancialReport));
    }

    private ActionResult listSecteurs(IServerRequest req) {
        Boolean withDeleted = req.getQueryParam("withDeleted", Boolean.class);
        List<XSecteur> lstRess = this.accessor.getAllSecteurs();
        if (!(lstRess == null || withDeleted != null && withDeleted.booleanValue())) {
            lstRess.removeIf(p -> Boolean.TRUE.equals(p.isDeleted));
        }
        CEditableDataObjectList<CSecteur> list = new CEditableDataObjectList<CSecteur>(lstRess, CSecteur.class);
        list.sort(this.CompIName);
        return ServerResponses.toJsonActionResult(list);
    }

    private ActionResult listResources(IServerRequest req) {
        List<XRessourceDefData> lstRess = this.accessor.getAllRessourceDefData();
        lstRess.removeIf(p -> Boolean.TRUE.equals(p.isDeleted));
        CEditableDataObjectList<CRessourceDefData> list = new CEditableDataObjectList<CRessourceDefData>(lstRess, CRessourceDefData.class);
        list.sort(this.CompIName);
        return ServerResponses.toJsonActionResult(list);
    }

    private ActionResult listTaxes(IServerRequest req) {
        Boolean withDeleted = req.getQueryParam("withDeleted", Boolean.class);
        List<XTaxeDef> lstRess = this.accessor.getAllTaxes();
        if (!(lstRess == null || withDeleted != null && withDeleted.booleanValue())) {
            lstRess.removeIf(p -> Boolean.TRUE.equals(p.isDeleted));
        }
        CEditableDataObjectList<CTaxDef> list = new CEditableDataObjectList<CTaxDef>(lstRess, CTaxDef.class);
        return ServerResponses.toJsonActionResult(list);
    }

    private ActionResult getRessByCriteria(IServerRequest req) {
        CRessourceCriteria data = req.getPostBody(CRessourceCriteria.class);
        List<XRessource> lstRess = this.accessor.getRessourceByCriteria(data.toX());
        CEditableDataObjectList<CRessource> list = new CEditableDataObjectList<CRessource>(lstRess, CRessource.class);
        list.sort(this.CompIName);
        return ServerResponses.toJsonActionResult(list);
    }

    private ActionResult getRessDefDataByCriteria(IServerRequest req) {
        CRessourceCriteria data = req.getPostBody(CRessourceCriteria.class);
        List<XRessourceDefData> lstRess = this.accessor.getRessourceDefDataByCriteria(data.toX());
        CEditableDataObjectList<CRessourceDefData> list = new CEditableDataObjectList<CRessourceDefData>(lstRess, CRessourceDefData.class);
        list.sort(this.CompIName);
        return ServerResponses.toJsonActionResult(list);
    }

    private ActionResult saveSecteurs(IServerRequest req) {
        CSecteur[] data = req.getPostBody(CSecteur[].class);
        ArrayList<XSecteur> xlist = new ArrayList<XSecteur>(data.length);
        for (CSecteur c : data) {
            xlist.add(c.convertx());
        }
        XObjectContainer container = new XObjectContainer(xlist);
        ReturnObject response = this.accessor.save((IDataObject)container, false);
        IEditableDataObjectList secteurs = ((XObjectContainer)response.getObj()).getObjects();
        CEditableDataObjectList<IName> clist = new CEditableDataObjectList<IName>();
        for (IMinimalEditableDataObject secteur : secteurs) {
            CSecteur cSecteur = new CSecteur();
            cSecteur.init((XSecteur)secteur);
            clist.add(cSecteur);
        }
        clist.sort(this.CompIName);
        response.setObj(clist);
        return ServerResponses.toJsonActionResult(response);
    }

    private ActionResult saveResources(IServerRequest req) {
        CRessource data = req.getPostBody(CRessource.class);
        ReturnObject response = this.accessor.save((IDataObject)data.convertx(), false);
        data.convertc((XRessource)response.getObj());
        response.setObj((Object)data);
        return ServerResponses.toJsonActionResult(response);
    }

    private ActionResult saveTaxes(IServerRequest req) {
        CTaxDef[] data = req.getPostBody(CTaxDef[].class);
        ArrayList<XTaxeDef> xtaxList = new ArrayList<XTaxeDef>(data.length);
        for (CTaxDef ctax : data) {
            xtaxList.add(ctax.convertx());
        }
        XObjectContainer container = new XObjectContainer(xtaxList);
        ReturnObject response = this.accessor.save((IDataObject)container, false);
        IEditableDataObjectList taxes = ((XObjectContainer)response.getObj()).getObjects();
        CEditableDataObjectList<CTaxDef> ctaxlist = new CEditableDataObjectList<CTaxDef>();
        for (IMinimalEditableDataObject tax : taxes) {
            CTaxDef cTax = new CTaxDef();
            cTax.init((XTaxeDef)tax);
            ctaxlist.add(cTax);
        }
        response.setObj(ctaxlist);
        return ServerResponses.toJsonActionResult(response);
    }

    private ActionResult saveBilledRessource(IServerRequest req) {
        CBilledRessource[] data = req.getPostBody(CBilledRessource[].class);
        ArrayList<XBilledRessource> xbilledList = new ArrayList<XBilledRessource>(data.length);
        for (CBilledRessource ctax : data) {
            xbilledList.add(ctax.convertx());
        }
        XObjectContainer container = new XObjectContainer(xbilledList);
        ReturnObject response = this.accessor.save((IDataObject)container, false);
        IEditableDataObjectList billed = ((XObjectContainer)response.getObj()).getObjects();
        CEditableDataObjectList<CBilledRessource> cbilledlist = new CEditableDataObjectList<CBilledRessource>();
        for (IMinimalEditableDataObject billedres : billed) {
            CBilledRessource cBilled = new CBilledRessource();
            cBilled.init((XBilledRessource)billedres);
            cbilledlist.add(cBilled);
        }
        response.setObj(cbilledlist);
        return ServerResponses.toJsonActionResult(response);
    }

    public ActionResult sendByEmailBilledRessource(IServerRequest req) {
        CSendEmailReportQuery query = req.getPostBody(CSendEmailReportQuery.class);
        IPrintController ctrl = Application.get().getPrintControllerFactory().newPrintController(query.getDataObject());
        ctrl.getSelection().add((IReport)query.getIReport());
        XReportContainer reportContainerToSend = new XReportContainer();
        reportContainerToSend.setLstReport(ctrl.getSelection());
        ReturnObject res = this.accessor.sendByEmailBilledRessource(query.email, query.getDataObject(), reportContainerToSend, query.idPat, query.idSite, null);
        return ServerResponses.toJsonActionResult(res);
    }

    private ActionResult listBySecteur(IServerRequest req) {
        Integer idSect = req.getRequiredQueryParam("idSecteur", Integer.class);
        Long time = null;
        List<XBillingRessource> lstRess = this.accessor.getBillingRessourceByCriteria(idSect, null, time, null, null);
        CEditableDataObjectList<CBillingRessource> appList = new CEditableDataObjectList<CBillingRessource>(lstRess, CBillingRessource.class);
        HashMap<Integer, CPatient> mapPt = new HashMap<Integer, CPatient>(appList.size());
        for (CBillingRessource cb : appList) {
            if (cb.getPatient() == null) continue;
            mapPt.put(cb.getPatient().id, cb.getPatient());
        }
        for (CBillingRessource cb : appList) {
            CPatient cPatient;
            if (cb.getPatient() != null || cb.getIdPatientAnchor() == null || (cPatient = (CPatient)((Object)mapPt.get(cb.getIdPatientAnchor()))) == null) continue;
            cb.setPatient(cPatient);
        }
        return ServerResponses.toJsonActionResult(appList);
    }

    private ActionResult listByPatients(IServerRequest req) {
        IntAVLTreeSet idPts = req.getRequiredQueryParam("idPts", IntAVLTreeSet.class);
        List<XBillingRessource> lstRess = this.accessor.getBillingRessourceByCriteria(null, null, null, null, idPts);
        CEditableDataObjectList<CBillingRessource> appList = new CEditableDataObjectList<CBillingRessource>(lstRess, CBillingRessource.class);
        HashMap<Integer, CPatient> mapPt = new HashMap<Integer, CPatient>(appList.size());
        for (CBillingRessource cb : appList) {
            if (cb.getPatient() == null) continue;
            mapPt.put(cb.getPatient().id, cb.getPatient());
        }
        for (CBillingRessource cb : appList) {
            CPatient cPatient;
            if (cb.getPatient() != null || cb.getIdPatientAnchor() == null || (cPatient = (CPatient)((Object)mapPt.get(cb.getIdPatientAnchor()))) == null) continue;
            cb.setPatient(cPatient);
        }
        return ServerResponses.toJsonActionResult(appList);
    }

    private ActionResult listByPatient(IServerRequest req) {
        Integer idPat = req.getRequiredQueryParam("id", Integer.class);
        if (idPat != null) {
            List<XBillingRessource> lstRess = this.accessor.getBillingRessourceByCriteria(null, idPat, null, null, null);
            CEditableDataObjectList<CBillingRessource> appList = new CEditableDataObjectList<CBillingRessource>(lstRess, CBillingRessource.class);
            return ServerResponses.toJsonActionResult(appList);
        }
        return ServerResponses.ERROR("Absence du id patient!");
    }

    private ActionResult save(IServerRequest req) {
        CBillingRessource data = req.getPostBody(EncounterController.CUidObject.class).getObject(CBillingRessource.class);
        String string = data.modificationStatus = data.getId() == null ? "STATUS_NEW" : "STATUS_UPDATED";
        if (data.idSite == null) {
            data.idSite = Application.get().getSitePluginController().getContextSite().getId();
        }
        ReturnObject obj = this.accessor.save((IDataObject)data.convertx(), false);
        CBillingRessource cRessource = new CBillingRessource();
        cRessource.convertc((XBillingRessource)obj.getObj());
        obj.setObj((Object)cRessource);
        return ServerResponses.toJsonActionResult(obj);
    }

    private ActionResult getBilledByPat(IServerRequest req) {
        Integer idPat = req.getRequiredQueryParam("id", Integer.class);
        if (idPat != null) {
            List<XBilledRessource> xlstRess = this.accessor.getBilledRessourceByCriteria(null, idPat, null, null, null);
            CEditableDataObjectList<CBilledRessource> clstRess = new CEditableDataObjectList<CBilledRessource>(xlstRess, CBilledRessource.class);
            return ServerResponses.toJsonActionResult(clstRess);
        }
        return ServerResponses.ERROR("Absence du id patient!");
    }

    private ActionResult getFinancialReport(IServerRequest req) {
        CFinancialReportCriteria data = req.getPostBody(CFinancialReportCriteria.class);
        if (data.type != null && data.getBilledList()) {
            ReturnObject res = this.accessor.getBilledRessourceByCriteria(data.buildBillCriteria());
            CEditableDataObjectList<CBilledRessource> clstRess = new CEditableDataObjectList<CBilledRessource>((List)res.getObj(), CBilledRessource.class);
            clstRess.sort((a, b) -> a.noFacture < b.noFacture ? -1 : 1);
            res.setObj(clstRess);
            return ServerResponses.toJsonActionResult(res);
        }
        if (data.type != null) {
            return ServerResponses.toJsonActionResult(this.accessor.getFinancialReportByCriteria(data.buildBillCriteria()));
        }
        return ServerResponses.ERROR("Erreur dans les crit\u00e8res re\u00e7u!");
    }

    public class CSendEmailReportQuery
    extends CFinishedReportQuery {
        public String email;
        public Integer idPat;
        public Integer idSite;
    }
}

