/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.util.ExceptionUtils;
import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.dataaccess.client.ApssAccessorClient;
import ca.infodata.ofys.data.dataaccess.client.EFormAccessorClient;
import ca.infodata.ofys.data.middle.dataobjects.eform.ApssFormId;
import ca.infodata.ofys.data.middle.dataobjects.eform.ApssRequestJson;
import ca.infodata.ofys.data.middle.dataobjects.eform.ApssRequestOperation;
import ca.infodata.ofys.data.middle.dataobjects.eform.XBaseEform;
import ca.infodata.ofys.data.middle.dataobjects.eform.XBaseEformData;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEformData;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.dashboard.models.CForm;
import ca.infodata.ofys.ui.dashboard.models.CFormData;
import ca.infodata.ofys.ui.dashboard.models.CSearchCRDSCriteria;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CrdsController
extends AbstractWebController {
    private static final Logger logger = Logger.getLogger(CrdsController.class.getName());
    private ApssAccessorClient accessor = new ApssAccessorClient();
    private final EFormAccessorClient eFormAccessorClient = new EFormAccessorClient();

    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes("/dashboard/crds/ws", RouterFunctions.routeReturnObject("/getRequest", this::getRequest), RouterFunctions.routeReturnObject("/updateRequest", this::updateRequest), RouterFunctions.routeReturnObject("/listRequestByPatient", this::listRequestByPatient), RouterFunctions.routeReturnObject("/listForm", this::listForm), RouterFunctions.routeReturnObject("/getForm", this::getForm), RouterFunctions.routeReturnObject("/saveAddedFiles", this::saveAddedFiles), RouterFunctions.routeReturnObject("/sendAddedFilesToCrds", this::sendAddedFilesToCrds), RouterFunctions.routeReturnObject("/findCrdsForms", this::findCrdsForms));
    }

    private ReturnObject listForm(IServerRequest req) {
        ReturnObject ro = new ReturnObject();
        try {
            ReturnObject ret = this.accessor.getAccessor().listFormId();
            this.manageNonOkResponse(ret);
            List list = (List)ret.getObj();
            ArrayList<CForm> clist = new ArrayList<CForm>(list.size());
            for (XBaseEform xBaseEform : list) {
                clist.add(new CForm(xBaseEform));
            }
            ro.setObj(clist);
            return ro;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to get apss request as json", e);
            MultiStatus ms = new MultiStatus();
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
            return ro;
        }
    }

    private ReturnObject getForm(IServerRequest req) {
        ReturnObject ro = new ReturnObject();
        try {
            ApssFormId formId = new ApssFormId();
            formId.id = req.getQueryParam("formId");
            ro = this.accessor.getAccessor().getForm(formId);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to get apss request as json", e);
            MultiStatus ms = new MultiStatus();
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    private ReturnObject saveAddedFiles(IServerRequest req) {
        ReturnObject ro = new ReturnObject();
        try {
            CFormData cData = req.getPostBody(CFormData.class);
            XEformData xData = cData.toXEformData();
            XEformData savedData = this.eFormAccessorClient.saveData(xData);
            cData.id = savedData.getId();
            cData.idAnchor = savedData.getIdAnchor();
            if (cData.form.type != 2) {
                Application.get().getPreSaveController().removeByTag("XFORM", cData.tag);
            } else if (cData.attente != null) {
                cData.attente.setId(cData.id);
            }
            ro.setObj((Object)cData);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to save eform data", e);
            MultiStatus ms = new MultiStatus();
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    private ReturnObject sendAddedFilesToCrds(IServerRequest req) {
        ReturnObject ro = new ReturnObject();
        try {
            CFormData cData = req.getPostBody(CFormData.class);
            String requestId = cData.crdsRequestId;
            ApssRequestOperation operation = ApssRequestOperation.join_files;
            ReturnObject ret = this.accessor.getAccessor().updateRequest(requestId, operation);
            this.manageNonOkResponse(ret);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to get apss request as json", e);
            MultiStatus ms = new MultiStatus();
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    private ReturnObject findCrdsForms(IServerRequest req) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            CSearchCRDSCriteria criteria = req.getPostBody(CSearchCRDSCriteria.class);
            ReturnObject ret = this.accessor.getAccessor().findCrdsForms(criteria);
            this.manageNonOkResponse(ret);
            if (ret.getObj() != null) {
                List lst = (List)ret.getObj();
                ArrayList<CFormData> cfd = new ArrayList<CFormData>(lst.size());
                for (XBaseEformData x : lst) {
                    cfd.add(new CFormData(x, x.getForm()));
                }
                ro.setObj(cfd);
            }
            ms.setSeverity(IStatus.Severity.OK);
            ro.setStatus(ms);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to find apss forms", e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    private ReturnObject updateRequest(IServerRequest req) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            String requestId = req.getQueryParam("requestId");
            ApssRequestOperation operation = req.getRequiredQueryParam("operation", ApssRequestOperation.class);
            ReturnObject ret = this.accessor.getAccessor().updateRequest(requestId, operation);
            ro.setObj(ret.getObj());
            ms.setMessage(ret.getStatus().getMessage());
            ms.setSeverity(ret.getStatus().getSeverity());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to get apss request as json", e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage(e));
        }
        ro.setStatus(ms);
        return ro;
    }

    private ReturnObject getRequest(IServerRequest req) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            Integer requestId = req.getQueryParam("requestId", Integer.class);
            ApssRequestJson request = this.accessor.getRequest(requestId);
            ro.setObj((Object)request);
            ms.setSeverity(IStatus.Severity.OK);
            ro.setStatus(ms);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to get apss request as json", e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    private ReturnObject listRequestByPatient(IServerRequest req) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        Integer patientId = null;
        try {
            patientId = req.getRequiredQueryParam("patientId", Integer.class);
            ReturnObject ret = this.accessor.getAccessor().listRequestByPatient(patientId);
            ro.setObj(ret.getObj());
            ms.setMessage(ret.getStatus().getMessage());
            ms.setSeverity(ret.getStatus().getSeverity());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to list crds request for patient " + patientId, e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    private void manageNonOkResponse(ReturnObject r) throws Exception {
        if (r == null) {
            throw new Exception("Null response");
        }
        if (r.getStatus() == null) {
            throw new Exception("No status response");
        }
        if (!r.getStatus().isOkToProceed()) {
            throw new StatusException((IStatus)r.getStatus());
        }
    }
}

