/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.base64.Base64DecodedString;
import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.controller.PatientController;
import ca.infodata.ofys.client.web.core.ActionResult;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.middle.dataobjects.XUser;
import ca.infodata.ofys.data.middle.dataobjects.chat.LINK_TYPE;
import ca.infodata.ofys.data.middle.dataobjects.chat.XCourrielDest;
import ca.infodata.ofys.data.middle.dataobjects.chat.XCourrielTexte;
import ca.infodata.ofys.data.middle.dataobjects.chat.XCourrielTexteCriteria;
import ca.infodata.ofys.data.middle.dataobjects.eform.XBaseEformData;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XBaseLaboResultsProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.scan.XBasePatientImage;
import ca.infodata.ofys.ui.dashboard.accessor.CourrielSyncAccesorClient;
import ca.infodata.ofys.ui.dashboard.accessor.PreferencesSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.models.CCourrielDest;
import ca.infodata.ofys.ui.dashboard.models.CCourrielTexte;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;

public class CourrielController
extends AbstractWebController {
    public static final int PROP_CHAT_MESSAGE_NOTIFICATION = 1;
    private final PreferencesSyncAccessorClient preferencesAccessor;
    private final CourrielSyncAccesorClient accessor;
    private final PatientController patientController;

    public CourrielController(PatientController patientController) {
        this.patientController = patientController;
        this.accessor = new CourrielSyncAccesorClient();
        this.preferencesAccessor = new PreferencesSyncAccessorClient();
        this.getNotificationSystemConsumer().setHandleMethod(this::handleNotification);
    }

    private void handleNotification(DataObjectUpdatedNotification notification) throws Exception {
        IDataObject object = notification.getObject();
        if (object instanceof XCourrielDest) {
            CCourrielDest jMsg = new CCourrielDest((XCourrielDest)object);
            ServerResponses.sendJsonToClient(notification.getClientId(), "mail.alert", (Object)jMsg);
        } else if (object instanceof XCourrielTexte) {
            CCourrielTexte jMsg = new CCourrielTexte((XCourrielTexte)object);
            ServerResponses.sendJsonToClient(notification.getClientId(), "mail.new", (Object)jMsg);
        }
    }

    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes("/dashboard/courriel/ws", RouterFunctions.route("/find", this::handleFind, ActionResult.class), RouterFunctions.route("/findIdsPerFolder", this::handleFindIdsPerFolder, ActionResult.class), RouterFunctions.routeAction("/findIds", req -> ServerResponses.toJsonActionResult(this.handleFindIds(req))), RouterFunctions.route("/setRead", this::handleSetRead, ActionResult.class), RouterFunctions.route("/setUnread", this::handleSetUnread, ActionResult.class), RouterFunctions.route("/setArchive", this::handleSetArchive, ActionResult.class), RouterFunctions.route("/setUnarchive", this::handleSetUnarchive, ActionResult.class), RouterFunctions.route("/list/bypat", this::handleListByPat, ActionResult.class), RouterFunctions.route("/list/frompat", this::handleListFromPat, ActionResult.class), RouterFunctions.route("/byIds", this::handleListByIds, ActionResult.class), RouterFunctions.route("/responses", this::handleListResponses, ActionResult.class), RouterFunctions.route("/previous", this::handleListPrevious, ActionResult.class), RouterFunctions.route("/moveTo", this::handleMoveTo, ActionResult.class), RouterFunctions.route("/openLink", this::handleOpenLink, ActionResult.class), RouterFunctions.routeAction("/nameFolder", req -> ServerResponses.toJsonActionResult(this.handleNameFolder(req))), RouterFunctions.route("/save", this::handleSave, ActionResult.class));
    }

    private ActionResult handleSave(IServerRequest req) {
        CCourrielTexte courrielToSave = req.getPostBody(CCourrielTexte.class);
        return ServerResponses.toJsonActionResult(this.createCourriel(courrielToSave));
    }

    private ActionResult handleSetRead(IServerRequest req) {
        Integer[] ids = req.getRequiredQueryParam("ids", Integer[].class);
        if (ids == null || ids.length == 0) {
            return ServerResponses.SUCCESS();
        }
        IntArrayList l = new IntArrayList();
        for (Integer i : ids) {
            l.add(i.intValue());
        }
        return ServerResponses.toJsonActionResult(this.accessor.setReadStatus((IntList)l));
    }

    private ActionResult handleSetUnread(IServerRequest req) {
        Integer[] ids = req.getRequiredQueryParam("ids", Integer[].class);
        if (ids == null || ids.length == 0) {
            return ServerResponses.SUCCESS();
        }
        IntArrayList l = new IntArrayList();
        for (Integer i : ids) {
            l.add(i.intValue());
        }
        return ServerResponses.toJsonActionResult(this.accessor.setUnreadStatus((IntList)l));
    }

    private ActionResult handleSetArchive(IServerRequest req) {
        Integer[] ids = req.getRequiredQueryParam("ids", Integer[].class);
        if (ids == null || ids.length == 0) {
            return ServerResponses.SUCCESS();
        }
        IntArrayList l = new IntArrayList();
        for (Integer i : ids) {
            l.add(i.intValue());
        }
        return ServerResponses.toJsonActionResult(this.accessor.setArchived((IntList)l));
    }

    private ActionResult handleSetUnarchive(IServerRequest req) {
        Integer[] ids = req.getRequiredQueryParam("ids", Integer[].class);
        if (ids == null || ids.length == 0) {
            return ServerResponses.SUCCESS();
        }
        IntArrayList l = new IntArrayList();
        for (Integer i : ids) {
            l.add(i.intValue());
        }
        return ServerResponses.toJsonActionResult(this.accessor.setUnarchived((IntList)l));
    }

    private ActionResult handleMoveTo(IServerRequest req) {
        Integer[] ids = req.getRequiredQueryParam("ids", Integer[].class);
        Integer folder = req.getQueryParam("folder", Integer.class);
        if (ids == null || ids.length == 0) {
            return ServerResponses.SUCCESS();
        }
        IntArrayList l = new IntArrayList();
        for (Integer i : ids) {
            l.add(i.intValue());
        }
        if (folder == null || folder < 5) {
            folder = null;
        }
        return ServerResponses.toJsonActionResult(this.accessor.moveTo((IntList)l, folder));
    }

    private ActionResult handleListByIds(IServerRequest req) {
        Integer[] ids = req.getRequiredQueryParam("ids", Integer[].class);
        if (ids == null || ids.length == 0) {
            return ServerResponses.SUCCESS();
        }
        IntArrayList l = new IntArrayList();
        for (Integer i : ids) {
            l.add(i.intValue());
        }
        return ServerResponses.toJsonActionResult(this.ToCCourrielTexte(this.accessor.byIds((IntList)l, true)));
    }

    private ActionResult handleListByPat(IServerRequest req) {
        Integer idPat = req.getRequiredQueryParam("id", Integer.class);
        return ServerResponses.toJsonActionResult(this.ToCCourrielTexte(this.accessor.listByPatient(idPat)));
    }

    private ActionResult handleListFromPat(IServerRequest req) {
        Integer idPat = req.getRequiredQueryParam("patId", Integer.class);
        return ServerResponses.toJsonActionResult(this.ToCCourrielTexte(this.accessor.listFromAndToPatient(idPat)));
    }

    private ActionResult handleListResponses(IServerRequest req) {
        Integer idResp = req.getRequiredQueryParam("id", Integer.class);
        XUser user = Application.get().getGlobalInstances().getSession().getUser();
        if (user.getIdPerson() != null) {
            XCourrielTexteCriteria criteria = new XCourrielTexteCriteria();
            criteria.response = idResp;
            criteria.limit = 99;
            criteria.offset = 0;
            return ServerResponses.toJsonActionResult(this.ToCCourrielTexte(this.accessor.getCourrielWithLimitOffset(criteria)));
        }
        return ServerResponses.ERROR("No id person with active user");
    }

    private ActionResult handleListPrevious(IServerRequest req) {
        Integer idPrevious = req.getRequiredQueryParam("id", Integer.class);
        XUser user = Application.get().getGlobalInstances().getSession().getUser();
        if (user.getIdPerson() != null) {
            XCourrielTexteCriteria criteria = new XCourrielTexteCriteria();
            criteria.toPerson = user.getIdPerson();
            criteria.previous = idPrevious;
            criteria.limit = 99;
            criteria.offset = 0;
            return ServerResponses.toJsonActionResult(this.ToCCourrielTexte(this.accessor.getCourrielWithLimitOffset(criteria)));
        }
        return ServerResponses.ERROR("No id person with active user");
    }

    private ReturnObject handleFindIds(IServerRequest req) {
        XCourrielTexteCriteria data = req.getPostBody(XCourrielTexteCriteria.class);
        return this.accessor.findIds(data);
    }

    private ActionResult handleFindIdsPerFolder(IServerRequest req) {
        Integer idPerson = req.getRequiredQueryParam("idPerson", Integer.class);
        Integer folderId = req.getQueryParam("folderId", Integer.class);
        if (folderId == null) {
            folderId = new Integer(1);
        }
        return ServerResponses.toJsonActionResult(this.accessor.getCourrielIdsPerFolder(idPerson, folderId));
    }

    private ActionResult handleFind(IServerRequest req) {
        XCourrielTexteCriteria data = req.getPostBody(XCourrielTexteCriteria.class);
        return ServerResponses.toJsonActionResult(this.ToCCourrielTexte(this.accessor.getCourrielWithLimitOffset(data)));
    }

    public ReturnObject createCourriel(CCourrielTexte toSave) {
        XCourrielTexte x = toSave.x();
        x.setModificationStatus(ModificationStatus.STATUS_NEW);
        ReturnObject ro = this.accessor.save(x);
        if (!ro.getStatus().isOK()) {
            ro.getStatus().setSeverity(ro.getStatus().getSeverity());
            ro.getStatus().setMessage(ro.getStatus().getMessage());
        }
        if (ro.getObj() != null) {
            XCourrielTexte chat = (XCourrielTexte)ro.getObj();
            ro.setObj((Object)CCourrielTexte.c(chat));
        }
        return ro;
    }

    public ReturnObject handleNameFolder(IServerRequest req) {
        Integer ids = req.getRequiredQueryParam("id", Integer.class);
        Integer idUser = req.getRequiredQueryParam("idUser", Integer.class);
        Integer toFolder = req.getQueryParam("toFolder", Integer.class);
        Base64DecodedString q = req.getQueryParam("name", Base64DecodedString.BLANK, Base64DecodedString.class);
        String name = q.getDecoded();
        if (ids != null && idUser != null && name != null) {
            return this.preferencesAccessor.setCourrielDossier(idUser, ids, name, toFolder);
        }
        return ServerResponses.ErrorReturnObject("data null or not of 2 int");
    }

    public ActionResult handleOpenLink(IServerRequest req) {
        int[] data = req.getPostBody(int[].class);
        if (data != null && data.length == 2) {
            int linkTypeToOpen = data[0];
            int idLink = data[1];
            if (linkTypeToOpen == LINK_TYPE.PATIENT.getValue()) {
                Application.get().getApplicationUiPlugin().openPatientEditEditor(this.patientController.getXPatient(idLink));
            } else if (linkTypeToOpen == LINK_TYPE.LABO.getValue()) {
                XBaseLaboResultsProfessionnal x = new XBaseLaboResultsProfessionnal();
                x.setId(Integer.valueOf(idLink));
                Application.get().getApplicationUiPlugin().openLaboEditor(x);
            } else if (linkTypeToOpen == LINK_TYPE.SCAN.getValue()) {
                XBasePatientImage x = new XBasePatientImage();
                x.setId(Integer.valueOf(idLink));
                Application.get().getApplicationUiPlugin().openPatientImageEditor(x);
            } else if (linkTypeToOpen == LINK_TYPE.FORM.getValue()) {
                XBaseEformData x = new XBaseEformData();
                x.setId(Integer.valueOf(idLink));
            } else {
                return ServerResponses.ERROR("linkTypeToOpen not supported:" + linkTypeToOpen);
            }
            return ServerResponses.SUCCESS();
        }
        return ServerResponses.ERROR("data null or not of 2 int");
    }

    public List<CCourrielTexte> ToCCourrielTexte(List<XCourrielTexte> msgs) {
        ArrayList<CCourrielTexte> activities = new ArrayList<CCourrielTexte>();
        if (msgs == null) {
            return activities;
        }
        for (XCourrielTexte obj : msgs) {
            activities.add(new CCourrielTexte(obj));
        }
        return activities;
    }

    public List<CCourrielDest> ToCCourrielDest(List<XCourrielDest> msgs) {
        ArrayList<CCourrielDest> activities = new ArrayList<CCourrielDest>();
        for (XCourrielDest obj : msgs) {
            activities.add(new CCourrielDest(obj));
        }
        return activities;
    }
}

