/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.dsq.domain.NIU_PRESCRIPTION;
import ca.infodata.dsq.domain.PrescriptionDeviceDetails;
import ca.infodata.dsq.domain.PrescriptionDrugDetails;
import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationResult;
import ca.infodata.ofys.client.modules.dsq.DSQcallType;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.client.modules.dsq.SqimHtmlFormatter;
import ca.infodata.ofys.client.modules.dsq.internal.CallBackResume;
import ca.infodata.ofys.client.modules.dsq.internal.CallBackSimpleResume;
import ca.infodata.ofys.client.modules.dsq.internal.GetCandidateController;
import ca.infodata.ofys.client.modules.dsq.internal.LegacyDsqControllerWeb;
import ca.infodata.ofys.client.modules.dsq.internal.OEPrescriptionController;
import ca.infodata.ofys.client.modules.dsq.internal.OEPrescriptionControllerCallback;
import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.util1.date.LocalDate;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OEPrescriptionControllerWeb
extends LegacyDsqControllerWeb {
    private static final Logger logger = Logger.getLogger(OEPrescriptionControllerWeb.class.getName());
    private OEPrescriptionController controller;

    public OEPrescriptionControllerWeb(Integer idPatient, IWebSocketChannel channel, GetCandidateController findCandidateController) {
        super(idPatient, channel);
        this.controller = new OEPrescriptionController(idPatient, new OEPrescriptionControllerCallback(){

            @Override
            public String listSummary(DsqCallback<QueryContinuationResult> callback) {
                return OEPrescriptionControllerWeb.this.browserCallback("listPrescriptionsOE", new CallBackResume(callback, DSQcallType.OEPrescription), SqimHtmlFormatter.getOESummary((QueryContinuationResult)callback.result));
            }

            @Override
            public String getDrugDetail(NIU_PRESCRIPTION id, DsqCallback<PrescriptionDrugDetails> callback) {
                return OEPrescriptionControllerWeb.this.browserCallback("getDrugDetailOE", new CallBackSimpleResume(callback), SqimHtmlFormatter.formatPrescriptionDrugDetails((PrescriptionDrugDetails)callback.result));
            }

            @Override
            public String getDeviceDetail(NIU_PRESCRIPTION id, DsqCallback<PrescriptionDeviceDetails> callback) {
                return OEPrescriptionControllerWeb.this.browserCallback("getDeviceDetailOE", new CallBackSimpleResume(callback), SqimHtmlFormatter.formatGetDevicePrescriptionDetails((PrescriptionDeviceDetails)callback.result));
            }
        }, findCandidateController);
    }

    public void listSummaryCallback(QueryContinuationResult result) {
        this.controller.getCallback().listSummary(new DsqCallback<QueryContinuationResult>(result));
    }

    public void listSummary() {
        try {
            this.controller.listSummary();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error", e);
            DsqCallback<Object> callback = new DsqCallback<Object>(null, Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]), e);
            this.controller.getCallback().listSummary(callback);
        }
    }

    public void getDrugDetail(NIU_PRESCRIPTION niu_PRESCRIPTION) {
        try {
            this.controller.getDrugDetail(niu_PRESCRIPTION);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error", e);
            DsqCallback<Object> callback = new DsqCallback<Object>(null, Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]), e);
            this.controller.getCallback().getDrugDetail(niu_PRESCRIPTION, callback);
        }
    }

    public void getDeviceDetail(NIU_PRESCRIPTION niu_PRESCRIPTION) {
        try {
            this.controller.getDeviceDetail(niu_PRESCRIPTION);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error", e);
            DsqCallback<Object> callback = new DsqCallback<Object>(null, Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]), e);
            this.controller.getCallback().getDeviceDetail(niu_PRESCRIPTION, callback);
        }
    }

    public void setStart(LocalDate date) {
        this.controller.setStart(date);
    }

    public void setEnd(LocalDate date) {
        this.controller.setEnd(date);
    }

    public void setOnlyActive(Boolean actif) {
        this.controller.setOnlyActive(Boolean.TRUE.equals(actif));
    }

    public LocalDate getStart() {
        return this.controller.getStart();
    }

    public LocalDate getEnd() {
        return this.controller.getEnd();
    }

    public boolean isOnlyActive() {
        return this.controller.isOnlyActive();
    }

    OEPrescriptionController getWrappedController() {
        return this.controller;
    }
}

