/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.dsq.domain.Candidate;
import ca.infodata.dsq.domain.VIEW_MODE;
import ca.infodata.dsq.domain.labo.getlist.LaboReportHeader;
import ca.infodata.dsq.domain.labo.getreport.LaboReport;
import ca.infodata.dsq.domain.labo.getreport.pdf.LaboReportHeaderFlat;
import ca.infodata.dsq.domain.labo.getreport.pdf.LaboReportPdf;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.client.modules.dsq.internal.GetCandidateController;
import ca.infodata.ofys.client.modules.dsq.internal.GetLaboReportController;
import ca.infodata.ofys.client.web.controller.DocumentsController;
import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.label.XLabelDef;
import ca.infodata.ofys.data.middle.dataobjects.scan.XBasePatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageProfessionnalStatus;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageResultType;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.ui.dashboard.models.CDsqRequest;
import ca.infodata.ofys.ui.dashboard.models.CLabelDef;
import ca.infodata.ofys.ui.dashboard.models.CPatientImage;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocalDate;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GetLaboReportControllerWeb {
    private static final String channelName = "dsq.lab.item";
    private static Logger logger = Logger.getLogger(GetLaboReportControllerWeb.class.getName());
    private GetLaboReportController controller;
    private DocumentsController documentsController;
    private Integer idPatient;
    private IWebSocketChannel wsChannel;

    public GetLaboReportControllerWeb(Integer idPatient, IWebSocketChannel channel, GetCandidateController findCandidateController, DocumentsController documentsController) {
        this.idPatient = idPatient;
        this.wsChannel = channel;
        this.documentsController = documentsController;
        this.controller = new GetLaboReportController(idPatient, findCandidateController){

            @Override
            public void callback(DsqCallback<LaboReport> dsqCallback) {
                GetLaboReportControllerWeb.this.callback(dsqCallback);
            }
        };
    }

    public void get(CDsqRequest dsqRequest) {
        if (dsqRequest == null) {
            throw new NullPointerException("dsqRequest");
        }
        if (dsqRequest.patientId == null) {
            throw new NullPointerException("dsqRequest.patientId");
        }
        if (!dsqRequest.patientId.equals(this.controller.getPatient().getId())) {
            throw new IllegalArgumentException("dsqRequest.patientId != controller.patient.id");
        }
        try {
            XPatientImage image = this.baseToXPatientImage(this.getPatientImage(dsqRequest.labo));
            ((XPatientImageProfessionnal)image.getProfessionnals().get((int)0)).status.add(XPatientImageProfessionnalStatus.SEEN);
            this.controller.setXImage(image);
            MultiStatus status = this.controller.valid();
            if (status.isOK()) {
                this.controller.get();
            } else {
                ServerResponses.sendJsonToClient(this.wsChannel, channelName, new ReturnObject(status));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while getting labo report", e);
            Status status = new Status(IStatus.Severity.ERROR, Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]));
            ServerResponses.sendJsonToClient(this.wsChannel, channelName, new ReturnObject((Serializable)status));
        }
    }

    private XBasePatientImage getPatientImage(LaboReportHeaderFlat labo) {
        XBasePatientImage image = new XBasePatientImage();
        image.setIdPatient(this.idPatient);
        image.setResult(labo.laboReportHeader.anormalFlag ? XPatientImageResultType.ANORMAL : XPatientImageResultType.SO);
        image.setId(null);
        image.setDecorators(XImageDecorator.NULL_DECORATORS);
        image.setDocumentDate(LocalDate.fromTimeInMillisUTC((Long)labo.laboReportHeader.specimenCollectionStartDatetime));
        image.valDsq = labo;
        image.setStr(GetLaboReportControllerWeb.formatDsqPatientImage((IPatient)this.getPatient(), labo));
        image.setStrWithoutPatient(GetLaboReportControllerWeb.formatDsqPatientImage(null, labo));
        return image;
    }

    private static String formatDsqPatientImage(IPatient patient, LaboReportHeaderFlat e) {
        JoinList joinList = new JoinList(", ");
        joinList.setAllowBlank(false);
        joinList.setTrim(true);
        String date = DateUtil.format((Long)e.laboReportHeader.specimenCollectionStartDatetime, (String)"yyyy-MM-dd HH:mm:ss");
        if (e.laboReportHeader.title != null) {
            List keywords = LaboReportHeader.getKeywords((String)e.laboReportHeader.title);
            joinList.add((CharSequence)new JoinList(" ", (Collection)keywords).toString());
        }
        if (e.laboReportHeader.reportType != null && "SURGP".equals(e.laboReportHeader.reportType.code)) {
            joinList.add((CharSequence)"s/o");
        }
        if ("completed".equals(e.laboResultStatus.code)) {
            joinList.add((CharSequence)"Final");
        } else if ("active".equals(e.laboResultStatus.code)) {
            joinList.add((CharSequence)"Partiel");
        } else {
            joinList.add((CharSequence)"s/o");
        }
        joinList.add((CharSequence)StringUtils.defaultString((String)e.laboReportHeader.reportType.text));
        if (e.laboRequest.author != null) {
            joinList.add((CharSequence)StringUtils.join((String)" ", (Object[])new Object[]{e.laboRequest.author.getFirstName(), e.laboRequest.author.getLastName()}));
        }
        joinList.add((CharSequence)(e.laboReportHeader.anormalFlag ? "anormal" : "non d\u00e9fini"));
        String text = "";
        if (patient != null) {
            String ptnom = " (" + patient.getName() + ")";
            text = date + " : " + ptnom + " " + joinList.toString();
        } else {
            text = date + " : " + joinList.toString();
        }
        if (Application.get().getGlobalInstances().inDebugMode()) {
            text = StringUtils.defaultString((String)e.laboResultId.extension) + ", " + text;
        }
        return text;
    }

    private XPatientImage baseToXPatientImage(XBasePatientImage xbase) {
        XPatientImage ximage = new XPatientImage();
        ximage.setId(null);
        ximage.patient = this.getPatient();
        ximage.idPatient = xbase.idPatient;
        ximage.name = "Document";
        ximage.picture = null;
        ximage.labels = new ArrayList();
        ximage.result = xbase.result;
        ximage.datetimeScanned = xbase.dateScanned;
        ximage.documentDate = xbase.documentDate;
        ximage.notesHistory = "";
        ximage.idUserAnchor = null;
        ximage.userName = null;
        ximage.valDsq = xbase.valDsq;
        ximage.dsqImagingResultExam = xbase.dsqImagingResultExam;
        ximage.result = XPatientImageResultType.SO;
        ximage.setProfessionnals((IEditableDataObjectList)new EditableDataObjectList());
        XPatientImageProfessionnal e = new XPatientImageProfessionnal();
        e.professionnal = Application.get().getPersonPluginController().getSessionProfessionnal().getId();
        ximage.getProfessionnals().add((IMinimalEditableDataObject)e);
        return ximage;
    }

    protected void callback(DsqCallback<LaboReport> dsqCallback) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        if (dsqCallback.exception != null) {
            MultiStatus ms1 = new MultiStatus();
            ms1.setSeverity(IStatus.Severity.ERROR);
            ms1.setMessage(dsqCallback.exception.getMessage());
            ms.add((IStatus)ms1);
        } else if (StringUtils.isNotBlank((String)dsqCallback.message)) {
            MultiStatus ms2 = new MultiStatus();
            ms2.setSeverity(IStatus.Severity.WARNING);
            ms2.setMessage(dsqCallback.message);
            ms.add((IStatus)ms2);
        }
        if (dsqCallback.result != null) {
            LaboReport report = (LaboReport)dsqCallback.result;
            XPatientImage ximage = this.controller.getPatientImage();
            if (report.title != null) {
                ximage.name = report.title;
            }
            ((XPatientImageProfessionnal)ximage.getProfessionnals().get((int)0)).modificationStatus.set((Object)ModificationStatus.STATUS_NEW_UPDATED);
            Candidate candidate = this.controller.getCandidate();
            LaboReportPdf laboReportPdf = new LaboReportPdf(candidate, report, ximage.valDsq);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                laboReportPdf.setViewMode(VIEW_MODE.VIEW);
                laboReportPdf.getPicture((OutputStream)bos);
                ximage.picture = bos.toByteArray();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to generate view pdf for dsq labo header. ximage.id " + ximage.getId(), e);
            }
            bos.reset();
            try {
                laboReportPdf.setViewMode(VIEW_MODE.PRINT);
                laboReportPdf.getPicture((OutputStream)bos);
                ximage.pictureToPrint = bos.toByteArray();
                XBaseProfessionnal professionnal = Application.get().getPersonPluginController().getSessionProfessionnal();
                Integer activeIdProf = null;
                if (professionnal != null) {
                    activeIdProf = professionnal.id;
                }
                String docId = "DSQLaboReport" + report.id.extension;
                CPatientImage cimage = this.documentsController.getCPatientImage(docId, new CPatientImage(ximage, activeIdProf, activeIdProf));
                XLabelDef xLabelLabo = Application.get().getPreferencesPluginController().getLabel(new Integer(XLabelDef.LABO_SCAN));
                cimage.labels.add(new CLabelDef(xLabelLabo));
                cimage.picture = ximage.picture;
                cimage.pictureToPrint = ximage.pictureToPrint;
                ms.setSeverity(IStatus.Severity.OK);
                ro.setObj((Object)cimage);
            }
            catch (Exception e) {
                ms.setSeverity(IStatus.Severity.ERROR);
                ms.setMessage("Erreur de g\u00e9n\u00e9ration de laboratoire DSQ. " + e.getMessage());
                ro.setStatus(ms);
                logger.log(Level.SEVERE, "Failed to generate print pdf for dsq labo header. ximage.id " + ximage.getId(), e);
            }
        }
        ro.setStatus(ms);
        ServerResponses.sendJsonToClient(this.wsChannel, channelName, ro);
    }

    private XPatient getPatient() {
        return Application.get().getCache().getPatientCache().get(this.idPatient);
    }
}

