/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.dsq.domain.Candidate;
import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.Id;
import ca.infodata.dsq.domain.NIU;
import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.job.IProgressMonitor;
import ca.infodata.ofys.client.job.Job;
import ca.infodata.ofys.client.job.JobStatus;
import ca.infodata.ofys.client.job.NullProgressMonitor;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.Alias;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.client.modules.dsq.IDSQPluginController;
import ca.infodata.ofys.client.modules.dsq.internal.GetCandidateController;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.IDSQAccessor;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.dsq.imaging.XImagingResultExamResponse;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.util.MiscUtil;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GetImagingResultExamReportController {
    private static final String OBTENTION_DU_RAPPORT = "Obtention du rapport";
    private static final Logger logger = Logger.getLogger(GetImagingResultExamReportController.class.getName());
    private final Integer idPatient;
    private Id studyIdentifier;
    private Integer reportIndex = 0;
    private Candidate candidate;
    private XImagingResultExamResponse result;
    private Job get;
    private final GetCandidateController findCandidateAction;
    private final IDSQPluginController dsq;
    private final IDSQAccessor dsqAccessor;

    public GetImagingResultExamReportController(Integer idPatient, GetCandidateController findCandidateAction) {
        if (findCandidateAction == null) {
            throw new NullPointerException("findCandidateAction");
        }
        this.idPatient = idPatient;
        this.dsq = Application.get().getDsqPluginController();
        this.dsqAccessor = Application.get().getDataAccessors().getDSQAccessor();
        this.findCandidateAction = findCandidateAction;
    }

    protected void callback(DsqCallback<XImagingResultExamResponse> dsqCallback, int reportIndex) {
    }

    public void get() throws Exception {
        if (this.get == null) {
            this.get = new Job(OBTENTION_DU_RAPPORT){

                @Override
                public void runWithException() {
                    GetImagingResultExamReportController.this.get2(this);
                }
            };
        }
        if (this.get.getState() == JobStatus.RUNNING) {
            this.callback(new DsqCallback<Object>(null, "Op\u00e9ration en cours...", null), this.reportIndex);
        } else {
            this.get.schedule();
        }
    }

    public void get2(IProgressMonitor monitor) {
        if (this.result == null) {
            DsqCallback<XImagingResultExamResponse> r = this.get3(monitor);
            if (r.result != null) {
                this.result = (XImagingResultExamResponse)r.result;
            }
            this.callback(r, this.reportIndex);
        } else {
            this.callback(new DsqCallback<XImagingResultExamResponse>(this.result), this.reportIndex);
        }
    }

    public MultiStatus valid() {
        return new MultiStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DsqCallback<XImagingResultExamResponse> get3(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        DsqCallback<XImagingResultExamResponse> callback = new DsqCallback<XImagingResultExamResponse>();
        try {
            monitor.beginTask(OBTENTION_DU_RAPPORT, 2);
            Alias alias = null;
            XmlSignatureI signature = null;
            XmlSignatureI signatureNiu = null;
            this.dsq.checkIfActionWasCanceled(monitor);
            this.candidate = this.findCandidateAction.getCandidate(monitor.subMonitor(1));
            String niu = this.candidate.getNiu().value();
            if (!this.dsq.hasSignatures(this.idPatient)) {
                if (!Application.get().getApplicationUiPlugin().isWindowsDesktop()) {
                    throw new AbortException(Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                }
                alias = this.dsq.getAlias(monitor);
                this.dsq.checkIfActionWasCanceled(monitor);
                signature = this.dsq.getSignatureI(monitor, alias);
                this.dsq.checkIfActionWasCanceled(monitor);
                signatureNiu = this.dsq.getXmlSignatureI(monitor, alias, niu);
                this.dsq.checkIfActionWasCanceled(monitor);
            }
            monitor.worked(1);
            this.dsq.checkIfActionWasCanceled(monitor);
            monitor.subTask("Recherche");
            ReturnObject r = this.dsqAccessor.getImagingExam((Signature)signature, (Signature)signatureNiu, this.idPatient, this.studyIdentifier);
            if (r == null) {
                throw new AbortException("Erreur lors de l'" + OBTENTION_DU_RAPPORT.toLowerCase());
            }
            this.dsq.manageDsqStatus(r.getStatus());
            callback.result = (XImagingResultExamResponse)r.getObj();
            this.dsq.checkIfActionWasCanceled(monitor);
        }
        catch (AbortException | CancelException | CannotConnectToServerException | StatusException e) {
            callback.message = e.getMessage();
        }
        catch (Exception e) {
            callback.exception = e;
            callback.message = e.getMessage();
            logger.log(Level.SEVERE, String.format("Failed to get imaging result exam detail %s, %s", this.idPatient, this.studyIdentifier), e);
        }
        finally {
            monitor.done();
        }
        return callback;
    }

    public void clear() {
        this.result = null;
        this.candidate = null;
    }

    public void setStudyIdentifier(Id studyIdentifier) {
        if (!MiscUtil.areObjectsEquals((Object)studyIdentifier, (Object)this.studyIdentifier)) {
            this.clear();
        }
        this.studyIdentifier = studyIdentifier;
    }

    public Id getStudyIdentifier() {
        return this.studyIdentifier;
    }

    public static String toString(Id id) {
        return id == null ? null : id.root + ";" + id.extension;
    }

    public static String toString(Code code) {
        return code == null ? null : code.codeSystem + ";" + code.code;
    }

    public static String toString(NIU niu) {
        return niu == null ? null : niu.oid() + ";" + niu.value();
    }

    public XImagingResultExamResponse getImagingResultExam() {
        return this.result;
    }

    public Candidate getCandidate() {
        return this.candidate;
    }

    public Integer getReportIndex() {
        return this.reportIndex;
    }

    public void setReportIndex(Integer reportIndex) {
        this.reportIndex = reportIndex == null ? 0 : reportIndex;
    }
}

