/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.dsq.domain.Address;
import ca.infodata.dsq.domain.Candidate;
import ca.infodata.dsq.domain.Gender;
import ca.infodata.dsq.domain.NAM;
import ca.infodata.dsq.domain.NIU_U;
import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.job.IProgressMonitor;
import ca.infodata.ofys.client.job.NullProgressMonitor;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.Alias;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.client.modules.dsq.IDSQPluginController;
import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.IDSQAccessor;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.patient.XPatientInactiveRaison;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.util1.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GetCandidateController {
    private static final Logger logger = Logger.getLogger(GetCandidateController.class.getName());
    private static final String RESOLUTION_DU_PATIENT = Messages.getString((String)"FindCandidateAction.RESOLUTION_DU_PATIENT", (String[])new String[0]);
    private final Integer idPatient;
    private final IDSQPluginController dsq;
    private final IDSQAccessor dsqAccessor;
    private Candidate candidate;

    public GetCandidateController(Integer idPatient, IWebSocketChannel channel) {
        this.idPatient = idPatient;
        this.dsq = Application.get().getDsqPluginController();
        this.dsqAccessor = Application.get().getDataAccessors().getDSQAccessor();
    }

    public IPatient getPatient() {
        if (this.idPatient == null) {
            throw new IllegalStateException("idPatient is null");
        }
        return Application.get().getCache().getPatientCache().get(this.idPatient);
    }

    public String getNiu(IProgressMonitor monitor) throws AbortException, CancelException, InterruptedException {
        return this.getNiu(false, false, monitor);
    }

    public Candidate getCandidate(IProgressMonitor monitor) throws AbortException, CancelException, InterruptedException {
        return this.getCandidate(false, false, monitor);
    }

    public Candidate getCandidate(boolean forceResolution, boolean forceResolutionDialog, IProgressMonitor monitor) throws AbortException, CancelException, InterruptedException {
        if (this.candidate != null && !forceResolution) {
            return this.candidate;
        }
        IPatient patient = this.getPatient();
        if (StringUtils.isNotBlank((String)patient.getNiu()) && !forceResolution) {
            NIU_U niu = new NIU_U(patient.getNiu());
            NAM nam = StringUtils.isBlank((CharSequence)patient.getHealthInsuranceNumber()) ? null : new NAM(patient.getHealthInsuranceNumber());
            String firstName = patient.getFirstName();
            String lastName = patient.getLastName();
            Gender dsqGender = GetCandidateController.getDsqGender(patient.getGender());
            Long birthdate = patient.getBirthDate() != null ? Long.valueOf(patient.getBirthDate().toTimeInMillisUTC()) : null;
            Address address = null;
            Long deceasedDate = patient.getInactiveDate() != null && patient.getInactiveRaison() == XPatientInactiveRaison.DCD ? Long.valueOf(patient.getInactiveDate().toAbsoluteDate().toTimeInMillisUTC()) : null;
            this.candidate = new Candidate(niu, nam, firstName, lastName, dsqGender, birthdate, address, deceasedDate, null);
            return this.candidate;
        }
        this.candidate = this.getCandidateNoCache(forceResolution, forceResolutionDialog, monitor);
        return this.candidate;
    }

    public String getNiu(boolean forceResolution, boolean forceResolutionDialog, IProgressMonitor monitor) throws AbortException, CancelException, InterruptedException {
        IPatient patient = this.getPatient();
        if (!forceResolution && StringUtils.isNotBlank((String)patient.getNiu())) {
            return patient.getNiu();
        }
        Candidate candidate = this.getCandidate(forceResolution, forceResolutionDialog, monitor);
        if (candidate != null) {
            return candidate.getNiu().value();
        }
        return null;
    }

    private Candidate getCandidateNoCache(boolean forceResolution, boolean forceResolutionDialog, IProgressMonitor monitor) throws AbortException, CancelException, InterruptedException {
        Candidate result = null;
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        monitor.beginTask(RESOLUTION_DU_PATIENT, 2);
        try {
            IPatient patient = this.getPatient();
            XmlSignatureI signature = null;
            if (!this.dsq.hasSignatures(null)) {
                if (!Application.get().getApplicationUiPlugin().isWindowsDesktop()) {
                    throw new AbortException(Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                }
                Alias alias = this.dsq.getAlias(monitor);
                signature = this.dsq.getSignatureI(monitor, alias, null);
                monitor.worked(1);
            }
            monitor.subTask(RESOLUTION_DU_PATIENT);
            ReturnObject r = this.dsqAccessor.findCandidateById((Signature)signature, patient.getId(), true);
            monitor.worked(1);
            if (r == null) {
                throw new AbortException("Erreur lors de la r\u00e9solution du patient au registre");
            }
            this.dsq.manageDsqStatus(r.getStatus());
            result = (Candidate)r.getObj();
            if (result != null) {
                monitor.log(Level.INFO, "R\u00e9solution r\u00e9ussie");
                Application.get().getCache().getPatientCache().remove(this.idPatient);
            }
        }
        catch (CannotConnectToServerException e) {
            throw new StatusException((IStatus)new Status(IStatus.Severity.ERROR, e.getMessage()));
        }
        catch (AbortException | CancelException | StatusException e) {
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, String.format("Failed to get candidate for patient %s", this.idPatient), e);
            throw new AbortException("Erreur lors de la r\u00e9solution du patient au registre");
        }
        finally {
            monitor.done();
        }
        return result;
    }

    public static Gender getDsqGender(String gender) {
        XPerson.Gender g = XPerson.Gender.from((String)gender);
        if (g == XPerson.Gender.FEMININ) {
            return Gender.FEMALE;
        }
        if (g == XPerson.Gender.MASCULIN) {
            return Gender.MALE;
        }
        return null;
    }
}

