/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.dsq.domain.NIU_PRESCRIPTION;
import ca.infodata.dsq.domain.PrescriptionDrugDetails;
import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationResult;
import ca.infodata.ofys.client.modules.dsq.DSQcallType;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.client.modules.dsq.SqimHtmlFormatter;
import ca.infodata.ofys.client.modules.dsq.internal.CallBackResume;
import ca.infodata.ofys.client.modules.dsq.internal.CallBackSimpleResume;
import ca.infodata.ofys.client.modules.dsq.internal.DMPrescriptionController;
import ca.infodata.ofys.client.modules.dsq.internal.DMPrescriptionControllerCallback;
import ca.infodata.ofys.client.modules.dsq.internal.GetCandidateController;
import ca.infodata.ofys.client.modules.dsq.internal.LegacyDsqControllerWeb;
import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.util1.date.LocalDate;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DMPrescriptionControllerWeb
extends LegacyDsqControllerWeb {
    private static final Logger logger = Logger.getLogger(DMPrescriptionController.class.getName());
    private DMPrescriptionController controller;

    public DMPrescriptionControllerWeb(Integer idPatient, IWebSocketChannel channel, GetCandidateController findCandidateController) {
        super(idPatient, channel);
        this.controller = new DMPrescriptionController(idPatient, new DMPrescriptionControllerCallback(){

            @Override
            public String listSummary(DsqCallback<QueryContinuationResult> callback) {
                return DMPrescriptionControllerWeb.this.browserCallback("listPrescriptionsDM", new CallBackResume(callback, DSQcallType.DMPrescription), SqimHtmlFormatter.getDMPrescriptionSummary((QueryContinuationResult)callback.result));
            }

            @Override
            public String getDetail(NIU_PRESCRIPTION id, String context, DsqCallback<PrescriptionDrugDetails> callback) {
                return DMPrescriptionControllerWeb.this.browserCallback("getPrescriptionsDMDetail", new CallBackSimpleResume(callback), SqimHtmlFormatter.formatPrescriptionDrugDetails((PrescriptionDrugDetails)callback.result));
            }
        }, findCandidateController);
    }

    public void listSummary() {
        try {
            this.controller.listSummary();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error", e);
            DsqCallback<Object> callback = new DsqCallback<Object>(null, Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]), e);
            this.controller.getCallback().listSummary(callback);
        }
    }

    public void getDetail(NIU_PRESCRIPTION niu_PRESCRIPTION, String context) {
        try {
            this.controller.getDetail(niu_PRESCRIPTION, context);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error", e);
            DsqCallback<Object> callback = new DsqCallback<Object>(null, Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]), e);
            this.controller.getCallback().getDetail(niu_PRESCRIPTION, context, callback);
        }
    }

    public void setStart(LocalDate date) {
        this.controller.setStart(date);
    }

    public void setEnd(LocalDate date) {
        this.controller.setEnd(date);
    }

    public void setIncludeCompletlyDispensed(Boolean actif) {
        this.controller.setIncludeCompletlyDispensed(Boolean.TRUE.equals(actif));
    }

    public void setIncludePartiallyDispensed(Boolean actif) {
        this.controller.setIncludePartiallyDispensed(Boolean.TRUE.equals(actif));
    }

    public void setIncludeNeverDispensed(Boolean actif) {
        this.controller.setIncludeNeverDispensed(Boolean.TRUE.equals(actif));
    }
}

