/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util;

import com.hivemq.client.internal.shaded.io.netty.util.NetUtil;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public final class InetSocketAddressUtil {
    @NotNull
    public static InetSocketAddress create(@NotNull String host, int port) {
        byte[] ipAddress = NetUtil.createByteArrayFromIpAddressString(host);
        if (ipAddress != null) {
            try {
                return new InetSocketAddress(InetAddress.getByAddress(ipAddress), port);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return InetSocketAddress.createUnresolved(host, port);
    }

    private InetSocketAddressUtil() {
    }
}

